/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.print;

import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.frameworks.i18n.localizer.Localizer;
import com.nokia.em.poseidon.frameworks.i18n.localizer.LocalizerRegistry;
import com.nokia.em.poseidon.frameworks.i18n.localizer.swing.SwingHierarchyIterator;
import com.nokia.em.poseidon.frameworks.mvc.Controller;
import com.nokia.em.poseidon.frameworks.mvc.swing.JDialogViewBase;
import com.nokia.em.poseidon.gui.print.PPrintControl;
import com.nokia.widgets.ClientProperties;
import com.nokia.widgets.PBorderFactory;
import com.nokia.widgets.PTabbedPane;
import com.nokia.widgets.buttons.PButton;
import com.nokia.widgets.buttons.PHelpButton;
import com.nokia.widgets.icons.CommonIcons;
import com.nokia.widgets.labels.PLabel;
import com.nokia.widgets.layout.PButtonRowLayout;
import com.nokia.widgets.layout.PMatrixLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import javax.print.PrintService;
import javax.print.attribute.EnumSyntax;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.MediaTray;
import javax.print.attribute.standard.PrinterIsAcceptingJobs;
import javax.print.attribute.standard.PrinterLocation;
import javax.print.attribute.standard.PrinterMakeAndModel;
import javax.print.attribute.standard.PrinterState;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.DefaultFormatter;
import net.miginfocom.swing.MigLayout;
import org.apache.log4j.Logger;

public class PPrintDialog
extends JDialogViewBase
implements ActionListener,
ChangeListener {
    protected static final String VIEW_LOCATION = "printDialog.location";
    protected static final int[] DEFAULT_BOUNDS = new int[]{100, 100, 343, 473};
    public static final int INSETS_SIZE_VERTICAL = 3;
    public static final int INSETS_SIZE_HORIZONTAL = 2;
    public static final int SPINNER_MIN_VALUE = 1;
    public static final String PROTOTYPE_DISPLAYABLE_VALUE_FOR_COMBO_BOXES = "PrototypeDisplayValueForComboBoxes";
    public static final int SPINNER_MAX_VALUE = 999;
    public static final int DIALOG_WIDTH = 315;
    public static final int DIALOG_HEIGTH = 450;
    public static final double SPINNER_MIN_DOUBLE_VALUE = 0.5;
    public static final double SPINNER_INCHES_STEP_LENGTH = 0.1;
    public static final double SPINNER_MM_STEP_LENGTH = 1.0;
    private PPrintControl myPrintController;
    private PageFormat myPageFormat;
    private JLabel myPrinterTypeLabel;
    private JLabel myPrinterStatusLabel;
    private JLabel myPrinterLocationLabel;
    protected JComboBox myPrinterNameBox;
    private PLabel mySourceLabel;
    private JComboBox myMediaSourceBox;
    private PLabel mySizeLabel;
    private JComboBox myMediaSizeBox;
    private JRadioButton myAllPrintRange;
    private JRadioButton myPagesPrintRange;
    private JRadioButton myMarginsInInches;
    private JRadioButton myMarginsInMm;
    private JRadioButton myPortraitButton;
    private JRadioButton myLandscapeButton;
    private JSpinner myFromPrintRangeSpinner;
    private int myPrintRangeTo = 1;
    private JSpinner myToPrintRangeSpinner;
    private int myPrintRangeFrom = 1;
    private PLabel myPageRangeToLabel;
    private JSpinner myNumberOfCopiesSpinner;
    private int myNumberOfCopies = 1;
    private Media[] myMediaSizes = null;
    private Media[] myMediaSources = null;
    private PTabbedPane myTabbedPane;
    private PButton myPrintButton;
    private PHelpButton myHelpButton;
    private JButton myCancelButton;
    private JSpinner myTopMarginSpinner;
    private JSpinner myBottomMarginSpinner;
    private JSpinner myLeftMarginSpinner;
    private JSpinner myRightMarginSpinner;
    private double myTopMargin = 1.0;
    private double myBottomMargin = 1.0;
    private double myLeftMargin = 1.0;
    private double myRightMargin = 1.0;
    private int myPageRangeMax = 1;
    private boolean myMarginalsUpdated = true;
    private boolean myIsSelectedInches;
    private String myKeySettings;
    private ResourceBundle myBundle;
    private boolean myIsInitialized;

    public PPrintDialog(PPrintControl controller) {
        super(controller);
        this.initDialog();
    }

    public PPrintDialog(PPrintControl controller, Frame frame) {
        super((Controller)controller, frame);
        this.initDialog();
    }

    public PPrintDialog(PPrintControl controller, Dialog dialog) {
        super((Controller)controller, dialog);
        this.initDialog();
    }

    @Override
    protected void storeSettings() {
        super.storeSettingsByKeySettings(this.myKeySettings);
    }

    @Override
    protected void restoreLocation() {
        super.restoreLocation(this.myKeySettings);
    }

    @Override
    public void dispose() {
        if (this.myPrintController == null) {
            return;
        }
        this.myTabbedPane.removeChangeListener(this);
        this.myPrintButton.removeActionListener(this);
        this.myCancelButton.removeActionListener(this);
        this.myHelpButton.removeActionListener(this);
        this.myPrinterNameBox.removeActionListener(this);
        this.myAllPrintRange.removeActionListener(this);
        this.myPagesPrintRange.removeActionListener(this);
        this.myNumberOfCopiesSpinner.removeChangeListener(this);
        this.myTopMarginSpinner.removeChangeListener(this);
        this.myBottomMarginSpinner.removeChangeListener(this);
        this.myLeftMarginSpinner.removeChangeListener(this);
        this.myRightMarginSpinner.removeChangeListener(this);
        this.myMarginsInInches.removeActionListener(this);
        this.myMarginsInMm.removeActionListener(this);
        this.myMediaSizes = null;
        this.myMediaSources = null;
        this.myPrintController = null;
        super.dispose();
    }

    public void setPageCount(int pageCount) {
        this.myPageRangeMax = pageCount;
        if (!this.myPagesPrintRange.isSelected()) {
            this.myPrintRangeTo = this.myPageRangeMax;
            this.myToPrintRangeSpinner.setValue(this.myPageRangeMax);
        }
    }

    public void setLandscapeSelection(boolean blnSelected) {
        this.myLandscapeButton.setSelected(blnSelected);
    }

    public void setPortraitSelection(boolean blnSelected) {
        this.myPortraitButton.setSelected(blnSelected);
    }

    public double getBottomMargin() {
        this.updateMarginals();
        return this.myBottomMargin;
    }

    public double getTopMargin() {
        this.updateMarginals();
        return this.myTopMargin;
    }

    public double getLeftMargin() {
        this.updateMarginals();
        return this.myLeftMargin;
    }

    public double getRightMargin() {
        this.updateMarginals();
        return this.myRightMargin;
    }

    public int getNumberOfCopies() {
        this.myNumberOfCopies = ((SpinnerNumberModel)this.myNumberOfCopiesSpinner.getModel()).getNumber().intValue();
        return this.myNumberOfCopies;
    }

    public int getPrintPagesFrom() {
        this.myPrintRangeFrom = ((SpinnerNumberModel)this.myFromPrintRangeSpinner.getModel()).getNumber().intValue();
        return this.myPrintRangeFrom;
    }

    public int getPrintPagesTo() {
        this.myPrintRangeTo = ((SpinnerNumberModel)this.myToPrintRangeSpinner.getModel()).getNumber().intValue();
        return this.myPrintRangeTo;
    }

    public boolean isLandscapeSelected() {
        return this.myLandscapeButton.isSelected();
    }

    public boolean isPortraitSelected() {
        return this.myPortraitButton.isSelected();
    }

    public boolean isRangeAll() {
        return this.myAllPrintRange.isSelected();
    }

    public boolean isRangePages() {
        return this.myPagesPrintRange.isSelected();
    }

    public MediaSizeName getSelectedMediaSize() {
        return (MediaSizeName)this.myMediaSizeBox.getSelectedItem();
    }

    public Media getSelectedMediaSource() {
        Object mediaSource = this.myMediaSourceBox.getSelectedItem();
        if (mediaSource instanceof MediaTray) {
            return (MediaTray)mediaSource;
        }
        return null;
    }

    public boolean isAutomaticSourceSelected() {
        String tmp;
        String automaticSelect = this.myBundle.getString("PPrintDialog.printServiceAutomaticSource_Text");
        Object selection = this.myMediaSourceBox.getSelectedItem();
        boolean booleanAutomatic = false;
        if (selection instanceof String && (tmp = (String)selection).equals(automaticSelect)) {
            booleanAutomatic = true;
        }
        return booleanAutomatic;
    }

    private void initDialog() {
        this.myPrintController = (PPrintControl)this.getController();
        this.myKeySettings = (String)this.myPrintController.getProperties().get("keySettings");
        this.myBundle = I18n.getI18n().getBundle(this.getClass());
        this.buildUI();
        this.initPageSettings();
        this.updateMarginalSpinners();
        if (this.getSelectedPrintService() == null) {
            this.enableView(false);
        }
        this.myPrintButton.requestFocus();
        this.initListeners();
        this.restoreSettings();
    }

    private void buildUI() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(12, 0, 0, 0);
        constraints.fill = 1;
        panel.add((Component)this.createTabbedPane(), constraints);
        constraints.anchor = 15;
        constraints.fill = 2;
        constraints.gridy = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)this.createButtonPanel(), constraints);
        this.getContentPane().add(panel);
        if (!this.myPrintController.isDefined("dialogtitle")) {
            this.setTitle(this.myBundle.getString("PPrintDialog.printDialogView_Text"));
        } else {
            this.setTitle((String)this.myPrintController.getProperty("dialogtitle"));
        }
        Localizer localiser = LocalizerRegistry.lookup("swing");
        localiser.localizeObjectHierarchy(new SwingHierarchyIterator(this));
        this.pack();
        this.setModal(true);
        this.setResizable(false);
        this.setLocationRelativeTo(this.getParent());
    }

    private void initListeners() {
        this.myTabbedPane.addChangeListener(this);
        this.myPrintButton.addActionListener(this);
        this.myCancelButton.addActionListener(this);
        this.myHelpButton.addActionListener(this);
        this.myPrinterNameBox.addActionListener(this);
        this.myAllPrintRange.addActionListener(this);
        this.myPagesPrintRange.addActionListener(this);
        this.myNumberOfCopiesSpinner.addChangeListener(this);
        this.myTopMarginSpinner.addChangeListener(this);
        this.myBottomMarginSpinner.addChangeListener(this);
        this.myLeftMarginSpinner.addChangeListener(this);
        this.myRightMarginSpinner.addChangeListener(this);
        this.myMarginsInInches.addActionListener(this);
        this.myMarginsInMm.addActionListener(this);
    }

    private void enableView(boolean enabled) {
        this.myPrintButton.setEnabled(enabled);
        this.myMarginsInInches.setEnabled(enabled);
        this.myMarginsInMm.setEnabled(enabled);
        this.myTopMarginSpinner.setEnabled(enabled);
        this.myBottomMarginSpinner.setEnabled(enabled);
        this.myLeftMarginSpinner.setEnabled(enabled);
        this.myRightMarginSpinner.setEnabled(enabled);
        this.myPagesPrintRange.setEnabled(enabled);
        this.myAllPrintRange.setEnabled(enabled);
        this.myNumberOfCopiesSpinner.setEnabled(enabled);
        this.myMediaSourceBox.setEnabled(enabled);
        this.mySourceLabel.setEnabled(enabled);
        this.myMediaSizeBox.setEnabled(enabled);
        this.mySizeLabel.setEnabled(enabled);
        this.myPortraitButton.setEnabled(enabled);
        this.myLandscapeButton.setEnabled(enabled);
    }

    private void initPageSettings() {
        this.createDefaultPageFormat();
        this.restorePrinterSettings();
        this.myAllPrintRange.setSelected(true);
        this.myTopMarginSpinner.setEnabled(true);
        this.myBottomMarginSpinner.setEnabled(true);
        this.myLeftMarginSpinner.setEnabled(true);
        this.myRightMarginSpinner.setEnabled(true);
        this.myMarginsInMm.setSelected(true);
        this.myPortraitButton.setEnabled(true);
        if (this.myPageFormat.getOrientation() == 0) {
            this.setLandscapeSelection(true);
        } else {
            this.setPortraitSelection(true);
        }
        if ("landscape".equals(this.myPrintController.getProperty("orientation"))) {
            this.myLandscapeButton.setSelected(true);
        }
        if (this.myPrintController.isDefined("topmargin")) {
            Double topMargin = (Double)this.myPrintController.getProperty("topmargin");
            this.myTopMargin = topMargin;
            this.myTopMarginSpinner.setValue(topMargin);
        }
        if (this.myPrintController.isDefined("leftmargin")) {
            Double leftMargin = (Double)this.myPrintController.getProperty("leftmargin");
            this.myLeftMargin = leftMargin;
            this.myLeftMarginSpinner.setValue(leftMargin);
        }
        if (this.myPrintController.isDefined("bottommargin")) {
            Double bottomMargin = (Double)this.myPrintController.getProperty("bottommargin");
            this.myBottomMargin = bottomMargin;
            this.myBottomMarginSpinner.setValue(bottomMargin);
        }
        if (this.myPrintController.isDefined("rightmargin")) {
            Double rightMargin = (Double)this.myPrintController.getProperty("rightmargin");
            this.myRightMargin = rightMargin;
            this.myRightMarginSpinner.setValue(rightMargin);
        }
    }

    private void createDefaultPageFormat() {
        this.myPageFormat = new PageFormat();
        if ("portrait".equals(this.myPrintController.getProperty("orientation"))) {
            this.myPageFormat.setOrientation(1);
        }
    }

    private void restorePrinterSettings() {
        if (this.myPrintController.isDefined("defaultprinter")) {
            this.myPrinterNameBox.setSelectedItem(this.myPrintController.getProperty("defaultprinter"));
        }
        if (this.myPrintController.isDefined("defaultsize")) {
            this.myMediaSizeBox.setSelectedItem(this.myPrintController.getProperty("defaultsize"));
        }
    }

    private void storePrinterSettings() {
        try {
            if (this.myIsInitialized && this.getSelectedPrintService() != null) {
                this.myPrintController.setProperty("defaultprinter", this.getSelectedPrintService().getName());
                this.myPrintController.setProperty("defaultsize", this.getSelectedMediaSize().getName());
            }
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass()).error("Cannot store selected printer settings.", e);
        }
    }

    private JTabbedPane createTabbedPane() {
        this.myTabbedPane = new PTabbedPane();
        int[] borders = new int[]{1};
        this.myTabbedPane.putClientProperty("OrangeTouch.paintedContentBorderSegments", borders);
        JPanel generalPanel = this.createGeneralTab();
        JPanel pageSetupPanel = this.createPageSetupTab();
        this.myTabbedPane.add(this.myBundle.getString("PPrintDialog.printGeneralPanel_Text"), generalPanel);
        this.myTabbedPane.add(this.myBundle.getString("PPrintDialog.printPageSetupPanel_Text"), pageSetupPanel);
        this.myTabbedPane.setMnemonicAt(0, 71);
        this.myTabbedPane.setMnemonicAt(1, 80);
        return this.myTabbedPane;
    }

    private JPanel createButtonPanel() {
        this.myPrintButton = new PButton();
        this.myPrintButton.setDefaultButton(true);
        this.myPrintButton.setName("PPrintDialog.printButton");
        this.myCancelButton = new JButton();
        this.myCancelButton.setName("CancelAction");
        this.myHelpButton = new PHelpButton();
        JPanel buttonPanel = new JPanel(new PButtonRowLayout());
        buttonPanel.add(this.myPrintButton);
        buttonPanel.add(this.myCancelButton);
        buttonPanel.add(this.myHelpButton);
        buttonPanel.putClientProperty("panelType", ClientProperties.PANEL_BUTTONAREA_BACKGROUND);
        buttonPanel.setBorder(PBorderFactory.getButtonBarBorder());
        return buttonPanel;
    }

    private JPanel createGeneralTab() {
        PMatrixLayout layout = new PMatrixLayout(1, 12, 12, 12, 12);
        JPanel generalPanel = new JPanel(layout);
        this.createPrinterArea(generalPanel);
        this.createPrintRangeArea(generalPanel);
        this.createCopiesArea(generalPanel);
        return generalPanel;
    }

    private void createPrinterArea(JPanel generalPanel) {
        this.myPrinterStatusLabel = PLabel.createValueText();
        this.myPrinterLocationLabel = PLabel.createValueText();
        this.myPrinterTypeLabel = PLabel.createValueText();
        PLabel printerLabel = PLabel.createTitle();
        printerLabel.setName("PPrintDialog.printPrinterLabel");
        generalPanel.add(printerLabel);
        JPanel printerPanel = new JPanel((LayoutManager)new MigLayout("insets 0 10 0 0"));
        PLabel nameLabel = new PLabel();
        nameLabel.setLabelType(ClientProperties.LABEL_SYSTEM_TEXT);
        this.myPrinterNameBox = new JComboBox();
        nameLabel.setLabelFor(this.myPrinterNameBox);
        nameLabel.setName("PPrintDialog.printerNameLabel");
        nameLabel.setDisplayedMnemonic(this.myBundle.getMnemonic("PPrintDialog.printerNameLabel_Mnemonic"));
        printerPanel.add(nameLabel);
        this.myPrinterNameBox.setName("printNameBox");
        this.myPrinterNameBox.setPrototypeDisplayValue(PROTOTYPE_DISPLAYABLE_VALUE_FOR_COMBO_BOXES);
        PrintService[] services = this.myPrintController.getPrintServices();
        PrintService defaultService = this.myPrintController.getDefaultPrintService();
        if (services != null) {
            int i = 0;
            while (i < services.length) {
                this.myPrinterNameBox.addItem(services[i].getName());
                ++i;
            }
        } else if (defaultService != null) {
            this.myPrinterNameBox.addItem(defaultService.getName());
        }
        if (defaultService != null) {
            this.myPrinterNameBox.setSelectedItem(defaultService.getName());
        }
        printerPanel.add((Component)this.myPrinterNameBox, "wrap");
        PLabel typeLabel = new PLabel();
        typeLabel.setLabelType(ClientProperties.LABEL_SYSTEM_TEXT);
        typeLabel.setName("PPrintDialog.printTypeLabel");
        printerPanel.add(typeLabel);
        printerPanel.add((Component)this.myPrinterTypeLabel, "wrap");
        PLabel statusLabel = new PLabel();
        statusLabel.setLabelType(ClientProperties.LABEL_SYSTEM_TEXT);
        statusLabel.setName("PPrintDialog.printerStatusLabel");
        printerPanel.add(statusLabel);
        printerPanel.add((Component)this.myPrinterStatusLabel, "wrap");
        PLabel locationLabel = new PLabel();
        locationLabel.setLabelType(ClientProperties.LABEL_SYSTEM_TEXT);
        locationLabel.setName("PPrintDialog.printerLocationLabel");
        printerPanel.add(locationLabel);
        printerPanel.add(this.myPrinterLocationLabel);
        generalPanel.add(printerPanel);
        this.updatePrinterInfo();
    }

    private void createPrintRangeArea(JPanel generalPanel) {
        JPanel buttons = new JPanel();
        buttons.setLayout(new BoxLayout(buttons, 1));
        ButtonGroup bGroup = new ButtonGroup();
        PMatrixLayout rangeAllLayout = new PMatrixLayout(4, 12, 0, 12, 0);
        rangeAllLayout.setComponentVerticalAlignment(2);
        JPanel rangeAllPanel = new JPanel(rangeAllLayout);
        PLabel rangeLabel = new PLabel();
        rangeLabel.setLabelType(ClientProperties.LABEL_SYSTEM_TEXT);
        rangeLabel.setLabelType(ClientProperties.LABEL_TITLE);
        rangeLabel.setName("PPrintDialog.printRangeLabel");
        generalPanel.add(rangeLabel);
        this.myAllPrintRange = new JRadioButton();
        this.myAllPrintRange.setName("PPrintDialog.printAllPagesButton");
        bGroup.add(this.myAllPrintRange);
        rangeAllPanel.add(this.myAllPrintRange);
        buttons.add(rangeAllPanel);
        PMatrixLayout rangePagesLayout = new PMatrixLayout(4, 12, 0, 12, 0);
        rangePagesLayout.setComponentVerticalAlignment(2);
        JPanel rangePagesPanel = new JPanel(rangePagesLayout);
        this.myPagesPrintRange = new JRadioButton();
        this.myPagesPrintRange.setName("PPrintDialog.printPagesButton");
        bGroup.add(this.myPagesPrintRange);
        rangePagesPanel.add(this.myPagesPrintRange);
        this.myFromPrintRangeSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 999, 1));
        JFormattedTextField fromSpinnerField = ((JSpinner.DefaultEditor)this.myFromPrintRangeSpinner.getEditor()).getTextField();
        ((DefaultFormatter)fromSpinnerField.getFormatter()).setAllowsInvalid(false);
        this.myFromPrintRangeSpinner.setEnabled(false);
        rangePagesPanel.add(this.myFromPrintRangeSpinner);
        this.myPageRangeToLabel = PLabel.createSystemText();
        this.myPageRangeToLabel.setName("PPrintDialog.printToLabel");
        this.myPageRangeToLabel.setEnabled(false);
        this.myPageRangeToLabel.setBorder(BorderFactory.createEmptyBorder());
        rangePagesPanel.add(this.myPageRangeToLabel);
        this.myToPrintRangeSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 999, 1));
        JFormattedTextField toSpinnerField = ((JSpinner.DefaultEditor)this.myToPrintRangeSpinner.getEditor()).getTextField();
        ((DefaultFormatter)toSpinnerField.getFormatter()).setAllowsInvalid(false);
        this.myToPrintRangeSpinner.setEnabled(false);
        rangePagesPanel.add(this.myToPrintRangeSpinner);
        buttons.add(rangePagesPanel);
        generalPanel.add(buttons);
    }

    private void createCopiesArea(JPanel generalPanel) {
        this.myNumberOfCopiesSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 999, 1));
        PLabel copiesLabel = new PLabel();
        copiesLabel.setLabelType(ClientProperties.LABEL_TITLE);
        copiesLabel.setName("PPrintDialog.printCopiesLabel");
        generalPanel.add(copiesLabel);
        JPanel nocPanel = new JPanel((LayoutManager)new MigLayout("insets 0 10 0 0"));
        PLabel numberOfCopiesLabel = new PLabel();
        numberOfCopiesLabel.setLabelType(ClientProperties.LABEL_SYSTEM_TEXT);
        numberOfCopiesLabel.setName("PPrintDialog.printNumberOfCopiesLabel");
        numberOfCopiesLabel.setDisplayedMnemonic(this.myBundle.getMnemonic("PPrintDialog.printNumberOfCopiesLabel_Mnemonic"));
        nocPanel.add(numberOfCopiesLabel);
        JFormattedTextField field = ((JSpinner.DefaultEditor)this.myNumberOfCopiesSpinner.getEditor()).getTextField();
        ((DefaultFormatter)field.getFormatter()).setAllowsInvalid(false);
        numberOfCopiesLabel.setLabelFor(field);
        numberOfCopiesLabel.setBorder(BorderFactory.createEmptyBorder());
        nocPanel.add(this.myNumberOfCopiesSpinner);
        generalPanel.add(nocPanel);
    }

    private JPanel createPageSetupTab() {
        PMatrixLayout pageLayout = new PMatrixLayout(1, 12, 12, 12, 12);
        JPanel pageSetupPanel = new JPanel(pageLayout);
        pageSetupPanel.setName("PPrintDialog.printPageSetupPanel");
        this.createMarginsPanel(pageSetupPanel);
        this.createUnitPanel(pageSetupPanel);
        this.createOrientationPanel(pageSetupPanel);
        this.createMediaPanel(pageSetupPanel);
        return pageSetupPanel;
    }

    private void createMarginsPanel(JPanel pageSetupPanel) {
        PLabel marginsLabel = new PLabel();
        marginsLabel.setLabelType(ClientProperties.LABEL_SYSTEM_TEXT);
        marginsLabel.setLabelType(ClientProperties.LABEL_TITLE);
        marginsLabel.setName("PPrintDialog.printMarginsLabel");
        pageSetupPanel.add(marginsLabel);
        PLabel topLabel = new PLabel();
        PLabel bottomLabel = new PLabel();
        PLabel leftLabel = new PLabel();
        PLabel rightLabel = new PLabel();
        topLabel.setLabelType(ClientProperties.LABEL_SYSTEM_TEXT);
        bottomLabel.setLabelType(ClientProperties.LABEL_SYSTEM_TEXT);
        leftLabel.setLabelType(ClientProperties.LABEL_SYSTEM_TEXT);
        rightLabel.setLabelType(ClientProperties.LABEL_SYSTEM_TEXT);
        PMatrixLayout marginsLayout = new PMatrixLayout(4, 12, 7, 12, 0);
        marginsLayout.setComponentVerticalAlignment(2);
        JPanel marginsPanel = new JPanel(marginsLayout);
        this.myTopMarginSpinner = new JSpinner(new SpinnerNumberModel(this.myBottomMargin, 0.5, 999.0, 1.0));
        JFormattedTextField topMarginSpinnerField = ((JSpinner.DefaultEditor)this.myTopMarginSpinner.getEditor()).getTextField();
        ((DefaultFormatter)topMarginSpinnerField.getFormatter()).setAllowsInvalid(false);
        topLabel.setLabelFor(topMarginSpinnerField);
        topLabel.setName("PPrintDialog.printTopMarginLabel");
        topLabel.setDisplayedMnemonic(this.myBundle.getMnemonic("PPrintDialog.printTopMarginLabel_Mnemonic"));
        marginsPanel.add(topLabel);
        marginsPanel.add(this.myTopMarginSpinner);
        this.myBottomMarginSpinner = new JSpinner(new SpinnerNumberModel(this.myBottomMargin, 0.5, 999.0, 1.0));
        JFormattedTextField bottomMarginSpinnerField = ((JSpinner.DefaultEditor)this.myBottomMarginSpinner.getEditor()).getTextField();
        ((DefaultFormatter)bottomMarginSpinnerField.getFormatter()).setAllowsInvalid(false);
        bottomLabel.setLabelFor(bottomMarginSpinnerField);
        bottomLabel.setName("PPrintDialog.printBottomMarginLabel");
        bottomLabel.setDisplayedMnemonic(this.myBundle.getMnemonic("PPrintDialog.printBottomMarginLabel_Mnemonic"));
        marginsPanel.add(bottomLabel);
        marginsPanel.add(this.myBottomMarginSpinner);
        this.myLeftMarginSpinner = new JSpinner(new SpinnerNumberModel(this.myBottomMargin, 0.5, 999.0, 1.0));
        JFormattedTextField leftMarginSpinnerField = ((JSpinner.DefaultEditor)this.myLeftMarginSpinner.getEditor()).getTextField();
        ((DefaultFormatter)leftMarginSpinnerField.getFormatter()).setAllowsInvalid(false);
        leftLabel.setLabelFor(leftMarginSpinnerField);
        leftLabel.setName("PPrintDialog.printLeftMarginLabel");
        leftLabel.setDisplayedMnemonic(this.myBundle.getMnemonic("PPrintDialog.printLeftMarginLabel_Mnemonic"));
        marginsPanel.add(leftLabel);
        marginsPanel.add(this.myLeftMarginSpinner);
        this.myRightMarginSpinner = new JSpinner(new SpinnerNumberModel(this.myBottomMargin, 0.5, 999.0, 1.0));
        JFormattedTextField rightMarginSpinnerField = ((JSpinner.DefaultEditor)this.myRightMarginSpinner.getEditor()).getTextField();
        ((DefaultFormatter)rightMarginSpinnerField.getFormatter()).setAllowsInvalid(false);
        rightLabel.setLabelFor(rightMarginSpinnerField);
        rightLabel.setName("PPrintDialog.printRightMarginLabel");
        rightLabel.setDisplayedMnemonic(this.myBundle.getMnemonic("PPrintDialog.printRightMarginLabel_Mnemonic"));
        marginsPanel.add(rightLabel);
        marginsPanel.add(this.myRightMarginSpinner);
        pageSetupPanel.add(marginsPanel);
    }

    private void createUnitPanel(JPanel pageSetupPanel) {
        PLabel unitLabel = new PLabel();
        unitLabel.setLabelType(ClientProperties.LABEL_SYSTEM_TEXT);
        unitLabel.setLabelType(ClientProperties.LABEL_TITLE);
        unitLabel.setName("PPrintDialog.printMarginsUnitLabel");
        pageSetupPanel.add(unitLabel);
        PMatrixLayout unitLayout = new PMatrixLayout(2, 12, 6, 12, 0);
        JPanel unitPanel = new JPanel();
        unitPanel.setLayout(unitLayout);
        ButtonGroup unitButtonGroup = new ButtonGroup();
        this.myMarginsInInches = new JRadioButton();
        this.myMarginsInInches.setMargin(new Insets(3, 2, 3, 2));
        this.myMarginsInInches.setName("PPrintDialog.printMarginsInInchesButton");
        unitButtonGroup.add(this.myMarginsInInches);
        unitPanel.add(this.myMarginsInInches);
        this.myMarginsInMm = new JRadioButton();
        this.myMarginsInMm.setMargin(new Insets(3, 2, 3, 2));
        this.myMarginsInMm.setName("PPrintDialog.printMarginsInMmButton");
        unitButtonGroup.add(this.myMarginsInMm);
        unitPanel.add(this.myMarginsInMm);
        this.myMarginsInInches.setSelected(true);
        pageSetupPanel.add(unitPanel);
    }

    private void createOrientationPanel(JPanel pageSetupPanel) {
        PLabel orientationLabel = new PLabel();
        orientationLabel.setLabelType(ClientProperties.LABEL_SYSTEM_TEXT);
        orientationLabel.setLabelType(ClientProperties.LABEL_TITLE);
        orientationLabel.setName("PPrintDialog.printOrientationLabel");
        pageSetupPanel.add(orientationLabel);
        PMatrixLayout orientationLayout = new PMatrixLayout(2, 12, 6, 12, 0);
        orientationLayout.setComponentVerticalAlignment(2);
        JPanel orientationPanel = new JPanel(orientationLayout);
        ButtonGroup orientationGroup = new ButtonGroup();
        this.myPortraitButton = new JRadioButton();
        this.myPortraitButton.setMargin(new Insets(3, 2, 3, 2));
        this.myPortraitButton.setName("PPrintDialog.printPortraitButton");
        if (this.myPortraitButton.isEnabled()) {
            this.myPortraitButton.setSelected(true);
        }
        orientationGroup.add(this.myPortraitButton);
        JLabel portraitIconLabel = new JLabel();
        JLabel landscapeIconLabel = new JLabel();
        portraitIconLabel.setIcon(CommonIcons.getPrintPortraitIcon());
        landscapeIconLabel.setIcon(CommonIcons.getPrintLandscapeIcon());
        this.myLandscapeButton = new JRadioButton();
        this.myLandscapeButton.setMargin(new Insets(3, 2, 3, 2));
        this.myLandscapeButton.setName("PPrintDialog.printLandscapeButton");
        this.myLandscapeButton.setEnabled(true);
        if (this.myLandscapeButton.isEnabled() && !this.myPortraitButton.isSelected()) {
            this.myLandscapeButton.setSelected(true);
        }
        orientationGroup.add(this.myLandscapeButton);
        orientationPanel.add(portraitIconLabel);
        orientationPanel.add(this.myPortraitButton);
        orientationPanel.add(landscapeIconLabel);
        orientationPanel.add(this.myLandscapeButton);
        pageSetupPanel.add(orientationPanel);
    }

    private void createMediaPanel(JPanel pageSetupPanel) {
        PLabel mediaLabel = new PLabel();
        mediaLabel.setName("PPrintDialog.printMediaLabel");
        mediaLabel.setLabelType(ClientProperties.LABEL_SYSTEM_TEXT);
        mediaLabel.setLabelType(ClientProperties.LABEL_TITLE);
        JPanel mediaPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(6, 0, 0, 6);
        mediaPanel.add((Component)mediaLabel, gbc);
        this.mySourceLabel = new PLabel();
        this.mySourceLabel.setLabelType(ClientProperties.LABEL_SYSTEM_TEXT);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = new Insets(12, 12, 0, 0);
        this.myMediaSourceBox = new JComboBox();
        this.myMediaSourceBox.setEnabled(false);
        this.mySourceLabel.setLabelFor(this.myMediaSourceBox);
        this.mySourceLabel.setName("PPrintDialog.printMediaSourceLabel");
        this.mySourceLabel.setDisplayedMnemonic(this.myBundle.getMnemonic("PPrintDialog.printMediaSourceLabel_Mnemonic"));
        this.mySourceLabel.setEnabled(false);
        mediaPanel.add((Component)this.mySourceLabel, gbc);
        gbc.gridx = 1;
        gbc.insets = new Insets(12, 12, 0, 6);
        this.myMediaSourceBox.setPrototypeDisplayValue(PROTOTYPE_DISPLAYABLE_VALUE_FOR_COMBO_BOXES);
        mediaPanel.add((Component)this.myMediaSourceBox, gbc);
        this.mySizeLabel = new PLabel();
        this.mySizeLabel.setLabelType(ClientProperties.LABEL_SYSTEM_TEXT);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = new Insets(6, 12, 4, 0);
        this.myMediaSizeBox = new JComboBox();
        this.myMediaSizeBox.setEnabled(false);
        this.mySizeLabel.setLabelFor(this.myMediaSizeBox);
        this.mySizeLabel.setName("PPrintDialog.printMediaSizeLabel");
        this.mySizeLabel.setDisplayedMnemonic(this.myBundle.getMnemonic("PPrintDialog.printMediaSizeLabel_Mnemonic"));
        this.mySizeLabel.setEnabled(false);
        mediaPanel.add((Component)this.mySizeLabel, gbc);
        gbc.gridx = 1;
        gbc.insets = new Insets(6, 12, 4, 0);
        this.myMediaSizeBox.setPrototypeDisplayValue(PROTOTYPE_DISPLAYABLE_VALUE_FOR_COMBO_BOXES);
        mediaPanel.add((Component)this.myMediaSizeBox, gbc);
        pageSetupPanel.add(mediaPanel);
    }

    private PrintService getSelectedPrintService() {
        return this.myPrintController != null ? this.myPrintController.getPrintService(this.myPrinterNameBox.getSelectedIndex()) : null;
    }

    private void enablePrintRangeSelection(boolean enabled) {
        this.myFromPrintRangeSpinner.setEnabled(enabled);
        this.myToPrintRangeSpinner.setEnabled(enabled);
        this.myPageRangeToLabel.setEnabled(enabled);
    }

    private void updateMarginalSpinners() {
        if (this.myMarginsInMm.isSelected()) {
            this.myIsSelectedInches = false;
            Double stepSize = new Double(1.0);
            ((SpinnerNumberModel)this.myTopMarginSpinner.getModel()).setStepSize(stepSize);
            ((SpinnerNumberModel)this.myBottomMarginSpinner.getModel()).setStepSize(stepSize);
            ((SpinnerNumberModel)this.myLeftMarginSpinner.getModel()).setStepSize(stepSize);
            ((SpinnerNumberModel)this.myRightMarginSpinner.getModel()).setStepSize(stepSize);
            this.myTopMarginSpinner.setValue(new Double(Math.min(this.myTopMargin * 25.0, 999.0)));
            this.myBottomMarginSpinner.setValue(new Double(Math.min(this.myBottomMargin * 25.0, 999.0)));
            this.myLeftMarginSpinner.setValue(new Double(Math.min(this.myLeftMargin * 25.0, 999.0)));
            this.myRightMarginSpinner.setValue(new Double(Math.min(this.myRightMargin * 25.0, 999.0)));
        } else if (this.myMarginsInInches.isSelected()) {
            this.myIsSelectedInches = true;
            Double stepSize = new Double(0.1);
            ((SpinnerNumberModel)this.myTopMarginSpinner.getModel()).setStepSize(stepSize);
            ((SpinnerNumberModel)this.myBottomMarginSpinner.getModel()).setStepSize(stepSize);
            ((SpinnerNumberModel)this.myLeftMarginSpinner.getModel()).setStepSize(stepSize);
            ((SpinnerNumberModel)this.myRightMarginSpinner.getModel()).setStepSize(stepSize);
            this.myTopMarginSpinner.setValue(new Double(this.myTopMargin));
            this.myBottomMarginSpinner.setValue(new Double(this.myBottomMargin));
            this.myLeftMarginSpinner.setValue(new Double(this.myLeftMargin));
            this.myRightMarginSpinner.setValue(new Double(this.myRightMargin));
        }
        this.myMarginalsUpdated = true;
    }

    private void updateMarginals() {
        if (this.myMarginsInMm.isSelected()) {
            this.myTopMargin = Math.max(((SpinnerNumberModel)this.myTopMarginSpinner.getModel()).getNumber().doubleValue() / 25.0, 0.5);
            this.myBottomMargin = Math.max(((SpinnerNumberModel)this.myBottomMarginSpinner.getModel()).getNumber().doubleValue() / 25.0, 0.5);
            this.myLeftMargin = Math.max(((SpinnerNumberModel)this.myLeftMarginSpinner.getModel()).getNumber().doubleValue() / 25.0, 0.5);
            this.myRightMargin = Math.max(((SpinnerNumberModel)this.myRightMarginSpinner.getModel()).getNumber().doubleValue() / 25.0, 0.5);
            this.myMarginalsUpdated = true;
        } else if (this.myMarginsInInches.isSelected()) {
            this.myTopMargin = ((SpinnerNumberModel)this.myTopMarginSpinner.getModel()).getNumber().doubleValue();
            this.myBottomMargin = ((SpinnerNumberModel)this.myBottomMarginSpinner.getModel()).getNumber().doubleValue();
            this.myLeftMargin = ((SpinnerNumberModel)this.myLeftMarginSpinner.getModel()).getNumber().doubleValue();
            this.myRightMargin = ((SpinnerNumberModel)this.myRightMarginSpinner.getModel()).getNumber().doubleValue();
            this.myMarginalsUpdated = true;
        }
    }

    private void updatePrinterInfo() {
        PrintService printService = this.getSelectedPrintService();
        if (printService == null) {
            return;
        }
        String printerType = this.myBundle.getString("PPrintDialog.printServiceTypeNotAvailable_Text");
        String printerStatus = this.myBundle.getString("PPrintDialog.printServiceStatusNotAvailable_Text");
        String printerLocation = this.myBundle.getString("PPrintDialog.printServiceLocationNotAvailable_Text");
        PrinterMakeAndModel pServiceTypeAttr = printService.getAttribute(PrinterMakeAndModel.class);
        if (pServiceTypeAttr != null) {
            printerType = pServiceTypeAttr.getName();
        }
        this.myPrinterTypeLabel.setText(printerType);
        EnumSyntax pServiceStatusAttr = printService.getAttribute(PrinterState.class);
        if (pServiceStatusAttr != null) {
            printerStatus = pServiceStatusAttr.getName();
        } else {
            pServiceStatusAttr = printService.getAttribute(PrinterIsAcceptingJobs.class);
            if (pServiceStatusAttr != null && pServiceStatusAttr.equals(PrinterIsAcceptingJobs.ACCEPTING_JOBS)) {
                printerStatus = this.myBundle.getString("PPrintDialog.printServiceAcceptingJob_Text");
            }
        }
        this.myPrinterStatusLabel.setText(printerStatus);
        PrinterLocation pServiceLocationAttr = printService.getAttribute(PrinterLocation.class);
        if (pServiceLocationAttr != null) {
            printerLocation = pServiceLocationAttr.getName();
        }
        this.myPrinterLocationLabel.setText(printerLocation);
    }

    protected void updateMediaSelections() {
        new Thread(new MediaSourceUpdater()).start();
    }

    protected void helpRequest() {
        this.myPrintController.helpRequested();
    }

    private void cancelRequest() {
        this.storePrinterSettings();
        if (this.myPrintController != null) {
            this.myPrintController.destroy();
        } else {
            super.dispose();
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.myPrinterNameBox)) {
            this.updatePrinterInfo();
            this.updateMediaSelections();
        } else if (event.getSource().equals(this.myPagesPrintRange)) {
            this.enablePrintRangeSelection(true);
        } else if (event.getSource().equals(this.myAllPrintRange)) {
            this.enablePrintRangeSelection(false);
        } else if (event.getSource().equals(this.myHelpButton)) {
            this.helpRequest();
        } else if (event.getSource().equals(this.myPrintButton)) {
            if (!this.myMarginalsUpdated) {
                this.updateMarginals();
            }
            this.myPrintController.repaginate();
            this.storePrinterSettings();
            this.myPrintController.startPrinting(this.getSelectedPrintService());
            if (this.myPrintController != null) {
                this.myPrintController.destroy();
            }
        } else if (event.getSource().equals(this.myCancelButton)) {
            this.cancelRequest();
        } else if (event.getSource().equals(this.myMarginsInInches) && !this.myIsSelectedInches) {
            this.myTopMargin = Math.max(((SpinnerNumberModel)this.myTopMarginSpinner.getModel()).getNumber().doubleValue() / 25.0, 0.5);
            this.myBottomMargin = Math.max(((SpinnerNumberModel)this.myBottomMarginSpinner.getModel()).getNumber().doubleValue() / 25.0, 0.5);
            this.myLeftMargin = Math.max(((SpinnerNumberModel)this.myLeftMarginSpinner.getModel()).getNumber().doubleValue() / 25.0, 0.5);
            this.myRightMargin = Math.max(((SpinnerNumberModel)this.myRightMarginSpinner.getModel()).getNumber().doubleValue() / 25.0, 0.5);
            this.updateMarginalSpinners();
        } else if (event.getSource().equals(this.myMarginsInMm) && this.myIsSelectedInches) {
            this.myTopMargin = ((SpinnerNumberModel)this.myTopMarginSpinner.getModel()).getNumber().doubleValue();
            this.myBottomMargin = ((SpinnerNumberModel)this.myBottomMarginSpinner.getModel()).getNumber().doubleValue();
            this.myLeftMargin = ((SpinnerNumberModel)this.myLeftMarginSpinner.getModel()).getNumber().doubleValue();
            this.myRightMargin = ((SpinnerNumberModel)this.myRightMarginSpinner.getModel()).getNumber().doubleValue();
            this.updateMarginalSpinners();
        }
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        if (this.myNumberOfCopiesSpinner.equals(event.getSource())) {
            this.myNumberOfCopies = ((SpinnerNumberModel)this.myNumberOfCopiesSpinner.getModel()).getNumber().intValue();
        } else if (event.getSource().getClass().equals(JTabbedPane.class)) {
            if (!this.myMarginalsUpdated) {
                this.updateMarginals();
            }
            this.myPrintController.repaginate();
        } else if (event.getSource().equals(this.myBottomMarginSpinner) || event.getSource().equals(this.myTopMarginSpinner) || event.getSource().equals(this.myLeftMarginSpinner) || event.getSource().equals(this.myRightMarginSpinner)) {
            if (this.myMarginsInMm.isSelected()) {
                this.myMarginalsUpdated = false;
            } else if (this.myMarginsInInches.isSelected()) {
                this.myMarginalsUpdated = false;
            }
        } else if (event.getSource().equals(this.myFromPrintRangeSpinner)) {
            this.myPrintRangeFrom = ((SpinnerNumberModel)this.myFromPrintRangeSpinner.getModel()).getNumber().intValue();
        } else if (event.getSource().equals(this.myToPrintRangeSpinner)) {
            this.myPrintRangeTo = ((SpinnerNumberModel)this.myToPrintRangeSpinner.getModel()).getNumber().intValue();
        }
    }

    private class MediaSourceUpdater
    implements Runnable {
        private MediaSourceUpdater() {
        }

        @Override
        public void run() {
            this.doInBackground();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MediaSourceUpdater.this.done();
                }
            });
        }

        protected Object doInBackground() {
            PPrintDialog.this.myMediaSources = PPrintDialog.this.myPrintController != null ? PPrintDialog.this.myPrintController.getAvailableSources(PPrintDialog.this.getSelectedPrintService()) : null;
            PPrintDialog.this.myMediaSizes = PPrintDialog.this.myPrintController != null ? PPrintDialog.this.myPrintController.getAvailableSizes(PPrintDialog.this.getSelectedPrintService()) : null;
            return null;
        }

        protected void done() {
            int i;
            String automaticSelect = PPrintDialog.this.myBundle.getString("PPrintDialog.printServiceAutomaticSource_Text");
            PPrintDialog.this.myMediaSourceBox.removeAllItems();
            PPrintDialog.this.myMediaSourceBox.addItem(automaticSelect);
            if (PPrintDialog.this.myMediaSources != null) {
                i = 0;
                while (i < PPrintDialog.this.myMediaSources.length) {
                    PPrintDialog.this.myMediaSourceBox.addItem(PPrintDialog.this.myMediaSources[i]);
                    ++i;
                }
                PPrintDialog.this.myMediaSourceBox.setSelectedItem(automaticSelect);
                PPrintDialog.this.myMediaSourceBox.setEnabled(true);
                PPrintDialog.this.mySourceLabel.setEnabled(true);
            }
            PPrintDialog.this.myMediaSizeBox.removeAllItems();
            if (PPrintDialog.this.myMediaSizes != null) {
                i = 0;
                while (i < PPrintDialog.this.myMediaSizes.length) {
                    if (MediaSize.getMediaSizeForName((MediaSizeName)PPrintDialog.this.myMediaSizes[i]) != null) {
                        PPrintDialog.this.myMediaSizeBox.addItem(PPrintDialog.this.myMediaSizes[i]);
                    }
                    ++i;
                }
                PPrintDialog.this.myMediaSizeBox.setSelectedItem(PPrintDialog.this.getSelectedPrintService().getDefaultAttributeValue(Media.class));
                PPrintDialog.this.myMediaSizeBox.setEnabled(true);
                PPrintDialog.this.mySizeLabel.setEnabled(true);
            }
            PPrintDialog.this.myIsInitialized = true;
        }
    }
}

