/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.print;

import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.frameworks.print.PPrintableDoc;
import com.nokia.em.poseidon.gui.print.PPrintControl;
import com.nokia.em.poseidon.services.ui.UserInterface;
import com.nokia.em.poseidon.util.PSettings;
import java.util.HashMap;
import java.util.Map;

public final class PrintDialogFactory {
    private static PrintDialogFactory theInstance;

    public static synchronized PrintDialogFactory getInstance() {
        if (theInstance == null) {
            theInstance = new PrintDialogFactory();
        }
        return theInstance;
    }

    private PrintDialogFactory() {
    }

    public static void showPrintdialog(PPrintableDoc doc) {
        PrintDialogFactory.showPrintdialog(doc, null, null);
    }

    public static void showPrintdialog(PPrintableDoc doc, String title, String keyPrefix) {
        PrintDialogFactory.showPrintdialog(doc, title, keyPrefix, null);
    }

    public static void showPrintdialog(PPrintableDoc doc, String title, String keyPrefix, Map<String, Object> properties) {
        Map<String, Object> props = PrintDialogFactory.restoreProperties(keyPrefix);
        props.put("keySettings", keyPrefix);
        if (properties != null && !properties.containsKey("parentfame") && !properties.containsKey("parentdialog") || properties == null) {
            props.put("parentfame", PoseidonRuntime.getRuntime().getService(UserInterface.class).getFrame());
        }
        if (title != null) {
            props.put("dialogtitle", title);
        }
        if (properties != null) {
            props.putAll(properties);
        }
        PPrintControl ctrl = new PPrintControl(doc, props);
        PrintDialogFactory.storeProperties(ctrl.getProperties(), keyPrefix);
    }

    private static Map<String, Object> restoreProperties(String keyPrefix) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        String validKeyPrefix = "";
        if (keyPrefix != null) {
            validKeyPrefix = keyPrefix;
        }
        PrintDialogFactory.restoreStringProperty(validKeyPrefix, "defaultprinter", properties);
        PrintDialogFactory.restoreStringProperty(validKeyPrefix, "defaultsize", properties);
        return properties;
    }

    private static void storeProperties(Map<String, Object> properties, String keyPrefix) {
        String validKeyPrefix = "";
        if (keyPrefix != null) {
            validKeyPrefix = keyPrefix;
        }
        PrintDialogFactory.storeStringProperty(validKeyPrefix, "defaultprinter", properties);
        PrintDialogFactory.storeStringProperty(validKeyPrefix, "defaultsize", properties);
        PSettings.getInstance().save();
    }

    private static void storeStringProperty(String keyPrefix, String key, Map<String, Object> properties) {
        if (properties.containsKey(key)) {
            PSettings.getInstance().set(String.valueOf(keyPrefix) + key, (String)properties.get(key));
        }
    }

    private static void restoreStringProperty(String keyPrefix, String key, Map<String, Object> properties) {
        if (PSettings.getInstance().isValueStored(String.valueOf(keyPrefix) + key)) {
            properties.put(key, PSettings.getInstance().get(String.valueOf(keyPrefix) + key, ""));
        }
    }
}

