/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.raml;

import com.nokia.em.poseidon.util.TextUtils;
import com.nokia.widgets.infotip.InfoTip;
import com.nokia.widgets.labels.PLabel;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumnModel;

public class TableCellInfoTipProvider
implements MouseListener,
MouseMotionListener {
    private int myCurrentRow = -1;
    private int myCurrentColumn = -1;
    protected JTable myValidationTable;
    protected InfoTip myInfoTip;
    private JLabel myContent;
    private int myColumnIndex;

    public TableCellInfoTipProvider(JTable table, int columnIndex) {
        this.myValidationTable = table;
        this.myContent = PLabel.createValueText("");
        this.myInfoTip = new InfoTip((Component)this.myValidationTable, true);
        this.myInfoTip.setTipContent(this.myContent);
        this.myInfoTip.setDisplayStrategy(3);
        this.myContent.setBorder(BorderFactory.createEmptyBorder(4, 6, 4, 6));
        table.addMouseListener(this);
        table.addMouseMotionListener(this);
        this.myColumnIndex = columnIndex;
    }

    private void setInfo(String info) {
        this.myContent.setText(info);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.resetCellPosition();
        if (this.myValidationTable == null || this.myValidationTable.getParent() == null) {
            this.myInfoTip.setVisible(false);
            return;
        }
        Rectangle infoTipBounds = SwingUtilities.convertRectangle(this.myInfoTip, SwingUtilities.getLocalBounds(this.myInfoTip), this.myValidationTable.getParent());
        if (infoTipBounds == null || !infoTipBounds.contains(e.getPoint())) {
            this.myInfoTip.setVisible(false);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.resetCellPosition();
        this.myInfoTip.setVisible(false);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.resetCellPosition();
        this.myInfoTip.setVisible(false);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int row = this.myValidationTable.rowAtPoint(e.getPoint());
        int column = this.myValidationTable.columnAtPoint(e.getPoint());
        if (column == this.myColumnIndex && row > -1) {
            if (row == this.myCurrentRow && column == this.myCurrentColumn) {
                return;
            }
            this.myInfoTip.setVisible(false);
            Object tipText = this.myValidationTable.getValueAt(row, column);
            FontMetrics fontMetrics = this.myValidationTable.getFontMetrics(this.myValidationTable.getFont());
            int width = SwingUtilities.computeStringWidth(fontMetrics, tipText.toString());
            TableColumnModel columnModel = this.myValidationTable.getColumnModel();
            int contentWidth = columnModel.getColumn(column).getWidth() - 2 * this.myValidationTable.getIntercellSpacing().width - SwingUtilities.computeStringWidth(fontMetrics, "...");
            if (width > contentWidth + 2) {
                int rowLength = 80;
                if (tipText.toString().length() >= rowLength) {
                    String separateLine = "\n";
                    int maxRowCount = 10;
                    String toolTipText = TextUtils.forcedTextWrap(tipText.toString().trim(), separateLine, rowLength, maxRowCount, fontMetrics);
                    this.setInfo(toolTipText);
                    this.myValidationTable.setValueAt(String.valueOf(tipText.toString().substring(0, rowLength)) + "...", row, column);
                } else {
                    this.setInfo(TextUtils.textWrap(tipText.toString().trim()));
                }
                if (!this.myValidationTable.isRowSelected(this.myValidationTable.rowAtPoint(e.getPoint()))) {
                    this.myInfoTip.show(this.myValidationTable, e.getX(), e.getY() + 20);
                }
            } else {
                this.myInfoTip.setVisible(false);
            }
        } else {
            this.myInfoTip.setVisible(false);
        }
        this.myCurrentRow = row;
        this.myCurrentColumn = column;
    }

    private void resetCellPosition() {
        this.myCurrentColumn = -1;
        this.myCurrentRow = -1;
    }
}

