/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.raml;

import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.frameworks.mvc.ControllerBase;
import com.nokia.em.poseidon.frameworks.raml.RAMLValidationContext;
import com.nokia.em.poseidon.frameworks.raml.RAMLValidationResult;
import com.nokia.em.poseidon.gui.print.PrintDialogFactory;
import com.nokia.em.poseidon.gui.raml.ValidationDetailsPrintableDoc;
import com.nokia.em.poseidon.gui.raml.ValidationDetailsView;
import com.nokia.em.poseidon.gui.raml.edit.RAMLEditPanel;
import com.nokia.em.poseidon.gui.savechooser.SaveChooserController;
import com.nokia.em.poseidon.gui.savechooser.SaveChooserFactory;
import com.nokia.em.poseidon.gui.savechooser.SaveChooserModel;
import com.nokia.em.poseidon.util.PSettings;
import com.nokia.em.poseidon.util.file.PFileFilter;
import java.io.File;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class ValidationDetailsController
extends ControllerBase {
    private static final String VALIDATION_DETAILS_COMPONENT = "VALIDATION_DETAILS_COMPONENT";
    private static final String FILE_EXTENSION = "xml";
    private static final String DEFAULT_FILE_NAME = "Validation_Results.xml";
    private static final String SETTINGS_KEY_SAVING_FILE = "ValidationDetailsFile";
    private RAMLValidationContext myValidationContext;
    private Logger myLogger = Logger.getLogger(this.getClass());
    private ResourceBundle myResourceBundle = I18n.getI18n().getBundle(this.getClass());
    private RAMLEditPanel myEditPanel;

    public ValidationDetailsController() {
    }

    public ValidationDetailsController(RAMLEditPanel panel) {
        this();
        this.myEditPanel = panel;
    }

    public void setValidationContext(RAMLValidationContext validationContext) {
        this.myValidationContext = validationContext;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ValidationDetailsController.this.myValidationContext != null) {
                    ((ValidationDetailsView)((Object)ValidationDetailsController.this.getView())).setValidationResults(ValidationDetailsController.this.myValidationContext.getResults());
                }
            }
        });
    }

    public RAMLValidationContext getValidationContext() {
        return this.myValidationContext;
    }

    public void saveValidationDetails(String titleKey) {
        SaveChooserController myChooser = SaveChooserFactory.createFileChooserController();
        SaveChooserModel saveModel = myChooser.getModel();
        saveModel.setDefaultFileName(DEFAULT_FILE_NAME);
        saveModel.setDialogTitleKey(titleKey);
        saveModel.setSettings(PSettings.getInstance());
        saveModel.setSettingsKey(SETTINGS_KEY_SAVING_FILE);
        saveModel.setDefaultPath(PoseidonRuntime.getRuntime().getUserHome());
        saveModel.setFileFilter(new PFileFilter(FILE_EXTENSION, this.myResourceBundle.getString("ValidationDetailsView.XMLFileFilter_Text")));
        myChooser.setVisible(true);
        File destination = myChooser.selectFile();
        if (destination != null) {
            try {
                this.myValidationContext.writeToFile(destination);
            }
            catch (Exception e) {
                ((ValidationDetailsView)((Object)this.getView())).showErrorDialog(this.myResourceBundle.getString(titleKey), this.myResourceBundle.getString("ValidationDetailsView.SaveErrorHeadline_Text"), this.myResourceBundle.getString("ValidationDetailsView.SaveErrorMessage_Text"));
                this.myLogger.error("Failed to save validation details.", e);
            }
        }
    }

    public void printValidationDetails() {
        ValidationDetailsPrintableDoc printer = new ValidationDetailsPrintableDoc(this.myValidationContext);
        printer.doPrinting();
        PrintDialogFactory.showPrintdialog(printer, I18n.getI18n().getBundle(this.getClass()).getString("ValidationDetailsView.PrintDialogTitle_Text"), VALIDATION_DETAILS_COMPONENT);
    }

    public void validationResultSelected(RAMLValidationResult result, boolean isFocused) {
        if (this.myEditPanel != null) {
            this.myEditPanel.highlightResult(result, isFocused);
        }
    }
}

