/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.raml;

import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.frameworks.i18n.localizer.Localizer;
import com.nokia.em.poseidon.frameworks.i18n.localizer.LocalizerRegistry;
import com.nokia.em.poseidon.frameworks.i18n.localizer.swing.SwingHierarchyIterator;
import com.nokia.em.poseidon.frameworks.mvc.Controller;
import com.nokia.em.poseidon.frameworks.mvc.swing.JDialogViewBase;
import com.nokia.em.poseidon.frameworks.raml.RAMLValidationResult;
import com.nokia.em.poseidon.gui.common.PStaticDialogs;
import com.nokia.em.poseidon.gui.common.taskview.PTaskViewButtonBar;
import com.nokia.em.poseidon.gui.raml.ValidationDetailsController;
import com.nokia.em.poseidon.gui.raml.ValidationDetailsPanel;
import com.nokia.em.poseidon.gui.raml.ValidationDetailsView;
import com.nokia.em.poseidon.services.help.PHelp;
import com.nokia.widgets.buttons.PHelpButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.SwingUtilities;

public class ValidationDetailsDialog
extends JDialogViewBase
implements ValidationDetailsView {
    private static final int MINIMUM_DIALOG_HEIGHT = 500;
    private ValidationDetailsPanel myValidationPanel;
    private JButton mySaveButton;
    private JButton myPrintButton;

    public ValidationDetailsDialog(ValidationDetailsController controller, Frame owner, String title) {
        super((Controller)controller, owner);
        this.setTitle(title);
        this.setName(title);
        this.buidUI();
        controller.setView(this);
        this.restoreSettings();
    }

    public ValidationDetailsDialog(ValidationDetailsController controller, Dialog owner, String title) {
        super((Controller)controller, owner);
        this.setTitle(title);
        this.setName(title);
        this.buidUI();
        controller.setView(this);
        this.restoreSettings();
    }

    private void buidUI() {
        this.setLayout(new BorderLayout());
        this.myValidationPanel = new ValidationDetailsPanel((ValidationDetailsController)this.getController());
        this.myValidationPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.add((Component)this.myValidationPanel, "Center");
        this.mySaveButton = new JButton();
        this.mySaveButton.setName("ValidationDetailsView.SaveDetails");
        this.mySaveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((ValidationDetailsController)ValidationDetailsDialog.this.getController()).saveValidationDetails("ValidationDetailsView.IncorrectFile_SaveDialogTitle_Text");
            }
        });
        this.myPrintButton = new JButton();
        this.myPrintButton.setName("ValidationDetailsView.PrintDetails");
        this.myPrintButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((ValidationDetailsController)ValidationDetailsDialog.this.getController()).printValidationDetails();
            }
        });
        JButton closeButton = new JButton();
        closeButton.setName("CloseAction");
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ValidationDetailsDialog.this.getController().destroy();
            }
        });
        PHelpButton helpButton = new PHelpButton(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PoseidonRuntime.getRuntime().getService(PHelp.class).showHelp(ValidationDetailsDialog.this, "Poseidon_IncorrectFileContentDetails");
            }
        });
        AbstractButton[] buttons = new AbstractButton[]{helpButton, this.mySaveButton, this.myPrintButton, closeButton};
        PTaskViewButtonBar buttonBar = new PTaskViewButtonBar(buttons);
        this.add((Component)buttonBar, "South");
        Localizer localizer = LocalizerRegistry.lookup("swing");
        localizer.localizeObjectHierarchy(new SwingHierarchyIterator(this));
        int width = 970;
        this.setMinimumSize(new Dimension(width, 500));
        this.setPreferredSize(new Dimension(width, 500));
        this.updateButtonStatus(false);
        this.setModal(true);
        this.pack();
    }

    private void updateButtonStatus(boolean enabled) {
        this.mySaveButton.setEnabled(enabled);
        this.myPrintButton.setEnabled(enabled);
    }

    @Override
    public void setValidationResults(List<RAMLValidationResult> validationResults) {
        this.updateButtonStatus(!validationResults.isEmpty());
        this.myValidationPanel.setValidationResults(validationResults);
    }

    @Override
    public void showErrorDialog(String title, String headline, String message) {
        PStaticDialogs.showErrorDialog(this, title, headline, message, null);
    }

    @Override
    public void setVisible(boolean visible) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ValidationDetailsDialog.this.myValidationPanel.resizeTable();
            }
        });
        super.setVisible(visible);
    }
}

