/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.raml;

import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.frameworks.mvc.swing.JPanelViewBase;
import com.nokia.em.poseidon.frameworks.raml.RAMLValidationResult;
import com.nokia.em.poseidon.gui.common.PStaticDialogs;
import com.nokia.em.poseidon.gui.raml.TableCellInfoTipProvider;
import com.nokia.em.poseidon.gui.raml.ValidationDetailsController;
import com.nokia.em.poseidon.gui.raml.ValidationDetailsMessageCellEditor;
import com.nokia.em.poseidon.gui.raml.ValidationDetailsMessageCellRenderer;
import com.nokia.em.poseidon.gui.raml.ValidationDetailsTable;
import com.nokia.em.poseidon.gui.raml.ValidationDetailsTableModel;
import com.nokia.em.poseidon.gui.raml.ValidationDetailsView;
import com.nokia.em.poseidon.services.ui.UserInterface;
import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.util.GradientUtils;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.commandbar.CommandBar;
import com.nokia.widgets.icons.CommonIcons;
import com.nokia.widgets.icons.PEmptyIcon;
import com.nokia.widgets.labels.ItemCountLabel;
import com.nokia.widgets.labels.PLabel;
import com.nokia.widgets.table.PTable;
import com.nokia.widgets.table.PTableCellRenderer;
import com.nokia.widgets.table.PTableModelSorter;
import com.nokia.widgets.util.ScaleUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.ColorUIResource;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;

public class ValidationDetailsPanel
extends JPanelViewBase
implements ValidationDetailsView,
TableModelListener,
TableColumnModelListener {
    private static final int MINIMUM_COLUMN_WIDTH = 16;
    private static final int MARGIN = 12;
    private static final int ICON_WIDTH = 10;
    protected static final int TYPE_COLUMN_WIDTH = 80;
    protected static final int MANAGED_OBJECT_COLUMN_WIDTH = 260;
    protected static final int DESC_COLUMN_WIDTH = 200;
    protected static final int PARAMETER_COLUMN_WIDTH = 140;
    protected static final int DETAILED_DESC_COLUMN_WIDTH = 250;
    private static final int DOUBLE_CLICK = 2;
    private static final Color[] ERROR_COLOR = new Color[]{NetUtils.decodeColor("#FF1A1A"), NetUtils.decodeColor("#E81515")};
    private static final Color[] WARNING_COLOR = new Color[]{NetUtils.decodeColor("#FED11A"), NetUtils.decodeColor("#E6B802")};
    private static final PEmptyIcon EMPTY_ICON = new PEmptyIcon(25, 6);
    protected ResourceBundle myResourceBundle;
    protected ValidationDetailsTableModel myValidationDetailsTableModel;
    protected ItemCountLabel myHeaderLabel = new ItemCountLabel();
    protected boolean myIncludeHeader = false;
    protected PTable myValidationDetailsTable;
    protected JProgressBar myValidationProgress = new JProgressBar();
    protected JLabel myValidationLabel = PLabel.createValueText();
    protected CommandBar myCommandBar;
    protected AbstractAction mySaveValidationAction;
    private Map<Integer, Double> myColumnWidthMap = new HashMap<Integer, Double>();
    private final TableColumn myDummyColumn = new TableColumn();
    private boolean myIsDevMode = "on".equals(PoseidonRuntime.getRuntime().getParameters().getFirstValue("devmode"));

    public ValidationDetailsPanel(ValidationDetailsController controller, boolean includeHeader) {
        super(controller);
        this.myIncludeHeader = includeHeader;
        this.myResourceBundle = I18n.getI18n().getBundle(this.getClass());
        this.buildUI();
        controller.setView(this);
    }

    public ValidationDetailsPanel(ValidationDetailsController controller) {
        this(controller, false);
    }

    protected void buildUI() {
        this.setLayout(new BorderLayout());
        if (this.myIncludeHeader) {
            JPanel header = new JPanel((LayoutManager)new MigLayout("insets 2 6 2 2, gap 6"));
            header.add(PLabel.createTitle(this.myResourceBundle.getString("RAMLValidation.DetailsPanel.Errors")));
            this.myHeaderLabel.setVisible(false);
            header.add((Component)this.myHeaderLabel, "growy");
            header.add((Component)this.createCommandBar(), "push, alignx right, aligny top");
            this.add((Component)header, "North");
        }
        this.add(this.createValidationDetailsTable());
        this.myValidationProgress.setIndeterminate(true);
        this.myValidationProgress.setStringPainted(false);
        this.myValidationLabel.setText(this.myResourceBundle.getString("ValidationDetailsView.Validating"));
    }

    protected CommandBar createCommandBar() {
        this.myCommandBar = new CommandBar(){

            @Override
            protected JButton createActionComponent(Action action) {
                JButton result = super.createActionComponent(action);
                result.setMargin(new Insets(3, 3, 3, 3));
                return result;
            }
        };
        this.mySaveValidationAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((ValidationDetailsController)ValidationDetailsPanel.this.getController()).saveValidationDetails("ValidationDetailsView.SaveDialogTitle_Text");
            }
        };
        this.mySaveValidationAction.putValue("SmallIcon", CommonIcons.getSaveAsIcon());
        this.myCommandBar.add(this.mySaveValidationAction, (Object)"East");
        return this.myCommandBar;
    }

    protected JScrollPane createValidationDetailsTable() {
        String[] columnTitles = new String[this.myIsDevMode ? 6 : 5];
        columnTitles[0] = this.myResourceBundle.getString("ValidationDetailsView.Type_Text");
        columnTitles[1] = this.myResourceBundle.getString("ValidationDetailsView.ManagedObject_Text");
        columnTitles[3] = this.myResourceBundle.getString("ValidationDetailsView.Parameter_Text");
        columnTitles[2] = this.myResourceBundle.getString("ValidationDetailsView.ErrorDesc_Text");
        columnTitles[4] = this.myResourceBundle.getString("ValidationDetailsView.DetailErrorDesc_Text");
        if (this.myIsDevMode) {
            columnTitles[5] = "RID";
        }
        this.myValidationDetailsTableModel = new ValidationDetailsTableModel(columnTitles);
        this.myValidationDetailsTableModel.addTableModelListener(this);
        final PTableModelSorter sorter = new PTableModelSorter(this.myValidationDetailsTableModel);
        sorter.sort(true, 0);
        this.myValidationDetailsTable = new ValidationDetailsTable(sorter);
        if (this.myIncludeHeader) {
            this.myValidationDetailsTable.setStandalone(false);
            this.myValidationDetailsTable.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            JTableHeader header = this.myValidationDetailsTable.getTableHeader();
            header.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1));
        }
        new InfoTipProvider(this.myValidationDetailsTable);
        this.myValidationDetailsTable.setName("ValidationDetailsTable");
        this.myValidationDetailsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    final int row = ValidationDetailsPanel.this.myValidationDetailsTable.rowAtPoint(e.getPoint());
                    final int clickCount = e.getClickCount();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (row > -1 && ValidationDetailsPanel.this.myController != null) {
                                int originalRow = sorter.getOriginalIndex(row);
                                if (clickCount == 2 && originalRow >= 0) {
                                    ((ValidationDetailsController)ValidationDetailsPanel.this.myController).validationResultSelected((this).ValidationDetailsPanel.this.myValidationDetailsTableModel.getResult(originalRow), true);
                                } else if (originalRow >= 0) {
                                    ((ValidationDetailsController)ValidationDetailsPanel.this.myController).validationResultSelected((this).ValidationDetailsPanel.this.myValidationDetailsTableModel.getResult(originalRow), false);
                                }
                            }
                        }
                    });
                }
            }
        });
        this.myValidationDetailsTable.addMouseMotionListener(new MouseMotionListener(){
            private final Cursor textCursor = Cursor.getPredefinedCursor(2);
            private final Cursor defaultCursor = Cursor.getPredefinedCursor(12);

            @Override
            public void mouseMoved(MouseEvent e) {
                int rowAtPoint = ValidationDetailsPanel.this.myValidationDetailsTable.rowAtPoint(e.getPoint());
                int colAtPoint = ValidationDetailsPanel.this.myValidationDetailsTable.columnAtPoint(e.getPoint());
                if (rowAtPoint == -1 || colAtPoint == -1) {
                    return;
                }
                if (colAtPoint == 4 && ValidationDetailsPanel.this.myValidationDetailsTable.isRowSelected(rowAtPoint)) {
                    ValidationDetailsPanel.this.myValidationDetailsTable.setCursor(this.textCursor);
                } else {
                    ValidationDetailsPanel.this.myValidationDetailsTable.setCursor(this.defaultCursor);
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
            }
        });
        AbstractAction enterAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = ValidationDetailsPanel.this.myValidationDetailsTable.getSelectedRow();
                if (row > -1 && ValidationDetailsPanel.this.myController != null) {
                    int originalRow = sorter.getOriginalIndex(row);
                    ((ValidationDetailsController)ValidationDetailsPanel.this.myController).validationResultSelected(ValidationDetailsPanel.this.myValidationDetailsTableModel.getResult(originalRow), false);
                }
            }
        };
        this.myValidationDetailsTable.getInputMap(0).put(KeyStroke.getKeyStroke("ENTER"), "selectResult");
        this.myValidationDetailsTable.getActionMap().put("selectResult", enterAction);
        this.myValidationDetailsTable.setSelectionMode(0);
        this.myValidationDetailsTable.setEmptyText(this.myResourceBundle.getString("ValidationDetailsView.No.Errors"));
        this.myValidationDetailsTable.setBackground(this.getBackground());
        this.myValidationDetailsTable.putClientProperty("OrangeTouch.paintEditRectOnTableCell", false);
        TableColumnModel columnModel = this.myValidationDetailsTable.getColumnModel();
        columnModel.addColumnModelListener(this);
        columnModel.getColumn(0).setCellRenderer(new TypeColumnRender());
        this.updateColumnWidths();
        ValidationDetailsMessageCellEditor cellEditor = new ValidationDetailsMessageCellEditor();
        ValidationDetailsMessageCellRenderer cellRenderer = new ValidationDetailsMessageCellRenderer();
        columnModel.getColumn(4).setCellRenderer(cellRenderer);
        columnModel.getColumn(4).setCellEditor(cellEditor);
        JTableHeader tableHeader = this.myValidationDetailsTable.getTableHeader();
        tableHeader.setReorderingAllowed(false);
        tableHeader.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    ValidationDetailsPanel.this.resizeTable();
                }
            }
        });
        JScrollPane tableScrollPanel = new JScrollPane(this.myValidationDetailsTable);
        tableScrollPanel.setVerticalScrollBarPolicy(20);
        return tableScrollPanel;
    }

    private int getResultCount(List<RAMLValidationResult> results, RAMLValidationResult.State state) {
        int result = 0;
        for (RAMLValidationResult validationResult : results) {
            if (validationResult.getState() != state) continue;
            ++result;
        }
        return result;
    }

    @Override
    public void setValidationResults(List<RAMLValidationResult> validationResults) {
        this.myValidationDetailsTableModel.setContents(validationResults);
        int resultCount = this.getResultCount(validationResults, RAMLValidationResult.State.ERROR);
        this.myHeaderLabel.setItemCount(resultCount);
        this.myHeaderLabel.setVisible(this.myValidationProgress.getParent() == null);
        this.myHeaderLabel.updateUI();
        if (this.mySaveValidationAction != null) {
            this.mySaveValidationAction.setEnabled(resultCount > 0);
        }
    }

    @Override
    public void showErrorDialog(String title, String headline, String message) {
        PStaticDialogs.showErrorDialog(PoseidonRuntime.getRuntime().getService(UserInterface.class).getFrame(), title, headline, message, null);
    }

    public void setShowValidationProgress(boolean showProgress) {
        this.myValidationDetailsTable.remove(this.myValidationProgress);
        this.myValidationDetailsTable.remove(this.myValidationLabel);
        this.myValidationDetailsTable.setEmptyText(this.myResourceBundle.getString("ValidationDetailsView.No.Errors"));
        if (showProgress) {
            this.myValidationDetailsTable.setEmptyText("");
            this.myValidationDetailsTable.add(this.myValidationLabel);
            this.myValidationDetailsTable.add(this.myValidationProgress);
            this.myValidationLabel.setLocation(ScaleUtils.scale(new Point(5, 2)));
            this.myValidationLabel.setSize(this.myValidationLabel.getPreferredSize());
            this.myValidationProgress.setLocation(ScaleUtils.scale(new Point(80, 2)));
            this.myValidationProgress.setSize(ScaleUtils.scale(new Dimension(100, 15)));
            this.myHeaderLabel.setText("");
        }
        this.myValidationDetailsTable.revalidate();
        this.myValidationDetailsTable.repaint();
    }

    @Override
    public void columnMarginChanged(ChangeEvent e) {
        JTableHeader header = this.myValidationDetailsTable.getTableHeader();
        TableColumnModel model = this.myValidationDetailsTable.getColumnModel();
        TableColumn detailedDescColumn = model.getColumn(4);
        TableColumn ridColumn = null;
        TableColumn column = header.getResizingColumn();
        if (this.myIsDevMode) {
            ridColumn = model.getColumn(5);
        }
        if (column != null && !column.equals(this.myDummyColumn) && column != detailedDescColumn && column != ridColumn) {
            int index = model.getColumnIndex(column.getIdentifier());
            int tableWidth = this.myValidationDetailsTable.getWidth();
            double ratio = (float)column.getWidth() * 1.0f / (float)tableWidth;
            this.myColumnWidthMap.put(index, ratio);
        } else {
            this.updateColumnWidths();
        }
    }

    @Override
    public void columnMoved(TableColumnModelEvent e) {
    }

    @Override
    public void columnRemoved(TableColumnModelEvent e) {
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent e) {
    }

    @Override
    public void columnAdded(TableColumnModelEvent e) {
    }

    @Override
    public void tableChanged(TableModelEvent tablemodelevent) {
        this.updateColumnWidths();
    }

    private void updateColumnWidths() {
        TableColumnModel columnModel = this.myValidationDetailsTable.getColumnModel();
        columnModel.removeColumnModelListener(this);
        JTableHeader header = this.myValidationDetailsTable.getTableHeader();
        TableColumn column = columnModel.getColumn(4);
        header.setResizingColumn(column);
        this.updateColumnWidth(0);
        this.updateColumnWidth(2);
        this.updateColumnWidth(1);
        this.updateColumnWidth(3);
        int rowCount = this.myValidationDetailsTableModel.getRowCount();
        if (this.myIsDevMode) {
            if (rowCount > 0) {
                this.updateColumnWidth(5);
            } else {
                int width = this.myValidationDetailsTable.getWidth();
                this.setColumnWidth(5, columnModel, width);
            }
        }
        if (rowCount == 0) {
            this.updateColumnWidth(4);
        }
        this.resizeTable();
        this.doLayout();
        columnModel.addColumnModelListener(this);
    }

    private void updateColumnWidth(int columnIndex) {
        TableColumnModel columnModel = this.myValidationDetailsTable.getColumnModel();
        int width = this.getColumnWidth(columnIndex);
        this.setColumnWidth(columnIndex, columnModel, width);
    }

    private int getColumnWidth(int columnIndex) {
        int width = 0;
        width = this.myColumnWidthMap.containsKey(columnIndex) ? this.computeColumnWidthFromSavedRatio(columnIndex, this.myColumnWidthMap.get(columnIndex)) : this.computeColumnWidth(columnIndex);
        return width;
    }

    private int computeColumnWidthFromSavedRatio(int columnIndex, double ratio) {
        int tableWidth = this.myValidationDetailsTable.getWidth();
        int computedWidth = (int)((double)tableWidth * ratio);
        if (computedWidth > 16) {
            int occupiedWidth = 0;
            int i = 0;
            while (i < columnIndex) {
                occupiedWidth += this.myValidationDetailsTable.getColumnModel().getColumn(i).getWidth();
                ++i;
            }
            i = columnIndex + 1;
            while (i < this.myValidationDetailsTable.getColumnModel().getColumnCount()) {
                occupiedWidth += 16;
                ++i;
            }
            int remainingWidth = tableWidth - occupiedWidth;
            return computedWidth > remainingWidth ? remainingWidth : computedWidth;
        }
        return 16;
    }

    private int computeColumnWidth(int columnIndex) {
        int columnWidth;
        if (columnIndex == 4 && !this.myIsDevMode) {
            columnWidth = this.computeDetailedDescriptionColumnWidth();
        } else {
            int rowCount = this.myValidationDetailsTableModel.getRowCount();
            int columnDataWidth = rowCount > 0 ? this.computeColumnWidthFromTableData(columnIndex, rowCount) : 0;
            int columnHeaderWidth = this.computeColumnWidthFromTableHeader(columnIndex);
            columnWidth = columnDataWidth > columnHeaderWidth ? columnDataWidth : columnHeaderWidth;
            columnWidth += 22;
        }
        return columnWidth;
    }

    private int computeDetailedDescriptionColumnWidth() {
        int tableWidth = this.myValidationDetailsTable.getWidth();
        int occupiedWidth = 0;
        for (int i : this.myColumnWidthMap.keySet()) {
            if (i == 4) continue;
            occupiedWidth = (int)((double)occupiedWidth + this.myColumnWidthMap.get(i));
        }
        return tableWidth - occupiedWidth;
    }

    private int computeColumnWidthFromTableData(int columnIndex, int rowCount) {
        int maxStringLength = 0;
        int i = 0;
        while (i < rowCount) {
            int stringLength = 0;
            Object cellValue = this.myValidationDetailsTableModel.getValueAt(i, columnIndex);
            if (cellValue != null) {
                String value = cellValue.toString();
                stringLength = this.myValidationDetailsTable.getFontMetrics(this.getFont()).stringWidth(value);
            }
            int n = maxStringLength = stringLength > maxStringLength ? stringLength : maxStringLength;
            if (columnIndex == 3 && maxStringLength >= 140) {
                maxStringLength = 140;
                break;
            }
            ++i;
        }
        if (columnIndex == 0) {
            maxStringLength += 10;
        }
        return maxStringLength;
    }

    private int computeColumnWidthFromTableHeader(int columnIndex) {
        String columnName = this.myValidationDetailsTableModel.getColumnName(columnIndex);
        int stringLength = this.myValidationDetailsTable.getFontMetrics(this.myValidationDetailsTable.getFont()).stringWidth(columnName);
        return stringLength;
    }

    private void setColumnWidth(int columnIndex, TableColumnModel columnModel, int width) {
        columnModel.getColumn(columnIndex).setPreferredWidth(width);
        columnModel.getColumn(columnIndex).setWidth(width);
    }

    public void resizeTable() {
        this.myValidationDetailsTable.revalidate();
        this.myValidationDetailsTable.doLayout();
        this.myValidationDetailsTable.repaint();
    }

    private class InfoTipProvider
    extends TableCellInfoTipProvider
    implements MouseListener,
    MouseMotionListener {
        public InfoTipProvider(JTable table) {
            super(table, 4);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            int row = this.myValidationTable.rowAtPoint(e.getPoint());
            if (row > -1 && ValidationDetailsPanel.this.myValidationDetailsTableModel.getResult(row) != null) {
                super.mouseMoved(e);
            } else {
                this.myInfoTip.setVisible(false);
            }
        }
    }

    private class TypeColumnRender
    extends PTableCellRenderer {
        private RAMLValidationResult.State myState;

        public TypeColumnRender() {
            super(2);
            this.myState = null;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.myState = (RAMLValidationResult.State)((Object)value);
            this.setIcon(EMPTY_ICON);
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Color[] stripe = this.getStripeColors();
            if (stripe != null) {
                GradientUtils.drawVerticalGradient((JComponent)this, g, stripe, 0, 0, 10, this.getHeight() - 1);
            }
        }

        @Override
        protected void paintBorder(Graphics g) {
            boolean focused;
            boolean bl = focused = Boolean.TRUE.equals(this.getClientProperty("Table.hasFocus")) || this.hasFocus();
            if (focused) {
                ColorUIResource outline = NetLookAndFeel.getFocusColor();
                g.setColor(outline);
                g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            }
        }

        private Color[] getStripeColors() {
            if (RAMLValidationResult.State.ERROR.equals((Object)this.myState)) {
                return ERROR_COLOR;
            }
            if (RAMLValidationResult.State.WARNING.equals((Object)this.myState)) {
                return WARNING_COLOR;
            }
            return null;
        }
    }
}

