/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.raml;

import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.frameworks.print.PPrintHelper;
import com.nokia.em.poseidon.frameworks.print.PPrintTable;
import com.nokia.em.poseidon.frameworks.print.PPrintText;
import com.nokia.em.poseidon.frameworks.print.PPrintableArea;
import com.nokia.em.poseidon.frameworks.print.PPrintableDoc;
import com.nokia.em.poseidon.frameworks.print.PPrintableSection;
import com.nokia.em.poseidon.frameworks.raml.RAMLValidationContext;
import com.nokia.em.poseidon.frameworks.raml.RAMLValidationResult;
import javax.swing.JTable;

public class ValidationDetailsPrintableDoc
extends PPrintableDoc
implements PPrintableSection {
    private static final char COLON = ':';
    private String myTypeText;
    private String myMngObjectText;
    private String myParameterText;
    private String myErrorDescText;
    private String myDetailedDescText;
    private RAMLValidationContext myValidationContext;
    private ResourceBundle myResourceBundle;
    private String myReportName;
    private PPrintHelper myPrintHelper;
    private PPrintText.ALIGN myAlignment = PPrintText.ALIGN.CENTER;

    public ValidationDetailsPrintableDoc(RAMLValidationContext validationContext) {
        this.myValidationContext = validationContext;
        this.myResourceBundle = I18n.getI18n().getBundle(this.getClass());
        this.initLocalizations();
        this.myReportName = this.myResourceBundle.getString("ValidationDetailsPrinter.ReportTitle_Text");
        this.myPrintHelper = new PPrintHelper(this);
    }

    private void initLocalizations() {
        this.myTypeText = String.valueOf(this.myResourceBundle.getString("ValidationDetailsView.Type_Text")) + ':';
        this.myMngObjectText = String.valueOf(this.myResourceBundle.getString("ValidationDetailsView.ManagedObject_Text")) + ':';
        this.myParameterText = String.valueOf(this.myResourceBundle.getString("ValidationDetailsView.Parameter_Text")) + ':';
        this.myErrorDescText = String.valueOf(this.myResourceBundle.getString("ValidationDetailsView.ErrorDesc_Text")) + ':';
        this.myDetailedDescText = String.valueOf(this.myResourceBundle.getString("ValidationDetailsView.DetailErrorDesc_Text")) + ':';
    }

    private void createValidationResultPrintOut(RAMLValidationResult validationResult) {
        PPrintText resultDesc = new PPrintText((Object)((Object)validationResult.getState()) + " - " + validationResult.getDistName(), this);
        PPrintTable resultTable = new PPrintTable(this.createValidationResultTable(validationResult), (PPrintableArea)this);
        resultTable.setDrawTableLines(false);
        resultTable.setCellBottomMarginal(2);
        resultTable.setCellTopMarginal(2);
        resultTable.setCellLeftMarginal(10);
        resultTable.setCellRightMarginal(2);
        PPrintText emptyRow = new PPrintText(" ", this);
        this.add(resultDesc);
        this.add(resultTable);
        this.add(emptyRow);
    }

    private JTable createValidationResultTable(RAMLValidationResult validationResult) {
        JTable resultTable = new JTable(5, 2);
        resultTable.setValueAt(this.myTypeText, 0, 0);
        resultTable.setValueAt(validationResult.getState().toString(), 0, 1);
        resultTable.setValueAt(this.myMngObjectText, 1, 0);
        resultTable.setValueAt(validationResult.getDistName(), 1, 1);
        resultTable.setValueAt(this.myErrorDescText, 2, 0);
        resultTable.setValueAt(validationResult.getText(), 2, 1);
        resultTable.setValueAt(this.myParameterText, 3, 0);
        resultTable.setValueAt(validationResult.getParameterName(), 3, 1);
        resultTable.setValueAt(this.myDetailedDescText, 4, 0);
        resultTable.setValueAt(validationResult.getDetails(), 4, 1);
        return resultTable;
    }

    private PPrintableArea createPageFooter() {
        return this.myPrintHelper.createPageFooter();
    }

    @Override
    protected PPrintableArea createPageHeader() {
        return this.myPrintHelper.createPageHeader(1);
    }

    @Override
    protected void doPrinting() {
        this.setPageHeader(this.createPageHeader());
        for (RAMLValidationResult result : this.myValidationContext.getResults()) {
            this.createValidationResultPrintOut(result);
            this.add(new PPrintText(" ", this));
        }
        this.add(this.createPageFooter());
    }

    @Override
    public String getReportName() {
        return this.myReportName;
    }

    @Override
    public PPrintText.ALIGN getAlignment() {
        return this.myAlignment;
    }
}

