/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.raml;

import com.nokia.em.poseidon.frameworks.raml.RAMLValidationResult;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class ValidationDetailsTableModel
extends AbstractTableModel {
    protected static final int TYPE_COLUMN_INDEX = 0;
    protected static final int MANAGED_OBJECT_COLUMN_INDEX = 1;
    protected static final int DESC_COLUMN_INDEX = 2;
    private static final String HTML_LINE_BREAK = "<br>";
    protected static final int PARAMETER_COLUMN_INDEX = 3;
    protected static final int DETAILED_DESC_COLUMN_INDEX = 4;
    protected static final int RID_INDEX = 5;
    private List<RAMLValidationResult> myValidationResults = new ArrayList<RAMLValidationResult>();
    private String[] myColumnTitles;

    public ValidationDetailsTableModel(String[] columnTitles) {
        this.myColumnTitles = columnTitles;
    }

    public void setContents(List<RAMLValidationResult> validationResults) {
        this.myValidationResults.clear();
        if (validationResults == null) {
            return;
        }
        this.myValidationResults.addAll(validationResults);
        this.fireTableChanged(new TableModelEvent(this));
    }

    private String removeHtmlLineBreaks(String text) {
        StringBuffer parsedText = new StringBuffer(text);
        int index = 0;
        while ((index = parsedText.toString().toLowerCase().indexOf(HTML_LINE_BREAK)) >= 0) {
            String replacement = parsedText.charAt(index - 1) == ' ' ? "" : " ";
            parsedText.replace(index, index + HTML_LINE_BREAK.length(), replacement);
        }
        return parsedText.toString();
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.myColumnTitles.length) {
            return "";
        }
        return this.myColumnTitles[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return 4 == column;
    }

    @Override
    public int getColumnCount() {
        return this.myColumnTitles.length;
    }

    public RAMLValidationResult getResult(int row) {
        return this.myValidationResults.get(row);
    }

    @Override
    public int getRowCount() {
        return this.myValidationResults.size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (row < 0 || row >= this.myValidationResults.size() || column < 0 || column >= this.myColumnTitles.length) {
            return "";
        }
        RAMLValidationResult result = this.myValidationResults.get(row);
        switch (column) {
            case 0: {
                return result.getState();
            }
            case 1: {
                return result.getDistName();
            }
            case 2: {
                return this.removeHtmlLineBreaks(result.getText());
            }
            case 3: {
                return result.getParameterName();
            }
            case 4: {
                return this.removeHtmlLineBreaks(result.getDetails());
            }
            case 5: {
                return result.getRelationshipId();
            }
        }
        return "-";
    }
}

