/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.raml.edit;

import com.nokia.em.poseidon.gui.raml.edit.RAMLEditPanel;
import com.nokia.em.poseidon.gui.raml.edit.RAMLNode;
import com.nokia.widgets.checkboxtree.CheckBoxTreeSelectionModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class RAMLCopyDataToModel {
    protected static final int INIT_CAPACITY = 100;
    private final RAMLEditPanel myRamlEditPanel;
    private boolean myIsCopyChildMOs = true;
    private boolean myIsCopyChildLists = true;

    public RAMLCopyDataToModel(RAMLEditPanel ramlEditPanel) {
        this.myRamlEditPanel = ramlEditPanel;
    }

    public List<String> getNodeList() {
        List<RAMLNode> nodes = this.getSameNodesExceptSelected();
        ArrayList<String> nodeList = new ArrayList<String>(100);
        for (RAMLNode node : nodes) {
            nodeList.add(node.getName());
        }
        this.sort(nodeList);
        return nodeList;
    }

    public final RAMLNode getSelectedNode() {
        return this.myRamlEditPanel.getSelectedNode();
    }

    protected final List<RAMLNode> getSameNodesExceptSelected() {
        return this.myRamlEditPanel.getSameNodesExceptSelected();
    }

    public final void copyTo(CheckBoxTreeSelectionModel model) {
        List<String> selectedElements = this.getSelectedElements(model);
        this.sort(selectedElements);
        this.myRamlEditPanel.copySelectedNodeTo(selectedElements, this.myIsCopyChildMOs, this.myIsCopyChildLists);
    }

    public final List<String> getSelectedElements(CheckBoxTreeSelectionModel model) {
        TreePath[] selectionPaths = model.getSelectionPaths();
        ArrayList<String> selectedElementList = new ArrayList<String>();
        int i = 0;
        while (i < selectionPaths.length) {
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)selectionPaths[i].getLastPathComponent();
            if (treeNode.isLeaf() && !treeNode.isRoot()) {
                selectedElementList.add((String)treeNode.getUserObject());
            }
            ++i;
        }
        return selectedElementList;
    }

    public void setIsCopyChildMOs(boolean isCopyChildMOs) {
        this.myIsCopyChildMOs = isCopyChildMOs;
    }

    public void setIsCopyChildLists(boolean isCopyChildLists) {
        this.myIsCopyChildLists = isCopyChildLists;
    }

    private void sort(List<String> list) {
        Collections.sort(list, new Comparator<String>(){

            @Override
            public int compare(String elementOne, String elementTwo) {
                String[] elementOneMoNameAndId = elementOne.split("-");
                String[] elementTwoMoNameAndId = elementTwo.split("-");
                return Integer.parseInt(elementOneMoNameAndId[1]) - Integer.parseInt(elementTwoMoNameAndId[1]);
            }
        });
    }
}

