/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.raml.edit;

import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.frameworks.mvc.swing.JDialogViewBase;
import com.nokia.em.poseidon.gui.raml.edit.RAMLCopyDataToModel;
import com.nokia.em.poseidon.services.help.PHelp;
import com.nokia.em.poseidon.services.ui.UserInterface;
import com.nokia.em.poseidon.util.TextUtils;
import com.nokia.widgets.ClientProperties;
import com.nokia.widgets.PButtonPane;
import com.nokia.widgets.PPanel;
import com.nokia.widgets.buttons.PHelpButton;
import com.nokia.widgets.checkboxtree.CheckBoxTree;
import com.nokia.widgets.labels.PLabel;
import com.nokia.widgets.layout.PHorizontalLayout;
import com.nokia.widgets.util.PListFocusTraversalPolicy;
import com.nokia.widgets.util.ScaleUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import net.miginfocom.swing.MigLayout;

public class RAMLCopyDataToView
extends JDialogViewBase {
    private static final int DIALOG_WIDTH = 350;
    private static final int DIALOG_HEIGHT = 450;
    private static final int SCROLL_PANEL__WIDTH = 200;
    private final PListFocusTraversalPolicy myFocusPolicy = new PListFocusTraversalPolicy();
    private final ResourceBundle myRB;
    protected final RAMLCopyDataToModel myModel;
    private PPanel myTreePanel;
    private CheckBoxTree myCheckBoxTree;
    private JButton myCopyButton;
    private JCheckBox myCopyChildMOCheckBox;
    private JCheckBox myCopyChildListCheckBox;
    private PPanel myUpperPanel;
    private PPanel myButtonPanel;
    protected JButton myCloseButton;
    protected JButton myHelpButton;
    private String myStrHelpId;
    private String myRootNodeName;

    public RAMLCopyDataToView(RAMLCopyDataToModel model, String helpId, String rootNodeName) {
        super(null, PoseidonRuntime.getRuntime().getService(UserInterface.class).getFrame());
        this.myStrHelpId = helpId;
        this.myRB = I18n.getI18n().getBundle(this.getClass());
        this.myModel = model;
        this.myRootNodeName = rootNodeName;
        this.buildUI();
        this.addFocusTraversalPolicy();
        this.pack();
    }

    private void buildUI() {
        Container contentPane = this.getContentPane();
        GridBagConstraints contentPaneConstraints = new GridBagConstraints();
        this.createUpperPanel();
        this.layoutUpperPanel(contentPane, contentPaneConstraints);
        this.createButtonPanel();
        this.layoutButtonPanel(contentPane, contentPaneConstraints);
        this.setTitle(TextUtils.format("CopyDataToDialog_Title", this.myModel.getSelectedNode().getName()));
        this.setSize();
        this.createUIComponents();
        this.layoutUI();
        this.intializeLocation();
        this.setModal(true);
    }

    private void intializeLocation() {
        Point p = this.getLocation();
        if (p.x == 0 || p.y == 0) {
            this.setLocationRelativeTo(this.getOwner());
        }
    }

    private void createUpperPanel() {
        this.myUpperPanel = new PPanel(new PHorizontalLayout(0, 0, 0, 0));
        this.myUpperPanel.setBackground(UIManager.getColor("Panel.background"));
        this.myUpperPanel.setVisibleLowerEdge(false);
    }

    private void layoutButtonPanel(Container contentPane, GridBagConstraints contentPaneConstraints) {
        contentPaneConstraints.weightx = 1.0;
        contentPaneConstraints.weighty = 0.0;
        contentPaneConstraints.fill = 2;
        contentPane.add((Component)this.myButtonPanel, contentPaneConstraints);
    }

    private void layoutUpperPanel(Container contentPane, GridBagConstraints contentPaneConstraints) {
        contentPane.setLayout(new GridBagLayout());
        contentPaneConstraints.gridx = 0;
        contentPaneConstraints.gridy = -1;
        contentPaneConstraints.gridwidth = 1;
        contentPaneConstraints.gridheight = 1;
        contentPaneConstraints.weightx = 1.0;
        contentPaneConstraints.weighty = 1.0;
        contentPaneConstraints.fill = 1;
        contentPane.add((Component)this.myUpperPanel, contentPaneConstraints);
    }

    protected void createButtonPanel() {
        this.myButtonPanel = new PButtonPane();
        this.myButtonPanel.putClientProperty("panelType", ClientProperties.PANEL_BUTTONAREA_BACKGROUND);
        this.myButtonPanel.setVisibleUpperEdge(true);
        this.createCloseButton();
        this.createCopyButton();
        this.createHelpButton();
        this.myButtonPanel.add((Component)this.myHelpButton, "West");
        this.myButtonPanel.add(this.myCopyButton);
        this.myButtonPanel.add((Component)this.myCloseButton, "East");
        this.myCloseButton.requestFocus();
    }

    private void createCloseButton() {
        this.myCloseButton = new JButton();
        this.myCloseButton.setName("CopyDataToView.CloseButton");
        this.myCloseButton.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent ae) {
                RAMLCopyDataToView.this.closeHelpWindow();
                RAMLCopyDataToView.this.handleWindowClosing();
            }
        });
    }

    private void createHelpButton() {
        this.myHelpButton = new PHelpButton();
        this.myHelpButton.setName("helpButton");
        this.myHelpButton.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent ae) {
                if (RAMLCopyDataToView.this.myStrHelpId != null) {
                    RAMLCopyDataToView.this.showHelpDirectly();
                } else {
                    RAMLCopyDataToView.this.showMessageWithoutHelpId();
                }
            }
        });
    }

    private void closeHelpWindow() {
        PHelp helpService = PoseidonRuntime.getRuntime().getService(PHelp.class);
        helpService.closeHelpWindow();
    }

    @Override
    protected void handleWindowClosing() {
        this.dispose();
        this.storeSettings();
    }

    private void showHelpDirectly() {
        PHelp helService = PoseidonRuntime.getRuntime().getService(PHelp.class);
        helService.showHelp(this, this.myStrHelpId);
    }

    protected void showMessageWithoutHelpId() {
    }

    private void setSize() {
        Dimension dimension = new Dimension(ScaleUtils.scale(350), ScaleUtils.scale(450));
        this.setPreferredSize(dimension);
        this.setMinimumSize(dimension);
        this.setResizable(true);
    }

    private void createUIComponents() {
        this.createPanel();
        this.createCheckBoxTree();
        this.createCopyChildMOsAndListsCheckBox();
    }

    private void createCopyChildMOsAndListsCheckBox() {
        this.myCopyChildMOCheckBox = new JCheckBox();
        this.myCopyChildMOCheckBox.setName("CopyChildMOsCheckBox");
        this.myCopyChildMOCheckBox.setText(this.myRB.getString("CopyChildMOCheckBox_Text"));
        this.myCopyChildMOCheckBox.setSelected(true);
        this.myCopyChildMOCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RAMLCopyDataToView.this.myModel.setIsCopyChildMOs(RAMLCopyDataToView.this.myCopyChildMOCheckBox.isSelected());
            }
        });
        this.myCopyChildListCheckBox = new JCheckBox();
        this.myCopyChildListCheckBox.setName("CopyChildListsCheckBox");
        this.myCopyChildListCheckBox.setText(this.myRB.getString("CopyChildListCheckBox_Text"));
        this.myCopyChildListCheckBox.setSelected(true);
        this.myCopyChildListCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RAMLCopyDataToView.this.myModel.setIsCopyChildLists(RAMLCopyDataToView.this.myCopyChildListCheckBox.isSelected());
            }
        });
    }

    private void createPanel() {
        this.myTreePanel = new PPanel();
        this.myTreePanel.setBackground(Color.WHITE);
        this.myTreePanel.setLayout((LayoutManager)new MigLayout("insets 0 0 0 0 ", "", ""));
    }

    private void createCheckBoxTree() {
        this.myCheckBoxTree = new ModelCheckBoxTree(this.getTree(), this);
        this.myCheckBoxTree.setVisibleRowCount(10);
        this.myCheckBoxTree.setDefaultIcons(false);
        this.myTreePanel.add((Component)this.myCheckBoxTree, "wrap");
    }

    protected DefaultMutableTreeNode getTree() {
        List<String> nodeList = this.myModel.getNodeList();
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(this.myRootNodeName);
        for (String name : nodeList) {
            DefaultMutableTreeNode firstLevelNode = new DefaultMutableTreeNode(name);
            rootNode.add(firstLevelNode);
        }
        return rootNode;
    }

    private void createCopyButton() {
        this.myCopyButton = new JButton(this.myRB.getString("CopyButton_Text"));
        this.myCopyButton.setMnemonic(this.myRB.getMnemonic("CopyButton_Text"));
        this.myCopyButton.setEnabled(false);
        this.getRootPane().setDefaultButton(this.myCopyButton);
        this.myCopyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RAMLCopyDataToView.this.setCursor(new Cursor(3));
                RAMLCopyDataToView.this.myModel.copyTo(RAMLCopyDataToView.this.myCheckBoxTree.getCheckBoxTreeSelectionModel());
                RAMLCopyDataToView.this.closeHelpWindow();
                RAMLCopyDataToView.this.handleWindowClosing();
                RAMLCopyDataToView.this.setCursor(new Cursor(0));
            }
        });
    }

    private void layoutUI() {
        this.myUpperPanel.removeAll();
        this.myUpperPanel.setLayout((LayoutManager)new MigLayout("insets 12 18 12 12 ", "", ""));
        JScrollPane treeScrollPane = new JScrollPane(this.myTreePanel);
        treeScrollPane.setPreferredSize(new Dimension(200, 450));
        this.myUpperPanel.add((Component)treeScrollPane, "wrap");
        this.myUpperPanel.add((Component)this.myCopyChildMOCheckBox, "wrap");
        this.myUpperPanel.add((Component)this.myCopyChildListCheckBox, "wrap");
        this.myUpperPanel.add(this.createCopyInfo());
        this.myCloseButton.setText(this.myRB.getString("CopyDataToView.CloseButton_Text"));
    }

    private PLabel createCopyInfo() {
        PLabel tableFooterInfo = PLabel.createSystemText(this.myRB.getString("CopyInfo"));
        tableFooterInfo.setLabelType(ClientProperties.LABEL_SYSTEM_TEXT);
        tableFooterInfo.setIcon(this.myRB.getImageIcon("PWizardConcept.InfoButton_Icon"));
        tableFooterInfo.setVerticalTextPosition(1);
        tableFooterInfo.putClientProperty("OrangeTouch.automaticTooltipEnabled", Boolean.FALSE);
        return tableFooterInfo;
    }

    private void addFocusTraversalPolicy() {
        this.myFocusPolicy.add(this.myCheckBoxTree);
        this.myFocusPolicy.add(this.myCopyButton);
        this.myFocusPolicy.add(this.myCloseButton);
        this.myFocusPolicy.add(this.myHelpButton);
        this.setFocusTraversalPolicy(this.myFocusPolicy);
    }

    private void updateCopyButtonStatus() {
        this.myCopyButton.setEnabled(this.myModel.getSelectedElements(this.myCheckBoxTree.getCheckBoxTreeSelectionModel()).size() > 0);
    }

    private class ModelCheckBoxTree
    extends CheckBoxTree {
        private RAMLCopyDataToView myCopyDataToView;

        public ModelCheckBoxTree(DefaultMutableTreeNode root, RAMLCopyDataToView view) {
            super(root);
            this.myCopyDataToView = view;
        }

        @Override
        protected CheckBoxTree.Handler createHandler() {
            return new CopyDataToModalHandler(this);
        }

        @Override
        public boolean isCheckBoxEnabled(TreePath path) {
            return true;
        }

        class CopyDataToModalHandler
        extends CheckBoxTree.Handler {
            public CopyDataToModalHandler(CheckBoxTree tree) {
                super(tree);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                super.mouseReleased(e);
                ModelCheckBoxTree.this.myCopyDataToView.updateCopyButtonStatus();
            }
        }
    }
}

