/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.raml.edit;

import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLDescription;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLMetaParameter;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLRelatedParameter;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLBit;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLBitList;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLBoolean;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLBooleanValidator;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLDecimal;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLDefaultValue;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLEnum;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLEnumValidator;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLInteger;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLNumber;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLSimpleType;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLSpecialValue;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLString;
import com.nokia.em.poseidon.gui.raml.edit.RAMLEditEventHandler;
import com.nokia.em.poseidon.gui.raml.edit.RAMLNode;
import com.nokia.em.poseidon.gui.raml.edit.RAMLUIGroup;
import com.nokia.em.poseidon.gui.raml.edit.RamlInfoTip;
import com.nokia.em.poseidon.util.CoordinatesUtils;
import com.nokia.em.poseidon.util.GPSValue;
import com.nokia.em.poseidon.util.TextUtils;
import com.nokia.widgets.PComboBox;
import com.nokia.widgets.PPanel;
import com.nokia.widgets.labels.PLabel;
import com.nokia.widgets.layout.ExtendedGridBagConstraints;
import com.nokia.widgets.text.DocumentBase;
import com.nokia.widgets.text.PTextField;
import com.nokia.widgets.text.TextFieldFactory;
import com.nokia.widgets.util.ClientPropertyUtil;
import com.nokia.widgets.util.SystemUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.UIManager;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import net.miginfocom.swing.MigLayout;

public class RAMLEditComponentFactory {
    private static final boolean ACCEPT_FULLWIDTH_CHARACTERS = false;
    public static Insets RANGE_INSETS = new Insets(3, 3, 6, 3);
    private static final ResourceBundle RB = I18n.getI18n().getBundle(RAMLEditComponentFactory.class);
    private static boolean theModelChanged;
    private static COMMISSIONING_TYPE myCommissioningType;
    public static final String MIGLAYOUT_SIZEGROUP_COMMON = "sgx common, width pref:pref:max";
    public static final String MIGLAYOUT_SIZEGROUP_COMMON_WRAP = "sgx common, wrap, width pref:pref:max";

    private static RAMLMetaParameter getInstanceParameter(List<RAMLMetaParameter> params) {
        for (RAMLMetaParameter p : params) {
            if (!p.isInstanceParameter() || p.isDeleted()) continue;
            return p;
        }
        return null;
    }

    public static String getDefaultValue(RAMLMetaParameter metaData) {
        RAMLBoolean bool;
        Object def;
        String defVal = "";
        RAMLSimpleType simple = (RAMLSimpleType)metaData.getValueType();
        if (simple.getBaseType().equals("decimal")) {
            RAMLDecimal dec = (RAMLDecimal)simple;
            Object def2 = dec.getDefaultValue();
            if (def2 != null) {
                int maxAllowedDecimal = RAMLEditComponentFactory.getMaxAllowedDecimal(dec);
                DecimalFormat df = new DecimalFormat();
                df.setMaximumFractionDigits(maxAllowedDecimal);
                df.setGroupingUsed(false);
                defVal = df.format(((RAMLDefaultValue)def2).getValue());
            }
        } else if (simple.getBaseType().equals("integer")) {
            RAMLInteger intgr = (RAMLInteger)simple;
            Object def3 = intgr.getDefaultValue();
            if (def3 != null) {
                defVal = String.valueOf(((RAMLDefaultValue)def3).getValue());
            }
        } else if (simple.getBaseType().equals("enumeration")) {
            RAMLEnum enumeration = (RAMLEnum)simple;
            Object def4 = enumeration.getDefaultValue();
            if (def4 != null) {
                defVal = enumeration.getText((Integer)((RAMLDefaultValue)def4).getValue());
            }
        } else if (simple.getBaseType().equals("string")) {
            RAMLDefaultValue def5 = (RAMLDefaultValue)simple.getDefaultValue();
            if (def5 != null) {
                defVal = (String)def5.getValue();
            }
        } else if (simple.getBaseType().equals("bit")) {
            RAMLBitList bit = (RAMLBitList)simple;
            Object def6 = bit.getDefaultValue();
            if (def6 != null) {
                defVal = String.valueOf(((RAMLDefaultValue)def6).getValue());
            }
        } else if (simple.getBaseType().equals("boolean") && (def = (bool = (RAMLBoolean)simple).getDefaultValue()) != null) {
            defVal = "" + ((RAMLDefaultValue)def).getValue();
        }
        return defVal;
    }

    private static int getMaxAllowedDecimal(RAMLDecimal dec) {
        String max = dec.getMaxValue() == null ? "." : dec.getMaxValue().toString();
        String min = dec.getMinValue() == null ? "." : dec.getMinValue().toString();
        String step = dec.getStep() == null ? "." : dec.getStep().toString();
        ArrayList<Integer> list = new ArrayList<Integer>(3);
        list.add(max.substring(max.indexOf(".")).length());
        list.add(min.substring(min.indexOf(".")).length());
        list.add(step.substring(step.indexOf(".")).length());
        int maxAllowedDecimal = 0;
        for (Integer i : list) {
            maxAllowedDecimal = Math.max(maxAllowedDecimal, i);
        }
        return maxAllowedDecimal;
    }

    private static void setTextFieldValues(String value, String defaultValue, RAMLMetaParameter metaData, RAMLNode selectedNode, PTextField textField, RAMLEditEventHandler eventHandler, boolean setDefaultValue) {
        DocumentBase document = (DocumentBase)textField.getDocument();
        textField.setMandatoryEntry(metaData.isMandatory());
        textField.putClientProperty("RAML.Meta.Data", metaData);
        textField.putClientProperty("RAML.Node.Owner", selectedNode);
        if (value != null && selectedNode.isValueAllowed(metaData, value).isOk()) {
            document.insertUnfilteredString(value);
        } else if ((RAMLEditComponentFactory.isManualCommissioning() || metaData.isMandatory()) && setDefaultValue && defaultValue != null && selectedNode.isValueAllowed(metaData, defaultValue).isOk() && !metaData.isSetByTheSystem()) {
            theModelChanged = true;
            selectedNode.setValue(metaData, defaultValue);
            textField.setText(defaultValue);
        }
        textField.getDocument().putProperty("RAML.Txt.Field", textField);
        textField.addFocusListener(eventHandler);
        textField.addDocumentListener(eventHandler);
    }

    public static String createRangeText(RAMLDecimal decimal, Double min, Double max, Double step, int digits) {
        BigDecimal minBD = new BigDecimal(min);
        BigDecimal maxBD = new BigDecimal(max);
        minBD = minBD.setScale(digits, 6);
        maxBD = maxBD.setScale(digits, 6);
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        if (decimal.getSpecialValues().size() > 0) {
            for (RAMLSpecialValue<Double> tmp : decimal.getSpecialValues()) {
                BigDecimal special = new BigDecimal(tmp.getValue());
                if ((special = special.setScale(digits, 6)).compareTo(minBD) >= 0 && special.compareTo(maxBD) <= 0) continue;
                sb.append(special.toString());
                sb.append(", ");
            }
        }
        sb.append(minBD.toString());
        if (step != null) {
            BigDecimal stepBD = new BigDecimal(step);
            stepBD = stepBD.setScale(digits, 6);
            sb.append(", ");
            sb.append(stepBD);
        }
        if (step != null) {
            sb.append(", ");
        }
        sb.append("...");
        sb.append(maxBD.toString());
        sb.append("]");
        return sb.toString();
    }

    public static String createRangeText(RAMLInteger integer, Integer min, Integer max, Integer step) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        if (integer.getSpecialValues().size() > 0) {
            for (RAMLSpecialValue<Integer> tmp : integer.getSpecialValues()) {
                if (tmp.getValue() >= min && tmp.getValue() <= max) continue;
                sb.append(tmp.getValue());
                sb.append(", ");
            }
        }
        sb.append(min);
        if (step != null) {
            sb.append(", ");
            sb.append(step);
        }
        if (step != null) {
            sb.append(", ");
        }
        sb.append("...");
        sb.append(max);
        sb.append("]");
        return sb.toString();
    }

    private static int getColumnCount(Number min, Number max) {
        if (min != null && max == null) {
            return String.valueOf(min).length();
        }
        if (min == null && max != null) {
            return String.valueOf(max).length();
        }
        if (min != null && max != null) {
            return Math.max(String.valueOf(max).length(), String.valueOf(min).length());
        }
        return 5;
    }

    protected static void createUnmodifiableCoordinatesComponent(String value, RAMLMetaParameter metaData, RAMLNode selectedNode, PPanel target, String property) {
        GPSValue gpsValue = new GPSValue();
        CoordinatesUtils.convertSCFValueToDMSValue(value, gpsValue);
        gpsValue.setSCFValue(value);
        gpsValue.setDegreesFieldEmpty(false);
        gpsValue.setMinutesFieldEmpty(false);
        gpsValue.setSecondsFieldEmpty(false);
        PLabel coordinatesValueLabel = RAMLEditComponentFactory.createCoordinatesValueLabel(metaData, selectedNode, property, gpsValue);
        target.add((Component)coordinatesValueLabel, "sgx common, width pref:pref:max, split 2, wrap");
        coordinatesValueLabel.putClientProperty("DMS", gpsValue);
    }

    private static PLabel createCoordinatesValueLabel(RAMLMetaParameter metaP, RAMLNode selectedNode, String property, GPSValue gpsValue) {
        StringBuilder builder = new StringBuilder();
        String positionValue = RAMLEditComponentFactory.getPositionValue(gpsValue.getSCFValue(), property);
        builder.append(String.valueOf(positionValue) + " ");
        builder.append(gpsValue.getDegrees());
        builder.append("\u00b0 ");
        builder.append(gpsValue.getMinutes());
        builder.append("' ");
        builder.append(gpsValue.getSeconds());
        builder.append("\"");
        PLabel textLabel = PLabel.createValueText(builder.toString());
        textLabel.putClientProperty("RAML.Meta.Data", metaP);
        textLabel.putClientProperty("RAML.Node.Owner", selectedNode);
        return textLabel;
    }

    private static String getPositionValue(String value, String property) {
        String comboBoxValue = "";
        int valueInt = Integer.parseInt(value);
        if (valueInt > 0) {
            if ("DMS latitude".equals(property)) {
                comboBoxValue = "N";
            } else if ("DMS longitude".equals(property)) {
                comboBoxValue = "E";
            }
        } else if (valueInt < 0) {
            if ("DMS latitude".equals(property)) {
                comboBoxValue = "S";
            } else if ("DMS longitude".equals(property)) {
                comboBoxValue = "W";
            }
        }
        return comboBoxValue;
    }

    protected static void createCoordinatesComponent(String value, RAMLMetaParameter metaData, RAMLNode selectedNode, RAMLEditEventHandler eventHandler, PPanel target, String property) {
        int maxRange = 0;
        GPSValue gpsValue = new GPSValue();
        JComboBox<String> comboBox = new JComboBox<String>();
        comboBox.addItem("");
        if ("DMS latitude".equals(property)) {
            comboBox.addItem("N");
            comboBox.addItem("S");
            maxRange = 90;
        } else if ("DMS longitude".equals(property)) {
            comboBox.addItem("E");
            comboBox.addItem("W");
            maxRange = 180;
        }
        comboBox.setPrototypeDisplayValue("W");
        PTextField degreeTextField = TextFieldFactory.createDiscontinuousIntegerRangeTextField(0, maxRange, 1);
        degreeTextField.setName("degree");
        degreeTextField.setColumns(3);
        PLabel degreesLabel = new PLabel("\u00b0");
        PTextField minuteTextField = TextFieldFactory.createDiscontinuousIntegerRangeTextField(0, 59, 1);
        minuteTextField.setName("minute");
        PLabel minutesLabel = new PLabel("'");
        PTextField secondTextField = TextFieldFactory.createDiscontinuousDecimalRangeTextField(2, 0.0, 59.99, 0.01);
        secondTextField.setName("second");
        PLabel secondsLabel = new PLabel("\"");
        PPanel coordinatesPanel = new PPanel((LayoutManager)new MigLayout("insets 0"));
        coordinatesPanel.add(comboBox);
        coordinatesPanel.add(degreeTextField);
        coordinatesPanel.add(degreesLabel);
        coordinatesPanel.add(minuteTextField);
        coordinatesPanel.add(minutesLabel);
        coordinatesPanel.add(secondTextField);
        coordinatesPanel.add(secondsLabel);
        target.add((Component)coordinatesPanel, "sgx common, width pref:pref:max, split 2");
        PLabel rangeLabel = PLabel.createRangeLabel(CoordinatesUtils.getDMSRange(property));
        target.add((Component)rangeLabel, "wrap");
        if (value != null && !value.isEmpty()) {
            CoordinatesUtils.convertSCFValueToDMSValue(value, gpsValue);
            RAMLEditComponentFactory.setTextFieldValues(gpsValue.getDegrees(), null, metaData, selectedNode, degreeTextField, null, false);
            RAMLEditComponentFactory.setTextFieldValues(gpsValue.getMinutes(), null, metaData, selectedNode, minuteTextField, null, false);
            RAMLEditComponentFactory.setTextFieldValues(gpsValue.getSeconds(), null, metaData, selectedNode, secondTextField, null, false);
            int valueInt = Integer.parseInt(value);
            if (valueInt > 0) {
                comboBox.setSelectedIndex(1);
            } else if (valueInt < 0) {
                comboBox.setSelectedIndex(2);
            }
            gpsValue.setDegreesFieldEmpty(false);
            gpsValue.setMinutesFieldEmpty(false);
            gpsValue.setSecondsFieldEmpty(false);
        }
        gpsValue.setSCFValue(value);
        comboBox.putClientProperty("DMS", gpsValue);
        degreeTextField.putClientProperty("DMS", gpsValue);
        minuteTextField.putClientProperty("DMS", gpsValue);
        secondTextField.putClientProperty("DMS", gpsValue);
        coordinatesPanel.putClientProperty("DMS", gpsValue);
        RAMLEditComponentFactory.disableComponentsFromTarget(target, comboBox, degreeTextField, minuteTextField, secondTextField);
        RAMLEditComponentFactory.addEventHandler(comboBox, eventHandler, metaData, selectedNode);
        RAMLEditComponentFactory.addEventHandler(degreeTextField, eventHandler, metaData, selectedNode);
        RAMLEditComponentFactory.addEventHandler(minuteTextField, eventHandler, metaData, selectedNode);
        RAMLEditComponentFactory.addEventHandler(secondTextField, eventHandler, metaData, selectedNode);
        RAMLEditComponentFactory.addEventHandler(coordinatesPanel, eventHandler, metaData, selectedNode);
    }

    private static void disableComponentsFromTarget(PPanel target, JComboBox comboBox, PTextField degreeTextField, PTextField minuteTextField, PTextField secondTextField) {
        if (RAMLEditComponentFactory.isTargetParamDisabled(target)) {
            comboBox.setEnabled(false);
            degreeTextField.setEnabled(false);
            minuteTextField.setEnabled(false);
            secondTextField.setEnabled(false);
        }
    }

    private static void addEventHandler(JComponent component, RAMLEditEventHandler eventHandler, RAMLMetaParameter metaData, RAMLNode node) {
        component.putClientProperty("RAML.Meta.Data", metaData);
        component.putClientProperty("RAML.Node.Owner", node);
        if (component instanceof PTextField) {
            PTextField textField = (PTextField)component;
            textField.getDocument().putProperty("RAML.Txt.Field", textField);
            textField.addFocusListener(eventHandler);
            textField.addDocumentListener(eventHandler);
        } else if (component instanceof JComboBox) {
            JComboBox combo = (JComboBox)component;
            combo.addActionListener(eventHandler);
        }
    }

    protected static void createCommonComponent(String value, RAMLMetaParameter metaData, RAMLNode selectedNode, PPanel target, RAMLEditEventHandler eventHandler, boolean setDefaultValue) {
        PTextField textField = RAMLEditComponentFactory.createCommonComponent(value, metaData, selectedNode, eventHandler, setDefaultValue);
        textField.setEnabled(!RAMLEditComponentFactory.isTargetParamDisabled(target));
        target.add((Component)textField, MIGLAYOUT_SIZEGROUP_COMMON_WRAP);
    }

    private static PTextField createCommonComponent(String value, RAMLMetaParameter metaData, RAMLNode selectedNode, RAMLEditEventHandler eventHandler, boolean setDefaultValue) {
        PTextField textField = new PTextField();
        textField.setName(String.valueOf(metaData.getName()) + "TextField");
        RAMLSimpleType simple = (RAMLSimpleType)metaData.getValueType();
        RAMLDefaultValue defVal = (RAMLDefaultValue)simple.getDefaultValue();
        String defaultText = defVal == null ? null : defVal.getValue().toString();
        RAMLEditComponentFactory.setTextFieldValues(value, defaultText, metaData, selectedNode, textField, eventHandler, setDefaultValue);
        return textField;
    }

    protected static void createStringComponent(String value, RAMLMetaParameter metaData, RAMLNode node, PPanel target, RAMLEditEventHandler eventHandler, boolean setDefaultValue) {
        PTextField textField = RAMLEditComponentFactory.createStringComponent(value, metaData, node, eventHandler, setDefaultValue);
        textField.setEnabled(!RAMLEditComponentFactory.isTargetParamDisabled(target));
        int column = textField.getColumns();
        if (column >= 40) {
            target.add((Component)textField, "sgx string" + column + ", wrap, width pref:pref:max");
        } else {
            target.add((Component)textField, MIGLAYOUT_SIZEGROUP_COMMON_WRAP);
        }
    }

    private static PTextField createStringComponent(String value, RAMLMetaParameter metaData, RAMLNode node, RAMLEditEventHandler eventHandler, boolean setDefaultValue) {
        PTextField textField;
        RAMLString str = (RAMLString)metaData.getValueType();
        if (str.getFixedLength() != -1) {
            int fixed = str.getFixedLength();
            textField = TextFieldFactory.createFixedLengthTextField(fixed);
            if (fixed > 150) {
                textField.setColumns(150);
            }
        } else if (str.getMaxLength() != -1) {
            int max = str.getMaxLength();
            String regularExp = metaData.getRegularExpression();
            if (metaData.isPrintableString()) {
                textField = TextFieldFactory.createASN1PrintableStringTextField(max);
            } else {
                boolean isAllowXMLEntities = regularExp != null && (Pattern.matches(regularExp, "&") || Pattern.matches(regularExp, "<") || Pattern.matches(regularExp, ">"));
                PTextField pTextField = textField = metaData.getValidationPattern() != null && metaData.getValidationPattern().contains("UTF8") ? TextFieldFactory.createUTF8EncodingTextField(max, isAllowXMLEntities) : TextFieldFactory.createAlphaNumericTextField(max, isAllowXMLEntities);
            }
            if (max > 150) {
                textField.setColumns(150);
            }
        } else {
            textField = new PTextField();
        }
        textField.setName(String.valueOf(metaData.getName()) + "TextField");
        Object defVal = str.getDefaultValue();
        String defaultText = defVal == null ? null : (String)((RAMLDefaultValue)defVal).getValue();
        RAMLEditComponentFactory.setTextFieldValues(value, defaultText, metaData, node, textField, eventHandler, setDefaultValue);
        return textField;
    }

    protected static void createIntegerComponent(String value, RAMLMetaParameter metaData, RAMLNode node, PPanel target, RAMLEditEventHandler eventHandler, boolean setDefaultValue) {
        RAMLInteger integer = (RAMLInteger)metaData.getValueType();
        PLabel typeLabel = PLabel.createValueText(integer.getUnitType());
        Integer min = (Integer)integer.getMinValue();
        Integer max = (Integer)integer.getMaxValue();
        Integer step = (Integer)integer.getStep();
        List<RAMLSpecialValue<Integer>> specialValues = integer.getSpecialValues();
        int[] specValArray = new int[specialValues.size()];
        int i = 0;
        while (i < specialValues.size()) {
            specValArray[i] = specialValues.get(i).getValue();
            ++i;
        }
        PTextField textField = RAMLEditComponentFactory.createIntegerComponents(metaData, target, typeLabel, min, max, step, specValArray);
        textField.setColumns(RAMLEditComponentFactory.getColumnCount(min, max));
        Object defVal = integer.getDefaultValue();
        String defaultText = defVal == null ? null : String.valueOf(((RAMLDefaultValue)defVal).getValue());
        RAMLEditComponentFactory.setTextFieldValues(value, defaultText, metaData, node, textField, eventHandler, setDefaultValue);
    }

    private static PTextField createIntegerComponents(RAMLMetaParameter metaData, PPanel target, PLabel typeLabel, Integer min, Integer max, Integer step, int[] specValArray) {
        PTextField textField;
        RAMLInteger integer = (RAMLInteger)metaData.getValueType();
        if (min != null && max != null) {
            textField = integer.getStep() != null ? (specValArray.length == 0 ? TextFieldFactory.createDiscontinuousIntegerRangeTextField(min, max, step) : TextFieldFactory.createDiscontinuousIntegerRangeTextField(min, max, step, specValArray)) : (specValArray.length == 0 ? TextFieldFactory.createIntegerTextField(min, max) : TextFieldFactory.createIntegerTextField(min, max, specValArray));
            textField.setName(String.valueOf(metaData.getName()) + "TextField");
            target.add((Component)textField, "sgx common, width pref:pref:max, split 2");
            String typeLabelText = typeLabel.getText();
            PLabel rangeLabel = PLabel.createRangeLabel(String.valueOf(typeLabelText) + (typeLabelText.isEmpty() ? "" : " ") + RAMLEditComponentFactory.createRangeText(integer, min, max, step != null && min + step != max ? Integer.valueOf(min + step) : null));
            target.add((Component)rangeLabel, "wrap");
        } else {
            textField = new PTextField();
            target.add((Component)textField, MIGLAYOUT_SIZEGROUP_COMMON);
            target.add((Component)typeLabel, "wrap");
        }
        textField.setEnabled(!RAMLEditComponentFactory.isTargetParamDisabled(target));
        typeLabel.setEnabled(!RAMLEditComponentFactory.isTargetParamDisabled(target));
        return textField;
    }

    protected static void createDecimalComponent(String value, RAMLMetaParameter metaData, RAMLNode node, PPanel target, RAMLEditEventHandler eventHandler, boolean setDefaultValue) {
        RAMLDecimal decimal = (RAMLDecimal)metaData.getValueType();
        String tmpValue = value;
        Double min = (Double)decimal.getMinValue();
        Double max = (Double)decimal.getMaxValue();
        Double step = (Double)decimal.getStep();
        PLabel typeLabel = PLabel.createValueText(decimal.getUnitType());
        Integer divisor = (Integer)decimal.getDivisor();
        Integer multiplier = (Integer)decimal.getMultiplier();
        Double shift = (Double)decimal.getShift();
        int digits = decimal.getDigits();
        boolean valueIsSpecialValue = false;
        List<RAMLSpecialValue<Double>> specialValues = decimal.getSpecialValues();
        double[] specValArray = new double[specialValues.size()];
        int i = 0;
        while (i < specialValues.size()) {
            specValArray[i] = specialValues.get(i).getValue();
            if (tmpValue != null && tmpValue.length() != 0 && specialValues.get(i).getValue().intValue() == new Double(tmpValue).intValue()) {
                valueIsSpecialValue = true;
            }
            ++i;
        }
        PTextField textField = RAMLEditComponentFactory.createDecimalComponets(metaData, target, min, max, step, typeLabel, digits, specValArray);
        textField.setColumns(RAMLEditComponentFactory.getColumnCount(min, max));
        Object defVal = decimal.getDefaultValue();
        String defaultText = "";
        if (defVal != null) {
            Double d = (Double)((RAMLDefaultValue)defVal).getValue();
            String string = defaultText = digits == 0 ? String.valueOf((int)d.doubleValue()) : String.valueOf(d);
        }
        if (tmpValue != null && TextUtils.isNumeric(tmpValue) && !valueIsSpecialValue) {
            if (multiplier != 1) {
                Double tmpDouble = new Double(tmpValue) * (double)multiplier.intValue();
                NumberFormat format = NumberFormat.getInstance();
                format.setMinimumFractionDigits(0);
                format.setMaximumFractionDigits(Integer.MAX_VALUE);
                tmpValue = String.valueOf(tmpDouble);
            }
            if (divisor != 0) {
                BigDecimal bigDecimalTmpValue = new BigDecimal(tmpValue);
                tmpValue = bigDecimalTmpValue.divide(new BigDecimal(divisor)).toPlainString();
            }
            if (shift != 0.0) {
                tmpValue = String.valueOf(Double.parseDouble(tmpValue) + shift);
                if (digits == 0) {
                    tmpValue = String.valueOf(new Double(tmpValue).intValue());
                }
            }
            if (tmpValue.startsWith("-") && Double.parseDouble(tmpValue) == 0.0) {
                tmpValue = tmpValue.substring(1);
            }
        }
        if (tmpValue != null && TextUtils.isNumeric(tmpValue) && tmpValue.startsWith("0") && !tmpValue.startsWith("0.")) {
            tmpValue = String.valueOf(new Double(tmpValue).intValue());
        }
        if (tmpValue != null && TextUtils.isNumeric(tmpValue) && (step == null || step % 1.0 == 0.0)) {
            NumberFormat nf = NumberFormat.getInstance();
            nf.setMaximumFractionDigits(0);
            nf.setGroupingUsed(false);
            tmpValue = nf.format(new Double(tmpValue));
        }
        RAMLEditComponentFactory.setTextFieldValues(tmpValue, defaultText, metaData, node, textField, eventHandler, setDefaultValue);
    }

    private static PTextField createDecimalComponets(RAMLMetaParameter metaData, PPanel target, Double min, Double max, Double step, PLabel typeLabel, int digits, double[] specValArray) {
        PTextField textField;
        RAMLDecimal decimal = (RAMLDecimal)metaData.getValueType();
        if (min != null && max != null) {
            textField = decimal.getStep() != null ? (specValArray.length == 0 ? TextFieldFactory.createDiscontinuousDecimalRangeTextField(digits, min, max, step, null, false) : TextFieldFactory.createDiscontinuousDecimalRangeTextField(digits, min, max, step, specValArray, false)) : (specValArray.length == 0 ? TextFieldFactory.createDecimalTextField(digits, (double)min, (double)max, false) : TextFieldFactory.createDecimalTextField(digits, min, max, specValArray, false));
            textField.setName(String.valueOf(metaData.getName()) + "Textfield");
            target.add((Component)textField, "sgx common, width pref:pref:max, split 2");
            String typeLabelText = typeLabel.getText();
            PLabel rangeLabel = PLabel.createRangeLabel(String.valueOf(typeLabelText) + (typeLabelText.isEmpty() ? "" : " ") + RAMLEditComponentFactory.createRangeText(decimal, min, max, step != null && !SystemUtils.isEqual(min, max) ? Double.valueOf(min + step) : null, digits));
            target.add((Component)rangeLabel, "wrap");
        } else {
            textField = new PTextField();
            target.add((Component)textField, MIGLAYOUT_SIZEGROUP_COMMON);
            target.add((Component)typeLabel, "wrap");
        }
        textField.setEnabled(!RAMLEditComponentFactory.isTargetParamDisabled(target));
        typeLabel.setEnabled(!RAMLEditComponentFactory.isTargetParamDisabled(target));
        return textField;
    }

    protected static void createEnumComponent(String value, RAMLMetaParameter metaData, RAMLNode node, PPanel target, RAMLEditEventHandler eventHandler, boolean setDefaultValue) {
        PComboBox combo = RAMLEditComponentFactory.createEnumComponent(value, metaData, node, eventHandler, setDefaultValue);
        combo.setEnabled(!RAMLEditComponentFactory.isTargetParamDisabled(target));
        double comboWidth = combo.getPreferredSize().getWidth();
        if (comboWidth >= 300.0) {
            target.add((Component)combo, "sgx combo" + comboWidth + ", wrap");
        } else {
            target.add((Component)combo, MIGLAYOUT_SIZEGROUP_COMMON_WRAP);
        }
    }

    public static void createBitComponents(String value, RAMLMetaParameter metaData, RAMLNode node, PPanel target, RAMLEditEventHandler eventHandler, Map<String, RAMLUIGroup> uiGroups) {
        RAMLEditComponentFactory.createBitComponents(value, metaData, node, target, eventHandler, uiGroups, Optional.empty());
    }

    public static void createBitComponents(String value, RAMLMetaParameter metaData, RAMLNode node, PPanel target, RAMLEditEventHandler eventHandler, Map<String, RAMLUIGroup> uiGroups, Optional<Icon> icon) {
        RAMLBitList enumeration = (RAMLBitList)metaData.getValueType();
        String defaultValue = "0";
        if (enumeration.getDefaultValue() != null) {
            defaultValue = String.valueOf(((RAMLDefaultValue)enumeration.getDefaultValue()).getValue());
        }
        PLabel info = PLabel.createValueText();
        info.putClientProperty("RAML.Meta.Data", metaData);
        target.add((Component)info, MIGLAYOUT_SIZEGROUP_COMMON_WRAP);
        RAMLUIGroup bitGroup = new RAMLUIGroup(metaData.getFullName(), info, metaData);
        bitGroup.setInfoText(value == null ? defaultValue : value);
        info.setEnabled(!RAMLEditComponentFactory.isTargetParamDisabled(target));
        for (RAMLBit bit : enumeration.getBits()) {
            PLabel label = PLabel.createSystemText(String.valueOf(bit.getText()) + ":");
            target.add(label);
            icon.ifPresent(m -> target.add((Component)new PLabel((Icon)m), MIGLAYOUT_SIZEGROUP_COMMON));
            JComponent comp = null;
            comp = bit.isFixed() ? RAMLEditComponentFactory.createUnmodifiableBitComponent(value) : RAMLEditComponentFactory.createBitComponent(value, metaData, node, eventHandler, bit);
            if (comp instanceof PComboBox) {
                ((PComboBox)comp).addActionListener(eventHandler);
            }
            comp.setEnabled(!RAMLEditComponentFactory.isTargetParamDisabled(target));
            target.add((Component)comp, MIGLAYOUT_SIZEGROUP_COMMON_WRAP);
            bitGroup.addUIComponent(comp);
        }
        uiGroups.put(bitGroup.getName(), bitGroup);
    }

    private static PComboBox createEnumComponent(String value, RAMLMetaParameter metaData, RAMLNode node, RAMLEditEventHandler eventHandler, boolean setDefaultValue) {
        RAMLEnum enumeration = (RAMLEnum)metaData.getValueType();
        PComboBox combo = new PComboBox();
        combo.setName(String.valueOf(metaData.getName()) + "ComboBox");
        combo.setMandatoryEntry(metaData.isMandatory());
        combo.setEmptyItem("");
        combo.addItem("");
        combo.setPackPopupWidth(true);
        for (String text : enumeration.getTexts()) {
            combo.addItem(text);
        }
        if (value != null && node.isValueAllowed(metaData, value).isOk()) {
            if (RAMLEnumValidator.isNumber(value) && !enumeration.getTexts().contains(value) && !value.contains(".") && !value.contains(",")) {
                combo.setSelectedItem(enumeration.getText(Integer.parseInt(value)));
            } else {
                combo.setSelectedItem(value);
            }
        } else if ((RAMLEditComponentFactory.isManualCommissioning() || metaData.isMandatory()) && setDefaultValue && enumeration.getDefaultValue() != null && node.isValueAllowed(metaData, ((Integer)((RAMLDefaultValue)enumeration.getDefaultValue()).getValue()).toString()).isOk() && !metaData.isSetByTheSystem()) {
            String text;
            text = enumeration.getText((Integer)((RAMLDefaultValue)enumeration.getDefaultValue()).getValue());
            theModelChanged = true;
            node.setValue(metaData, text);
            combo.setSelectedItem(text);
        }
        combo.putClientProperty("RAML.Meta.Data", metaData);
        combo.putClientProperty("RAML.Node.Owner", node);
        combo.addActionListener(eventHandler);
        return combo;
    }

    private static PComboBox createBitComponent(String value, RAMLMetaParameter metaData, RAMLNode node, RAMLEditEventHandler eventHandler, RAMLBit bit) {
        PComboBox combo = new PComboBox();
        combo.setName(String.valueOf(metaData.getName()) + "ComboBox");
        combo.setMandatoryEntry(metaData.isMandatory());
        combo.setEmptyItem("");
        combo.addItem(Boolean.TRUE.toString());
        combo.addItem(Boolean.FALSE.toString());
        if (value == null || value.length() == 0) {
            combo.setSelectedItem(bit.isDefaultOn() ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
        } else {
            combo.setSelectedItem(bit.isBitOn(Integer.parseInt(value)) ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
        }
        if (bit.isFixed()) {
            combo.setEnabled(false);
        }
        combo.putClientProperty("RAML.Meta.Data", metaData);
        combo.putClientProperty("RAML.Node.Owner", node);
        combo.putClientProperty("RAML.Bit.Name", metaData);
        combo.addActionListener(eventHandler);
        return combo;
    }

    private static PLabel createUnmodifiableBitComponent(String value) {
        PLabel label = PLabel.createValueText("" + Boolean.TRUE.toString().equals(value));
        return label;
    }

    protected static void createBooleanComponent(String value, RAMLMetaParameter metaData, RAMLNode node, PPanel target, RAMLEditEventHandler eventHandler, boolean setDefaultValue) {
        PComboBox combo = RAMLEditComponentFactory.createBooleanComponent(value, metaData, node, eventHandler, setDefaultValue);
        combo.setEnabled(!RAMLEditComponentFactory.isTargetParamDisabled(target));
        target.add((Component)combo, MIGLAYOUT_SIZEGROUP_COMMON_WRAP);
    }

    private static PComboBox createBooleanComponent(String value, RAMLMetaParameter metaData, RAMLNode node, RAMLEditEventHandler eventHandler, boolean setDefaultValue) {
        RAMLBoolean bool = (RAMLBoolean)metaData.getValueType();
        PComboBox combo = new PComboBox();
        combo.setName(String.valueOf(metaData.getName()) + "ComboBox");
        combo.setMandatoryEntry(metaData.isMandatory());
        combo.setEmptyItem("");
        combo.addItem("");
        combo.addItem(Boolean.TRUE);
        combo.addItem(Boolean.FALSE);
        if (value != null && value.length() != 0 && node.isValueAllowed(metaData, value).isOk()) {
            combo.setSelectedItem(RAMLBooleanValidator.isValueTrue(value));
        } else if ((RAMLEditComponentFactory.isManualCommissioning() || metaData.isMandatory()) && !"".equals(value) && setDefaultValue && bool.getDefaultValue() != null && node.isValueAllowed(metaData, ((Boolean)((RAMLDefaultValue)bool.getDefaultValue()).getValue()).toString()).isOk() && !metaData.isSetByTheSystem()) {
            theModelChanged = true;
            node.setValue(metaData, ((Boolean)((RAMLDefaultValue)bool.getDefaultValue()).getValue()).toString());
            combo.setSelectedItem(((RAMLDefaultValue)bool.getDefaultValue()).getValue());
        } else {
            combo.setSelectedItem("");
        }
        combo.putClientProperty("RAML.Meta.Data", metaData);
        combo.putClientProperty("RAML.Node.Owner", node);
        combo.addActionListener(eventHandler);
        return combo;
    }

    public static void createSimpleTypeComponent(String value, RAMLMetaParameter metaData, RAMLNode selectedNode, PPanel target, RAMLEditEventHandler eventHandler, Map<String, RAMLUIGroup> uiGroups, boolean setDefaultValue) {
        if (metaData.isSimpleType()) {
            RAMLSimpleType simple = (RAMLSimpleType)metaData.getValueType();
            String type = simple.getBaseType();
            if (type.equals("boolean")) {
                RAMLEditComponentFactory.createBooleanComponent(value, metaData, selectedNode, target, eventHandler, setDefaultValue);
            } else if (type.equals("enumeration")) {
                RAMLEditComponentFactory.createEnumComponent(value, metaData, selectedNode, target, eventHandler, setDefaultValue);
            } else if (type.equals("decimal")) {
                RAMLEditComponentFactory.createDecimalComponent(value, metaData, selectedNode, target, eventHandler, setDefaultValue);
            } else if (type.equals("integer")) {
                RAMLEditComponentFactory.createIntegerComponent(value, metaData, selectedNode, target, eventHandler, setDefaultValue);
            } else if (type.equals("bit")) {
                RAMLEditComponentFactory.createBitComponents(value, metaData, selectedNode, target, eventHandler, uiGroups);
            } else if (type.equals("string")) {
                RAMLEditComponentFactory.createStringComponent(value, metaData, selectedNode, target, eventHandler, setDefaultValue);
            } else {
                RAMLEditComponentFactory.createCommonComponent(value, metaData, selectedNode, target, eventHandler, setDefaultValue);
            }
        }
    }

    public static void createInstanceParameterComponent(ExtendedGridBagConstraints gc, RAMLNode node, PPanel target, RAMLEditEventHandler eventHandler, Map<String, RAMLUIGroup> uiGroups, JComponent component) {
        RAMLMetaParameter instanceP = RAMLEditComponentFactory.getInstanceParameter(node.getMetaParameters());
        if (instanceP != null) {
            gc.nextRow();
            gc.fillNone();
            gc.useNormalInsets();
            PLabel nameLabel = PLabel.createSystemText(String.valueOf(instanceP.getFullName()) + ":");
            nameLabel.setAutoTooltipEnabled(false);
            nameLabel.setToolTipText(null);
            RAMLDescription desc = instanceP.getShortDescription();
            String descString = desc == null ? null : desc.getDescription();
            RamlInfoTip nameLabelTip = new RamlInfoTip(nameLabel, instanceP.getName(), descString, RAMLEditComponentFactory.generateDistName(instanceP));
            nameLabelTip.setShowDelay(500);
            nameLabelTip.setTipContentActive(true);
            nameLabelTip.setDismissOnTooltipPress(true);
            target.add(nameLabel);
            if (component != null) {
                gc.nextColumn();
                gc.useSpecificInsets(new Insets(3, 3, 3, 0));
                target.add(component);
                gc.nextColumn();
                gc.fillHorizontal();
                gc.useSpecificInsets(new Insets(3, 0, 3, 6));
            } else {
                gc.nextColumn();
                gc.fillHorizontal();
                gc.useNormalInsets();
            }
            String id = node.getId();
            if (instanceP.isSetByTheSystem() || instanceP.isUnModifiable() && instanceP.isLocked() || instanceP.isUnChangeable()) {
                RAMLEditComponentFactory.createUnmodifiableComponent(id, instanceP, target, node);
            } else {
                RAMLEditComponentFactory.createSimpleTypeComponent(id, instanceP, node, target, eventHandler, uiGroups, true);
            }
            gc.useHeaderInsets();
        }
    }

    public static void createUnmodifiableComponent(String value, RAMLMetaParameter metaData, PPanel target, RAMLNode node) {
        RAMLSimpleType simple;
        StringBuilder valueText = new StringBuilder();
        if (value == null && !metaData.isSetByTheSystem()) {
            valueText.append(RAMLEditComponentFactory.getDefaultValue(metaData));
            theModelChanged = true;
            node.setValue(metaData, RAMLEditComponentFactory.getDefaultValue(metaData));
        } else if (value != null && value.length() != 0) {
            simple = (RAMLSimpleType)metaData.getValueType();
            if (!"string".equals(simple.getBaseType()) && TextUtils.isNumeric(value)) {
                if (simple.getBaseType().equals("enumeration") && ((RAMLEnum)simple).getTexts().contains(value)) {
                    valueText.append(value);
                } else if ("decimal".equals(simple.getBaseType())) {
                    RAMLDecimal decimal = (RAMLDecimal)simple;
                    Integer divisor = (Integer)decimal.getDivisor();
                    Integer multiplier = (Integer)decimal.getMultiplier();
                    Double shift = (Double)decimal.getShift();
                    Double tempValue = Double.parseDouble(value);
                    tempValue = tempValue * (double)multiplier.intValue();
                    tempValue = tempValue / (double)divisor.intValue();
                    if ((tempValue = Double.valueOf(tempValue + shift)) % 1.0 == 0.0) {
                        valueText.append(tempValue.longValue());
                    } else {
                        valueText.append(tempValue);
                    }
                } else {
                    valueText.append(new Double(value).longValue());
                }
            } else {
                valueText.append(value);
            }
        }
        if (metaData.isSimpleType() && !metaData.isSetByTheSystem() && ((simple = (RAMLSimpleType)metaData.getValueType()).getBaseType().equals("decimal") || simple.getBaseType().equals("integer"))) {
            RAMLNumber tmp = (RAMLNumber)simple;
            valueText.append(" ");
            valueText.append(tmp.getUnitType());
        }
        PLabel info = PLabel.createValueText(valueText.toString());
        info.setName(metaData.getName());
        info.putClientProperty("RAML.Meta.Data", metaData);
        info.putClientProperty("RAML.Node.Owner", node);
        info.setEnabled(!RAMLEditComponentFactory.isTargetParamDisabled(target));
        target.add((Component)info, MIGLAYOUT_SIZEGROUP_COMMON_WRAP);
    }

    public static String createTooltTip(RAMLNode selectedNode, RAMLMetaParameter metaData) {
        StringBuilder tooltipBuilder = new StringBuilder();
        tooltipBuilder.append("<HTML>");
        tooltipBuilder.append(metaData.getName());
        if (metaData.getShortDescription() != null) {
            tooltipBuilder.append("<BR>");
            tooltipBuilder.append(RAMLEditComponentFactory.encodeLessThanChar(metaData.getShortDescription().getDescription()));
        }
        if ("cellShudown".equals(metaData.getModificationType())) {
            tooltipBuilder.append("<BR>");
            tooltipBuilder.append(RB.getString("RAMLEdit.Requires.Cell.Shutdown"));
        }
        if ("objectLocking".equals(metaData.getModificationType())) {
            tooltipBuilder.append("<BR>");
            Object[] tmp = new Object[]{selectedNode.getName()};
            tooltipBuilder.append(MessageFormat.format(RB.getString("RAMLEdit.Requires.Requires.MO.Locking"), tmp));
        }
        tooltipBuilder.append("</HTML>");
        return TextUtils.textWrap(tooltipBuilder.toString(), "<BR>", 80);
    }

    public static String createRelatedTooltTip(RAMLNode parameterOwner, RAMLMetaParameter metaData) {
        boolean hasSpecialValues;
        StringBuilder tooltipBuilder = new StringBuilder();
        tooltipBuilder.append("<HTML>");
        StringBuilder specialValBuilder = new StringBuilder();
        StringBuilder relatedValBuilder = new StringBuilder();
        boolean bl = hasSpecialValues = metaData.isSimpleType() && ((RAMLSimpleType)metaData.getValueType()).getSpecialValues().size() > 0;
        if (hasSpecialValues) {
            RAMLSimpleType simple = (RAMLSimpleType)metaData.getValueType();
            List specials = simple.getSpecialValues();
            specialValBuilder.append(RB.getString("RAMLEdit.Special.Values"));
            specialValBuilder.append("<BR>");
            for (RAMLSpecialValue tmp : specials) {
                specialValBuilder.append(tmp.getText());
                specialValBuilder.append("=");
                if (TextUtils.isInteger(tmp.getValue().toString())) {
                    specialValBuilder.append(((Double)tmp.getValue()).intValue());
                } else {
                    specialValBuilder.append(tmp.getValue().toString());
                }
                specialValBuilder.append("<BR>");
            }
            specialValBuilder.append("<BR>");
        }
        for (RAMLRelatedParameter rp : metaData.getRelatedParameters().getRelatedParams()) {
            if (Boolean.valueOf(rp.getHidden()).booleanValue()) continue;
            String pName = rp.getParamName();
            RAMLMetaParameter metaP = null;
            List<RAMLMetaParameter> list = parameterOwner.getMetaParameters();
            for (RAMLMetaParameter metaPs : list) {
                if (!metaPs.getName().trim().equals(pName)) continue;
                metaP = metaPs;
            }
            if (metaP == null) {
                metaP = parameterOwner.getMetaParameter(rp.getClassName(), pName);
            }
            String paramText = metaP == null ? pName : String.valueOf(pName) + " (" + metaP.getFullName() + ")";
            Object[] values = new Object[]{paramText, rp.getClassName()};
            relatedValBuilder.append(MessageFormat.format(RB.getString("RAMLEdit.Related.To"), values));
            if (rp.getDescription() != null) {
                relatedValBuilder.append(RAMLEditComponentFactory.encodeLessThanChar(": " + rp.getDescription().getDescription()));
            }
            relatedValBuilder.append("<BR>");
        }
        if (relatedValBuilder.length() == 0 && metaData.getRelatedParameters().getDescription() != null) {
            relatedValBuilder.append(RAMLEditComponentFactory.encodeLessThanChar(metaData.getRelatedParameters().getDescription().getDescription()));
        }
        tooltipBuilder.append(specialValBuilder.toString());
        tooltipBuilder.append(TextUtils.textWrap(relatedValBuilder.toString(), "<BR>", RAMLEditComponentFactory.adjustTooltipSize(relatedValBuilder.toString().length())));
        tooltipBuilder.append("</HTML>");
        return tooltipBuilder.length() == 0 ? null : tooltipBuilder.toString().replaceAll("=<", "=&lt;");
    }

    private static String encodeLessThanChar(String s) {
        String retVal = s;
        if (s != null && s.contains("<")) {
            retVal = s.replaceAll("<", "&lt;");
        }
        return retVal;
    }

    private static boolean isManualCommissioning() {
        return COMMISSIONING_TYPE.MANUAL.equals((Object)myCommissioningType);
    }

    public static int adjustTooltipSize(int textLength) {
        if (textLength <= 800) {
            return 80;
        }
        if (textLength / 10 < 200) {
            return textLength / 10;
        }
        return 200;
    }

    public static void resetModelChanged() {
        theModelChanged = false;
    }

    public static boolean isModelChanged() {
        return theModelChanged;
    }

    public static JEditorPane createClickableToolTip(String name, String description, String distName) {
        StringBuilder tooltipBuilder = new StringBuilder();
        tooltipBuilder.append("<html><table><tr><td valign=\"top\" class=\"label\">");
        if (distName.contains(".")) {
            tooltipBuilder.append(RB.getString("PDDB_Parameter_Tooltip_ParamShortName"));
        } else {
            tooltipBuilder.append(RB.getString("PDDB_Parameter_Tooltip_MOName"));
        }
        tooltipBuilder.append("</td><td>");
        tooltipBuilder.append(name);
        tooltipBuilder.append("</td></tr>");
        if (description != null && description.trim().length() != 0) {
            tooltipBuilder.append("<tr><td valign=\"top\" class=\"label\">");
            tooltipBuilder.append(RB.getString("PDDB_Parameter_Tooltip_ShortDesc"));
            tooltipBuilder.append("</td><td>");
            tooltipBuilder.append(TextUtils.textWrap(TextUtils.encodeToHTMLSourceCode(description), "<br>", 80));
            tooltipBuilder.append("</td></tr>");
        }
        tooltipBuilder.append("<tr><td><a href=\"");
        tooltipBuilder.append(distName);
        tooltipBuilder.append("\">");
        tooltipBuilder.append(RB.getString("PDDB_Parameter_Tooltip_ShowMore"));
        tooltipBuilder.append("</a></td><td>&nbsp;</td></html>");
        JEditorPane pane = new JEditorPane("text/html", tooltipBuilder.toString());
        pane.setEditable(false);
        pane.setToolTipText(null);
        pane.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        pane.setMinimumSize(new Dimension(350, 100));
        Font font = UIManager.getFont("Label.textFont");
        Color hyperLinkColor = UIManager.getColor("Hyperlink.lightForeground");
        String cssLinkColor = "rgb(" + hyperLinkColor.getRed() + "," + hyperLinkColor.getGreen() + "," + hyperLinkColor.getBlue() + ")";
        String bodyRule = "body { font-family: " + font.getFamily() + "; " + "font-size: " + font.getSize() + "pt; color:white}";
        StyleSheet styleSheet = ((HTMLDocument)pane.getDocument()).getStyleSheet();
        styleSheet.addRule(bodyRule);
        styleSheet.addRule("a { text-decoration: underline; color: " + cssLinkColor + "}");
        styleSheet.addRule("a:hover { text-decoration: none; color: " + cssLinkColor + "}");
        styleSheet.addRule(".label { font-weight: bold; vertical-align: top; white-space: nowrap");
        return pane;
    }

    public static String generateDistName(RAMLMetaParameter metaData) {
        StringBuilder sb = new StringBuilder();
        sb.append(metaData.getMetaManagedObject().getClassName());
        sb.append(".");
        if (metaData.getParentParamName() != null) {
            sb.append(metaData.getParentParamName());
            sb.append(".");
        }
        sb.append(metaData.getName());
        return sb.toString();
    }

    public static COMMISSIONING_TYPE getCommissioningType() {
        return myCommissioningType;
    }

    public static void setCommissioningType(COMMISSIONING_TYPE commissioningType) {
        myCommissioningType = commissioningType;
    }

    public static boolean isTargetParamDisabled(PPanel target) {
        return ClientPropertyUtil.booleanValue(target, "PARAMETERS_DISABLED");
    }

    public static enum COMMISSIONING_TYPE {
        TEMPLATE,
        PLANNED,
        MANUAL,
        RECONFIGURATION;

    }
}

