/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.raml.edit;

import com.nokia.em.poseidon.frameworks.raml.RAMLParameter;
import com.nokia.em.poseidon.frameworks.raml.RAMLValidationResult;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLMetaParameter;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLBitList;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLSimpleType;
import com.nokia.em.poseidon.gui.raml.edit.RAMLEditPanel;
import com.nokia.em.poseidon.gui.raml.edit.RAMLNode;
import com.nokia.em.poseidon.gui.raml.edit.RAMLUIGroup;
import com.nokia.em.poseidon.util.CoordinatesUtils;
import com.nokia.em.poseidon.util.GPSValue;
import com.nokia.widgets.labels.PLabel;
import com.nokia.widgets.text.PTextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.apache.log4j.Logger;

public class RAMLEditEventHandler
extends FocusAdapter
implements ActionListener,
DocumentListener {
    private RAMLEditPanel myPanel;
    private Timer myValidationTimer = null;

    public RAMLEditEventHandler(RAMLEditPanel panel) {
        this.myPanel = panel;
        this.myValidationTimer = new Timer(500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RAMLEditEventHandler.this.myPanel.validateAndNotify();
            }
        });
        this.myValidationTimer.setRepeats(false);
    }

    protected boolean handleEvent(RAMLMetaParameter metaP, RAMLNode selected, String newValue, boolean showBalloon) {
        RAMLSimpleType simple = (RAMLSimpleType)metaP.getValueType();
        if (simple instanceof RAMLBitList) {
            return this.handleBitGroupEvent(metaP, selected);
        }
        RAMLValidationResult result = selected.isValueAllowed(metaP, newValue);
        this.myPanel.repaintRAMLTree();
        this.myPanel.fireActionPerfomed(new ActionEvent(this, 1, "valueChanged"));
        if (!metaP.isInstanceParameter() || !result.getState().equals((Object)RAMLValidationResult.State.ERROR)) {
            selected.setValue(metaP, newValue);
        }
        if (result.isOk()) {
            return true;
        }
        if (showBalloon) {
            this.myPanel.showBalloon(metaP.getName(), result);
        }
        this.myPanel.repaintRAMLTree();
        return false;
    }

    private boolean handleBitGroupEvent(RAMLMetaParameter metaP, RAMLNode selected) {
        RAMLUIGroup bitGroup = this.myPanel.getUIGroups().get(metaP.getFullName());
        RAMLBitList bit = (RAMLBitList)metaP.getValueType();
        if (bitGroup == null) {
            return false;
        }
        boolean[] selections = new boolean[bit.getBits().size()];
        int i = 0;
        for (JComponent c : bitGroup.getUIComponents()) {
            selections[i] = c instanceof PLabel ? "true".equals(((PLabel)c).getText()) : "true".equals(((JComboBox)c).getSelectedItem().toString());
            ++i;
        }
        String value = String.valueOf(bit.generateBitValue(selections));
        selected.setValue(metaP, value);
        bitGroup.setInfoText(value);
        this.myPanel.repaintRAMLTree();
        this.myPanel.fireActionPerfomed(new ActionEvent(this, 1, "valueChanged"));
        return true;
    }

    private void handleDocumentEvent(DocumentEvent e) {
        try {
            PTextField field = (PTextField)e.getDocument().getProperty("RAML.Txt.Field");
            RAMLMetaParameter metaP = (RAMLMetaParameter)field.getClientProperty("RAML.Meta.Data");
            Document document = e.getDocument();
            String value = "";
            value = metaP.hasDMSProperty("DMS latitude") || metaP.hasDMSProperty("DMS longitude") ? this.getGPSCoordinatesSCFValue(field) : document.getText(document.getStartPosition().getOffset(), document.getEndPosition().getOffset());
            if (value == null) {
                return;
            }
            value = value.replace("\n", "");
            RAMLNode node = (RAMLNode)field.getClientProperty("RAML.Node.Owner");
            boolean success = this.handleEvent(metaP, node, value, metaP.isInstanceParameter());
            if (success && metaP.isInstanceParameter()) {
                this.myPanel.closeOpenBalloon();
            }
            this.myPanel.notifyValidationStarted();
            this.myValidationTimer.restart();
            if (metaP.isInstanceParameter()) {
                this.myPanel.updateParameterTitle();
            }
        }
        catch (BadLocationException e1) {
            Logger.getLogger(RAMLEditPanel.class).error("document handling failed: " + e.toString());
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.getOppositeComponent() != null && e.getSource() instanceof JTextField) {
            Integer value;
            JTextField field = (JTextField)e.getSource();
            RAMLMetaParameter metaP = (RAMLMetaParameter)field.getClientProperty("RAML.Meta.Data");
            RAMLNode node = (RAMLNode)field.getClientProperty("RAML.Node.Owner");
            String newValue = field.getText();
            if (metaP.hasDMSProperty("DMS latitude") || metaP.hasDMSProperty("DMS longitude")) {
                newValue = this.getGPSCoordinatesSCFValue(field);
            }
            boolean success = this.handleEvent(metaP, node, newValue, true);
            RAMLParameter p = node.getParameter(metaP.getName());
            if (!success || !metaP.isInstanceParameter()) {
                if (p == null) {
                    field.setText("");
                }
            } else {
                this.myPanel.closeOpenBalloon();
            }
            if (p != null && p.getMetaData() != null && p.getMetaData().isInstanceParameter() && field.getText().length() > 0 && !(newValue = String.valueOf(value = Integer.valueOf(new Double(field.getText()).intValue()))).equals(field.getText())) {
                field.setText(newValue);
            }
        }
    }

    private String getGPSCoordinatesSCFValue(JComponent source) {
        GPSValue gpsValue = (GPSValue)source.getClientProperty("DMS");
        String scfValue = "";
        if (source instanceof JTextField) {
            String componentValue;
            JTextField textField = (JTextField)source;
            String type = textField.getName();
            boolean isComponentEmpty = textField.getText().isEmpty();
            String string = componentValue = isComponentEmpty && gpsValue.hasValue() ? "0" : textField.getText();
            if ("degree".equals(type)) {
                gpsValue.setDegrees(componentValue);
                gpsValue.setDegreesFieldEmpty(isComponentEmpty);
            } else if ("minute".equals(type)) {
                gpsValue.setMinutes(componentValue);
                gpsValue.setMinutesFieldEmpty(isComponentEmpty);
            } else if ("second".equals(type)) {
                gpsValue.setSeconds(componentValue);
                gpsValue.setSecondsFieldEmpty(isComponentEmpty);
            }
        } else if (source instanceof JComboBox) {
            JComboBox comboBox = (JComboBox)source;
            gpsValue.setNegative(comboBox.getSelectedIndex() == 2);
        }
        if (gpsValue.hasValue()) {
            scfValue = CoordinatesUtils.convertDMSValueToSCFValue(gpsValue.getDegrees(), gpsValue.getMinutes(), gpsValue.getSeconds(), gpsValue.isNegative());
        }
        gpsValue.setSCFValue(scfValue);
        return scfValue;
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JComboBox) {
            boolean success;
            JComboBox combo = (JComboBox)e.getSource();
            RAMLMetaParameter metaP = (RAMLMetaParameter)combo.getClientProperty("RAML.Meta.Data");
            RAMLNode node = (RAMLNode)combo.getClientProperty("RAML.Node.Owner");
            String newValue = combo.getSelectedItem().toString();
            if (metaP.hasDMSProperty("DMS latitude") || metaP.hasDMSProperty("DMS longitude")) {
                newValue = this.getGPSCoordinatesSCFValue((JComponent)e.getSource());
            }
            if (success = this.handleEvent(metaP, node, newValue, true)) {
                this.myPanel.closeOpenBalloon();
            } else {
                RAMLParameter p = node.getParameter(metaP.getName());
                if (p == null) {
                    combo.setSelectedItem("");
                } else {
                    combo.setSelectedItem(p.getValue());
                }
            }
            this.myPanel.notifyValidationStarted();
            this.myValidationTimer.restart();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.handleDocumentEvent(e);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.handleDocumentEvent(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.handleDocumentEvent(e);
    }
}

