/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.raml.edit;

import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.frameworks.i18n.localizer.Localizer;
import com.nokia.em.poseidon.frameworks.i18n.localizer.LocalizerRegistry;
import com.nokia.em.poseidon.frameworks.i18n.localizer.swing.SwingHierarchyIterator;
import com.nokia.em.poseidon.frameworks.raml.RAMLItem;
import com.nokia.em.poseidon.frameworks.raml.RAMLItemList;
import com.nokia.em.poseidon.frameworks.raml.RAMLManagedObject;
import com.nokia.em.poseidon.frameworks.raml.RAMLParameter;
import com.nokia.em.poseidon.frameworks.raml.RAMLParameterList;
import com.nokia.em.poseidon.frameworks.raml.RAMLValidationContext;
import com.nokia.em.poseidon.frameworks.raml.RAMLValidationResult;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLDescription;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLMetaDataFile;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLMetaManagedObject;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLMetaParameter;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLRelatedParameter;
import com.nokia.em.poseidon.gui.raml.ValidationDetailsController;
import com.nokia.em.poseidon.gui.raml.ValidationDetailsPanel;
import com.nokia.em.poseidon.gui.raml.edit.CreationPriorityComparator;
import com.nokia.em.poseidon.gui.raml.edit.RAMLButton;
import com.nokia.em.poseidon.gui.raml.edit.RAMLCopyDataToModel;
import com.nokia.em.poseidon.gui.raml.edit.RAMLCopyDataToView;
import com.nokia.em.poseidon.gui.raml.edit.RAMLCreatable;
import com.nokia.em.poseidon.gui.raml.edit.RAMLEditComponentFactory;
import com.nokia.em.poseidon.gui.raml.edit.RAMLEditEventHandler;
import com.nokia.em.poseidon.gui.raml.edit.RAMLEditUtils;
import com.nokia.em.poseidon.gui.raml.edit.RAMLEditValidator;
import com.nokia.em.poseidon.gui.raml.edit.RAMLMenuButton;
import com.nokia.em.poseidon.gui.raml.edit.RAMLNode;
import com.nokia.em.poseidon.gui.raml.edit.RAMLTreeListener;
import com.nokia.em.poseidon.gui.raml.edit.RAMLTreeModel;
import com.nokia.em.poseidon.gui.raml.edit.RAMLTreeUI;
import com.nokia.em.poseidon.gui.raml.edit.RAMLUIGroup;
import com.nokia.em.poseidon.gui.raml.edit.RAMLUnconfiguredNodeAction;
import com.nokia.em.poseidon.gui.raml.edit.RamlInfoTip;
import com.nokia.em.poseidon.gui.raml.edit.comparemo.CompareMOHandler;
import com.nokia.em.poseidon.gui.raml.edit.pddbbrowser.PDDBBrowserController;
import com.nokia.em.poseidon.services.ui.UserInterface;
import com.nokia.em.poseidon.services.ui.items.ScrollableMenu;
import com.nokia.em.poseidon.util.CoordinatesUtils;
import com.nokia.em.poseidon.util.GeneralUtils;
import com.nokia.em.poseidon.util.TextUtils;
import com.nokia.em.poseidon.util.concurrency.SwingWorker;
import com.nokia.widgets.PComboBox;
import com.nokia.widgets.PPanel;
import com.nokia.widgets.ScrollablePopupMenu;
import com.nokia.widgets.balloon.Balloon;
import com.nokia.widgets.buttons.MenuButton;
import com.nokia.widgets.commandbar.CommandBar;
import com.nokia.widgets.icons.CommonIcons;
import com.nokia.widgets.icons.PEmptyIcon;
import com.nokia.widgets.infotip.InfoTip;
import com.nokia.widgets.labels.PLabel;
import com.nokia.widgets.layout.ExtendedGridBagConstraints;
import com.nokia.widgets.table.PTable;
import com.nokia.widgets.text.PTextField;
import com.nokia.widgets.tree.PDefaultTreeCellRenderer;
import com.nokia.widgets.tree.TreeSearchBar;
import com.nokia.widgets.util.ScaleUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreePath;
import net.miginfocom.swing.MigLayout;
import org.apache.log4j.Logger;

public class RAMLEditPanel
extends JPanel
implements RAMLTreeListener {
    private static final int TREE_PATH_BOUNDS_PREFIX = 50;
    public static final int TREE_WIDTH = 393;
    public static final int BUTTON_HIGHT = 28;
    public static final int TREE_HIGHT = 100;
    public static final int SIDE_BAR_WIDTH = 160;
    public static final String PROPERTY_NAME = "RAML.Meta.Data";
    public static final String PROPERTY_OWNER = "RAML.Node.Owner";
    public static final String PROPERTY_BIT_NAME = "RAML.Bit.Name";
    public static final String PROPERTY_TXT_FIELD = "RAML.Txt.Field";
    public static final int ID_REVALIDATE = 1;
    public static final int ID_SHOW_VALIDATE = 2;
    public static final int ID_HIDE_VALIDATE = 3;
    public static final int ID_REBUILD_UI = 4;
    public static final String COMMAND_REVALIDATE = "valueChanged";
    public static final String COMMAND_VALIDATION_VISIBLE = "validationVisible";
    public static final String COMMAND_VALIDATION_VISIBLE_WITH_ERRORS = "validationVisibleWithErrors";
    public static final String COMMAND_VALIDATION_ONGOING = "validationOngoing";
    public static final String COMMAND_VALIDATION_HIDE = "validationNonVisible";
    public static final String COMMAND_PARAMETERS_VISIBLE = "parametersVisible";
    public static final String DEFAULT_VALUE_NEEDED_IN_PARAMETER_CREATION = "defaultValueNeededInParameterCreation";
    public static final String IS_COPIED_FROM_ANOTHER_MO = "isCopiedFromAnotherMo";
    protected RAMLTreeModel myTreeModel;
    protected JTree myTree;
    protected TreeSearchBar myTreeSearch;
    protected JComponent myCreateComponent;
    protected JComponent myNewComponent;
    protected RAMLButton myNewButton;
    protected RAMLButton myCreateButton;
    protected RAMLMenuButton myNewMenuButton;
    protected JComponent myDeleteComponent;
    protected RAMLButton myDeleteButton;
    protected RAMLMenuButton myDeleteMenuButton;
    protected RAMLMenuButton myCompareMOMenuButton;
    protected PPanel myParameterPanel;
    protected PPanel mySortPanel;
    protected PLabel myParamHeader;
    protected PPanel myLeftPanel;
    protected PPanel myGeneralLeftPanel;
    protected RAMLEditEventHandler myEventHandler;
    protected static final ResourceBundle theBundle = I18n.getI18n().getBundle(RAMLEditPanel.class);
    protected static final ImageIcon WARNING_ICON = CommonIcons.getWarningIcon();
    protected static final Icon PLACEHOLDER_ICON = new PEmptyIcon(WARNING_ICON.getIconHeight(), WARNING_ICON.getIconWidth());
    protected RAMLNode myCurrentNode;
    protected PComboBox mySortComboBox;
    protected SORTING mySorting = SORTING.ALPHABETICAL;
    protected ValidationDetailsPanel myValidationPanel;
    protected ValidationDetailsController myValidationController;
    protected JSplitPane mySplitPane;
    protected JSplitPane myMidSplitPane;
    protected RAMLMenuButton myCopyParaMenuButton;
    protected JButton myCopyParaToButton;
    protected Logger myLogger;
    protected PTable myListTable;
    protected RAMLUnconfiguredNodeAction myUnconfiguredNodeAction;
    protected Map<RAMLNode, Boolean> myRAMLNodeValidity = new IdentityHashMap<RAMLNode, Boolean>();
    private List<ActionListener> myActionListeners;
    private Map<String, RAMLUIGroup> myUIGroups;
    private Balloon myOpenBalloon;
    private RAMLButton myCopyButton;
    private RelatedFunctionComparator myRelatedFunctionComparator;
    private CreationPriorityComparator myCreationPriorityComparator;
    private RAMLEditValidator myValidator;
    private boolean myShowVendorSpecificParams;
    protected JComponent myHighlightedComponent = null;
    private Timer myValidationTimer = null;
    private Timer myShowProgressTimer;
    private SwingWorker myValidationWorker;
    private RAMLMetaDataFile myMetadataFile;
    protected PDDBBrowserController myPddbBrowserController;
    private List<PLabel> myLabels = new ArrayList<PLabel>();
    private List<RAMLMetaParameter> myMetaDataForLabels = new ArrayList<RAMLMetaParameter>();
    private JPopupMenu myTreeContextMenu;
    private List<RAMLNode> mySiblingMOs = new ArrayList<RAMLNode>(0);

    public RAMLEditPanel(RAMLTreeModel treeModel) {
        this(treeModel, false, null);
    }

    public RAMLEditPanel(RAMLTreeModel treeModel, final boolean showValidationPanel, RAMLEditValidator validator, Container parent) {
        this.myValidator = validator;
        this.myLogger = Logger.getLogger(this.getClass());
        this.myTreeModel = treeModel;
        this.myActionListeners = new ArrayList<ActionListener>();
        this.myUIGroups = new HashMap<String, RAMLUIGroup>();
        this.myRelatedFunctionComparator = new RelatedFunctionComparator();
        this.myCreationPriorityComparator = new CreationPriorityComparator();
        this.buildUI(showValidationPanel);
        this.layoutUI(showValidationPanel);
        Localizer localizer = LocalizerRegistry.lookup("swing");
        localizer.setResourceBundle(theBundle);
        localizer.localizeObjectHierarchy(new SwingHierarchyIterator(this));
        this.myTree.setSelectionPath(new TreePath(this.myTreeModel.getRoot()));
        this.myCurrentNode = this.myTreeModel.getSelectedRAMLNode();
        this.setParameterValueNoGUISupportEnabled(this.myCurrentNode);
        this.myValidationTimer = new Timer(500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RAMLEditPanel.this.validateAndNotify();
            }
        });
        this.myValidationTimer.setRepeats(false);
        this.myShowProgressTimer = new Timer(750, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (showValidationPanel) {
                    RAMLEditPanel.this.myValidationController.setValidationContext(new RAMLValidationContext("RAML"));
                    RAMLEditPanel.this.myValidationPanel.setShowValidationProgress(true);
                }
            }
        });
        this.myShowProgressTimer.setRepeats(false);
        if (RamlInfoTip.getPddbBrowserController() == null) {
            this.myPddbBrowserController = new PDDBBrowserController(parent);
            RamlInfoTip.setPddbBrowserController(this.myPddbBrowserController);
        } else {
            this.myPddbBrowserController = (PDDBBrowserController)RamlInfoTip.getPddbBrowserController();
        }
    }

    protected void setParameterValueNoGUISupportEnabled(RAMLNode node) {
        List<RAMLMetaParameter> metaParams = node.getMetaParameters();
        for (RAMLMetaParameter metaParam : metaParams) {
            if (metaParam.isVisibleInGUI() || !metaParam.hasDefaultValue()) continue;
            node.setValue(metaParam, RAMLEditComponentFactory.getDefaultValue(metaParam));
        }
        for (RAMLNode child : node.getChilds()) {
            this.setParameterValueNoGUISupportEnabled(child);
        }
    }

    public RAMLEditPanel(RAMLTreeModel treeModel, boolean showValidationPanel, RAMLEditValidator validator) {
        this(treeModel, showValidationPanel, validator, null);
    }

    public void buildUI(boolean createValidationPanel) {
        this.createEventHandler();
        this.myTree = new RAMLTree(this, this.myTreeModel){

            @Override
            public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (value != null) {
                    return ((RAMLNode)value).getName();
                }
                return super.convertValueToText(value, selected, expanded, leaf, row, hasFocus);
            }
        };
        this.myTree.putClientProperty("OrangeTouch.refreshTreeLayoutOnPaint", true);
        this.myTree.putClientProperty("OrangeTouch.automaticTooltipEnabled", false);
        this.myTree.setExpandsSelectedPaths(true);
        this.myTree.setName("RAMLEditorTree");
        this.createSearchBar();
        this.myTreeSearch.setBorder(BorderFactory.createEmptyBorder(0, 0, 3, 0));
        this.myTreeSearch.getSearchField().setParentNodeResolver(this.myTreeModel);
        this.myTreeModel.addRAMLTreeListener(this);
        this.myLeftPanel = new PPanel(new BorderLayout());
        this.myLeftPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.myParameterPanel = new PPanel((LayoutManager)new MigLayout());
        this.myParamHeader = PLabel.createTitle();
        if (createValidationPanel) {
            this.myValidationController = new ValidationDetailsController(this);
            this.myValidationPanel = new ValidationDetailsPanel(this.myValidationController, true);
            this.myValidationController.setView(this.myValidationPanel);
            this.mySplitPane = new JSplitPane(0);
            this.mySplitPane.setResizeWeight(1.0);
            this.myMidSplitPane = new JSplitPane(1);
        }
        this.initButtons();
        this.createSortCombobox();
        this.myNewComponent = this.myNewButton;
        this.myDeleteComponent = this.myDeleteButton;
        this.myTree.getSelectionModel().setSelectionMode(1);
        this.myTree.addTreeSelectionListener(this.myTreeModel);
        this.myTree.setCellRenderer(this.createTreeCellRenderer());
        this.createTreeInfoTipProvider();
        this.myTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                RAMLEditPanel.this.showPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                RAMLEditPanel.this.showPopup(e);
            }
        });
    }

    protected void initButtons() {
        this.initNewButton();
        this.initNewMenuButton();
        this.initDeleteButton();
        this.initDeleteMenuButton();
        this.initCopyButton();
        this.initCopyDataMenuButton();
        this.initCopyDataToButton();
        this.initCompareMOMenuButton();
        this.initCreateButton();
    }

    private void initNewButton() {
        this.myNewButton = new RAMLButton(theBundle.getString("RAMLEdit.New"), "");
        this.myNewButton.setName("NewButton");
        this.myNewButton.setMnemonic(theBundle.getMnemonic("RAMLEdit.New_Mnemonic"));
        this.initComponentDimensionAndAvailability(this.myNewButton);
        this.myNewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RAMLEditPanel.this.createActionForNewFunction(RAMLEditPanel.this.myNewButton.getClassName());
                RAMLEditPanel.this.closeVisiblePopupMenus();
                RAMLEditPanel.this.requestFocusInWindow();
            }
        });
    }

    private void initCreateButton() {
        this.myCreateButton = new RAMLButton(theBundle.getString("RAMLEdit.Create.Button"), "");
        this.myCreateButton.setName("CreateButton");
        this.myCreateButton.setMnemonic(theBundle.getMnemonic("RAMLEdit.Create_Mnemonic"));
        this.initComponentDimensionAndAvailability(this.myCreateButton);
        this.myCreateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RAMLEditPanel.this.myUnconfiguredNodeAction.createAction();
                RAMLEditPanel.this.closeVisiblePopupMenus();
                RAMLEditPanel.this.requestFocusInWindow();
            }
        });
    }

    private void initDeleteButton() {
        this.myDeleteButton = new RAMLButton(theBundle.getString("RAMLEdit.Delete"), "");
        this.myDeleteButton.setMnemonic(theBundle.getMnemonic("RAMLEdit.Delete_Mnemonic"));
        this.initComponentDimensionAndAvailability(this.myDeleteButton);
        this.myDeleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RAMLEditPanel.this.removesChildObject();
                RAMLEditPanel.this.closeVisiblePopupMenus();
                RAMLEditPanel.this.requestFocusInWindow();
            }
        });
    }

    private void initCopyButton() {
        this.myCopyButton = new RAMLButton(theBundle.getString("RAMLEdit.Copy.Button"), "");
        this.myCopyButton.setMnemonic(theBundle.getMnemonic("RAMLEdit.Copy.Button_Mnemonic"));
        this.initComponentDimensionAndAvailability(this.myCopyButton);
        this.myCopyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RAMLEditPanel.this.copyObject();
                RAMLEditPanel.this.closeVisiblePopupMenus();
            }
        });
    }

    private void initNewMenuButton() {
        this.myNewMenuButton = new RAMLMenuButton(theBundle.getString("RAMLEdit.New"));
        this.myNewMenuButton.setMnemonic(theBundle.getMnemonic("RAMLEdit.New_Mnemonic"));
        this.initMenuButton(this.myNewMenuButton, "NewMenuButton");
    }

    private void initDeleteMenuButton() {
        this.myDeleteMenuButton = new RAMLMenuButton(theBundle.getString("RAMLEdit.Delete"));
        this.myDeleteMenuButton.setMnemonic(theBundle.getMnemonic("RAMLEdit.Delete_Mnemonic"));
        this.initMenuButton(this.myDeleteMenuButton, "DeleteMenuButton");
    }

    protected void initCopyDataMenuButton() {
        this.myCopyParaMenuButton = new RAMLMenuButton(theBundle.getString("RAMLEdit.Copy.Parameter"));
        this.myCopyParaMenuButton.setMnemonic(theBundle.getMnemonic("RAMLEdit.Copy.Parameter.Mnemonic"));
        this.initMenuButton(this.myCopyParaMenuButton, "CopyDataMenuButton");
    }

    protected void initCopyDataToButton() {
        this.myCopyParaToButton = new JButton(theBundle.getString("CopyDataToButton_Text"));
        this.myCopyParaToButton.setMnemonic(theBundle.getMnemonic("CopyDataToButton_Mnemonic"));
        this.myCopyParaToButton.setVisible(false);
        this.myCopyParaToButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RAMLEditPanel.this.showCopyDataToDialog();
                RAMLEditPanel.this.closeVisiblePopupMenus();
            }
        });
    }

    public void closeVisiblePopupMenus() {
        for (RAMLMenuButton ramlMenuButton : this.getAllPopUpMenuButtons()) {
            if (ramlMenuButton == null || !ramlMenuButton.getPopupMenu().isVisible()) continue;
            ramlMenuButton.getPopupMenu().setVisible(false);
        }
        this.closeVisibleScrollablePopupMenus();
    }

    private void closeVisibleScrollablePopupMenus() {
        if (this.myTreeContextMenu != null && this.myTreeContextMenu.isVisible()) {
            this.myTreeContextMenu.setVisible(false);
        }
    }

    private List<RAMLMenuButton> getAllPopUpMenuButtons() {
        ArrayList<RAMLMenuButton> ramlMenuButtons = new ArrayList<RAMLMenuButton>(4);
        ramlMenuButtons.add(0, this.myNewMenuButton);
        ramlMenuButtons.add(1, this.myDeleteMenuButton);
        ramlMenuButtons.add(2, this.myCompareMOMenuButton);
        ramlMenuButtons.add(3, this.myCopyParaMenuButton);
        return ramlMenuButtons;
    }

    protected void showCopyDataToDialog() {
        RAMLCopyDataToModel model = new RAMLCopyDataToModel(this);
        RAMLCopyDataToView view = new RAMLCopyDataToView(model, "BTS_CopyDataTo", this.getRootNodeName());
        view.setVisible(true);
    }

    protected String getRootNodeName() {
        return "All";
    }

    private void initCompareMOMenuButton() {
        this.myCompareMOMenuButton = new RAMLMenuButton(theBundle.getString("RAMLEdit.Compare"));
        this.myCompareMOMenuButton.setMnemonic(theBundle.getMnemonic("RAMLEdit.CompareMO.Mnemonic"));
        this.initMenuButton(this.myCompareMOMenuButton, "CompareMOMenuButton");
    }

    private void initMenuButton(RAMLMenuButton menuButton, String name) {
        menuButton.setName(name);
        this.initComponentDimensionAndAvailability(menuButton);
        menuButton.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        menuButton.putClientProperty("JComboBox.isFileChooserCombo", Boolean.TRUE);
    }

    private void initComponentDimensionAndAvailability(Component component) {
        component.setMinimumSize(new Dimension(this.getTreeWidth(), 28));
        component.setPreferredSize(new Dimension(this.getTreeWidth(), 28));
        component.setMaximumSize(new Dimension(this.getTreeWidth(), 28));
        component.setVisible(false);
    }

    protected void createEventHandler() {
        this.myEventHandler = new RAMLEditEventHandler(this);
    }

    protected PDefaultTreeCellRenderer createTreeCellRenderer() {
        return new CommonTreeCellRenderer();
    }

    protected void createSortCombobox() {
        this.mySortComboBox = new PComboBox(new String[]{theBundle.getString("RAMLEdit.Alphabetical"), theBundle.getString("RAMLEdit.Related"), theBundle.getString("RAMLEdit.Creation")});
        this.mySortComboBox.setName("RAMLEditorSortComboBox");
        this.mySortComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String selected = (String)RAMLEditPanel.this.mySortComboBox.getSelectedItem();
                if (selected.equals(theBundle.getString("RAMLEdit.Alphabetical"))) {
                    RAMLEditPanel.this.mySorting = SORTING.ALPHABETICAL;
                } else if (selected.equals(theBundle.getString("RAMLEdit.Related"))) {
                    RAMLEditPanel.this.mySorting = SORTING.RELATED;
                } else if (selected.equals(theBundle.getString("RAMLEdit.Creation"))) {
                    RAMLEditPanel.this.mySorting = SORTING.CREATION;
                }
                RAMLEditPanel.this.rebuildParametersUI();
                RAMLEditPanel.this.mySortComboBox.requestFocusInWindow();
            }
        });
    }

    protected int getTreeWidth() {
        return 393;
    }

    public void validateAndNotify() {
        this.notifyValidationStarted();
        this.myRAMLNodeValidity.clear();
        if (this.myValidationWorker != null) {
            this.myValidationWorker.cancel(true);
            this.myValidationWorker = null;
        }
        this.myValidationWorker = new SwingWorker(){

            protected Object construct() throws Exception {
                RAMLValidationContext context = RAMLEditPanel.this.doValidation();
                HashMap<RAMLNode, Boolean> validity = new HashMap<RAMLNode, Boolean>();
                Set inValidNodes = RAMLEditPanel.this.getNodesFromValidationContext(context);
                this.setValidityToChildren((RAMLNode)RAMLEditPanel.this.myTreeModel.getRoot(), validity, inValidNodes);
                return new Object[]{context, validity};
            }

            private void setValidityToChildren(RAMLNode node, Map<RAMLNode, Boolean> validity, Set<String> inValidNodes) {
                if (!RAMLEditPanel.this.isInTheErrorSet(node, inValidNodes)) {
                    this.setValidityToChildren(validity, node, true);
                } else {
                    validity.put(node, false);
                    for (RAMLNode child : node.getChilds()) {
                        this.setValidityToChildren(child, validity, inValidNodes);
                    }
                }
            }

            private void setValidityToChildren(Map<RAMLNode, Boolean> validity, RAMLNode node, boolean value) {
                validity.put(node, value);
                for (RAMLNode child : node.getChilds()) {
                    this.setValidityToChildren(validity, child, value);
                }
            }

            @Override
            protected void finished() {
                RAMLValidationContext context;
                try {
                    Object[] result = (Object[])this.get();
                    context = (RAMLValidationContext)result[0];
                    RAMLEditPanel.this.myRAMLNodeValidity = (Map)result[1];
                    RAMLEditPanel.this.myTree.repaint();
                }
                catch (Exception e) {
                    RAMLEditPanel.this.myLogger.debug("Exception while RAML validation.", e);
                    return;
                }
                if (RAMLEditPanel.this.myValidationPanel != null) {
                    RAMLEditPanel.this.myValidationPanel.setShowValidationProgress(false);
                }
                RAMLEditPanel.this.myShowProgressTimer.stop();
                if (RAMLEditPanel.this.myValidationController != null) {
                    RAMLEditPanel.this.myValidationController.setValidationContext(context);
                }
                RAMLEditPanel.this.rebuildButtons();
                RAMLEditPanel.this.fireActionPerfomed(new ActionEvent(this, 2, RAMLEditPanel.this.isValidationErrorExist(context.getResults()) ? RAMLEditPanel.COMMAND_VALIDATION_VISIBLE_WITH_ERRORS : RAMLEditPanel.COMMAND_VALIDATION_VISIBLE));
            }
        };
        this.myValidationWorker.start();
        this.myShowProgressTimer.restart();
    }

    protected void rebuildButtons() {
        this.rebuildNewComponent();
        this.rebuildCopyButton();
        this.rebuildCopyDataMenuButton();
        this.rebuildCopyDataToButton();
        this.rebuildDeleteComponent();
    }

    protected void resizeButtonComponents() {
        int width = this.myMidSplitPane.getLeftComponent().getWidth();
        this.resizeButtonComponents(width);
    }

    protected void resizeButtonComponents(int newWidth) {
        Component[] components = ((PPanel)this.myGeneralLeftPanel.getComponent(1)).getComponents();
        int i = 0;
        while (i < components.length) {
            Component component = components[i];
            int minWidth = (int)component.getMinimumSize().getWidth();
            int maxWidth = (int)component.getMaximumSize().getWidth();
            int preferWidth = newWidth - 10 > minWidth ? newWidth - 10 : minWidth;
            preferWidth = preferWidth > maxWidth ? maxWidth : preferWidth;
            component.setMinimumSize(new Dimension(minWidth, 28));
            component.setPreferredSize(new Dimension(preferWidth, 28));
            component.setMaximumSize(new Dimension(this.getTreeWidth(), 28));
            component.repaint();
            ++i;
        }
    }

    public boolean isValidationErrorExist(List<RAMLValidationResult> results) {
        for (RAMLValidationResult result : results) {
            if (RAMLValidationResult.State.ERROR != result.getState()) continue;
            return true;
        }
        return false;
    }

    private Set<String> getNodesFromValidationContext(RAMLValidationContext context) {
        List<RAMLValidationResult> list = context.getResults();
        HashSet<String> returnSet = new HashSet<String>(list.size());
        for (RAMLValidationResult result : list) {
            Object obj = result.getSource();
            if (obj instanceof RAMLManagedObject) {
                this.addParentNodesToErrorSet((RAMLManagedObject)obj, returnSet);
                continue;
            }
            if (obj instanceof RAMLItem) {
                this.addParentNodesToErrorSet((RAMLItem)obj, result, returnSet);
                continue;
            }
            if (obj instanceof RAMLParameterList) {
                this.addParentNodesToErrorSet(((RAMLParameterList)obj).getManagedObject(), returnSet);
                continue;
            }
            if (obj instanceof RAMLItemList) {
                this.addParentNodesToErrorSet(((RAMLItemList)obj).getManagedObject(), returnSet);
                continue;
            }
            if (obj == null) continue;
            this.myLogger.error("Unsupported data type in the validation context: " + obj.getClass().getName());
        }
        return returnSet;
    }

    protected void addParentNodesToErrorSet(RAMLItem item, RAMLValidationResult ramlValidationResult, Set<String> returnSet) {
        returnSet.add(item.toString());
    }

    protected void addParentNodesToErrorSet(RAMLManagedObject currentMO, Set<String> returnSet) {
        String distName = currentMO.getDistName();
        returnSet.add(distName);
        RAMLManagedObject parent = currentMO.getParentMO();
        while (parent != null) {
            distName = parent.getDistName();
            returnSet.add(distName);
            parent = parent.getParentMO();
        }
    }

    protected boolean isInTheErrorSet(RAMLNode node, Set<String> inValidNodes) {
        return !node.isValid();
    }

    protected void notifyValidationStarted() {
        this.fireActionPerfomed(new ActionEvent(this, 2, COMMAND_VALIDATION_ONGOING));
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.myValidationWorker != null) {
            this.myValidationWorker.cancel(true);
        }
    }

    public RAMLValidationContext doValidation() {
        return this.myValidator == null ? new RAMLValidationContext("RAML") : this.myValidator.validate();
    }

    public RAMLNode getSelectedNode() {
        return this.myCurrentNode;
    }

    public Map<String, RAMLUIGroup> getUIGroups() {
        return this.myUIGroups;
    }

    public void addActionListener(ActionListener l) {
        this.myActionListeners.add(l);
    }

    public void removeActionListener(ActionListener l) {
        this.myActionListeners.remove(l);
    }

    protected void fireActionPerfomed(ActionEvent e) {
        ArrayList<ActionListener> tmp = new ArrayList<ActionListener>(this.myActionListeners);
        for (ActionListener l : tmp) {
            l.actionPerformed(e);
        }
    }

    protected void repaintRAMLTree() {
        this.myTree.invalidate();
        this.myTree.repaint();
    }

    public void showPopup(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        TreePath clickedElement = null;
        this.myTree.getPathForLocation(x, y);
        clickedElement = this.getCustomizePathForLocation(x, y);
        if (clickedElement == null || this.myTree.getSelectionPath() == null) {
            return;
        }
        if (e.isPopupTrigger()) {
            if (!clickedElement.equals(this.myTree.getSelectionPath())) {
                this.myTree.setSelectionPath(clickedElement);
                this.myCurrentNode = this.myTreeModel.getSelectedRAMLNode();
            }
            this.myTreeContextMenu = new ScrollablePopupMenu();
            List<RAMLCreatable> childs = this.myCurrentNode.getMetaChilds();
            if (childs.size() > 0) {
                boolean newItemAdded = false;
                ScrollableMenu newItems = new ScrollableMenu(theBundle.getString("RAMLEdit.New"));
                for (final RAMLCreatable child : childs) {
                    JMenuItem item = new JMenuItem(child.getName());
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            RAMLEditPanel.this.createActionForNewFunction(child.getClassIdentifier());
                        }
                    });
                    item.setToolTipText(this.resizeTooltip(child.getDescription()));
                    if (this.myCurrentNode.getId().isEmpty() || !this.isUnconfiguredNodeActionNull() && this.myUnconfiguredNodeAction.isNodeNonConfigured(this.myCurrentNode) || this.isNodeIdEmpty()) continue;
                    ((JMenu)newItems).add(item);
                    newItemAdded = true;
                }
                this.addNewItemsToTreeMenu(newItemAdded, newItems);
            }
            boolean isDeletable = this.isDeletable();
            if (this.myCurrentNode.getParent() != null) {
                this.addPopMenuItems(this.myTreeContextMenu, isDeletable);
            }
            if (this.myTreeContextMenu.getComponentCount() == 0) {
                return;
            }
            if (this.hasMultipleInstances(this.myCurrentNode)) {
                ScrollableMenu compareItems = new ScrollableMenu(theBundle.getString("RAMLEdit.Compare"));
                this.mySiblingMOs = this.getSiblings(this.myCurrentNode);
                for (final RAMLNode sibling : this.mySiblingMOs) {
                    JMenuItem menuItem = new JMenuItem(sibling.getName());
                    menuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            new CompareMOHandler(RAMLEditPanel.this.myCurrentNode, sibling, RAMLEditPanel.this.myTreeModel);
                            RAMLEditPanel.this.rebuildParametersUI();
                            RAMLEditPanel.this.validateAndNotify();
                        }
                    });
                    ((JMenu)compareItems).add(menuItem);
                }
                this.myTreeContextMenu.add(compareItems);
            }
            this.myTreeContextMenu.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }

    private void addNewItemsToTreeMenu(boolean newItemAdded, JMenu newItems) {
        if (newItemAdded) {
            this.myTreeContextMenu.add(newItems);
        }
    }

    private TreePath getCustomizePathForLocation(int x, int y) {
        Rectangle pathBounds;
        TreePath closestPath = this.myTree.getClosestPathForLocation(x, y);
        if (closestPath != null && (pathBounds = this.myTree.getPathBounds(closestPath)) != null && x >= pathBounds.x - 50 && x < pathBounds.x + 393 && y >= pathBounds.y && y < pathBounds.y + pathBounds.height) {
            return closestPath;
        }
        return null;
    }

    protected JPopupMenu getTreeContextMenu() {
        return this.myTreeContextMenu;
    }

    private List<RAMLNode> getSiblings(RAMLNode currentNode) {
        ArrayList<RAMLNode> siblings = new ArrayList<RAMLNode>(0);
        RAMLNode parent = (RAMLNode)currentNode.getParent();
        List<RAMLNode> children = parent.getChilds();
        for (RAMLNode child : children) {
            if (!RAMLEditPanel.isSiblings(currentNode, child)) continue;
            siblings.add(child);
        }
        return siblings;
    }

    public static boolean isSiblings(RAMLNode currentNode, RAMLNode targetNode) {
        if (targetNode == null) {
            return false;
        }
        String targetID = targetNode.getId();
        if (!targetID.isEmpty() && !TextUtils.isInteger(targetID)) {
            return false;
        }
        if (currentNode == null || targetNode == null || currentNode.equals(targetNode)) {
            return false;
        }
        String currentName = RAMLEditPanel.getNameWithoutIdentifier(currentNode);
        String targetName = RAMLEditPanel.getNameWithoutIdentifier(targetNode);
        return currentName != null && currentName.equals(targetName);
    }

    public static String getNameWithoutIdentifier(RAMLNode node) {
        int hyphenIndex = node.getName().lastIndexOf("-");
        return node.getName().substring(0, hyphenIndex);
    }

    public void setCreateAction(RAMLUnconfiguredNodeAction createAction) {
        this.myUnconfiguredNodeAction = createAction;
    }

    protected void addPopMenuItems(JPopupMenu popup, boolean isDeletable) {
        if (!this.isUnconfiguredNodeActionNull() && this.myUnconfiguredNodeAction.isNodeNonConfigured(this.myCurrentNode)) {
            this.unconfiguredAddPopMenuItem(popup);
        } else {
            this.configuredAddPopMenuItem(popup, isDeletable);
        }
    }

    private void unconfiguredAddPopMenuItem(JPopupMenu popup) {
        JMenuItem item = new JMenuItem(theBundle.getString("RAMLEdit.Create.Button"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                RAMLEditPanel.this.myUnconfiguredNodeAction.createAction();
            }
        });
        if (!this.isUnconfiguredNodeActionNull() && this.myUnconfiguredNodeAction.isParentMoIdNotConfigured(this.myCurrentNode)) {
            popup.add(item);
        }
    }

    private void configuredAddPopMenuItem(JPopupMenu popup, boolean isDeletable) {
        if (this.myCurrentNode.isCopyable()) {
            JMenuItem copyItem = new JMenuItem(theBundle.getString("RAMLEdit.Copy.Button"));
            copyItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    RAMLEditPanel.this.copyObject();
                }
            });
            copyItem.setToolTipText(this.resizeTooltip(String.valueOf(theBundle.getString("RAMLEdit.Copy.Button")) + " " + this.myCurrentNode.getName()));
            if (!this.isNodeIdEmpty()) {
                popup.add(copyItem);
            }
        }
        if (isDeletable) {
            JMenuItem item = new JMenuItem(theBundle.getString("RAMLEdit.Delete"));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    RAMLEditPanel.this.removesChildObject();
                }
            });
            this.setToolTipText(item, "RAMLEdit.Delete");
            popup.add(item);
        }
    }

    protected boolean isPopupMenuItemForDeleteAllAdded(JPopupMenu popup) {
        if (this.isDeleteAllEnabled()) {
            JMenuItem item = this.createDefaultDeleteAllMenuItem();
            popup.add(item);
            return true;
        }
        return false;
    }

    protected JMenuItem createDefaultDeleteAllMenuItem() {
        JMenuItem item = new JMenuItem(MessageFormat.format(theBundle.getString("RAMLEdit.DeleteAll"), this.myCurrentNode.getName().split("-")[0]));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                RAMLEditPanel.this.removesAllInstancesOfSelectedNode();
            }
        });
        item.setToolTipText(this.resizeTooltip(MessageFormat.format(theBundle.getString("RAMLEdit.DeleteAll_Tooltip"), this.myCurrentNode.getName().split("-")[0], ((RAMLNode)this.myCurrentNode.getParent()).getName())));
        return item;
    }

    protected boolean isDeleteAllEnabled() {
        return this.hasMultipleInstances(this.myCurrentNode) && this.hasZeroMinOccurs(this.myCurrentNode) && this.myCurrentNode.isDeletable();
    }

    private boolean hasZeroMinOccurs(RAMLNode currentNode) {
        if (RAMLEditUtils.isListEntry(currentNode, (RAMLNode)currentNode.getParent())) {
            return false;
        }
        List<RAMLMetaParameter> metaParameters = currentNode.getMetaParameters();
        if (metaParameters.size() != 0) {
            RAMLMetaManagedObject managedObject = metaParameters.get(0).getMetaManagedObject();
            return managedObject.getMinOccurs() == 0;
        }
        return false;
    }

    protected boolean hasMultipleInstances(RAMLNode currentNode) {
        RAMLNode parentNode = (RAMLNode)currentNode.getParent();
        if (currentNode.isList() || parentNode == null) {
            return false;
        }
        List<RAMLNode> mySiblings = parentNode.getChilds();
        for (RAMLNode child : mySiblings) {
            if (!RAMLEditPanel.isSiblings(currentNode, child)) continue;
            return true;
        }
        return false;
    }

    private boolean isSureToDeleteAll(String childName, String parentName) {
        JButton deleteButton = new JButton(theBundle.getString("RAMLEdit.DeleteAll.OptionPane.Delete"));
        deleteButton.setMnemonic(theBundle.getMnemonic("RAMLEdit.DeleteAll.OptionPane.Delete_Mnemonic"));
        deleteButton.setName("RAMLEditDeleteAllConfirm");
        JButton cancelButton = new JButton(theBundle.getString("RAMLEdit.CompareMO.OptionPane.Cancel"));
        cancelButton.setName("RAMLEditDeleteAllCancel");
        Object[] options = new Object[]{deleteButton, cancelButton};
        final JOptionPane optionPane = new JOptionPane(MessageFormat.format(theBundle.getString("RAMLEdit.DeleteAll.OptionPane.Text"), childName, parentName), 3, 0, null, options, options[1]);
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                optionPane.setValue(0);
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                optionPane.setValue(2);
            }
        });
        JDialog dialog = optionPane.createDialog(this, theBundle.getString("RAMLEdit.DeleteAll.OptionPane.Title"));
        dialog.show();
        dialog.dispose();
        return optionPane.getValue() == null ? false : (Integer)optionPane.getValue() == 0;
    }

    public void showBalloon(RAMLNode node, RAMLValidationResult result) {
        JFrame parent = PoseidonRuntime.getRuntime().getService(UserInterface.class).getFrame();
        this.myTreeModel.setSelectedNode(node);
        this.myTree.setSelectionPath(this.myTreeModel.getTreePathToRoot());
        this.myTree.getCellRenderer();
        if (this.myOpenBalloon != null) {
            this.myOpenBalloon.close();
        }
        this.myOpenBalloon = new Balloon((JComponent)((Object)this.myTree.getCellRenderer()), parent, result.getDetails(), result.getText(), 1, 2);
        Rectangle r = this.myTree.getPathBounds(this.myTree.getSelectionPath());
        this.myOpenBalloon.setLocationOffset(new Point(r.x, r.y));
        this.myOpenBalloon.relocateBalloon(this.myTree);
        this.myOpenBalloon.showBalloon();
    }

    public void showBalloon(String pName, RAMLValidationResult result) {
        JFrame parent = PoseidonRuntime.getRuntime().getService(UserInterface.class).getFrame();
        int i = 0;
        while (i < this.myParameterPanel.getComponentCount()) {
            JComponent ab;
            RAMLMetaParameter meta;
            Component c = this.myParameterPanel.getComponent(i);
            if (c instanceof JComponent && ((meta = (RAMLMetaParameter)(ab = (JComponent)c).getClientProperty(PROPERTY_NAME)) != null && pName.equals(meta.getName()) || meta != null && pName.equals(meta.getFullName()))) {
                if (this.myOpenBalloon != null) {
                    this.myOpenBalloon.close();
                }
                this.myOpenBalloon = new Balloon(ab, parent, result.getDetails(), result.getText(), 1, 0);
                this.myOpenBalloon.showBalloon();
                return;
            }
            ++i;
        }
    }

    public void layoutUI(boolean createValidationPanel) {
        this.setLayout(new BorderLayout());
        ExtendedGridBagConstraints mainGc = new ExtendedGridBagConstraints();
        mainGc.setAnchor(23);
        this.myTree.setScrollsOnExpand(false);
        this.myTree.setExpandsSelectedPaths(true);
        CommandBar commandBar = new CommandBar();
        commandBar.add((Component)this.myTreeSearch, (Object)"West");
        this.myLeftPanel.add((Component)commandBar, "North");
        JScrollPane pane = new JScrollPane(this.myTree);
        pane.putClientProperty("OrangeTouch.curvedSheet", true);
        pane.setMinimumSize(new Dimension(this.getTreeWidth(), this.getTreeHight()));
        pane.setPreferredSize(new Dimension(this.getTreeWidth(), this.getTreeHight()));
        pane.setMaximumSize(new Dimension(this.getTreeWidth(), this.getTreeHight()));
        this.myLeftPanel.add((Component)pane, "Center");
        this.layoutButtonPanel();
        PPanel tmpPanel = new PPanel(new BorderLayout());
        tmpPanel.add((Component)this.myLeftPanel, "West");
        JScrollPane scroll = new JScrollPane(this.myParameterPanel);
        scroll.getVerticalScrollBar().setUnitIncrement(27);
        scroll.setViewportBorder(BorderFactory.createEmptyBorder(12, 6, 6, 12));
        tmpPanel.add((Component)scroll, "Center");
        if (createValidationPanel) {
            tmpPanel.setMinimumSize(new Dimension(100, 220));
            this.myValidationPanel.setMinimumSize(new Dimension(100, 100));
            this.myValidationPanel.setPreferredSize(new Dimension(100, 60));
            this.mySplitPane.setLeftComponent(tmpPanel);
            this.mySplitPane.setRightComponent(this.myValidationPanel);
            this.add((Component)this.mySplitPane, "Center");
        } else {
            this.add((Component)tmpPanel, "Center");
        }
    }

    public void showValidationPanel() {
    }

    public void showEditingPanel() {
    }

    public void setSelectedNode(RAMLNode node) {
        this.myTreeModel.setSelectedNode(node);
        this.myTree.setSelectionPath(this.myTreeModel.getTreePathToRoot());
    }

    protected void layoutButtonPanel() {
        PPanel buttonPanel = new PPanel(new GridBagLayout());
        ExtendedGridBagConstraints buttonGc = new ExtendedGridBagConstraints();
        buttonGc.setTopInset(0);
        buttonGc.setLeftInset(0);
        buttonGc.setRightInset(0);
        buttonGc.setBottomInset(0);
        buttonGc.fillHorizontal();
        this.addButtonsToPanel(buttonPanel, buttonGc);
        this.myLeftPanel.add((Component)buttonPanel, "South");
    }

    protected void addButtonsToPanel(PPanel buttonPanel, ExtendedGridBagConstraints buttonGc) {
        buttonPanel.add((Component)this.myNewComponent, buttonGc);
        buttonGc.nextRow();
        buttonPanel.add((Component)this.myDeleteComponent, buttonGc);
        buttonGc.nextRow();
        buttonPanel.add((Component)this.myCopyButton, buttonGc);
        buttonGc.nextRow();
        buttonPanel.add((Component)this.myCopyParaMenuButton, buttonGc);
        buttonGc.nextRow();
        buttonPanel.add((Component)this.myCopyParaToButton, buttonGc);
        buttonGc.nextRow();
        buttonPanel.add((Component)this.myCompareMOMenuButton, buttonGc);
        buttonGc.nextRow();
        buttonPanel.add((Component)this.myCreateButton, buttonGc);
        buttonGc.nextRow();
    }

    protected int getTreeHight() {
        return 100;
    }

    protected void rebuildDeleteComponent() {
        PPanel container = (PPanel)this.myDeleteComponent.getParent();
        GridBagLayout layout = (GridBagLayout)container.getLayout();
        GridBagConstraints constraints = layout.getConstraints(this.myDeleteComponent);
        if (this.isDeleteAllEnabled()) {
            if (this.myDeleteComponent instanceof JButton) {
                container.remove(this.myDeleteComponent);
                this.myDeleteComponent = this.myDeleteMenuButton;
                container.add((Component)this.myDeleteComponent, constraints);
                container.revalidate();
            }
            this.myDeleteMenuButton.initMenuButton();
            this.resetMinimumSize(this.myDeleteMenuButton, 35);
            JMenuItem item = new JMenuItem(String.valueOf(theBundle.getString("RAMLEdit.Delete")) + " " + this.myCurrentNode.getName());
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    RAMLEditPanel.this.removesChildObject();
                }
            });
            this.setToolTipText(item, "RAMLEdit.Delete");
            this.myDeleteMenuButton.getPopupMenu().add(item);
            item = new JMenuItem(MessageFormat.format(theBundle.getString("RAMLEdit.DeleteAll"), this.myCurrentNode.getName().split("-")[0]));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    RAMLEditPanel.this.removesAllInstancesOfSelectedNode();
                }
            });
            item.setToolTipText(this.resizeTooltip(MessageFormat.format(theBundle.getString("RAMLEdit.DeleteAll_Tooltip"), this.myCurrentNode.getName().split("-")[0], ((RAMLNode)this.myCurrentNode.getParent()).getName())));
            this.myDeleteMenuButton.getPopupMenu().add(item);
            this.setToolTipText(this.myDeleteMenuButton, "RAMLEdit.Delete");
        } else {
            if (this.myDeleteComponent instanceof MenuButton) {
                container.remove(this.myDeleteComponent);
                this.myDeleteComponent = this.myDeleteButton;
                container.add((Component)this.myDeleteComponent, constraints);
                container.revalidate();
            }
            String name = this.myCurrentNode.getName();
            this.myDeleteButton.setText(String.valueOf(theBundle.getString("RAMLEdit.Delete")) + " " + name);
            this.myDeleteButton.setClassName(name);
            this.resetMinimumSize(this.myDeleteButton, 35);
            this.setToolTipText(this.myDeleteComponent, "RAMLEdit.Delete");
        }
        if (!this.isUnconfiguredNodeActionNull()) {
            this.myDeleteComponent.setVisible(this.isDeletable() && !this.myUnconfiguredNodeAction.isNodeNonConfigured(this.myCurrentNode));
        } else {
            this.myDeleteComponent.setVisible(this.isDeletable());
        }
    }

    protected boolean isDeletable() {
        return this.myCurrentNode.getParent() != null && this.myCurrentNode.isDeletable();
    }

    protected void rebuildCopyButton() {
        boolean isCopyVisible;
        String name = this.myCurrentNode.getName();
        this.myCopyButton.setText(String.valueOf(theBundle.getString("RAMLEdit.Copy.Button")) + " " + name);
        this.myCopyButton.setClassName(name);
        this.resetMinimumSize(this.myCopyButton, 35);
        this.setToolTipText(this.myCopyButton, "RAMLEdit.Copy.Button");
        boolean bl = isCopyVisible = this.myCurrentNode.getParent() != null && this.myCurrentNode.isCopyable();
        if (!this.isUnconfiguredNodeActionNull()) {
            this.myCopyButton.setVisible(isCopyVisible && !this.myUnconfiguredNodeAction.isNodeNonConfigured(this.myCurrentNode));
        } else {
            this.myCopyButton.setVisible(isCopyVisible);
        }
        this.setMissingIDComponentAttribute(this.myCopyButton, ButtonSource.COPY);
    }

    protected void rebuildCopyDataMenuButton() {
        this.myCopyParaMenuButton.setToolTipText(null);
        this.resetMinimumSize(this.myCopyParaMenuButton, 35);
        if (this.isSelectedNodeSupportedCopyDataFrom()) {
            if (this.hasNodesWithIDGreaterOrEqualThanTwo()) {
                List<RAMLNode> nodes = this.getSameNodesExceptSelected();
                this.myCopyParaMenuButton.initMenuButton();
                for (final RAMLNode node : nodes) {
                    JMenuItem item = new JMenuItem(node.getName());
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            PoseidonRuntime.getRuntime().setRuntimeProperty(RAMLEditPanel.IS_COPIED_FROM_ANOTHER_MO, true);
                            RAMLEditPanel.this.copyMOAndChilds(node, RAMLEditPanel.this.myCurrentNode, true, true);
                            RAMLEditPanel.this.refresh();
                            PoseidonRuntime.getRuntime().setRuntimeProperty(RAMLEditPanel.IS_COPIED_FROM_ANOTHER_MO, false);
                        }
                    });
                    this.myCopyParaMenuButton.getPopupMenu().add(item);
                }
                this.myCopyParaMenuButton.setVisible(!this.isUnconfiguredNodeActionNull() && !this.myUnconfiguredNodeAction.isNodeNonConfigured(this.myCurrentNode));
            } else {
                this.myCopyParaMenuButton.setVisible(false);
            }
        } else {
            this.myCopyParaMenuButton.setVisible(false);
        }
        this.setMissingIDComponentAttribute(this.myCopyParaMenuButton, ButtonSource.COPY);
        this.myCopyParaMenuButton.repaint();
    }

    protected boolean isSelectedNodeSupportedCopyDataFrom() {
        return true;
    }

    private boolean hasNodesWithIDGreaterOrEqualThanTwo() {
        List<RAMLNode> sameNodes = this.myTreeModel.getSiblingNodesHasId(this.myCurrentNode, this.getSelectedNodeName());
        return sameNodes.size() >= 2;
    }

    protected void rebuildCreateButton() {
        String name = this.myCurrentNode.getName();
        this.myCreateButton.setText(String.valueOf(theBundle.getString("RAMLEdit.Create.Button")) + " " + name);
        this.myCreateButton.setClassName(name);
        this.resetMinimumSize(this.myCreateButton, 35);
        this.setToolTipText(this.myCreateButton, "RAMLEdit.Create.Button");
        this.myCreateButton.setVisible(!this.isUnconfiguredNodeActionNull() && this.myUnconfiguredNodeAction.isNodeNonConfigured(this.myCurrentNode));
    }

    protected void rebuildNewComponent() {
        ButtonSource source;
        PPanel container = (PPanel)this.myNewComponent.getParent();
        GridBagLayout layout = (GridBagLayout)container.getLayout();
        GridBagConstraints constraints = layout.getConstraints(this.myNewComponent);
        int size = this.myCurrentNode.getMetaChilds().size();
        if (size == 0) {
            if (this.myNewComponent instanceof MenuButton) {
                container.remove(this.myNewComponent);
                this.myNewComponent = this.myNewButton;
                container.add((Component)this.myNewComponent, constraints);
                container.revalidate();
            }
            this.myNewButton.setText("");
            this.myNewButton.setClassName("");
            this.setToolTipText(this.myNewComponent, "RAMLEdit.New");
            this.myNewComponent.setVisible(false);
            source = ButtonSource.NEW_BUTTON;
        } else if (size == 1) {
            if (this.myNewComponent instanceof MenuButton) {
                container.remove(this.myNewComponent);
                this.myNewComponent = this.myNewButton;
                container.add((Component)this.myNewComponent, constraints);
                container.revalidate();
            }
            List<RAMLCreatable> childs = this.myCurrentNode.getMetaChilds();
            RAMLCreatable child = childs.get(0);
            String name = child.getName();
            this.myNewButton.setText(String.valueOf(theBundle.getString("RAMLEdit.New")) + " " + name);
            this.myNewButton.setClassName(child.getClassIdentifier());
            this.resetMinimumSize(this.myNewButton, 35);
            this.myNewButton.setToolTipText(this.resizeTooltip(String.valueOf(theBundle.getString("RAMLEdit.New")) + " " + child.getFullname()));
            this.myNewComponentVisibilityCheck();
            source = ButtonSource.NEW_BUTTON;
        } else {
            if (this.myNewComponent instanceof JButton) {
                container.remove(this.myNewComponent);
                this.myNewComponent = this.myNewMenuButton;
                container.add((Component)this.myNewComponent, constraints);
                container.revalidate();
            }
            this.myNewMenuButton.initMenuButton();
            this.resetMinimumSize(this.myNewMenuButton, 0);
            this.setToolTipText(this.myNewMenuButton, "RAMLEdit.New");
            List<RAMLCreatable> childs = this.myCurrentNode.getMetaChilds();
            for (final RAMLCreatable child : childs) {
                JMenuItem item = new JMenuItem(child.getName());
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        RAMLEditPanel.this.createActionForNewFunction(child.getClassIdentifier());
                    }
                });
                item.setToolTipText(this.resizeTooltip(child.getDescription()));
                this.myNewMenuButton.getPopupMenu().add(item);
            }
            this.myNewComponentVisibilityCheck();
            source = ButtonSource.NEW_DROPDOWN;
        }
        this.setMissingIDComponentAttribute(this.myNewComponent, source);
    }

    protected void myNewComponentVisibilityCheck() {
        if (!this.isUnconfiguredNodeActionNull()) {
            this.myNewComponent.setVisible(!this.myUnconfiguredNodeAction.isNodeNonConfigured(this.myCurrentNode));
        } else {
            this.myNewComponent.setVisible(true);
        }
    }

    private boolean isUnconfiguredNodeActionNull() {
        return this.myUnconfiguredNodeAction == null;
    }

    private void setMissingIDComponentAttribute(JComponent component, ButtonSource source) {
        String tooltip = this.generateDisabledTooltip(this.myCurrentNode, source);
        if (tooltip == null) {
            return;
        }
        component.setEnabled(!this.isNodeIdEmpty());
        if (this.isNodeIdEmpty()) {
            component.setToolTipText(this.resizeTooltip(tooltip));
        }
    }

    private boolean isNodeIdEmpty() {
        String id = this.myCurrentNode.getId();
        if (this.myCurrentNode.isList()) {
            id = ((RAMLNode)this.myCurrentNode.getParent()).getId();
        } else if (this.myCurrentNode.isListItem()) {
            id = ((RAMLNode)((RAMLNode)this.myCurrentNode.getParent()).getParent()).getId();
        }
        return id.isEmpty();
    }

    protected String generateDisabledTooltip(RAMLNode currentNode, ButtonSource source) {
        return null;
    }

    protected void rebuildCompareMOButton() {
        if (this.hasMultipleInstances(this.myCurrentNode)) {
            this.myCompareMOMenuButton.initMenuButton();
            this.resetMinimumSize(this.myCompareMOMenuButton, 70);
            this.setToolTipText(this.myCompareMOMenuButton, "RAMLEdit.CompareTo");
            this.mySiblingMOs = this.getSiblings(this.myCurrentNode);
            for (final RAMLNode sibling : this.mySiblingMOs) {
                JMenuItem item = new JMenuItem(sibling.getName());
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                new CompareMOHandler((this).RAMLEditPanel.this.myCurrentNode, sibling, (this).RAMLEditPanel.this.myTreeModel);
                                RAMLEditPanel.this.rebuildParametersUI();
                                RAMLEditPanel.this.validateAndNotify();
                            }
                        });
                    }
                });
                this.myCompareMOMenuButton.getPopupMenu().add(item);
            }
            this.myCompareMOMenuButton.setVisible(true);
        } else {
            this.myCompareMOMenuButton.setVisible(false);
        }
        this.myCompareMOMenuButton.repaint();
    }

    private void setToolTipText(JComponent component, String keyword) {
        if (!this.myCurrentNode.isList() && !this.myCurrentNode.isListItem()) {
            component.setToolTipText(this.resizeTooltip(String.valueOf(theBundle.getString(keyword)) + " " + this.myCurrentNode.getMetaParameters().get(0).getMetaManagedObject().getFullName()));
        } else {
            component.setToolTipText(this.resizeTooltip(String.valueOf(theBundle.getString(keyword)) + " " + this.myCurrentNode.getName()));
        }
    }

    public void closeOpenBalloon() {
        if (this.myOpenBalloon != null && this.myOpenBalloon.getHost() != this.myTree) {
            this.myOpenBalloon.close();
        }
    }

    public void updateParameterTitle() {
        String headerPrefix = " " + theBundle.getString("RAMLEdit.Properties");
        this.myParamHeader.setText(String.valueOf(this.myCurrentNode.getName()) + headerPrefix);
    }

    public void setShowVendorSpecificParams(boolean showVendorSpecificParams) {
        this.myShowVendorSpecificParams = showVendorSpecificParams;
    }

    public boolean getShowVendorSpecificParams() {
        return this.myShowVendorSpecificParams;
    }

    public void generateListTable(RAMLNode node, boolean showVendorSpecificParams) {
    }

    protected void rebuildParametersUI() {
        this.clearParametersUI();
        this.updateParameterTitle();
        this.closeOpenBalloon();
        RAMLNode node = this.myCurrentNode;
        if (node.getChilds().size() > 0 && node.isList()) {
            this.generateListTable(node, this.myShowVendorSpecificParams);
            return;
        }
        if (node.getMetaParameters().size() == 0) {
            return;
        }
        ExtendedGridBagConstraints gc = new ExtendedGridBagConstraints();
        this.layoutSortComboBox();
        this.updateParameterTitle();
        this.myParameterPanel.add((Component)this.myParamHeader, "wrap");
        RAMLEditComponentFactory.resetModelChanged();
        RAMLEditComponentFactory.createInstanceParameterComponent(gc, node, this.myParameterPanel, this.myEventHandler, this.getUIGroups(), this.createEditingComponent(node));
        this.addParameters(node, gc);
        if (RAMLEditComponentFactory.isModelChanged()) {
            this.validateAndNotify();
        }
        this.myParameterPanel.add(Box.createGlue());
        this.setTextFieldMinimumSizes(this.myParameterPanel);
        this.myParameterPanel.revalidate();
        this.myParameterPanel.repaint();
    }

    protected void layoutSortComboBox() {
        PPanel pan = new PPanel((LayoutManager)new MigLayout("insets 12 0 0 12"));
        pan.add(PLabel.createSystemText(theBundle.getString("RAMLEdit.Sort.Title")));
        pan.add((Component)this.mySortComboBox, "wrap");
        this.myParameterPanel.add((Component)pan, "wrap");
    }

    protected JComponent createEditingComponent(RAMLNode node) {
        return null;
    }

    protected void clearParametersUI() {
        int i = 0;
        while (i < this.myParameterPanel.getComponentCount()) {
            Component c = this.myParameterPanel.getComponent(i);
            if (c instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)c;
                button.removeFocusListener(this.myEventHandler);
                button.removeActionListener(this.myEventHandler);
                button.putClientProperty(PROPERTY_NAME, null);
                button.putClientProperty(PROPERTY_OWNER, null);
            }
            ++i;
        }
        this.myParameterPanel.removeAll();
    }

    protected void addParameters(RAMLNode node, ExtendedGridBagConstraints gc) {
        RAMLNode parent = (RAMLNode)node.getParent();
        List<RAMLMetaParameter> metaPs = node.getMetaParameters();
        this.sort(metaPs);
        if (this.myMetadataFile == null && metaPs.size() > 0) {
            this.myMetadataFile = metaPs.get(0).getMetaManagedObject().getMetaDataFile();
            this.myPddbBrowserController.init(this.myMetadataFile);
        }
        String title = null;
        for (RAMLMetaParameter metaP : metaPs) {
            String value;
            if (!this.isParameterShowable(node, parent, metaP)) continue;
            title = this.checkForTitle(title, metaP);
            gc.useHeaderInsets();
            RAMLParameter p = node.getParameter(metaP.getName());
            String uiName = this.getParameterUiFullName(metaP);
            String string = value = p == null ? null : p.getValue();
            if (!metaP.hasDMSProperty("DMS latitude") && !metaP.hasDMSProperty("DMS longitude") && (metaP.isUnChangeable() || metaP.getRAMLParentMetadata().map(mP -> mP.isUnChangeable()).orElse(false).booleanValue())) {
                this.addRowForUnchangeableParam(node, metaP, uiName, value);
                continue;
            }
            if (metaP.hasDMSProperty("DMS latitude")) {
                this.addDMSPanelToRow(CoordinatesUtils.getValidCoordinatesValue(p), uiName, metaP, node, "DMS latitude");
                continue;
            }
            if (metaP.hasDMSProperty("DMS longitude")) {
                this.addDMSPanelToRow(CoordinatesUtils.getValidCoordinatesValue(p), uiName, metaP, node, "DMS longitude");
                continue;
            }
            if (metaP.isVendorSpecific() && metaP.isSimpleType() && metaP.getMaxOccurs() == 1) {
                this.addParameterRow(value, uiName, metaP, node);
                continue;
            }
            if (node.isModifiable() && !metaP.isDeleted() && !metaP.isHidden() && !metaP.isInstanceParameter() && metaP.isSimpleType() && metaP.getMaxOccurs() == 1 && !metaP.isLocked() && (metaP.isMandatory() || metaP.isOptional())) {
                this.addParameterRow(value, uiName, metaP, node);
                continue;
            }
            if (metaP.isSetByTheSystem() && metaP.isCopyTargetParameter() && node.isParentMetaDataNeeded(metaP)) {
                RAMLRelatedParameter rp = metaP.getCopySourceParameter();
                if (rp == null) continue;
                this.addParameterRow(value, uiName, node.getMetaParameter(rp.getClassName(), rp.getParamName()), node);
                continue;
            }
            if (metaP.isSetByTheSystem() || metaP.isLocked()) {
                this.addUnmodifiableRow(value == null || value.trim().isEmpty() ? metaP.getCreationType() : value, uiName, node, metaP, this.myParameterPanel);
                continue;
            }
            if (metaP.isSetByTheSystem() || metaP.getMaxOccurs() > 1 && !metaP.getFullName().equals(parent.getName())) continue;
            this.addParameterRow(value, uiName, metaP, node);
        }
        this.createClickableParamTooltips();
    }

    private void addRowForUnchangeableParam(RAMLNode node, RAMLMetaParameter metaP, String uiName, String value) {
        this.addUnmodifiableRow(GeneralUtils.isEmptyString(value) ? "" : value, uiName, node, metaP, this.myParameterPanel);
    }

    private String getParameterUiFullName(RAMLMetaParameter metaP) {
        String name = metaP.getFullName();
        if (metaP.isSimpleType() && metaP.getMaxOccurs() > 1) {
            name = name.replaceAll(" (?i)List(?![\\s\\S]*List)$", "").trim();
        }
        return name;
    }

    private void sort(List<RAMLMetaParameter> metaPs) {
        if (SORTING.ALPHABETICAL.equals((Object)this.mySorting)) {
            Collections.sort(metaPs);
        } else if (SORTING.RELATED.equals((Object)this.mySorting)) {
            Collections.sort(metaPs, this.myRelatedFunctionComparator);
        } else if (SORTING.CREATION.equals((Object)this.mySorting)) {
            Collections.sort(metaPs, this.myCreationPriorityComparator);
        }
    }

    private String checkForTitle(String title, RAMLMetaParameter metaP) {
        List<String> functions;
        String newTitleCandidate;
        String currentTitle = title;
        if (SORTING.RELATED.equals((Object)this.mySorting) && !(newTitleCandidate = (functions = metaP.getRelatedFunctions().getFunctions()).isEmpty() ? "" : functions.get(0)).equals(currentTitle)) {
            currentTitle = newTitleCandidate;
            this.addTitle(currentTitle);
        }
        if (SORTING.CREATION.equals((Object)this.mySorting)) {
            String creationType = metaP.getCreationType();
            if ("mandatory".equals(creationType)) {
                creationType = theBundle.getString("RAMLEdit.Sort.Creation.MandatoryParam");
            } else if ("optional".equals(creationType)) {
                creationType = theBundle.getString("RAMLEdit.Sort.Creation.OptionalParam");
            } else if (creationType.isEmpty()) {
                creationType = theBundle.getString("RAMLEdit.Sort.Creation.OtherParam");
            }
            if (!creationType.equals(currentTitle)) {
                currentTitle = creationType;
                this.addTitle(currentTitle);
            }
        }
        return currentTitle;
    }

    private void addTitle(String title) {
        if (title.length() == 0) {
            this.addTitleRow(theBundle.getString("RAMLEdit.No.Group.Title"));
        } else {
            this.addTitleRow(title);
        }
    }

    public boolean isParameterShowable(RAMLNode node, RAMLNode parent, RAMLMetaParameter metaP) {
        return RAMLEditUtils.isParameterShowable(node, parent, metaP, this.myShowVendorSpecificParams);
    }

    public boolean isValidRAML() {
        return ((RAMLNode)this.myTreeModel.getRoot()).isValid();
    }

    public void addTitleRow(String value) {
        PLabel nameLabel = PLabel.createTitle(value);
        nameLabel.setAutoTooltipEnabled(false);
        this.myParameterPanel.add((Component)nameLabel, "wrap");
    }

    public void addParameterRow(String value, String name, RAMLMetaParameter metaData, RAMLNode selectedNode) {
        PLabel nameLabel = PLabel.createSystemText(String.valueOf(name) + ":");
        nameLabel.setName(metaData.getName());
        nameLabel.setAutoTooltipEnabled(false);
        nameLabel.setToolTipText(null);
        this.myParameterPanel.add(nameLabel);
        this.addValueField(value, metaData, selectedNode);
        this.myLabels.add(nameLabel);
        this.myMetaDataForLabels.add(metaData);
    }

    public void addDMSPanelToRow(String value, String name, RAMLMetaParameter metaData, RAMLNode selectedNode, String property) {
        PLabel nameLabel = PLabel.createSystemText(String.valueOf(name) + ":");
        nameLabel.setName(metaData.getName());
        nameLabel.setAutoTooltipEnabled(false);
        nameLabel.setToolTipText(null);
        this.myParameterPanel.add(nameLabel);
        if (metaData.isUnModifiable()) {
            if (value == null || value.trim().isEmpty()) {
                this.addUnmodifiableValueField(metaData.getCreationType(), selectedNode, metaData, this.myParameterPanel);
            } else {
                this.addUnmodifiableDMSComponents(value, metaData, selectedNode, property);
            }
        } else if (metaData.isUnChangeable()) {
            this.addUnmodifiableValueField(value, selectedNode, metaData, this.myParameterPanel);
        } else {
            this.addDMSComponents(value, metaData, selectedNode, property);
        }
        this.myLabels.add(nameLabel);
        this.myMetaDataForLabels.add(metaData);
    }

    protected void addValueField(String value, RAMLMetaParameter metaData, RAMLNode selectedNode) {
        RAMLEditComponentFactory.createSimpleTypeComponent(value, metaData, selectedNode, this.myParameterPanel, this.myEventHandler, this.getUIGroups(), true);
    }

    protected void addDMSComponents(String value, RAMLMetaParameter metaData, RAMLNode selectedNode, String property) {
        RAMLEditComponentFactory.createCoordinatesComponent(value, metaData, selectedNode, this.myEventHandler, this.myParameterPanel, property);
    }

    protected void addUnmodifiableDMSComponents(String value, RAMLMetaParameter metaP, RAMLNode selectedNode, String property) {
        RAMLEditComponentFactory.createUnmodifiableCoordinatesComponent(value, metaP, selectedNode, this.myParameterPanel, property);
    }

    public void addUnmodifiableRow(String value, String name, RAMLNode parameterOwner, RAMLMetaParameter metaData, PPanel target) {
        PLabel label = PLabel.createSystemText(String.valueOf(name) + ":");
        label.setName(metaData.getName());
        label.setAutoTooltipEnabled(false);
        label.setToolTipText(null);
        target.add(label);
        this.addUnmodifiableValueField(value, parameterOwner, metaData, target);
        this.myLabels.add(label);
        this.myMetaDataForLabels.add(metaData);
    }

    protected void addUnmodifiableValueField(String value, RAMLNode parameterOwner, RAMLMetaParameter metaData, PPanel target) {
        RAMLEditComponentFactory.createUnmodifiableComponent(value, metaData, target, this.myCurrentNode);
    }

    protected void createChildObject(String className) {
        PoseidonRuntime.getRuntime().setRuntimeProperty(DEFAULT_VALUE_NEEDED_IN_PARAMETER_CREATION, true);
        this.myTreeModel.addChildToSelectedNode(className);
        this.setParameterValueNoGUISupportEnabled(this.myTreeModel.getSelectedRAMLNode());
        PoseidonRuntime.getRuntime().setRuntimeProperty(DEFAULT_VALUE_NEEDED_IN_PARAMETER_CREATION, false);
        this.fireActionPerfomed(new ActionEvent(this, 1, COMMAND_REVALIDATE));
        Runnable run = new Runnable(){

            @Override
            public void run() {
                RAMLEditPanel.this.validateAndNotify();
            }
        };
        SwingUtilities.invokeLater(run);
    }

    private void copyObject() {
        RAMLNode parent = (RAMLNode)this.myCurrentNode.getParent();
        RAMLNode node = this.myCurrentNode.copyInto(parent);
        this.myTreeModel.informChildNodeAddition(parent, node);
        this.setSelectedNode(node);
        this.notifyValidationStarted();
        this.myValidationTimer.restart();
    }

    private void copyNodes(RAMLNode source, RAMLNode target, boolean isCopyChildMOs, boolean isCopyChildLists) {
        for (RAMLNode child : this.getChildren(source, isCopyChildMOs, isCopyChildLists)) {
            if (this.isChildMOSupportAddAndDelete(child)) {
                RAMLNode targetChild = child.copyInto(target);
                if (targetChild == null) continue;
                this.myTreeModel.informChildNodeAddition(target, targetChild);
                continue;
            }
            RAMLNode targetChildNode = RAMLEditUtils.getChildRAMLNode(target, child.getName());
            if (targetChildNode == null) continue;
            this.copyMOAndChilds(child, targetChildNode, isCopyChildMOs, isCopyChildLists);
        }
    }

    protected void setTextFieldMinimumSizes(PPanel panel) {
        Component someComponent;
        Component[] comps = panel.getComponents();
        int maxWidth = -1;
        int i = 0;
        while (i < comps.length) {
            someComponent = comps[i];
            if (someComponent instanceof PTextField && someComponent.getPreferredSize().width > maxWidth) {
                maxWidth = someComponent.getPreferredSize().width;
            }
            ++i;
        }
        if (maxWidth > 0) {
            i = 0;
            while (i < comps.length) {
                someComponent = comps[i];
                if (someComponent instanceof PTextField) {
                    someComponent.setMinimumSize(new Dimension(maxWidth, someComponent.getPreferredSize().height));
                }
                ++i;
            }
        }
    }

    protected void rebuildCopyDataToButton() {
        this.myCopyParaToButton.setToolTipText(null);
        this.resetMinimumSize(this.myCopyParaToButton, 35);
        if (this.isSelectedNodeSupportedCopyDataTo()) {
            this.myCopyParaToButton.setVisible(this.hasNodesWithIDGreaterOrEqualThanTwo());
        } else {
            this.myCopyParaToButton.setVisible(false);
        }
        this.setMissingIDComponentAttribute(this.myCopyParaToButton, ButtonSource.COPY);
        this.myCopyParaToButton.repaint();
    }

    protected String getSelectedNodeName() {
        String selectedNodeName = this.myCurrentNode.getName();
        if (selectedNodeName.indexOf("-") > 0) {
            return selectedNodeName.substring(0, selectedNodeName.indexOf("-"));
        }
        return selectedNodeName;
    }

    protected boolean isSelectedNodeSupportedCopyDataTo() {
        return false;
    }

    public void copySelectedNodeTo(List<String> selectedNodeList, boolean isCopyChildMOs, boolean isCopyChildLists) {
        List<RAMLNode> nodes = this.getSameNodesExceptSelected();
        RAMLNode node = null;
        for (String name : selectedNodeList) {
            node = this.getRamlNode(name, nodes);
            if (node == null) continue;
            this.copyMOAndChilds(this.myCurrentNode, node, isCopyChildMOs, isCopyChildLists);
        }
        if (node != null && this.getChildren(this.myCurrentNode, isCopyChildMOs, isCopyChildLists).isEmpty()) {
            this.setSelectedNode(node);
        }
        this.refresh();
    }

    public void copyMOAndChilds(RAMLNode srcNode, RAMLNode targetNode, boolean isCopyChildMOs, boolean isCopyChildLists) {
        this.removesChildren(targetNode, isCopyChildMOs, isCopyChildLists);
        this.copyNodes(srcNode, targetNode, isCopyChildMOs, isCopyChildLists);
        targetNode.copyPara(srcNode);
    }

    protected boolean isChildMOSupportAddAndDelete(RAMLNode node) {
        return true;
    }

    private RAMLNode getRamlNode(String name, List<RAMLNode> nodes) {
        for (RAMLNode node : nodes) {
            if (!node.getName().equals(name)) continue;
            return node;
        }
        return null;
    }

    public List<RAMLNode> getSameNodesExceptSelected() {
        List<RAMLNode> sameNodes = this.myTreeModel.getSiblingNodesHasId(this.myCurrentNode, this.getSelectedNodeName());
        sameNodes.remove(this.myCurrentNode);
        return sameNodes;
    }

    protected void removesChildObject() {
        this.myTreeModel.removeSelectedNode();
        this.fireActionPerfomed(new ActionEvent(this, 1, COMMAND_REVALIDATE));
        this.validateAndNotify();
    }

    protected void removesAllInstancesOfSelectedNode() {
        String parentName;
        String childName = this.myTreeModel.getMOClassName(this.myCurrentNode);
        if (this.isSureToDeleteAll(childName, parentName = ((RAMLNode)this.myCurrentNode.getParent()).getName())) {
            this.myTreeModel.removeAllInstancesOfSelectedNode();
            this.fireActionPerfomed(new ActionEvent(this, 1, COMMAND_REVALIDATE));
            this.validateAndNotify();
        }
    }

    private void removesChildren(RAMLNode node, boolean isCopyChildMOs, boolean isCopyChildLists) {
        for (RAMLNode child : this.getChildren(node, isCopyChildMOs, isCopyChildLists)) {
            if (!this.isChildMOSupportAddAndDelete(child)) continue;
            node.removeChild(child);
            this.myTreeModel.informChildNodeRemoval(node, child);
            this.myTreeModel.fireChildRemoved(child);
        }
    }

    private List<RAMLNode> getChildren(RAMLNode node, boolean isCopyChildMOs, boolean isCopyChildLists) {
        if (isCopyChildMOs && isCopyChildLists) {
            return node.getChilds();
        }
        if (isCopyChildMOs) {
            ArrayList<RAMLNode> ramlNodes = new ArrayList<RAMLNode>();
            for (RAMLNode child : node.getChilds()) {
                if (child.isList()) continue;
                ramlNodes.add(child);
            }
            return ramlNodes;
        }
        if (isCopyChildLists) {
            ArrayList<RAMLNode> ramlNodes = new ArrayList<RAMLNode>();
            for (RAMLNode child : node.getChilds()) {
                if (!child.isList()) continue;
                ramlNodes.add(child);
            }
            return ramlNodes;
        }
        return new ArrayList<RAMLNode>();
    }

    @Override
    public void selectionChanged(RAMLNode selectedNode) {
        this.rebuildUI();
    }

    protected void rebuildUI() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RAMLEditPanel.this.myCurrentNode = RAMLEditPanel.this.myTreeModel.getSelectedRAMLNode();
                RAMLEditPanel.this.rebuildButtons();
                RAMLEditPanel.this.rebuildCompareMOButton();
                RAMLEditPanel.this.rebuildParametersUI();
                RAMLEditPanel.this.rebuildCreateButton();
                RAMLEditPanel.this.myLeftPanel.revalidate();
                RAMLEditPanel.this.myLeftPanel.repaint();
                RAMLEditPanel.this.myParameterPanel.revalidate();
                RAMLEditPanel.this.myParameterPanel.repaint();
                RAMLEditPanel.this.resizeButtonComponents();
                RAMLEditPanel.this.fireActionPerfomed(new ActionEvent(this, 1, RAMLEditPanel.COMMAND_REVALIDATE));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        (this).RAMLEditPanel.this.myTree.scrollPathToVisible((this).RAMLEditPanel.this.myTreeModel.getTreePathToRoot());
                        RAMLEditPanel.this.fireActionPerfomed(new ActionEvent(this, 4, RAMLEditPanel.COMMAND_PARAMETERS_VISIBLE));
                    }
                });
            }
        });
    }

    protected void createActionForNewFunction(String nodeName) {
        this.createChildObject(nodeName);
    }

    public void reloadParameterPanelValue() {
        RAMLNode node = this.myCurrentNode;
        if (node.getMetaParameters().size() == 0) {
            return;
        }
        int i = 0;
        while (i < this.myParameterPanel.getComponentCount()) {
            JComponent jComponent;
            RAMLMetaParameter metaP;
            Component component = this.myParameterPanel.getComponent(i);
            if (component instanceof JComponent && (metaP = (RAMLMetaParameter)(jComponent = (JComponent)component).getClientProperty(PROPERTY_NAME)) != null && metaP.isSetByTheSystem()) {
                RAMLParameter ramlParameter = node.getParameter(metaP.getName());
                this.updateParameterValueInUI(ramlParameter, jComponent);
            }
            ++i;
        }
    }

    private void updateParameterValueInUI(final RAMLParameter ramlParameter, final JComponent jComponent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ramlParameter != null) {
                    if (jComponent instanceof JTextComponent) {
                        JTextComponent valueField = (JTextComponent)jComponent;
                        valueField.setText(ramlParameter.getValue());
                    } else if (jComponent instanceof JLabel) {
                        JLabel valueField = (JLabel)jComponent;
                        valueField.setText(ramlParameter.getValue());
                    }
                }
            }
        });
    }

    @Override
    public void childAdded(RAMLNode child) {
        RAMLTreeModel model = (RAMLTreeModel)this.myTree.getModel();
        this.myTree.setSelectionPath(model.getTreePathToRoot());
    }

    @Override
    public void childRemoved(RAMLNode child) {
        RAMLTreeModel model = (RAMLTreeModel)this.myTree.getModel();
        this.myTree.setSelectionPath(model.getTreePathToRoot());
    }

    public void highlightResult(final RAMLValidationResult result, final boolean isFocused) {
        this.selectHighlightedParameterNodeFromTree(result);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String paramName = result.getParameterName();
                List<String> paramNameList = result.getAllInvalidParamNames();
                if (paramName != null && !"".equals(paramName)) {
                    RAMLEditPanel.this.highlightParameterInEditPanel(paramName, isFocused);
                } else if (paramNameList != null && paramNameList.size() > 0) {
                    RAMLEditPanel.this.highlightParameterInEditPanel(paramNameList.get(0), isFocused);
                } else {
                    RAMLEditPanel.this.highlightParameterInEditPanel("", isFocused);
                }
            }
        });
    }

    protected TreePath findPathToResult(RAMLValidationResult result) {
        if (this.myTreeModel != null) {
            return this.findPathToResultRecursively(this.myTreeModel.getRoot(), result);
        }
        return null;
    }

    protected boolean isParentNode(RAMLNode node, RAMLValidationResult result) {
        return false;
    }

    protected TreePath findPathToResultRecursively(Object parent, RAMLValidationResult result) {
        if (!(parent instanceof RAMLNode)) {
            return null;
        }
        for (RAMLNode child : ((RAMLNode)parent).getChilds()) {
            TreePath path = this.getChildTreePath(result, child);
            if (path != null) {
                return path;
            }
            if (child.getChilds().isEmpty() || (path = this.findPathToResultRecursively(child, result)) == null) continue;
            return path;
        }
        return this.getChildTreePath(result, this.myTreeModel.getRoot());
    }

    protected TreePath getChildTreePath(RAMLValidationResult result, Object node) {
        if (node instanceof RAMLNode) {
            RAMLNode ramlNode = (RAMLNode)node;
            Object source = result.getSource();
            int sourceIndex = result.getSourceIndex();
            if (source != null && this.isParentNode(ramlNode, result)) {
                if (source instanceof RAMLParameterList && sourceIndex >= 0 && ramlNode.getChilds().size() > sourceIndex) {
                    ramlNode = ramlNode.getChilds().get(sourceIndex);
                }
                return this.myTreeModel.getTreePathToRoot(ramlNode);
            }
        }
        return null;
    }

    private void selectHighlightedParameterNodeFromTree(RAMLValidationResult result) {
        TreePath path = this.findPathToResult(result);
        if (path != null) {
            this.myTree.setSelectionPath(path);
            this.myTree.scrollPathToVisible(path);
        }
    }

    private void refresh() {
        this.rebuildParametersUI();
        this.myParameterPanel.repaint();
        this.fireActionPerfomed(new ActionEvent(this, 1, COMMAND_REVALIDATE));
        this.myValidationTimer.restart();
    }

    public void highlightParameterInEditPanel(String parameterName, boolean isFocused) {
        this.clearHighlightedComponent();
        JComponent previousComponent = null;
        Component[] componentArray = this.myParameterPanel.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component comp = componentArray[n2];
            if (comp instanceof JComponent) {
                JComponent jComp = (JComponent)comp;
                RAMLMetaParameter meta = (RAMLMetaParameter)jComp.getClientProperty(PROPERTY_NAME);
                if (parameterName != null && meta != null && parameterName.equalsIgnoreCase(meta.getName())) {
                    this.myHighlightedComponent = previousComponent;
                    if (this.myHighlightedComponent instanceof JLabel) {
                        this.myHighlightedComponent.setOpaque(true);
                        this.myHighlightedComponent.setBackground(UIManager.getColor("TextField.selectionBackground"));
                        this.myHighlightedComponent.setForeground(UIManager.getColor("TextField.selectionForeground"));
                        Rectangle bounds = this.getViewportBounds(this.myHighlightedComponent, 0);
                        this.myHighlightedComponent.scrollRectToVisible(bounds);
                        this.myHighlightedComponent.scrollRectToVisible(bounds);
                        if (isFocused) {
                            Rectangle componentBounds = this.getViewportBounds(this.myHighlightedComponent, this.myHighlightedComponent.getWidth());
                            this.myHighlightedComponent.scrollRectToVisible(componentBounds);
                            if (jComp.getClientProperty("DMS") != null && jComp.getComponentCount() > 0) {
                                JComponent firstCompInPanel = (JComponent)jComp.getComponent(0);
                                firstCompInPanel.requestFocusInWindow();
                            } else {
                                jComp.requestFocusInWindow();
                            }
                        }
                        return;
                    }
                }
                previousComponent = jComp;
            }
            ++n2;
        }
    }

    protected Rectangle getViewportBounds(JComponent jComp, int x) {
        Rectangle bounds = SwingUtilities.getLocalBounds(jComp);
        JViewport viewport = (JViewport)SwingUtilities.getAncestorOfClass(JViewport.class, jComp);
        if (viewport != null) {
            bounds.x = x;
            bounds.y -= viewport.getExtentSize().height / 2;
            bounds.height += viewport.getExtentSize().height;
        }
        return bounds;
    }

    public void clearHighlightedComponent() {
        if (this.myHighlightedComponent != null) {
            this.myHighlightedComponent.setOpaque(false);
            this.myHighlightedComponent.setBackground(null);
            this.myHighlightedComponent.setForeground(UIManager.getColor("Label.foreground"));
            this.myHighlightedComponent = null;
        }
    }

    protected String resizeTooltip(String description) {
        if (description != null) {
            StringBuilder tooltipBuilder = new StringBuilder();
            tooltipBuilder.append("<HTML>");
            tooltipBuilder.append(TextUtils.textWrap(description, "<BR>", RAMLEditComponentFactory.adjustTooltipSize(description.length())));
            tooltipBuilder.append("</HTML>");
            return tooltipBuilder.toString();
        }
        return null;
    }

    public void hidePddbBrowser() {
        this.myPddbBrowserController.disposeView();
    }

    protected void createTreeInfoTipProvider() {
        new RAMLInfoTipProvider(this.myTree);
    }

    private void createClickableParamTooltips() {
        Iterator<RAMLMetaParameter> itr2 = this.myMetaDataForLabels.iterator();
        for (PLabel label : this.myLabels) {
            RAMLMetaParameter meta = itr2.next();
            RAMLDescription desc = meta.getShortDescription();
            String descString = desc == null ? null : desc.getDescription();
            RamlInfoTip nameLabelTip = new RamlInfoTip(label, meta.getName(), descString, RAMLEditComponentFactory.generateDistName(meta));
            nameLabelTip.setShowDelay(500);
            nameLabelTip.setTipContentActive(true);
            nameLabelTip.setDismissOnTooltipPress(true);
        }
        this.myMetaDataForLabels.clear();
        this.myLabels.clear();
    }

    protected void createSearchBar() {
        this.myTreeSearch = new TreeSearchBar(this.myTree);
    }

    public PPanel getParameterPanel() {
        return this.myParameterPanel;
    }

    public RAMLTreeModel getTreeModel() {
        return this.myTreeModel;
    }

    protected void resetMinimumSize(JButton button, int shift) {
        FontMetrics fontMetrics = button.getFontMetrics(button.getFont());
        int stringSize = SwingUtilities.computeStringWidth(fontMetrics, button.getText());
        button.setMinimumSize(new Dimension(stringSize + ScaleUtils.scale(shift), 28));
    }

    protected static enum ButtonSource {
        NEW_BUTTON,
        NEW_DROPDOWN,
        COPY,
        CREATE;

    }

    protected class CommonTreeCellRenderer
    extends PDefaultTreeCellRenderer {
        private static final long serialVersionUID = -5122480065180387315L;
        protected JLabel label;
        protected RAMLNode node;

        protected CommonTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean focus) {
            Component c = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, this.hasFocus);
            this.label = (JLabel)c;
            this.node = (RAMLNode)value;
            this.label.setName(this.node.getName());
            this.label.setToolTipText(null);
            Boolean isValid = RAMLEditPanel.this.myRAMLNodeValidity.get(this.node);
            if (isValid != null) {
                this.label.setIcon(isValid != false ? PLACEHOLDER_ICON : WARNING_ICON);
            } else {
                this.label.setIcon(PLACEHOLDER_ICON);
            }
            return this.label;
        }
    }

    protected class RAMLInfoTipProvider
    extends MouseAdapter
    implements ActionListener,
    HierarchyListener,
    TreeExpansionListener {
        protected InfoTip myInfoTip;
        private JTree myHostTree;
        private Object myCurrentPathComp;
        private Timer myAutoShowTimer;
        private Timer myDismissTimer;
        private int myXPos;
        private int myYPos;
        private Point mousePoint;

        public RAMLInfoTipProvider(JTree tree) {
            this.myHostTree = tree;
            this.myInfoTip = new InfoTip((Component)this.myHostTree, PLabel.createTipText(""));
            this.myInfoTip.setTipContentActive(true);
            this.myInfoTip.setDismissOnTooltipPress(true);
            this.myInfoTip.setDisplayStrategy(3);
            this.myAutoShowTimer = new Timer(500, this);
            this.myAutoShowTimer.setRepeats(false);
            this.myDismissTimer = new Timer(100, this);
            this.myDismissTimer.setRepeats(false);
            tree.addMouseListener(this);
            tree.addMouseMotionListener(this);
            tree.addHierarchyListener(this);
            tree.addTreeExpansionListener(this);
            this.myInfoTip.addMouseListener(this);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.hideInfoTip();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.mousePoint = e.getPoint();
            this.setInfoTipVisibilityBasedFromCurrentMousePoint(this.mousePoint);
        }

        private void hideInfoTip() {
            this.myAutoShowTimer.stop();
            this.myDismissTimer.restart();
            this.myInfoTip.setVisible(false);
        }

        protected void setTipContent(Object comp) {
            JComponent oldTip = this.myInfoTip.getTipContent();
            if (oldTip instanceof JEditorPane) {
                JEditorPane oldEditor = (JEditorPane)oldTip;
                HyperlinkListener[] listeners = oldEditor.getHyperlinkListeners();
                int i = 0;
                while (listeners != null && i < listeners.length) {
                    oldEditor.removeHyperlinkListener(listeners[i]);
                    ++i;
                }
            }
            RAMLNode node = (RAMLNode)comp;
            String name = node.getName();
            String desc = node.getDescription();
            if (name.contains("-")) {
                name = name.split("-")[0];
            }
            JEditorPane tip = RAMLEditComponentFactory.createClickableToolTip(name, desc, name);
            tip.addHyperlinkListener(RAMLEditPanel.this.myPddbBrowserController);
            this.myInfoTip.setTipContent(tip);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.myHostTree.isShowing() && e.getSource() == this.myAutoShowTimer && (RAMLEditPanel.this.myTreeContextMenu == null || !RAMLEditPanel.this.myTreeContextMenu.isVisible())) {
                this.myInfoTip.show(this.myHostTree, this.myXPos + 10, this.myYPos);
            } else if (e.getSource() == this.myDismissTimer) {
                this.myInfoTip.setVisible(false);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.myAutoShowTimer.stop();
            boolean isTreeInvoker = e.getSource().equals(this.myHostTree);
            if (isTreeInvoker && !this.myHostTree.contains(e.getPoint())) {
                this.hideInfoTip();
            } else if (!isTreeInvoker && !this.myInfoTip.contains(e.getPoint())) {
                TreePath path = this.myHostTree.getPathForLocation(e.getX(), e.getY());
                if (path != null && this.myCurrentPathComp != null) {
                    Object pathObject = path.getLastPathComponent();
                    if (!pathObject.equals(this.myCurrentPathComp)) {
                        this.hideInfoTip();
                    }
                } else {
                    this.hideInfoTip();
                }
            }
        }

        private void setInfoTipVisibilityBasedFromCurrentMousePoint(Point point) {
            if (point == null) {
                return;
            }
            int x = (int)point.getX();
            int y = (int)point.getY();
            if (x == -1 || y == -1) {
                return;
            }
            if (!this.myHostTree.contains(point)) {
                this.hideInfoTip();
                return;
            }
            TreePath path = this.myHostTree.getPathForLocation(x, y);
            if (path != null) {
                Object pathComp = path.getLastPathComponent();
                if (!pathComp.equals(this.myCurrentPathComp)) {
                    this.myAutoShowTimer.restart();
                    this.myInfoTip.setVisible(false);
                    this.myCurrentPathComp = pathComp;
                    this.setTipContent(this.myCurrentPathComp);
                }
                this.myXPos = x;
                this.myYPos = y;
            } else {
                this.myCurrentPathComp = null;
                this.hideInfoTip();
            }
        }

        @Override
        public void treeExpanded(TreeExpansionEvent event) {
            this.setInfoTipVisibilityBasedFromCurrentMousePoint(this.mousePoint);
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent event) {
            this.setInfoTipVisibilityBasedFromCurrentMousePoint(this.mousePoint);
        }

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            if ((e.getChangeFlags() & 4L) == 4L) {
                this.hideInfoTip();
            }
        }
    }

    static class RAMLNodeComboItemObj {
        private RAMLNode myRamlNode;

        public RAMLNodeComboItemObj(RAMLNode ramlNode) {
            this.myRamlNode = ramlNode;
        }

        public String toString() {
            return this.myRamlNode.getName();
        }

        public RAMLNode getRamlNode() {
            return this.myRamlNode;
        }
    }

    private class RAMLTree
    extends JTree {
        public RAMLTree(RAMLTreeModel myTreeModel) {
            super(myTreeModel);
        }

        @Override
        public void updateUI() {
            this.setUI(new RAMLTreeUI());
        }
    }

    private static class RelatedFunctionComparator
    implements Comparator {
        private RelatedFunctionComparator() {
        }

        public int compare(Object o1, Object o2) {
            RAMLMetaParameter compared1 = (RAMLMetaParameter)o1;
            RAMLMetaParameter compared2 = (RAMLMetaParameter)o2;
            List<String> params1 = compared1.getRelatedFunctions().getFunctions();
            List<String> params2 = compared2.getRelatedFunctions().getFunctions();
            if (params1.isEmpty() && params2.isEmpty()) {
                return compared1.compareTo(compared2);
            }
            if (params2.isEmpty()) {
                return -1;
            }
            if (params1.isEmpty()) {
                return 1;
            }
            return params1.get(0).compareTo(params2.get(0));
        }
    }

    protected static enum SORTING {
        ALPHABETICAL,
        RELATED,
        CREATION;

    }
}

