/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.raml.edit;

import com.nokia.em.poseidon.frameworks.raml.RAMLParameter;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLMetaParameter;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLDecimal;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLInteger;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLSimpleType;
import com.nokia.em.poseidon.gui.raml.edit.RAMLEditComponentFactory;
import com.nokia.em.poseidon.gui.raml.edit.RAMLNode;
import com.nokia.widgets.util.SystemUtils;

public class RAMLEditUtils {
    public static String getDecimalRange(RAMLSimpleType paramType) {
        String label = ((RAMLDecimal)paramType).getUnitType();
        Double min = (Double)((RAMLDecimal)paramType).getMinValue();
        Double max = (Double)((RAMLDecimal)paramType).getMaxValue();
        Double step = (Double)((RAMLDecimal)paramType).getStep();
        int digits = ((RAMLDecimal)paramType).getDigits();
        return String.valueOf(label) + " " + RAMLEditComponentFactory.createRangeText((RAMLDecimal)paramType, min, max, step != null && !SystemUtils.isEqual(min + step, max) ? Double.valueOf(min + step) : null, digits);
    }

    public static String getIntegerRange(RAMLSimpleType paramType) {
        String label = ((RAMLInteger)paramType).getUnitType();
        Integer min = (Integer)((RAMLInteger)paramType).getMinValue();
        Integer max = (Integer)((RAMLInteger)paramType).getMaxValue();
        Integer step = (Integer)((RAMLInteger)paramType).getStep();
        return String.valueOf(label) + " " + RAMLEditComponentFactory.createRangeText((RAMLInteger)paramType, min, max, step != null && !SystemUtils.isEqual(min + step, max.intValue()) ? Integer.valueOf(min + step) : null);
    }

    public static boolean isParameterShowable(RAMLNode node, RAMLNode parent, RAMLMetaParameter metaP, boolean isVendorSpecific) {
        boolean validValueType;
        if (isVendorSpecific) {
            return metaP.isVendorSpecific() && metaP.isHidden() && !metaP.isDeleted();
        }
        boolean bl = validValueType = metaP.isSimpleType() && (metaP.getMaxOccurs() == 1 || RAMLEditUtils.isListEntry(node, parent));
        return !metaP.isDeleted() && !metaP.isInstanceParameter() && !metaP.isHidden() && validValueType && (node.getParameter(metaP.getName()) != null || !metaP.isLocked()) && metaP.isVisibleInGUI();
    }

    public static boolean isListEntry(RAMLNode node, RAMLNode parent) {
        return node.isList() || parent != null && parent.isList() && node.getMetaChilds().size() == 0;
    }

    public static RAMLNode getChildRAMLNode(RAMLNode parentNode, String childName) {
        for (RAMLNode node : parentNode.getChilds()) {
            if (!node.getName().equals(childName)) continue;
            return node;
        }
        return null;
    }

    public static String getParameterFullname(RAMLParameter param) {
        if (param != null && param.getMetaData() != null) {
            return param.getMetaData().getFullName();
        }
        return "";
    }
}

