/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.raml.edit;

import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.gui.raml.edit.RAMLNode;
import com.nokia.em.poseidon.gui.raml.edit.RAMLNodeAdapter;
import com.nokia.em.poseidon.gui.raml.edit.RAMLTreeListener;
import com.nokia.widgets.tree.ParentNodeResolver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class RAMLTreeModel
implements TreeModel,
TreeSelectionListener,
ParentNodeResolver {
    private static final int INVALID_INDEX = -1;
    private static final int NODE_OFFSET = 1;
    private List<TreeModelListener> myListeners;
    private List<RAMLTreeListener> myRamlListeners;
    private RAMLNode myRoot;
    protected RAMLNode mySelectedNode;

    public RAMLTreeModel() {
        this.myRoot = new RAMLNodeAdapter(){

            @Override
            public String getName() {
                return I18n.getI18n().getBundle(this.getClass()).getString("RAMLEdit.Empty.Root");
            }
        };
        this.myListeners = new ArrayList<TreeModelListener>();
        this.myRamlListeners = new ArrayList<RAMLTreeListener>();
        this.mySelectedNode = this.myRoot;
    }

    public RAMLTreeModel(RAMLNode root) {
        this.myRoot = root;
        this.myListeners = new ArrayList<TreeModelListener>();
        this.myRamlListeners = new ArrayList<RAMLTreeListener>();
        this.mySelectedNode = root;
    }

    public void setRoot(RAMLNode root) {
        if (root == null) {
            this.clearModel();
        } else {
            this.mySelectedNode = this.myRoot = root;
            this.fireTreeStructureChanged(this.mySelectedNode);
        }
    }

    public void clearModel() {
        this.mySelectedNode = this.myRoot = new RAMLNodeAdapter(){

            @Override
            public String getName() {
                return I18n.getI18n().getBundle(this.getClass()).getString("RAMLEdit.Empty.Root");
            }
        };
        this.fireTreeStructureChanged(this.mySelectedNode);
        this.fireSelectionChanged(this.mySelectedNode);
    }

    public void addChildToSelectedNode(String className) {
        if (this.mySelectedNode != null) {
            RAMLNode child = this.mySelectedNode.createChild(className, true);
            List<RAMLNode> children = child.getChilds();
            this.mySelectedNode = child.isList() && children != null && children.size() == 1 ? children.get(0) : child;
            this.informChildNodeAddition(this.mySelectedNode, child);
        }
    }

    public void addChildToSelectedNode(String className, boolean reselect) {
        this.addChildToSelectedNode(this.mySelectedNode, className, true, reselect);
    }

    public void addChildToSelectedNode(RAMLNode pNode, String className, boolean modifiable, boolean reselect) {
        if (pNode != null) {
            RAMLNode cNode = pNode.createChild(className, modifiable);
            if (this.mySelectedNode.equals(pNode) && !this.mySelectedNode.isList() && reselect) {
                this.mySelectedNode = cNode;
            }
            this.informChildNodeAddition(pNode, cNode);
        }
    }

    public void informChildNodeAddition(RAMLNode child) {
        this.mySelectedNode = child;
        this.informChildNodeAddition(this.mySelectedNode, child);
    }

    public void informChildNodeAddition(RAMLNode parent, RAMLNode child) {
        this.fireTreeStructureChanged(parent);
        this.fireChildAdded(child);
    }

    public void informChildNodeAdditionFromTable(RAMLNode child) {
        this.fireTreeStructureChanged(this.mySelectedNode);
        if (child != null) {
            this.fireChildAdded(child);
        }
    }

    public void informChildNodeRemoval(RAMLNode child) {
        this.mySelectedNode = child;
        this.informChildNodeRemovalWithoutReselecting(child);
    }

    public void informChildNodeRemovalWithoutReselecting(RAMLNode child) {
        this.informChildNodeRemoval(this.mySelectedNode, child);
    }

    public void informChildNodeRemoval(RAMLNode parent, RAMLNode child) {
        this.fireTreeStructureChanged(parent);
        this.fireChildRemoved(child);
    }

    public void removeSelectedNode() {
        if (this.mySelectedNode != null && !this.myRoot.equals(this.mySelectedNode)) {
            RAMLNode parentNode = (RAMLNode)this.mySelectedNode.getParent();
            RAMLNode deletedNode = this.mySelectedNode;
            int deletedNodeIndex = this.getIndexOfChild(parentNode, deletedNode);
            parentNode.removeChild(deletedNode);
            this.relocateSelection(parentNode, deletedNodeIndex);
            this.informChildNodeRemoval(parentNode, deletedNode);
        }
    }

    public void removeAllInstancesOfSelectedNode() {
        if (this.mySelectedNode != null && !this.myRoot.equals(this.mySelectedNode)) {
            RAMLNode parentNode = (RAMLNode)this.mySelectedNode.getParent();
            List<RAMLNode> childNodes = parentNode.getChilds();
            String moClassaName = this.getMOClassName(this.mySelectedNode);
            for (RAMLNode childNode : childNodes) {
                if (!moClassaName.equals(this.getMOClassName(childNode)) || !childNode.isDeletable()) continue;
                int deletedNodeIndex = this.getIndexOfChild(parentNode, childNode);
                parentNode.removeChild(childNode);
                this.relocateSelection(parentNode, deletedNodeIndex);
                this.informChildNodeRemoval(parentNode, childNode);
            }
        }
    }

    public String getMOClassName(RAMLNode node) {
        return node.getName().split("-")[0];
    }

    protected void fireTreeStructureChanged(RAMLNode oldRoot) {
        TreeModelEvent e = new TreeModelEvent((Object)this, new Object[]{oldRoot});
        for (TreeModelListener tml : this.myListeners) {
            tml.treeStructureChanged(e);
        }
    }

    protected void fireSelectionChanged(RAMLNode selectedNode) {
        for (RAMLTreeListener tml : this.myRamlListeners) {
            tml.selectionChanged(selectedNode);
        }
    }

    protected void fireChildAdded(RAMLNode child) {
        for (RAMLTreeListener tml : this.myRamlListeners) {
            tml.childAdded(child);
        }
    }

    protected void fireChildRemoved(RAMLNode child) {
        for (RAMLTreeListener tml : this.myRamlListeners) {
            tml.childRemoved(child);
        }
    }

    public List<RAMLNode> getPathToRoot(RAMLNode selected) {
        ArrayList<RAMLNode> myPath = new ArrayList<RAMLNode>();
        myPath.add(selected);
        if (selected.getParent() != null) {
            myPath.addAll(this.getPathToRoot((RAMLNode)selected.getParent()));
        }
        return myPath;
    }

    public TreePath getTreePathToRoot(RAMLNode node) {
        List<RAMLNode> list = this.getPathToRoot(node);
        Collections.reverse(list);
        return new TreePath(list.toArray());
    }

    public TreePath getTreePathToRoot() {
        List<RAMLNode> list = this.getPathToRoot(this.getSelectedRAMLNode());
        Collections.reverse(list);
        Object[] path = new RAMLNode[list.size()];
        int i = 0;
        while (i < list.size()) {
            path[i] = list.get(i);
            ++i;
        }
        return new TreePath(path);
    }

    public void setSelectedNode(RAMLNode node) {
        this.mySelectedNode = node;
        this.fireSelectionChanged(this.mySelectedNode);
    }

    public RAMLNode getSelectedRAMLNode() {
        return this.mySelectedNode;
    }

    @Override
    public void addTreeModelListener(TreeModelListener listener) {
        this.myListeners.add(listener);
    }

    public void addRAMLTreeListener(RAMLTreeListener listener) {
        this.myRamlListeners.add(listener);
    }

    @Override
    public Object getChild(Object parent, int index) {
        RAMLNode p = (RAMLNode)parent;
        List<RAMLNode> childs = p.getChilds();
        if (index >= childs.size()) {
            return null;
        }
        RAMLNode ramlNode = childs.get(index);
        if (ramlNode.isShowable()) {
            return ramlNode;
        }
        return null;
    }

    @Override
    public int getChildCount(Object parent) {
        RAMLNode p = (RAMLNode)parent;
        int size = 0;
        for (RAMLNode ramlNode : p.getChilds()) {
            if (!ramlNode.isShowable()) continue;
            ++size;
        }
        return size;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        RAMLNode p = (RAMLNode)parent;
        RAMLNode c = (RAMLNode)child;
        List<RAMLNode> childNodes = p.getChilds();
        int i = 0;
        while (i < childNodes.size()) {
            RAMLNode tmp = childNodes.get(i);
            if (c.getName().equals(tmp.getName())) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    @Override
    public Object getRoot() {
        return this.myRoot;
    }

    @Override
    public boolean isLeaf(Object node) {
        RAMLNode p = (RAMLNode)node;
        return p.getChilds().size() == 0;
    }

    @Override
    public void removeTreeModelListener(TreeModelListener listener) {
        this.myListeners.remove(listener);
    }

    public void removeRAMLTreeListener(RAMLTreeListener listener) {
        this.myRamlListeners.remove(listener);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public void valueChanged(TreeSelectionEvent evt) {
        TreePath[] paths = evt.getPaths();
        int i = 0;
        while (i < paths.length) {
            if (evt.isAddedPath(i)) {
                this.mySelectedNode = (RAMLNode)paths[i].getLastPathComponent();
                this.fireSelectionChanged(this.mySelectedNode);
            }
            ++i;
        }
    }

    public List<RAMLNode> getSameNodes(RAMLNode selectNode, String name) {
        ArrayList<RAMLNode> sameNodes = new ArrayList<RAMLNode>();
        RAMLNode parent = (RAMLNode)selectNode.getParent();
        List<RAMLNode> childs = parent.getChilds();
        int i = 0;
        while (i < childs.size()) {
            String childMOClassName = this.getMOClassName(childs.get(i));
            if (childMOClassName.equals(name)) {
                sameNodes.add(childs.get(i));
            }
            ++i;
        }
        return sameNodes;
    }

    public List<RAMLNode> getSiblingNodesHasId(RAMLNode selectNode, String name) {
        ArrayList<RAMLNode> sameNodes = new ArrayList<RAMLNode>();
        RAMLNode parent = (RAMLNode)selectNode.getParent();
        if (parent == null) {
            return sameNodes;
        }
        List<RAMLNode> childs = parent.getChilds();
        int i = 0;
        int size = childs.size();
        while (i < size) {
            RAMLNode ramlNode = childs.get(i);
            if (ramlNode.getName().startsWith(name) && !ramlNode.getId().isEmpty()) {
                sameNodes.add(ramlNode);
            }
            ++i;
        }
        return sameNodes;
    }

    @Override
    public Object getParentNode(Object node) {
        return node instanceof RAMLNode ? ((RAMLNode)node).getParent() : null;
    }

    private void relocateSelection(RAMLNode parentNode, int removedChildNodeIndex) {
        List<RAMLNode> childNodes = this.getChildNodes(parentNode);
        if (removedChildNodeIndex - 1 > -1) {
            this.setSelectedNode(childNodes.get(removedChildNodeIndex - 1));
        } else if (removedChildNodeIndex < childNodes.size() && !childNodes.isEmpty()) {
            this.setSelectedNode(childNodes.get(removedChildNodeIndex));
        } else {
            this.setSelectedNode(parentNode);
        }
    }

    private List<RAMLNode> getChildNodes(RAMLNode parentNode) {
        ArrayList<RAMLNode> childNodes = new ArrayList<RAMLNode>();
        int childCount = this.getChildCount(parentNode);
        int i = 0;
        while (i < childCount) {
            childNodes.add((RAMLNode)this.getChild(parentNode, i));
            ++i;
        }
        return childNodes;
    }
}

