/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.raml.edit;

import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.util.TextUtils;
import com.nokia.widgets.infotip.InfoTip;
import com.nokia.widgets.labels.PLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;

public class RamlInfoTip
extends InfoTip
implements HierarchyListener {
    private static final ResourceBundle RB = I18n.getI18n().getBundle(RamlInfoTip.class);
    private static final String showMore = RB.getString("PDDB_Parameter_Tooltip_ShowMore");
    private static final String shortDesc = RB.getString("PDDB_Parameter_Tooltip_ShortDesc");
    private static final String moName = RB.getString("PDDB_Parameter_Tooltip_MOName");
    private static final String paraShortName = RB.getString("PDDB_Parameter_Tooltip_ParamShortName");
    private static final Color hyperLinkColor = UIManager.getColor("Hyperlink.lightForeground");
    private static final Font font = UIManager.getFont("Label.textFont");
    private static HyperlinkListener pddbBrowserController;
    protected String myName;
    protected String myDesp;
    protected String myDistName;

    public RamlInfoTip(Component invoker, String name, String desp, String distName) {
        super(invoker);
        this.myName = name;
        this.myDesp = desp;
        this.myDistName = distName;
        invoker.addHierarchyListener(this);
    }

    @Override
    protected void replaceTipContent() {
        JComponent comp = this.getTipContent();
        if (comp instanceof PLabel) {
            JEditorPane pane = this.createEditorPane(this.myName, this.myDesp, this.myDistName);
            pane.addHyperlinkListener(RamlInfoTip.getPddbBrowserController());
            pane.addMouseListener(this.myHandler);
            this.setTipContent(pane);
        }
    }

    public static HyperlinkListener getPddbBrowserController() {
        return pddbBrowserController;
    }

    protected JEditorPane createEditorPane(String name, String description, String distName) {
        StringBuilder tooltipBuilder = new StringBuilder();
        tooltipBuilder.append("<html><table><tr><td valign=\"top\" class=\"label\">");
        if (distName.contains(".")) {
            tooltipBuilder.append(paraShortName);
        } else {
            tooltipBuilder.append(moName);
        }
        tooltipBuilder.append("</td><td>");
        tooltipBuilder.append(name);
        tooltipBuilder.append("</td></tr>");
        if (description != null && description.trim().length() != 0) {
            tooltipBuilder.append("<tr><td valign=\"top\" class=\"label\">");
            tooltipBuilder.append(shortDesc);
            tooltipBuilder.append("</td><td>");
            tooltipBuilder.append(TextUtils.textWrap(TextUtils.encodeToHTMLSourceCode(description), "<br>", 80));
            tooltipBuilder.append("</td></tr>");
        }
        tooltipBuilder.append("<tr><td><a href=\"");
        tooltipBuilder.append(distName);
        tooltipBuilder.append("\">");
        tooltipBuilder.append(showMore);
        tooltipBuilder.append("</a></td><td>&nbsp;</td></html>");
        JEditorPane pane = new JEditorPane("text/html", tooltipBuilder.toString());
        pane.setEditable(false);
        pane.setToolTipText(null);
        pane.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        pane.setMinimumSize(new Dimension(350, 100));
        StyleSheet styleSheet = ((HTMLDocument)pane.getDocument()).getStyleSheet();
        this.addRule(styleSheet);
        return pane;
    }

    private void addRule(StyleSheet styleSheet) {
        String cssLinkColor = "rgb(" + hyperLinkColor.getRed() + "," + hyperLinkColor.getGreen() + "," + hyperLinkColor.getBlue() + ")";
        String bodyRule = "body { font-family: " + font.getFamily() + "; " + "font-size: " + font.getSize() + "pt; color:white}";
        styleSheet.addRule(bodyRule);
        styleSheet.addRule("a { text-decoration: underline; color: " + cssLinkColor + "}");
        styleSheet.addRule("a:hover { text-decoration: none; color: " + cssLinkColor + "}");
        styleSheet.addRule(".label { font-weight: bold; vertical-align: top; white-space: nowrap");
    }

    public static void setPddbBrowserController(HyperlinkListener pddbBrowserController) {
        RamlInfoTip.pddbBrowserController = pddbBrowserController;
    }

    @Override
    public void hierarchyChanged(HierarchyEvent e) {
        if ((e.getChangeFlags() & 4L) == 4L) {
            this.setVisible(false);
        }
    }
}

