/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.raml.edit.comparemo;

import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLMetaParameter;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLBit;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLBitList;
import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.borders.BaseBorder;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.buttons.PToolButton;
import com.nokia.widgets.icons.PArrowIcon;
import com.nokia.widgets.util.ComponentUtils;
import com.nokia.widgets.util.WidgetResources;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import net.miginfocom.swing.MigLayout;

public class CompareMOButtonEditorAndRenderer
extends AbstractCellEditor
implements TableCellEditor,
TableCellRenderer,
ActionListener {
    private JPanel myPanel = new JPanel((LayoutManager)new MigLayout("gap 4, align center, insets 2 n n n")){

        @Override
        protected void paintComponent(Graphics g) {
            if (!CompareMOButtonEditorAndRenderer.this.myTable.isRowSelected(CompareMOButtonEditorAndRenderer.this.myRow) || !CompareMOButtonEditorAndRenderer.this.myTable.isColumnSelected(CompareMOButtonEditorAndRenderer.this.myColumn)) {
                CompareMOButtonEditorAndRenderer.this.setButtonRollover(CompareMOButtonEditorAndRenderer.this.myLeftButton);
                CompareMOButtonEditorAndRenderer.this.setButtonRollover(CompareMOButtonEditorAndRenderer.this.myRightButton);
            }
            if (!CompareMOButtonEditorAndRenderer.this.myTable.isRowSelected(CompareMOButtonEditorAndRenderer.this.myRow)) {
                boolean paintRollovered = ComponentUtils.isRolloveredRow(CompareMOButtonEditorAndRenderer.this.myTable, CompareMOButtonEditorAndRenderer.this.myRow);
                if (CompareMOButtonEditorAndRenderer.this.myRow % 2 == 0) {
                    g.setColor(paintRollovered ? UIManager.getColor("Table.evenHoverBackground") : UIManager.getColor("Table.UnEditableRowBackground1"));
                } else {
                    g.setColor(paintRollovered ? UIManager.getColor("Table.oddHoverBackground") : UIManager.getColor("Table.UnEditableRowBackground2"));
                }
            } else {
                g.setColor(UIManager.getColor("Table.SelectedFocusedBackground"));
            }
            g.clearRect(0, 0, CompareMOButtonEditorAndRenderer.this.myPanel.getWidth(), CompareMOButtonEditorAndRenderer.this.myPanel.getHeight());
            g.fillRect(0, 0, CompareMOButtonEditorAndRenderer.this.myPanel.getWidth(), CompareMOButtonEditorAndRenderer.this.myPanel.getHeight());
        }
    };
    private PToolButton myLeftButton = this.createCopyButton(7);
    private PToolButton myRightButton = this.createCopyButton(3);
    private JLabel myNotEqualToLabel = new JLabel(WidgetResources.getImageIcon("MERGE_NOT_EQUAL_TO"));
    private JTable myTable;
    private int myRow;
    private Border myBorder = new CompareMOInnerButtonBorder();
    private Object myFirstValue;
    private Object mySecondValue;
    private int myColumn;
    private boolean myIsEnabled;
    private RAMLMetaParameter myMetaParameter;

    public CompareMOButtonEditorAndRenderer() {
        this.myPanel.setFocusable(false);
        this.myPanel.add(this.myLeftButton);
        this.myPanel.add(this.myRightButton);
        this.myPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                CompareMOButtonEditorAndRenderer.this.stopCellEditing();
            }
        });
        this.myPanel.setBorder(this.myBorder);
    }

    private PToolButton createCopyButton(int orientation) {
        PToolButton button = new PToolButton();
        button.setMinimalistic(true);
        button.setToolButton(false);
        PArrowIcon arrowIcon = new PArrowIcon(7, 3, (Color)NetLookAndFeel.getFocusColor(), orientation);
        button.setIcon(arrowIcon);
        button.addActionListener(this);
        return button;
    }

    public JButton getLeftButton() {
        return this.myLeftButton;
    }

    public JButton getRightButton() {
        return this.myRightButton;
    }

    public boolean transferFocus(FocusTraversal focusTraversal) {
        if (!this.myIsEnabled) {
            return false;
        }
        PToolButton firstButton = null;
        PToolButton secondButton = null;
        if (focusTraversal == FocusTraversal.FORWARD) {
            firstButton = this.myLeftButton;
            secondButton = this.myRightButton;
        } else {
            firstButton = this.myRightButton;
            secondButton = this.myLeftButton;
        }
        if (!firstButton.hasFocus() && !secondButton.hasFocus()) {
            firstButton.requestFocus();
        } else if (firstButton.hasFocus()) {
            secondButton.requestFocus();
        } else if (secondButton.hasFocus()) {
            return false;
        }
        return true;
    }

    @Override
    public Object getCellEditorValue() {
        return null;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.updateData(table, row, column);
        return this.myPanel;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.updateData(table, row, column);
        return this.myPanel;
    }

    private void updateData(JTable table, int row, int column) {
        this.myTable = table;
        this.myRow = row;
        this.myColumn = column;
        this.myFirstValue = this.myTable.getValueAt(row, 1);
        this.mySecondValue = this.myTable.getValueAt(row, 3);
        if (this.myTable.getModel().getValueAt(row, 0) instanceof RAMLBit) {
            RAMLBit bit = (RAMLBit)this.myTable.getModel().getValueAt(table.convertRowIndexToModel(row), 0);
            this.myLeftButton.setVisible(!bit.isFixed());
            this.myRightButton.setVisible(!bit.isFixed());
        } else {
            this.myMetaParameter = (RAMLMetaParameter)this.myTable.getModel().getValueAt(table.convertRowIndexToModel(row), 0);
            boolean buttonVisible = this.getCopyButtonVisibility();
            this.myLeftButton.setVisible(buttonVisible);
            this.myRightButton.setVisible(buttonVisible);
        }
        boolean isButtonEnabled = !this.isFirstMoParamValueEqualToSecond();
        this.myLeftButton.setEnabled(isButtonEnabled);
        this.myRightButton.setEnabled(isButtonEnabled);
        this.evaluateNotEqualSymbolVisibility();
        this.myIsEnabled = isButtonEnabled;
    }

    private boolean isFirstMoParamValueEqualToSecond() {
        return this.myFirstValue.equals(this.mySecondValue);
    }

    private boolean areLeftButtonAndRightButtonVisible() {
        return this.myLeftButton.isVisible() && this.myRightButton.isVisible();
    }

    private void evaluateNotEqualSymbolVisibility() {
        if (!this.isFirstMoParamValueEqualToSecond() && this.areLeftButtonAndRightButtonVisible()) {
            this.myPanel.add((Component)this.myNotEqualToLabel, 1);
        } else {
            this.myPanel.remove(this.myNotEqualToLabel);
        }
    }

    private boolean getCopyButtonVisibility() {
        return this.myMetaParameter != null && !(this.myMetaParameter.getValueType() instanceof RAMLBitList) && !this.myMetaParameter.isInstanceParameter() && !this.myMetaParameter.isSetByTheSystem() && !this.myMetaParameter.isLocked() && !this.myMetaParameter.isUnChangeable();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source.equals(this.myLeftButton)) {
            this.myTable.setValueAt(this.mySecondValue, this.myRow, 1);
            this.myLeftButton.setEnabled(false);
            this.myRightButton.setEnabled(false);
        } else if (source.equals(this.myRightButton)) {
            this.myTable.setValueAt(this.myFirstValue, this.myRow, 3);
            this.myLeftButton.setEnabled(false);
            this.myRightButton.setEnabled(false);
        }
    }

    public void copyValue(JTable table, int row, int fromColumn, int toColumn) {
        table.setValueAt(table.getValueAt(row, fromColumn), row, toColumn);
    }

    private void setButtonRollover(JButton button) {
        Point tablePoint = (Point)this.myTable.getClientProperty("BlueTouch.rolloveredCell");
        Point point = SwingUtilities.convertPoint(this.myTable, tablePoint, button.getParent());
        Rectangle rectangle = button.getBounds();
        if (rectangle.contains(point)) {
            button.getModel().setRollover(true);
        } else {
            button.getModel().setRollover(false);
        }
    }

    private class CompareMOInnerButtonBorder
    extends BaseBorder {
        public CompareMOInnerButtonBorder() {
            super(0, 0, 0, 0);
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            JComponent jComp = (JComponent)c;
            boolean focused = Boolean.TRUE.equals(jComp.getClientProperty("Table.hasFocus"));
            boolean editable = Boolean.TRUE.equals(jComp.getClientProperty("Table.isEditable"));
            if (!editable && !focused) {
                return;
            }
            if (focused) {
                Object oldAa = NetUtils.antiAliasingOn(g);
                Color outline = UIManager.getColor("Table.editorBorder");
                Rectangle rect = new Rectangle(0, 0, c.getWidth() - 1, c.getHeight() - 1);
                outline = NetLookAndFeel.getFocusColor();
                g.setColor(outline);
                ((Graphics2D)g).draw(rect);
                NetUtils.setAntialiasing(g, oldAa);
            }
        }
    }

    public static enum FocusTraversal {
        FORWARD,
        BACKWARD;

    }
}

