/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.raml.edit.comparemo;

import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLMetaParameter;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLBit;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLBitList;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLDecimal;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLEnum;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLInteger;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLSimpleType;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLString;
import com.nokia.em.poseidon.gui.raml.edit.RAMLEditComponentFactory;
import com.nokia.em.poseidon.gui.raml.edit.RAMLEditPanel;
import com.nokia.em.poseidon.gui.raml.edit.RAMLNode;
import com.nokia.em.poseidon.gui.raml.edit.RAMLTreeModel;
import com.nokia.em.poseidon.gui.raml.edit.comparemo.CompareMOUtils;
import com.nokia.em.poseidon.gui.raml.edit.comparemo.CompareMOView;
import com.nokia.em.poseidon.services.help.PHelp;
import com.nokia.widgets.util.SystemUtils;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;

public class CompareMOHandler {
    private RAMLNode myFirstNode;
    private RAMLNode mySecondNode;
    private RAMLTreeModel myTreeModel;
    private String myPath;
    private Object[][] myTableData;
    private PHelp myHelpService;
    protected final int META_PARAMETERS = 0;
    protected final int ALLOWED_VALUES = 1;
    private String myMOName;
    private List<RAMLNode> myComparableMOs = new ArrayList<RAMLNode>(0);
    private CompareMOView myView;

    public CompareMOHandler(RAMLNode current, RAMLNode target, RAMLTreeModel treeModel) {
        this.myFirstNode = current;
        this.mySecondNode = target;
        this.myMOName = this.myFirstNode.getName().split("-")[0];
        this.myTreeModel = treeModel;
        int paramCount = this.getTableRowCount(this.myFirstNode);
        this.myTableData = new Object[paramCount][2];
        this.myPath = this.getPath((RAMLNode)this.myFirstNode.getParent());
        this.myComparableMOs = this.getComparableMOs(this.myFirstNode);
        this.populateTable();
        String[] names = new String[]{this.myMOName, this.myPath, this.myFirstNode.getName(), this.mySecondNode.getName()};
        this.myView = new CompareMOView(this, names, this.myTableData, this.myFirstNode, this.mySecondNode, this.myComparableMOs);
        this.myView.showDialog();
    }

    private int getTableRowCount(RAMLNode currentNode) {
        int counter = 0;
        List<RAMLMetaParameter> metaPs = currentNode.getMetaParameters();
        for (RAMLMetaParameter metaP : metaPs) {
            if (!CompareMOUtils.isParameterShownInCompareMOTable(metaP)) continue;
            ++counter;
            if (!(metaP.getValueType() instanceof RAMLBitList)) continue;
            List<RAMLBit> bitList = ((RAMLBitList)metaP.getValueType()).getBits();
            counter += bitList.size();
        }
        return counter;
    }

    public void populateTable() {
        List<RAMLMetaParameter> metaParams = this.myFirstNode.getMetaParameters();
        int index = 0;
        for (RAMLMetaParameter metaParam : metaParams) {
            if (!CompareMOUtils.isParameterShownInCompareMOTable(metaParam)) continue;
            this.myTableData[index][0] = metaParam;
            this.insertLabelAndRange(metaParam, index);
            ++index;
            if (!(metaParam.getValueType() instanceof RAMLBitList)) continue;
            Integer parentRow = index - 1;
            for (RAMLBit bit : ((RAMLBitList)metaParam.getValueType()).getBits()) {
                this.myTableData[index][0] = bit;
                this.myTableData[index][1] = parentRow;
                ++index;
            }
        }
    }

    private void insertLabelAndRange(RAMLMetaParameter metaParam, int index) {
        this.myTableData[index][1] = this.getUnitsAndRange(metaParam);
    }

    private Object getUnitsAndRange(RAMLMetaParameter metaParam) {
        RAMLSimpleType paramType = (RAMLSimpleType)metaParam.getValueType();
        if (metaParam.isSetByTheSystem()) {
            return "Value set by the system";
        }
        if (paramType.getBaseType().equals("integer")) {
            return this.getIntegerRange(paramType);
        }
        if (paramType.getBaseType().equals("decimal")) {
            return this.getDecimalRange(paramType);
        }
        if (paramType.getBaseType().equals("enumeration")) {
            List<String> texts = ((RAMLEnum)paramType).getTexts();
            return texts;
        }
        if (paramType.getBaseType().equals("boolean")) {
            ArrayList<String> texts = new ArrayList<String>();
            texts.add(Boolean.toString(true));
            texts.add(Boolean.toString(false));
            return texts;
        }
        if (paramType.getBaseType().equals("string")) {
            return new Integer(((RAMLString)paramType).getMaxLength());
        }
        if (paramType.getBaseType().equals("bit")) {
            List[] selections = new List[]{new ArrayList(0), new ArrayList(0)};
            return selections;
        }
        return null;
    }

    private Object getDecimalRange(RAMLSimpleType paramType) {
        String label = ((RAMLDecimal)paramType).getUnitType();
        Double min = (Double)((RAMLDecimal)paramType).getMinValue();
        Double max = (Double)((RAMLDecimal)paramType).getMaxValue();
        Double step = (Double)((RAMLDecimal)paramType).getStep();
        int digits = ((RAMLDecimal)paramType).getDigits();
        return String.valueOf(label) + " " + RAMLEditComponentFactory.createRangeText((RAMLDecimal)paramType, min, max, step != null && !SystemUtils.isEqual(min + step, max) ? Double.valueOf(min + step) : null, digits);
    }

    private Object getIntegerRange(RAMLSimpleType paramType) {
        String label = ((RAMLInteger)paramType).getUnitType();
        Integer min = (Integer)((RAMLInteger)paramType).getMinValue();
        Integer max = (Integer)((RAMLInteger)paramType).getMaxValue();
        Integer step = (Integer)((RAMLInteger)paramType).getStep();
        return String.valueOf(label) + " " + RAMLEditComponentFactory.createRangeText((RAMLInteger)paramType, min, max, step != null && !SystemUtils.isEqual(min + step, max.intValue()) ? Integer.valueOf(min + step) : null);
    }

    private String getPath(RAMLNode node) {
        if (node.getParent() == null) {
            return String.valueOf(node.getName()) + "\\";
        }
        return String.valueOf(this.getPath((RAMLNode)node.getParent())) + node.getName() + "\\";
    }

    public RAMLNode getCurrentNode() {
        return this.myFirstNode;
    }

    public void setCurrentNode(RAMLNode currentNode) {
        this.myFirstNode = currentNode;
    }

    public RAMLNode getTargetNode() {
        return this.mySecondNode;
    }

    public void setTargetNode(RAMLNode targetNode) {
        this.mySecondNode = targetNode;
    }

    public RAMLTreeModel getTreeModel() {
        return this.myTreeModel;
    }

    public void setTreeModel(RAMLTreeModel treeModel) {
        this.myTreeModel = treeModel;
    }

    public List<RAMLNode> getComparableMOs(RAMLNode selectedNode) {
        RAMLNode parent = (RAMLNode)selectedNode.getParent();
        List<RAMLNode> children = parent.getChilds();
        ArrayList<RAMLNode> comparableMOs = new ArrayList<RAMLNode>(0);
        for (RAMLNode child : children) {
            if (!selectedNode.equals(child) && !RAMLEditPanel.isSiblings(selectedNode, child)) continue;
            comparableMOs.add(child);
        }
        return comparableMOs;
    }

    public RAMLNode getNode(String id) {
        for (RAMLNode node : this.myComparableMOs) {
            if (!node.getId().equals(id)) continue;
            return node;
        }
        return null;
    }

    protected void showHelp(Window parentView, String helpID) {
        if (this.myHelpService == null) {
            this.myHelpService = PoseidonRuntime.getRuntime().getService(PHelp.class);
        }
        if (this.myHelpService != null) {
            this.myHelpService.showHelp(parentView, helpID);
        }
    }
}

