/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.raml.edit.comparemo;

import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.frameworks.raml.RAMLParameter;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLMetaParameter;
import com.nokia.em.poseidon.gui.raml.edit.RAMLEditPanel;
import com.nokia.em.poseidon.gui.raml.edit.RAMLNode;
import com.nokia.em.poseidon.gui.raml.edit.comparemo.CompareMOColumn;
import com.nokia.em.poseidon.gui.raml.edit.comparemo.CompareMOHeaderNode;
import com.nokia.em.poseidon.gui.raml.edit.comparemo.CompareMOHeaderUI;
import com.nokia.em.poseidon.gui.raml.edit.comparemo.CompareMOTable;
import com.nokia.em.poseidon.gui.raml.edit.comparemo.CompareMOTableModel;
import com.nokia.em.poseidon.gui.raml.edit.comparemo.CompareMOUtils;
import com.nokia.em.poseidon.gui.raml.edit.comparemo.CompareMOView;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;

public class CompareMOHeader
extends JTableHeader
implements CellEditorListener {
    private TableCellEditor myCellEditor;
    private JComponent myEditorComponent;
    private int myEditingColumnIndex;
    private CompareMOTableModel myTableModel;
    private List<RAMLNode> myComparableMOs;
    protected static final ResourceBundle theRB = I18n.getI18n().getBundle(RAMLEditPanel.class);

    public CompareMOHeader(JTableHeader oldHeader, List<RAMLNode> comparableMOs) {
        this.table = oldHeader.getTable();
        this.columnModel = oldHeader.getColumnModel();
        this.reorderingAllowed = false;
        this.resizingAllowed = oldHeader.getResizingAllowed();
        this.updateTableInRealTime = oldHeader.getUpdateTableInRealTime();
        this.resizingColumn = oldHeader.getResizingColumn();
        this.draggedColumn = oldHeader.getDraggedColumn();
        this.draggedDistance = oldHeader.getDraggedDistance();
        this.setDefaultRenderer(oldHeader.getDefaultRenderer());
        this.myTableModel = (CompareMOTableModel)this.table.getModel();
        this.myComparableMOs = comparableMOs;
        this.setBorder(oldHeader.getBorder());
    }

    @Override
    public void updateUI() {
        this.setUI(new CompareMOHeaderUI());
        this.resizeAndRepaint();
        this.invalidate();
    }

    @Override
    public void editingStopped(ChangeEvent e) {
        TableCellEditor editor = this.getCellEditor();
        if (editor != null) {
            int columnIndex;
            Object oldValue;
            RAMLNode oldNode;
            Object newValue = editor.getCellEditorValue();
            RAMLNode newNode = ((CompareMOHeaderNode)newValue).getNode();
            if (newNode.equals(oldNode = ((CompareMOHeaderNode)(oldValue = this.columnModel.getColumn(columnIndex = this.getEditingColumnIndex()).getHeaderValue())).getNode()) || this.myTableModel.isColumnModified(columnIndex) && !this.isSureToUpdate()) {
                this.removeEditor();
                return;
            }
            this.columnModel.getColumn(columnIndex).setHeaderValue(newValue);
            RAMLNode selectedNode = CompareMOView.getNodeFromGroup((CompareMOHeaderNode)newValue, this.myComparableMOs);
            this.updateTableModel(selectedNode, columnIndex);
            this.removeEditor();
        }
    }

    private boolean isSureToUpdate() {
        JButton continueButton = new JButton(theRB.getString("RAMLEdit.CompareMO.OptionPane.Continue"));
        continueButton.setMnemonic(theRB.getMnemonic("RAMLEdit.CompareMO.OptionPane.Continue.Mnemonic"));
        JButton cancelButton = new JButton(theRB.getString("RAMLEdit.CompareMO.OptionPane.Cancel"));
        Object[] options = new Object[]{continueButton, cancelButton};
        final JOptionPane optionPane = new JOptionPane(theRB.getString("RAMLEdit.CompareMO.OptionPane_Text"), 3, 0, null, options, options[1]);
        continueButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                optionPane.setValue(0);
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                optionPane.setValue(1);
            }
        });
        JDialog dialog = optionPane.createDialog(this, theRB.getString("RAMLEdit.CompareMO.OptionPane_Title"));
        dialog.show();
        dialog.dispose();
        return (Integer)optionPane.getValue() == 0;
    }

    protected void updateTableModel(RAMLNode node, int column) {
        List<RAMLMetaParameter> metaParams = node.getMetaParameters();
        int rowIndex = 0;
        for (RAMLMetaParameter metaParam : metaParams) {
            if (rowIndex >= this.myTableModel.getRowCount() || !CompareMOUtils.isParameterShownInCompareMOTable(metaParam)) continue;
            String oldValue = (String)this.myTableModel.getValueAt(rowIndex, column);
            String newValue = null;
            if (metaParam.isInstanceParameter()) {
                newValue = node.getId();
            } else if (!metaParam.isSetByTheSystem()) {
                RAMLParameter parameter = node.getParameter(metaParam.getName());
                newValue = parameter == null || parameter.getValue() == null ? "" : CompareMOView.getRAMLParameterUIValue(node, metaParam);
            }
            if (newValue != null && !newValue.equals(oldValue)) {
                this.myTableModel.setValueAt(newValue, rowIndex, column);
            }
            ++rowIndex;
        }
        this.myTableModel.setColumnNode(column, node);
        this.myTableModel.resetModifiedFlag(column);
        if (this.myTableModel.isShowingAll()) {
            return;
        }
        ((CompareMOTable)this.getTable()).showDifferencesOnly();
    }

    private void removeEditor() {
        TableCellEditor editor = this.getCellEditor();
        if (editor != null) {
            editor.removeCellEditorListener(this);
            this.requestFocus();
            this.remove(this.myEditorComponent);
            int index = this.getEditingColumnIndex();
            Rectangle cellRect = this.getHeaderRect(index);
            this.setCellEditor(null);
            this.setEditingColumnIndex(-1);
            this.myEditorComponent = null;
            this.repaint(cellRect);
        }
    }

    @Override
    public void editingCanceled(ChangeEvent e) {
        this.removeEditor();
    }

    public JComponent getEditorComponent() {
        return this.myEditorComponent;
    }

    public boolean editCellAt(int index, MouseEvent e) {
        if (this.myCellEditor != null && !this.myCellEditor.stopCellEditing()) {
            return false;
        }
        TableCellEditor editor = this.getCellEditor(index);
        if (editor != null && editor.isCellEditable(e)) {
            this.myEditorComponent = this.prepareEditor(editor, index);
            this.removeItemFromOtherColumn(this.myEditorComponent, index);
            this.myEditorComponent.setBounds(this.getHeaderRect(index));
            this.add(this.myEditorComponent);
            this.myEditorComponent.validate();
            this.setCellEditor(editor);
            this.setEditingColumnIndex(index);
            editor.addCellEditorListener(this);
            return true;
        }
        return false;
    }

    private void removeItemFromOtherColumn(Component editorComponent, int index) {
        JComboBox comboBox = (JComboBox)editorComponent;
        Object selectedItem = this.columnModel.getColumn(index).getHeaderValue();
        while (comboBox.getItemAt(0) != null) {
            comboBox.removeItemAt(0);
        }
        TableColumn column = index == 1 ? this.columnModel.getColumn(3) : this.columnModel.getColumn(1);
        for (RAMLNode node : this.myComparableMOs) {
            if (node.equals(((CompareMOHeaderNode)selectedItem).getNode())) {
                comboBox.addItem(selectedItem);
                comboBox.setSelectedItem(selectedItem);
                continue;
            }
            if (node.equals(((CompareMOHeaderNode)column.getHeaderValue()).getNode())) continue;
            comboBox.addItem(new CompareMOHeaderNode(node));
        }
    }

    public int getEditingColumnIndex() {
        return this.myEditingColumnIndex;
    }

    public void setEditingColumnIndex(int editingColumnIndex) {
        this.myEditingColumnIndex = editingColumnIndex;
    }

    public void setCellEditor(TableCellEditor newEditor) {
        TableCellEditor oldEditor = this.myCellEditor;
        this.myCellEditor = newEditor;
        if (oldEditor != null) {
            oldEditor.removeCellEditorListener(this);
        }
        if (newEditor != null) {
            newEditor.addCellEditorListener(this);
        }
    }

    private JComponent prepareEditor(TableCellEditor editor, int index) {
        JTable ownerTable = this.getTable();
        Object value = this.columnModel.getColumn(index).getHeaderValue();
        boolean isSelected = true;
        int row = Integer.MIN_VALUE;
        JComponent component = (JComponent)editor.getTableCellEditorComponent(ownerTable, value, isSelected, row, index);
        return component;
    }

    public TableCellEditor getCellEditor() {
        return this.myCellEditor;
    }

    private TableCellEditor getCellEditor(int index) {
        int columnIndex = this.columnModel.getColumn(index).getModelIndex();
        if (this.columnModel.getColumn(columnIndex) instanceof CompareMOColumn) {
            CompareMOColumn col = (CompareMOColumn)this.columnModel.getColumn(columnIndex);
            return col.getHeaderEditor();
        }
        return null;
    }

    public boolean isEditing() {
        return this.myCellEditor != null;
    }
}

