/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.raml.edit.comparemo;

import com.nokia.em.poseidon.gui.raml.edit.comparemo.CompareMOHeader;
import com.nokia.laf.NetTableHeaderUI;
import com.nokia.widgets.util.NSNColors;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.TableColumnModel;

public class CompareMOHeaderUI
extends NetTableHeaderUI {
    @Override
    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler((CompareMOHeader)this.header);
    }

    public class MouseInputHandler
    extends BasicTableHeaderUI.MouseInputHandler {
        private CompareMOHeader myHeader;
        private Component myDispatchComponent;

        public MouseInputHandler(CompareMOHeader header) {
            super(CompareMOHeaderUI.this);
            this.myHeader = header;
        }

        private void setDispatchComponent(MouseEvent e) {
            JComponent editorComponent = this.myHeader.getEditorComponent();
            editorComponent.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, NSNColors.getLightGray()));
            Point p = e.getPoint();
            Point p2 = SwingUtilities.convertPoint(this.myHeader, p, editorComponent);
            this.myDispatchComponent = SwingUtilities.getDeepestComponentAt(editorComponent, p2.x, p2.y);
        }

        private boolean repostEvent(MouseEvent e) {
            if (this.myDispatchComponent == null) {
                return false;
            }
            MouseEvent e2 = SwingUtilities.convertMouseEvent(CompareMOHeaderUI.this.header, e, this.myDispatchComponent);
            this.myDispatchComponent.dispatchEvent(e2);
            return true;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            super.mousePressed(e);
            if (this.myHeader.getResizingColumn() == null) {
                Point point = e.getPoint();
                TableColumnModel columnModel = this.myHeader.getColumnModel();
                int index = columnModel.getColumnIndexAtX(point.x);
                if (index != -1 && this.myHeader.editCellAt(index, e)) {
                    this.setDispatchComponent(e);
                    this.repostEvent(e);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            this.repostEvent(e);
            this.myDispatchComponent = null;
        }
    }
}

