/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.raml.edit.comparemo;

import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLMetaParameter;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLBit;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLBoolean;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLDecimal;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLEnum;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLInteger;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLSimpleType;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLSpecialValue;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLString;
import com.nokia.em.poseidon.gui.raml.edit.AlphabeticalComparator;
import com.nokia.em.poseidon.gui.raml.edit.CreationPriorityComparator;
import com.nokia.em.poseidon.gui.raml.edit.RelatedFunctionComparator;
import com.nokia.em.poseidon.gui.raml.edit.comparemo.CompareMOHeader;
import com.nokia.em.poseidon.gui.raml.edit.comparemo.CompareMOTableModel;
import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.NetTheme;
import com.nokia.widgets.PComboBox;
import com.nokia.widgets.table.PComboBoxRenderer;
import com.nokia.widgets.table.PDefaultCellEditor;
import com.nokia.widgets.table.PTable;
import com.nokia.widgets.table.PTableCellRenderer;
import com.nokia.widgets.text.TextFieldFactory;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class CompareMOTable
extends PTable {
    private CompareMOTableModel myTableModel;

    public CompareMOTable(TableModel tableModel) {
        super(tableModel);
        this.myTableModel = (CompareMOTableModel)tableModel;
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        Object value = this.getValueAt(row, 0);
        if (column == 1 || column == 3) {
            if (value instanceof RAMLBit) {
                return this.getComboBoxRenderer(row);
            }
            RAMLMetaParameter meta = (RAMLMetaParameter)value;
            RAMLSimpleType simpleType = (RAMLSimpleType)meta.getValueType();
            if (!meta.isSetByTheSystem() && !meta.isLocked()) {
                if (simpleType instanceof RAMLBoolean || simpleType instanceof RAMLEnum) {
                    return this.getComboBoxRenderer(row);
                }
                return this.getTableCellRenderer(row);
            }
        }
        return super.getCellRenderer(row, column);
    }

    private TableCellRenderer getTableCellRenderer(final int row) {
        return new PTableCellRenderer(){

            @Override
            protected void paintComponent(Graphics g) {
                CompareMOTable.this.changeCellBackgroundIfValuesAreNotEqual(this, row);
                super.paintComponent(g);
            }
        };
    }

    private TableCellRenderer getComboBoxRenderer(final int row) {
        return new PComboBoxRenderer(){

            @Override
            protected void paintComponent(Graphics g) {
                CompareMOTable.this.changeCellBackgroundIfValuesAreNotEqual(this, row);
                super.paintComponent(g);
            }
        };
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        Object value = this.getValueAt(row, 0);
        if (column == 1 || column == 3) {
            if (value instanceof RAMLBit) {
                Object[] bitValues = new String[]{"true", "false"};
                return new PDefaultCellEditor((JComboBox)new PComboBox(bitValues));
            }
            RAMLMetaParameter meta = (RAMLMetaParameter)value;
            RAMLSimpleType simpleType = (RAMLSimpleType)meta.getValueType();
            if (!meta.isSetByTheSystem()) {
                if (simpleType instanceof RAMLBoolean) {
                    Object[] booleanValues = new String[]{"", "true", "false"};
                    return new PDefaultCellEditor((JComboBox)new PComboBox(booleanValues));
                }
                if (simpleType instanceof RAMLEnum) {
                    return this.getRAMLEnumCellEditor(simpleType);
                }
                if (simpleType instanceof RAMLInteger) {
                    return this.getRAMLIntegerCellEditor(simpleType);
                }
                if (simpleType instanceof RAMLDecimal) {
                    return this.getRAMLDecimalCellEditor(simpleType);
                }
                if (simpleType instanceof RAMLString) {
                    return this.getRAMLStringCellEditor(meta, simpleType);
                }
            }
        }
        return super.getCellEditor(row, column);
    }

    private TableCellEditor getRAMLStringCellEditor(RAMLMetaParameter meta, RAMLSimpleType simpleType) {
        RAMLString string = (RAMLString)simpleType;
        String regularExp = meta.getRegularExpression();
        if (string.getMaxLength() < 0) {
            return new PDefaultCellEditor(TextFieldFactory.createAlphaNumericTextField(string.getFixedLength()), 1);
        }
        if (meta.isPrintableString()) {
            return new PDefaultCellEditor(TextFieldFactory.createASN1PrintableStringTextField(string.getMaxLength()), 1);
        }
        if (regularExp != null && (regularExp.contains("&") || regularExp.contains("<") || regularExp.contains(">"))) {
            return new PDefaultCellEditor(TextFieldFactory.createAlphaNumericTextField(string.getMaxLength(), true), 1);
        }
        return new PDefaultCellEditor(TextFieldFactory.createAlphaNumericTextField(string.getMaxLength()), 1);
    }

    private TableCellEditor getRAMLDecimalCellEditor(RAMLSimpleType simpleType) {
        RAMLDecimal decimal = (RAMLDecimal)simpleType;
        return new PDefaultCellEditor(TextFieldFactory.createDecimalTextField(decimal.getDigits(), (double)((Double)decimal.getMinValue()), (double)((Double)decimal.getMaxValue()), this.getDoubleSpecialValuesAsArray(decimal.getSpecialValues())), 1);
    }

    private TableCellEditor getRAMLIntegerCellEditor(RAMLSimpleType simpleType) {
        RAMLInteger integer = (RAMLInteger)simpleType;
        return new PDefaultCellEditor(TextFieldFactory.createIntegerTextField((Integer)integer.getMinValue(), (Integer)integer.getMaxValue(), this.getIntegerSpecialValuesAsArray(integer.getSpecialValues())), 1);
    }

    private TableCellEditor getRAMLEnumCellEditor(RAMLSimpleType simpleType) {
        List<String> values = ((RAMLEnum)simpleType).getTexts();
        if (!values.contains("")) {
            values.add(0, "");
        }
        Object[] enumValues = values.toArray();
        values.remove(0);
        return new PDefaultCellEditor((JComboBox)new PComboBox(enumValues));
    }

    private int[] getIntegerSpecialValuesAsArray(List<RAMLSpecialValue<Integer>> integerSpecialValues) {
        int[] specialValues = new int[integerSpecialValues.size()];
        int i = 0;
        while (i < integerSpecialValues.size()) {
            specialValues[i] = integerSpecialValues.get(i).getValue();
            ++i;
        }
        return specialValues;
    }

    private double[] getDoubleSpecialValuesAsArray(List<RAMLSpecialValue<Double>> doubleSpecialValues) {
        double[] specialValues = new double[doubleSpecialValues.size()];
        int i = 0;
        while (i < doubleSpecialValues.size()) {
            specialValues[i] = doubleSpecialValues.get(i).getValue();
            ++i;
        }
        return specialValues;
    }

    private void changeCellBackgroundIfValuesAreNotEqual(JComponent component, int row) {
        String secondValue;
        String firstValue = this.getValueAt(row, 1).toString();
        component.putClientProperty("Table.tableCellBackground", !firstValue.equals(secondValue = this.getValueAt(row, 3).toString()) ? NetTheme.getHoverColor() : NetLookAndFeel.getWhite());
    }

    @Override
    public void columnMarginChanged(ChangeEvent e) {
        super.columnMarginChanged(e);
        this.stopCellEditing();
        this.getTableHeader().resizeAndRepaint();
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent e) {
        super.columnSelectionChanged(e);
        this.stopCellEditing();
    }

    private void stopCellEditing() {
        CompareMOHeader header = (CompareMOHeader)this.getTableHeader();
        if (header != null && header.isEditing()) {
            header.getCellEditor().stopCellEditing();
        }
    }

    protected void setSortableForAllColumns(TableRowSorter tableRowSorter, boolean isSortable) {
        tableRowSorter.setSortable(0, isSortable);
        tableRowSorter.setSortable(1, isSortable);
        tableRowSorter.setSortable(2, isSortable);
        tableRowSorter.setSortable(3, isSortable);
        tableRowSorter.setSortable(4, isSortable);
    }

    protected void sortByRelatedFunctions() {
        TableRowSorter sorter = (TableRowSorter)this.getRowSorter();
        this.stopCellEditing();
        this.setSortableForAllColumns(sorter, true);
        sorter.setComparator(0, new RelatedFunctionComparator());
        this.setSortKey(SortOrder.ASCENDING);
        sorter.sort();
        this.setSortableForAllColumns(sorter, false);
        this.myTableModel.setSortedAlphabetically(false);
        this.myTableModel.setMySortedRelatedFunctionFlag(true);
        this.myTableModel.setMySortedCreationPriorityFlag(false);
    }

    protected void sortByCreationPriority() {
        TableRowSorter sorter = (TableRowSorter)this.getRowSorter();
        this.stopCellEditing();
        this.setSortableForAllColumns(sorter, true);
        sorter.setComparator(0, new CreationPriorityComparator());
        this.setSortKey(SortOrder.ASCENDING);
        sorter.sort();
        this.setSortableForAllColumns(sorter, false);
        this.myTableModel.setSortedAlphabetically(false);
        this.myTableModel.setMySortedRelatedFunctionFlag(false);
        this.myTableModel.setMySortedCreationPriorityFlag(true);
    }

    protected void sortAlphabetically() {
        TableRowSorter sorter = (TableRowSorter)this.getRowSorter();
        this.stopCellEditing();
        this.setSortableForAllColumns(sorter, true);
        sorter.setComparator(0, new AlphabeticalComparator());
        this.setSortKey(SortOrder.ASCENDING);
        sorter.sort();
        this.setSortableForAllColumns(sorter, false);
        this.myTableModel.setSortedAlphabetically(true);
        this.myTableModel.setMySortedRelatedFunctionFlag(false);
        this.myTableModel.setMySortedCreationPriorityFlag(false);
    }

    private void setSortKey(SortOrder order) {
        ArrayList<RowSorter.SortKey> list = new ArrayList<RowSorter.SortKey>();
        list.add(new RowSorter.SortKey(0, order));
        this.getRowSorter().setSortKeys(list);
    }

    protected void showAllCells() {
        this.stopCellEditing();
        ((TableRowSorter)this.getRowSorter()).setRowFilter(new RowFilter(){

            public boolean include(RowFilter.Entry entry) {
                return true;
            }
        });
        this.myTableModel.setShowingAll(true);
    }

    protected void showDifferencesOnly() {
        this.stopCellEditing();
        ((TableRowSorter)this.getRowSorter()).setRowFilter(new RowFilter(){
            List<Integer> difference = new ArrayList<Integer>();

            public boolean include(RowFilter.Entry entry) {
                boolean notEqual;
                boolean bl = notEqual = !entry.getStringValue(1).equals(entry.getStringValue(3));
                if (notEqual) {
                    this.difference.add((Integer)entry.getIdentifier());
                }
                return this.difference.contains(entry.getIdentifier());
            }
        });
        this.myTableModel.setShowingAll(false);
    }
}

