/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.raml.edit.comparemo;

import com.nokia.em.poseidon.gui.raml.edit.comparemo.CompareMOButtonEditorAndRenderer;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JTable;
import javax.swing.KeyStroke;

public class CompareMOTableActions {
    public static void overrideEnterKeyEventOnMergeColumn(final JTable table) {
        KeyStroke enterKeyStroke = KeyStroke.getKeyStroke(10, 0);
        String enterStringName = (String)table.getInputMap(1).get(enterKeyStroke);
        final Action tabAction = table.getActionMap().get(enterStringName);
        AbstractAction modifiedEnterAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = table.getSelectedRow();
                int column = table.getSelectedColumn();
                if (column == 2) {
                    CompareMOButtonEditorAndRenderer cellEditor = (CompareMOButtonEditorAndRenderer)table.getCellEditor(row, column);
                    if (cellEditor.getLeftButton().hasFocus()) {
                        e.setSource(cellEditor.getLeftButton());
                    } else if (cellEditor.getRightButton().hasFocus()) {
                        e.setSource(cellEditor.getRightButton());
                    }
                    cellEditor.actionPerformed(e);
                } else {
                    tabAction.actionPerformed(e);
                }
            }
        };
        table.getActionMap().put(enterStringName, modifiedEnterAction);
        table.getInputMap(1).put(enterKeyStroke, enterStringName);
    }

    public static void handleTabActionOnMergeColumn(final JTable table, final TabAction tabAction) {
        final Action defaultTab = table.getActionMap().get(tabAction.getActionName());
        AbstractAction modifiedTab = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean isTabPressedOnMergeColumn = true;
                if (table.getSelectedColumn() != 2) {
                    defaultTab.actionPerformed(e);
                    isTabPressedOnMergeColumn = false;
                }
                CompareMOTableActions.handleFocusTraversalOnMergeColumn(table, tabAction, defaultTab, e, isTabPressedOnMergeColumn);
            }
        };
        table.getActionMap().put(tabAction.getActionName(), modifiedTab);
    }

    private static void handleFocusTraversalOnMergeColumn(JTable table, TabAction tabActionToOverride, Action defaultTabBehavior, ActionEvent event, boolean isTabPressedOnMergeColumn) {
        int column = table.getSelectedColumn();
        int row = table.getSelectedRow();
        if (column == 2) {
            boolean isCellDisabledOrTraversalEnded;
            table.editCellAt(row, column);
            CompareMOButtonEditorAndRenderer cellEditor = (CompareMOButtonEditorAndRenderer)table.getCellEditor(row, column);
            CompareMOButtonEditorAndRenderer.FocusTraversal forwardOrBackward = tabActionToOverride.hasShiftMask() ? CompareMOButtonEditorAndRenderer.FocusTraversal.BACKWARD : CompareMOButtonEditorAndRenderer.FocusTraversal.FORWARD;
            boolean bl = isCellDisabledOrTraversalEnded = !cellEditor.transferFocus(forwardOrBackward);
            if (isTabPressedOnMergeColumn && (isCellDisabledOrTraversalEnded || !table.isCellEditable(row, column))) {
                defaultTabBehavior.actionPerformed(event);
            } else if (isCellDisabledOrTraversalEnded) {
                cellEditor.stopCellEditing();
            }
        }
    }

    public static enum TabAction {
        SELECT_NEXT_COLUMN_CELL("selectNextColumnCell", false),
        SELECT_PREVIOUS_COLUMN_CELL("selectPreviousColumnCell", true);

        private String myActionName;
        private boolean myHasShiftMask;

        private TabAction(String actionName, boolean hasShiftMask) {
            this.myActionName = actionName;
            this.myHasShiftMask = hasShiftMask;
        }

        public String getActionName() {
            return this.myActionName;
        }

        public boolean hasShiftMask() {
            return this.myHasShiftMask;
        }
    }
}

