/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.raml.edit.comparemo;

import com.nokia.em.poseidon.frameworks.raml.RAMLParameter;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLMetaParameter;
import com.nokia.em.poseidon.frameworks.raml.metadata.logical.RAMLLogicalValidatorBase;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLBit;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLBitList;
import com.nokia.em.poseidon.gui.raml.edit.RAMLNode;
import com.nokia.widgets.table.PCellStatusTableModel;
import java.util.List;
import javax.swing.table.DefaultTableModel;

public class CompareMOTableModel
extends DefaultTableModel
implements PCellStatusTableModel {
    private RAMLNode myFirstNode;
    private RAMLNode mySecondNode;
    private boolean myFirstNodeModified;
    private boolean mySecondNodeModified;
    protected boolean mySortedAlphabeticallyFlag = true;
    protected boolean mySortedRelatedFunctionFlag = false;
    protected boolean mySortedCreationPriorityFlag = false;
    private boolean myShowingAllFlag = false;

    public CompareMOTableModel(Object[][] data, String[] columnNames, RAMLNode firstNode, RAMLNode secondNode) {
        super(data, columnNames);
        this.myFirstNode = firstNode;
        this.mySecondNode = secondNode;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        Object value = this.getValueAt(rowIndex, 0);
        if (value instanceof RAMLBit) {
            if (((RAMLBit)value).isFixed()) {
                return false;
            }
            return columnIndex == 1 || columnIndex == 2 || columnIndex == 3;
        }
        RAMLMetaParameter metaParameter = (RAMLMetaParameter)value;
        if (metaParameter.getValueType() instanceof RAMLBitList) {
            return false;
        }
        if (metaParameter.isUnChangeable()) {
            return false;
        }
        if (metaParameter.isSetByTheSystem()) {
            return false;
        }
        if (metaParameter.isLocked()) {
            return false;
        }
        if (metaParameter.isInstanceParameter()) {
            return false;
        }
        return columnIndex == 1 || columnIndex == 2 || columnIndex == 3;
    }

    private void setModifiedFlag(int columnIndex) {
        if (columnIndex == 1) {
            this.myFirstNodeModified = true;
        } else if (columnIndex == 3) {
            this.mySecondNodeModified = true;
        }
    }

    public void resetModifiedFlag(int columnIndex) {
        if (columnIndex == 1) {
            this.myFirstNodeModified = false;
        } else if (columnIndex == 3) {
            this.mySecondNodeModified = false;
        }
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        super.setValueAt(aValue, row, column);
        if (this.isValueChanged(row, column)) {
            this.setModifiedFlag(column);
        }
        if (this.getValueAt(row, 0) instanceof RAMLBit) {
            int parentRow = (Integer)this.getValueAt(row, 4);
            String value = this.getNewBitListValue(aValue, row, column, parentRow);
            this.setValueAt(value, parentRow, column);
        }
    }

    private String getNewBitListValue(Object bitValue, int row, int column, int parentRow) {
        RAMLMetaParameter parent = (RAMLMetaParameter)this.getValueAt(parentRow, 0);
        List[] list = (List[])this.getValueAt(parentRow, 4);
        List currentSelection = column == 1 ? list[0] : list[1];
        currentSelection.set(row - parentRow - 1, Boolean.parseBoolean((String)bitValue));
        RAMLBitList bit = (RAMLBitList)parent.getValueType();
        boolean[] selections = new boolean[currentSelection.size()];
        int index = 0;
        while (index < selections.length) {
            selections[index] = (Boolean)currentSelection.get(index);
            ++index;
        }
        String value = String.valueOf(bit.generateBitValue(selections));
        return value;
    }

    public boolean isValueChanged(int row, int column) {
        RAMLNode node = this.getColumnNode(column);
        Object thisData = this.getValueAt(row, column);
        if (node == null) {
            return false;
        }
        Object cellContent = this.getValueAt(row, 0);
        if (cellContent instanceof RAMLBit) {
            RAMLBit bit = (RAMLBit)cellContent;
            int parentRow = (Integer)this.getValueAt(row, 4);
            RAMLParameter parameter = node.getParameter(((RAMLMetaParameter)this.getValueAt(parentRow, 0)).getName());
            boolean cellValue = bit.isBitOn(Integer.parseInt(parameter.getValue()));
            return !thisData.equals(cellValue ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
        }
        RAMLMetaParameter metaParam = (RAMLMetaParameter)cellContent;
        if (metaParam == null || metaParam.isSetByTheSystem()) {
            return false;
        }
        if (metaParam.isInstanceParameter()) {
            String id = node.getId();
            boolean changed = !id.equals(thisData);
            return changed;
        }
        RAMLParameter parameter = node.getParameter(metaParam.getName());
        if (parameter == null || parameter.getValue() == null || "".equals(parameter.getValue())) {
            return this.getValueAt(row, column) != null && !"".equals(this.getValueAt(row, column));
        }
        String uiValue = RAMLLogicalValidatorBase.getUIValue(parameter);
        return !uiValue.equals(this.getValueAt(row, column));
    }

    private RAMLNode getColumnNode(int column) {
        if (column == 1) {
            return this.myFirstNode;
        }
        if (column == 3) {
            return this.mySecondNode;
        }
        return null;
    }

    public boolean isRowModified(int row) {
        return this.isValueChanged(row, 1) || this.isValueChanged(row, 3);
    }

    public boolean isColumnModified(int column) {
        if (column == 1) {
            return this.myFirstNodeModified;
        }
        if (column == 3) {
            return this.mySecondNodeModified;
        }
        return false;
    }

    public void setColumnNode(int column, RAMLNode node) {
        if (column == 1) {
            this.myFirstNode = node;
        } else if (column == 3) {
            this.mySecondNode = node;
        }
    }

    @Override
    public boolean isCellModified(int row, int column) {
        return this.isValueChanged(row, column);
    }

    @Override
    public boolean isCellWarned(int row, int column) {
        return false;
    }

    public boolean isShowingAll() {
        return this.myShowingAllFlag;
    }

    public void setShowingAll(boolean showingAllFlag) {
        this.myShowingAllFlag = showingAllFlag;
    }

    public boolean isSortedAlphabetically() {
        return this.mySortedAlphabeticallyFlag;
    }

    public void setSortedAlphabetically(boolean isSortedAlphabetically) {
        this.mySortedAlphabeticallyFlag = isSortedAlphabetically;
    }

    public boolean isSortedRelatedFunctionFlag() {
        return this.mySortedRelatedFunctionFlag;
    }

    public void setMySortedRelatedFunctionFlag(boolean isSortedRelatedFunctionFlag) {
        this.mySortedRelatedFunctionFlag = isSortedRelatedFunctionFlag;
    }

    public boolean isSortedCreationPriorityFlag() {
        return this.mySortedCreationPriorityFlag;
    }

    public void setMySortedCreationPriorityFlag(boolean isSortedCreationPriorityFlag) {
        this.mySortedCreationPriorityFlag = isSortedCreationPriorityFlag;
    }
}

