/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.raml.edit.comparemo;

import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.frameworks.raml.RAMLParameter;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLMetaParameter;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLBit;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLBitList;
import com.nokia.em.poseidon.gui.raml.edit.RAMLNode;
import com.nokia.em.poseidon.gui.raml.edit.comparemo.CompareMOButtonEditorAndRenderer;
import com.nokia.em.poseidon.gui.raml.edit.comparemo.CompareMOColumn;
import com.nokia.em.poseidon.gui.raml.edit.comparemo.CompareMOConsolidator;
import com.nokia.em.poseidon.gui.raml.edit.comparemo.CompareMOHandler;
import com.nokia.em.poseidon.gui.raml.edit.comparemo.CompareMOHeader;
import com.nokia.em.poseidon.gui.raml.edit.comparemo.CompareMOHeaderCellRenderer;
import com.nokia.em.poseidon.gui.raml.edit.comparemo.CompareMOHeaderNode;
import com.nokia.em.poseidon.gui.raml.edit.comparemo.CompareMOLabelRenderer;
import com.nokia.em.poseidon.gui.raml.edit.comparemo.CompareMOTable;
import com.nokia.em.poseidon.gui.raml.edit.comparemo.CompareMOTableActions;
import com.nokia.em.poseidon.gui.raml.edit.comparemo.CompareMOTableModel;
import com.nokia.em.poseidon.services.ui.UserInterface;
import com.nokia.widgets.PButtonPane;
import com.nokia.widgets.buttons.PHelpButton;
import com.nokia.widgets.labels.PLabel;
import com.nokia.widgets.table.PDefaultCellEditor;
import com.nokia.widgets.table.PTableHeaderRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import net.miginfocom.swing.MigLayout;

public class CompareMOView
implements ActionListener {
    private static final ResourceBundle RB = I18n.getI18n().getBaseBundle();
    private JButton myCopyLeftToRightButton;
    private JButton myCopyRightToLeftButton;
    private JButton myFinishButton;
    private JButton myCancelButton;
    private CompareMOTable myTable;
    private JComboBox myShowComboBox;
    private JComboBox mySortComboBox;
    private CompareMOTableModel myTableModel;
    private TableRowSorter myTableRowSorter;
    private RAMLNode myFirstNode;
    private RAMLNode mySecondNode;
    private List<RAMLNode> myComparableMOs;
    private JDialog myDialog;
    private PHelpButton myHelpButton;
    private CompareMOHandler myHandler;
    private static final String HELP_ID = "RAML_CompareTo";
    private CompareMOHeader myHeader;

    public CompareMOView(CompareMOHandler handler, String[] strings, Object[][] data, RAMLNode currentNode, RAMLNode targetNode, List<RAMLNode> comparableMOs) {
        this.myHandler = handler;
        this.myDialog = new JDialog(PoseidonRuntime.getRuntime().getService(UserInterface.class).getFrame());
        this.myDialog.setTitle(String.valueOf(RB.getString("RAMLEdit.Compare")) + " " + strings[0]);
        this.myDialog.setModal(true);
        this.setCurrentNode(currentNode);
        this.setTargetNode(targetNode);
        this.setComparableMOs(comparableMOs);
        this.buildUI(strings[1], this.myFirstNode, this.mySecondNode, data);
        this.myDialog.setPreferredSize(new Dimension(735, 400));
        this.myDialog.setMinimumSize(this.myDialog.getPreferredSize());
        this.myDialog.pack();
        this.myDialog.setLocationRelativeTo(null);
    }

    private void buildUI(String path, RAMLNode currentNode, RAMLNode targetNode, Object[][] data) {
        this.myDialog.setLayout(new BorderLayout());
        this.createLabelPanel(path);
        this.createTablePanel(currentNode, targetNode, data);
        this.createButtonPanel();
    }

    private void createLabelPanel(String path) {
        JPanel labelPanel = new JPanel((LayoutManager)new MigLayout("fill, insets n 17 n 17"));
        JLabel showLabel = new JLabel(RB.getString("RAMLEdit.Compare.Show"));
        this.myShowComboBox = new JComboBox();
        this.myShowComboBox.addItem(RB.getString("RAMLEdit.Compare.Show.All"));
        this.myShowComboBox.addItem(RB.getString("RAMLEdit.Compare.Show.Differences"));
        this.myShowComboBox.setSelectedIndex(1);
        JPanel sortPanel = new JPanel((LayoutManager)new MigLayout("insets n n n n"));
        JLabel sortLabel = new JLabel(RB.getString("RAMLEdit.Compare.Sorting"));
        this.mySortComboBox = new JComboBox();
        this.mySortComboBox.addItem(RB.getString("RAMLEdit.Compare.Sorting.Alphabetical"));
        this.mySortComboBox.addItem(RB.getString("RAMLEdit.Compare.Sorting.RelatedFunctions"));
        this.mySortComboBox.addItem(RB.getString("RAMLEdit.Compare.Sorting.CreationPriority"));
        sortPanel.add((Component)showLabel, "dock west");
        sortPanel.add((Component)this.myShowComboBox, "dock west, gapx 11");
        sortPanel.add((Component)this.mySortComboBox, "dock east, gapx 11");
        sortPanel.add((Component)sortLabel, "dock east");
        this.myShowComboBox.addActionListener(this);
        this.mySortComboBox.addActionListener(this);
        JPanel pathPanel = new JPanel((LayoutManager)new MigLayout("insets n 1 n 0"));
        pathPanel.add((Component)new JLabel(RB.getString("RAMLEdit.Compare.Path")), "dock west");
        pathPanel.add((Component)new PLabel(path), "dock west, gapx 10, wmin 10");
        labelPanel.add((Component)pathPanel, "align left");
        labelPanel.add((Component)sortPanel, "align right");
        labelPanel.setName("label");
        this.myDialog.add((Component)labelPanel, "North");
    }

    private void createButtonPanel() {
        this.myCopyLeftToRightButton = new JButton(RB.getString("RAMLEdit.Compare.CopyLeftToRight"));
        this.myCopyLeftToRightButton.setMnemonic(RB.getMnemonic("RAMLEdit.Compare.CopyLeftToRight.Mnemonic"));
        this.myCopyLeftToRightButton.setDisplayedMnemonicIndex(9);
        this.myCopyRightToLeftButton = new JButton(RB.getString("RAMLEdit.Compare.CopyRightToLeft"));
        this.myCopyRightToLeftButton.setMnemonic(RB.getMnemonic("RAMLEdit.Compare.CopyRightToLeft.Mnemonic"));
        this.myFinishButton = new JButton(RB.getString("RAMLEdit.CompareMO.Save_Changes.Text"));
        this.myFinishButton.setMnemonic(RB.getMnemonic("RAMLEdit.CompareMO.Save_Changes.Mnemonic"));
        this.myCancelButton = new JButton(RB.getString("RAMLEdit.Compare.Cancel"));
        this.myCopyLeftToRightButton.addActionListener(this);
        this.myCopyRightToLeftButton.addActionListener(this);
        this.myFinishButton.addActionListener(this);
        this.myCancelButton.addActionListener(this);
        this.myHelpButton = new PHelpButton();
        this.myHelpButton.addActionListener(this);
        PButtonPane buttonPanel = new PButtonPane(new AbstractButton[]{this.myHelpButton, this.myCopyLeftToRightButton, this.myCopyRightToLeftButton}, null, new AbstractButton[]{this.myFinishButton, this.myCancelButton});
        buttonPanel.setName("button");
        this.myDialog.add((Component)buttonPanel, "South");
    }

    private void createTablePanel(RAMLNode firstNode, RAMLNode secondNode, Object[][] data) {
        JPanel tablePanel = new JPanel((LayoutManager)new MigLayout("fill, insets 0 16 n 16"));
        CompareMOConsolidator dataConsolidator = new CompareMOConsolidator(firstNode, secondNode);
        Object[][] realData = dataConsolidator.consolidateAllData(data);
        String[] columnNames = this.getColumnNames(firstNode, secondNode);
        this.myTableModel = new CompareMOTableModel(realData, columnNames, firstNode, secondNode);
        this.myTableRowSorter = new TableRowSorter();
        this.myTable = new CompareMOTable(this.myTableModel);
        this.myTable.setAutoCreateRowSorter(false);
        this.myTable.setRowSorter(this.myTableRowSorter);
        this.myTable.setFocusable(true);
        this.myTableRowSorter.setModel(this.myTable.getModel());
        this.myTable.setSortableForAllColumns(this.myTableRowSorter, false);
        this.configureTable(this.myTable);
        JScrollPane tableScrollPane = new JScrollPane(this.myTable);
        tableScrollPane.setPreferredSize(this.myDialog.getMinimumSize());
        tableScrollPane.setVerticalScrollBarPolicy(20);
        tablePanel.add((Component)tableScrollPane, "grow, shrink");
        this.myHeader = (CompareMOHeader)this.myTable.getTableHeader();
        tablePanel.setName("table");
        this.myDialog.add((Component)tablePanel, "Center");
        this.myTable.showDifferencesOnly();
        this.myTable.sortAlphabetically();
        this.myDialog.addMouseListener(new CompareMOMouseAndComponentAdapter());
        this.myDialog.addComponentListener(new CompareMOComponentAdapter());
    }

    private String[] getColumnNames(RAMLNode currentNode, RAMLNode targetNode) {
        String[] columnNames = new String[]{RB.getString("RAMLEdit.Compare.Table.ParameterName"), currentNode.getName(), RB.getString("RAMLEdit.Compare.Table.Merge"), targetNode.getName(), RB.getString("RAMLEdit.Compare.Table.Range")};
        return columnNames;
    }

    @Deprecated
    protected static String getRAMLParameterUIValue(RAMLNode node, RAMLMetaParameter metaParam) {
        return CompareMOConsolidator.getRAMLParameterUIValue(node, metaParam);
    }

    private void configureTable(JTable table) {
        table.setSelectionMode(0);
        JTableHeader oldHeader = table.getTableHeader();
        table.setTableHeader(new CompareMOHeader(oldHeader, this.myComparableMOs));
        TableColumnModel columnModel = table.getColumnModel();
        this.modifyColumnModel(columnModel);
        this.initializeColumn(columnModel, 0, (TableCellRenderer)new CompareMOLabelRenderer(), 160);
        this.initializeColumn(columnModel, 2, new CompareMOButtonEditorAndRenderer(), new CompareMOButtonEditorAndRenderer(), 30);
        this.initializeColumn(columnModel, 4, new CompareMOLabelRenderer());
        this.initializeNodeHeader(columnModel);
        PTableHeaderRenderer headerRendererForMergeColumn = new PTableHeaderRenderer();
        headerRendererForMergeColumn.setHorizontalAlignment(0);
        columnModel.getColumn(2).setHeaderRenderer(headerRendererForMergeColumn);
        table.setPreferredScrollableViewportSize(table.getPreferredSize());
        CompareMOTableActions.handleTabActionOnMergeColumn(table, CompareMOTableActions.TabAction.SELECT_NEXT_COLUMN_CELL);
        CompareMOTableActions.handleTabActionOnMergeColumn(table, CompareMOTableActions.TabAction.SELECT_PREVIOUS_COLUMN_CELL);
        CompareMOTableActions.overrideEnterKeyEventOnMergeColumn(table);
    }

    private void modifyColumnModel(TableColumnModel columnModel) {
        int count = columnModel.getColumnCount();
        TableColumn[] oldColumns = new TableColumn[count];
        CompareMOColumn firstNodeColumn = new CompareMOColumn();
        firstNodeColumn.copyValues(columnModel.getColumn(1));
        CompareMOColumn secondNodeColumn = new CompareMOColumn();
        secondNodeColumn.copyValues(columnModel.getColumn(3));
        int index = 0;
        while (index < count) {
            oldColumns[index] = columnModel.getColumn(index);
            ++index;
        }
        index = 0;
        while (index < count) {
            columnModel.removeColumn(oldColumns[index]);
            ++index;
        }
        index = 0;
        while (index < count) {
            if (index == 1) {
                columnModel.addColumn(firstNodeColumn);
            } else if (index == 3) {
                columnModel.addColumn(secondNodeColumn);
            } else {
                columnModel.addColumn(oldColumns[index]);
            }
            ++index;
        }
    }

    private void initializeNodeHeader(TableColumnModel columnModel) {
        this.setHeaderEditorAndRenderer(columnModel, 1, this.myFirstNode);
        this.setHeaderEditorAndRenderer(columnModel, 3, this.mySecondNode);
    }

    private void setHeaderEditorAndRenderer(TableColumnModel columnModel, int index, RAMLNode currentNode) {
        JComboBox<CompareMOHeaderNode> comboBox = new JComboBox<CompareMOHeaderNode>();
        for (RAMLNode node : this.myComparableMOs) {
            comboBox.addItem(new CompareMOHeaderNode(node));
        }
        TableColumn column = columnModel.getColumn(index);
        if (column instanceof CompareMOColumn) {
            ((CompareMOColumn)column).setHeaderValue(new CompareMOHeaderNode(currentNode));
            ((CompareMOColumn)column).setHeaderRenderer(new CompareMOHeaderCellRenderer());
            ((CompareMOColumn)column).setHeaderEditor(new PDefaultCellEditor((JComboBox)comboBox));
        }
    }

    private void initializeColumn(TableColumnModel columnModel, int index, TableCellRenderer cellRenderer, int width) {
        this.initializeColumn(columnModel, index, cellRenderer);
        columnModel.getColumn(index).setPreferredWidth(width);
    }

    private void initializeColumn(TableColumnModel columnModel, int index, TableCellRenderer cellRenderer) {
        columnModel.getColumn(index).setCellRenderer(cellRenderer);
    }

    private void initializeColumn(TableColumnModel columnModel, int index, TableCellRenderer cellRenderer, TableCellEditor cellEditor) {
        this.initializeColumn(columnModel, index, cellRenderer);
        columnModel.getColumn(index).setCellEditor(cellEditor);
    }

    private void initializeColumn(TableColumnModel columnModel, int index, TableCellRenderer cellRenderer, TableCellEditor cellEditor, int width) {
        this.initializeColumn(columnModel, index, cellRenderer, cellEditor);
        columnModel.getColumn(index).setPreferredWidth(width);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source instanceof JButton) {
            this.doButtonAction(source);
        } else if (source instanceof JComboBox) {
            this.doComboBoxAction(source);
        }
    }

    private void doComboBoxAction(Object source) {
        JComboBox comboBox = (JComboBox)source;
        if (source.equals(this.myShowComboBox)) {
            String showSelection = (String)comboBox.getSelectedItem();
            if (RB.getString("RAMLEdit.Compare.Show.All").equals(showSelection)) {
                this.myTable.showAllCells();
            } else if (RB.getString("RAMLEdit.Compare.Show.Differences").equals(showSelection)) {
                this.myTable.showDifferencesOnly();
            }
        } else if (source.equals(this.mySortComboBox)) {
            String sortSelection = (String)comboBox.getSelectedItem();
            if (RB.getString("RAMLEdit.Compare.Sorting.Alphabetical").equals(sortSelection)) {
                if (!this.myTableModel.isSortedAlphabetically()) {
                    this.myTable.sortAlphabetically();
                }
            } else if (RB.getString("RAMLEdit.Compare.Sorting.RelatedFunctions").equals(sortSelection)) {
                if (!this.myTableModel.isSortedRelatedFunctionFlag()) {
                    this.myTable.sortByRelatedFunctions();
                }
            } else if (RB.getString("RAMLEdit.Compare.Sorting.CreationPriority").equals(sortSelection) && !this.myTableModel.isSortedCreationPriorityFlag()) {
                this.myTable.sortByCreationPriority();
            }
        }
    }

    private void doButtonAction(Object source) {
        if (source.equals(this.myCopyLeftToRightButton)) {
            int i = 0;
            while (i < this.myTable.getRowCount()) {
                if (this.isRowCopyEnabled(i)) {
                    this.myTable.setValueAt(this.myTable.getValueAt(i, 1), i, 3);
                }
                ++i;
            }
            this.myTable.repaint();
        } else if (source.equals(this.myCopyRightToLeftButton)) {
            int i = 0;
            while (i < this.myTable.getRowCount()) {
                if (this.isRowCopyEnabled(i)) {
                    this.myTable.setValueAt(this.myTable.getValueAt(i, 3), i, 1);
                }
                ++i;
            }
            this.myTable.repaint();
        } else if (source.equals(this.myFinishButton)) {
            this.prepareUpdateTreeModel();
            this.myDialog.dispose();
        } else if (source.equals(this.myCancelButton)) {
            this.myDialog.dispose();
        } else if (source instanceof PHelpButton) {
            this.myHandler.showHelp(this.getDialog(), HELP_ID);
        }
    }

    private boolean isRowCopyEnabled(int i) {
        Object cellContent = this.myTable.getValueAt(i, 0);
        if (cellContent instanceof RAMLBit) {
            RAMLBit bit = (RAMLBit)cellContent;
            return !bit.isFixed();
        }
        RAMLMetaParameter metaParam = (RAMLMetaParameter)cellContent;
        return CompareMOView.isParameterCopyable(metaParam);
    }

    protected static boolean isParameterCopyable(RAMLMetaParameter metaParameter) {
        return metaParameter != null && !(metaParameter.getValueType() instanceof RAMLBitList) && !metaParameter.isInstanceParameter() && !metaParameter.isSetByTheSystem() && !metaParameter.isLocked() && !metaParameter.isUnChangeable();
    }

    private void prepareUpdateTreeModel() {
        TableColumnModel columnModel = this.myTable.getColumnModel();
        this.updateTreeModel(columnModel, 1);
        this.updateTreeModel(columnModel, 3);
    }

    protected void updateTreeModel(TableColumnModel columnModel, int index) {
        TableColumn column = columnModel.getColumn(index);
        RAMLNode node = CompareMOView.getNodeFromGroup((CompareMOHeaderNode)column.getHeaderValue(), this.myComparableMOs);
        this.updateTreeModelNode(node, index);
    }

    protected static RAMLNode getNodeFromGroup(CompareMOHeaderNode header, List<RAMLNode> comparableMOs) {
        for (RAMLNode node : comparableMOs) {
            if (!node.equals(header.getNode())) continue;
            return node;
        }
        return null;
    }

    private void updateTreeModelNode(RAMLNode thisNode, int column) {
        int rowCount = this.myTable.getRowCount();
        int row = 0;
        while (row < rowCount) {
            RAMLMetaParameter metaParam;
            if (!(this.myTable.getValueAt(row, 0) instanceof RAMLBit) && !(metaParam = (RAMLMetaParameter)this.myTable.getValueAt(row, 0)).isSetByTheSystem()) {
                String name;
                RAMLParameter param;
                String newValue = this.myTable.getValueAt(row, column).toString();
                String currentValue = metaParam.isInstanceParameter() ? thisNode.getId() : ((param = thisNode.getParameter(name = metaParam.getName())) == null ? "" : param.getValue());
                if (currentValue == null && newValue != null || !currentValue.equals(newValue)) {
                    thisNode.setValue(metaParam, newValue);
                }
            }
            ++row;
        }
    }

    public JDialog getDialog() {
        return this.myDialog;
    }

    public void showDialog() {
        this.myDialog.setVisible(true);
    }

    public void setComparableMOs(List<RAMLNode> comparableMOs) {
        this.myComparableMOs = comparableMOs;
    }

    public void setCurrentNode(RAMLNode currentNode) {
        this.myFirstNode = currentNode;
    }

    public void setTargetNode(RAMLNode targetNode) {
        this.mySecondNode = targetNode;
    }

    private void stopCellEditing() {
        if (this.myHeader != null && this.myHeader.isEditing()) {
            this.myHeader.getCellEditor().stopCellEditing();
        }
    }

    private class CompareMOComponentAdapter
    extends ComponentAdapter {
        private CompareMOComponentAdapter() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            CompareMOView.this.stopCellEditing();
        }
    }

    private class CompareMOMouseAndComponentAdapter
    extends MouseAdapter {
        private CompareMOMouseAndComponentAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            CompareMOView.this.stopCellEditing();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            CompareMOView.this.stopCellEditing();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            CompareMOView.this.stopCellEditing();
        }
    }
}

