/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.raml.edit.pddbbrowser;

import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLMetaDataFile;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLMetaManagedObject;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLMetaParameter;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLRelatedParameter;
import com.nokia.em.poseidon.gui.raml.edit.pddbbrowser.PDDBBrowserView;
import com.nokia.em.poseidon.gui.savechooser.SaveChooserController;
import com.nokia.em.poseidon.gui.savechooser.SaveChooserFactory;
import com.nokia.em.poseidon.gui.savechooser.SaveChooserModel;
import com.nokia.em.poseidon.services.help.PHelp;
import com.nokia.em.poseidon.util.PSettings;
import com.nokia.em.poseidon.util.file.PFileFilter;
import com.nokia.widgets.infotip.InfoTip;
import java.awt.Container;
import java.awt.Window;
import java.util.Stack;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.apache.log4j.Logger;

public class PDDBBrowserController
implements HyperlinkListener {
    private Stack<String> myBack = new Stack();
    private String myCurrentDistName = "";
    private Stack<String> myForward = new Stack();
    private PHelp myHelpService;
    private Logger myLogger = Logger.getLogger(this.getClass());
    private RAMLMetaDataFile myMetaDataFile = null;
    private SaveChooserController mySaveChooserController;
    private SaveChooserModel mySaveChooserModel;
    private PDDBBrowserView myView = null;

    public PDDBBrowserController(Container container) {
        this.myView = container instanceof Window ? new PDDBBrowserView(this, (Window)container) : new PDDBBrowserView(this);
        this.mySaveChooserModel = new SaveChooserModel();
        this.mySaveChooserModel.setDialogTitleKey("PDDB_Parameter_BrowserSaveAsDialog_Title");
        this.mySaveChooserModel.setDefaultFileName("Parameter.html");
        this.mySaveChooserModel.setSettings(PSettings.getInstance());
        this.mySaveChooserModel.setSettingsKey("btsgui.pddbBrowserContentSaveKey");
        this.mySaveChooserModel.setFileFilter(new PFileFilter(new String[]{"html", "htm"}, "HTML Files"));
    }

    protected boolean isBackwardButtonEnabled() {
        return !this.myBack.isEmpty();
    }

    protected void backAction() {
        if (this.myBack.isEmpty()) {
            return;
        }
        String back = this.myBack.pop();
        this.myForward.push(this.myCurrentDistName);
        this.myCurrentDistName = back;
        this.openPDDBLink(back);
    }

    protected void clearHistory() {
        this.myBack.clear();
        this.myForward.clear();
        this.myCurrentDistName = "";
    }

    public void disposeView() {
        this.myView.setVisible(false);
        this.myView.dispose();
    }

    protected void forwardAction() {
        if (this.myForward.isEmpty()) {
            return;
        }
        String forward = this.myForward.pop();
        this.myBack.push(this.myCurrentDistName);
        this.myCurrentDistName = forward;
        this.openPDDBLink(forward);
    }

    protected boolean isForwardButtonEnabled() {
        return !this.myForward.isEmpty();
    }

    protected SaveChooserController getSaveChooserController() {
        return this.mySaveChooserController;
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && this.myMetaDataFile != null) {
            String distName;
            Container container;
            Object source = e.getSource();
            if (source instanceof JEditorPane && (container = ((JEditorPane)source).getParent()) instanceof InfoTip) {
                ((InfoTip)container).setVisible(false);
            }
            if (!this.myCurrentDistName.equals(distName = e.getDescription())) {
                this.pushToBack(distName);
                this.myForward.clear();
            }
            this.openPDDBLink(distName);
            this.myCurrentDistName = distName;
        }
    }

    public void init(RAMLMetaDataFile metaDataFile) {
        this.myMetaDataFile = metaDataFile;
        if (this.mySaveChooserController == null) {
            this.mySaveChooserController = SaveChooserFactory.createFileChooserController(this.mySaveChooserModel, this.myView);
            this.mySaveChooserModel.setDefaultPath(PoseidonRuntime.getRuntime().getUserHome());
        }
    }

    private void openPDDBLink(String distName) {
        String[] name = distName.split("\\.");
        RAMLMetaManagedObject metaMo = this.myMetaDataFile.getMetaManagedObject(name[0]);
        if (metaMo == null) {
            this.myLogger.debug("Managed object " + name[0] + " is not found and cannot be opened.");
            return;
        }
        if (name.length == 1) {
            this.myView.showMO(metaMo);
            return;
        }
        RAMLMetaParameter metaParam = null;
        metaParam = name.length == 3 ? metaMo.getMetaParameterFromList(name[1], name[2]) : metaMo.getMetaParameter(name[1]);
        if (metaParam == null) {
            this.myLogger.debug("Parameter " + distName + " is not found and cannot be opened.");
            return;
        }
        this.myView.showParameter(metaParam);
    }

    private void pushToBack(String distName) {
        if (distName.isEmpty() || this.myCurrentDistName.isEmpty()) {
            return;
        }
        if (this.myBack.isEmpty() || !this.myBack.peek().equals(this.myCurrentDistName)) {
            this.myBack.push(this.myCurrentDistName);
        }
    }

    protected void showHelp(String helpID) {
        if (this.myHelpService == null) {
            this.myHelpService = PoseidonRuntime.getRuntime().getService(PHelp.class);
        }
        if (this.myHelpService != null) {
            this.myHelpService.showHelp(helpID);
        }
    }

    protected boolean isMOExisting(String moName) {
        return this.myMetaDataFile.getMetaManagedObject(moName) != null;
    }

    protected boolean isExisting(RAMLRelatedParameter relatedParam) {
        String moName = relatedParam.getClassName();
        String listName = relatedParam.getListName();
        String name = relatedParam.getParamName();
        RAMLMetaManagedObject metaMo = this.myMetaDataFile.getMetaManagedObject(moName);
        if (metaMo == null) {
            return false;
        }
        RAMLMetaParameter metaParam = null;
        metaParam = listName != null && !listName.isEmpty() ? metaMo.getMetaParameterFromList(listName, name) : metaMo.getMetaParameter(name);
        return metaParam != null;
    }

    public void setSearchText(String text) {
        this.myView.setSearchText(text);
    }
}

