/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.raml.edit.pddbbrowser;

import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.frameworks.i18n.localizer.Localizer;
import com.nokia.em.poseidon.frameworks.i18n.localizer.LocalizerRegistry;
import com.nokia.em.poseidon.frameworks.i18n.localizer.swing.SwingHierarchyIterator;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLDescription;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLFeature;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLMetaManagedObject;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLMetaParameter;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLReference;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLRelatedParameter;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLRelatedParams;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLBitList;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLBoolean;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLComplexType;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLDecimal;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLDefaultValue;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLEnum;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLInteger;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLSimpleType;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLSpecialValue;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLString;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLValue;
import com.nokia.em.poseidon.gui.raml.edit.RAMLEditComponentFactory;
import com.nokia.em.poseidon.gui.raml.edit.pddbbrowser.PDDBBrowserController;
import com.nokia.em.poseidon.gui.savechooser.SaveChooserController;
import com.nokia.em.poseidon.util.TextUtils;
import com.nokia.em.poseidon.util.file.IOUtils;
import com.nokia.laf.text.NetHTMLEditorKit;
import com.nokia.widgets.PButtonPane;
import com.nokia.widgets.buttons.PHelpButton;
import com.nokia.widgets.text.PTextPane;
import com.nokia.widgets.text.search.TextPaneSearchBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import net.miginfocom.swing.MigLayout;
import org.apache.log4j.Logger;

public class PDDBBrowserView
extends JDialog
implements ActionListener {
    private static final String BACK_BUTTON = "PDDB_Parameter_BackButton";
    private static final String CLOSE_BUTTON = "PDDB.Parameter.CloseButton";
    private static final String FORWARD_BUTTON = "PDDB_Parameter_ForwardButton";
    private static final String HELP_BUTTON = "PDDB.Parameter.HelpButton";
    private static final String HELP_ID = "BTS_ShowMoreDetails";
    private static final String PRINT_BUTTON = "PDDB.Parameter.PrintButton";
    private static final ResourceBundle RB = I18n.getI18n().getBaseBundle();
    private static final String SAVE_AS_BUTTON = "PDDB.Parameter.SaveAsButton";
    private static final long serialVersionUID = 2679017055747223040L;
    private PDDBBrowserController myController;
    private PTextPane myTextPane;
    private Logger myLogger = Logger.getLogger(this.getClass());
    private JButton myBackButton;
    private JButton myCloseButton;
    private JButton myForwardButton;
    private DecimalFormat myDecimalFormatter = new DecimalFormat();
    private DecimalFormat myIntegerFormatter = new DecimalFormat();
    private TextPaneSearchBar mySearchBar;

    private static String generateDistName(RAMLRelatedParameter relatedParam) {
        StringBuilder sb = new StringBuilder(relatedParam.getClassName());
        sb.append(".");
        String listName = relatedParam.getListName();
        if (listName != null && !listName.isEmpty()) {
            sb.append(listName);
            sb.append(".");
        }
        sb.append(relatedParam.getParamName());
        return sb.toString();
    }

    protected PDDBBrowserView(PDDBBrowserController pddbBrowserController, Window window) {
        super(window, RB.getString("PDDB_Parameter_Browser_Title"));
        this.myController = pddbBrowserController;
        this.myDecimalFormatter.setGroupingUsed(false);
        this.myIntegerFormatter.setGroupingUsed(false);
        this.myIntegerFormatter.setMaximumFractionDigits(0);
        this.buildUI();
    }

    public PDDBBrowserView(PDDBBrowserController pddbBrowserController) {
        this.setTitle(RB.getString("PDDB_Parameter_Browser_Title"));
        this.myController = pddbBrowserController;
        this.buildUI();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JButton) {
            String buttonName = ((JButton)e.getSource()).getName();
            if (CLOSE_BUTTON.equals(buttonName)) {
                this.setVisible(false);
            } else if (BACK_BUTTON.equals(buttonName)) {
                this.myController.backAction();
                this.updateHistoryButtonsState();
            } else if (FORWARD_BUTTON.equals(buttonName)) {
                this.myController.forwardAction();
                this.updateHistoryButtonsState();
            } else if (PRINT_BUTTON.equals(buttonName)) {
                this.print();
            } else if (SAVE_AS_BUTTON.equals(buttonName)) {
                this.save();
            } else if (HELP_BUTTON.equals(buttonName)) {
                this.myController.showHelp(HELP_ID);
            }
        }
    }

    private void appendRAMLDecimal(StringBuilder builder, RAMLDecimal value) {
        builder.append(TextUtils.format(RB.getString("PDDB_Parameter_Content_Type"), "Decimal"));
        if (value.getDefaultValue() != null && ((RAMLDefaultValue)value.getDefaultValue()).getValue() != null) {
            builder.append(TextUtils.format(RB.getString("PDDB_Parameter_Content_DefaultValue"), this.myDecimalFormatter.format(((RAMLDefaultValue)value.getDefaultValue()).getValue())));
        }
        if (value.getMinValue() != null) {
            builder.append(TextUtils.format(RB.getString("PDDB_Parameter_Content_MinValue"), this.myDecimalFormatter.format(value.getMinValue())));
        }
        if (value.getMaxValue() != null) {
            builder.append(TextUtils.format(RB.getString("PDDB_Parameter_Content_MaxValue"), this.myDecimalFormatter.format(value.getMaxValue())));
        }
        if (value.getStep() != null) {
            builder.append(TextUtils.format(RB.getString("PDDB_Parameter_Content_StepValue"), this.myDecimalFormatter.format(value.getStep())));
        }
        Number multiplier = (Number)value.getMultiplier();
        Number divisor = (Number)value.getDivisor();
        Number shift = (Number)value.getShift();
        if (multiplier.doubleValue() != 1.0 || divisor.doubleValue() != 1.0 || shift.doubleValue() != 0.0) {
            builder.append(RB.getString("PDDB_Parameter_Content_UIConversion_Label"));
            builder.append(TextUtils.format(RB.getString("PDDB_Parameter_Content_UIConversion_Text"), this.myDecimalFormatter.format(multiplier), this.myDecimalFormatter.format(divisor), this.myDecimalFormatter.format(shift)));
        }
        if (value.getSpecialValues().size() > 0) {
            builder.append(RB.getString("PDDB_Parameter_Content_SpecialValue_Label"));
            int i = 0;
            Iterator<RAMLSpecialValue<Double>> iterator = value.getSpecialValues().iterator();
            while (iterator.hasNext()) {
                if (i > 0) {
                    builder.append(", ");
                }
                RAMLSpecialValue<Double> tmp = iterator.next();
                builder.append(TextUtils.format(RB.getString("PDDB_Parameter_Content_SpecialValue"), tmp.getValue(), tmp.getText()));
                ++i;
            }
        }
    }

    private void appendRAMLEnum(StringBuilder builder, RAMLEnum value) {
        builder.append(TextUtils.format(RB.getString("PDDB_Parameter_Content_Type"), "Enumeration"));
        int[] indices = value.getIndexes();
        HashMap<Integer, String> enumMap = new HashMap<Integer, String>();
        int i = 0;
        while (i < indices.length) {
            int index = indices[i];
            enumMap.put(index, value.getText(index));
            ++i;
        }
        if (value.getDefaultValue() != null && ((RAMLDefaultValue)value.getDefaultValue()).getValue() != null) {
            builder.append(TextUtils.format(RB.getString("PDDB_Parameter_Content_DefaultValue"), (String)enumMap.get(((RAMLDefaultValue)value.getDefaultValue()).getValue())));
        }
        builder.append("Enumeration: <br>");
        i = 0;
        while (i < indices.length) {
            builder.append(TextUtils.format(RB.getString("PDDB_Parameter_Content_EnumValue"), (String)enumMap.get(indices[i])));
            ++i;
        }
        List<RAMLSpecialValue<Integer>> specialValues = value.getSpecialValues();
        this.appendIntegerSpecialValue(builder, specialValues);
    }

    private void appendRAMLBoolean(StringBuilder builder, RAMLBoolean value) {
        builder.append(TextUtils.format(RB.getString("PDDB_Parameter_Content_Type"), "Boolean"));
        if (value.getDefaultValue() != null && ((RAMLDefaultValue)value.getDefaultValue()).getValue() != null) {
            builder.append(TextUtils.format(RB.getString("PDDB_Parameter_Content_DefaultValue"), ((RAMLDefaultValue)value.getDefaultValue()).getValue()));
        }
    }

    private void appendRAMLInteger(StringBuilder builder, RAMLInteger value) {
        builder.append(TextUtils.format(RB.getString("PDDB_Parameter_Content_Type"), "Integer"));
        if (value.getDefaultValue() != null && ((RAMLDefaultValue)value.getDefaultValue()).getValue() != null) {
            builder.append(TextUtils.format(RB.getString("PDDB_Parameter_Content_DefaultValue"), this.myIntegerFormatter.format(((RAMLDefaultValue)value.getDefaultValue()).getValue())));
        }
        if (value.getMinValue() != null) {
            builder.append(TextUtils.format(RB.getString("PDDB_Parameter_Content_MinValue"), this.myIntegerFormatter.format(value.getMinValue())));
        }
        if (value.getMaxValue() != null) {
            builder.append(TextUtils.format(RB.getString("PDDB_Parameter_Content_MaxValue"), this.myIntegerFormatter.format(value.getMaxValue())));
        }
        if (value.getStep() != null) {
            builder.append(TextUtils.format(RB.getString("PDDB_Parameter_Content_StepValue"), this.myIntegerFormatter.format(value.getStep())));
        }
        List<RAMLSpecialValue<Integer>> specialValues = value.getSpecialValues();
        this.appendIntegerSpecialValue(builder, specialValues);
    }

    private void appendRAMLString(StringBuilder builder, RAMLString value) {
        builder.append(TextUtils.format(RB.getString("PDDB_Parameter_Content_Type"), "String"));
        if (value.getFixedLength() != -1) {
            builder.append(TextUtils.format(RB.getString("PDDB_Parameter_Content_FixedLength"), this.myIntegerFormatter.format(value.getFixedLength())));
        } else {
            builder.append(TextUtils.format(RB.getString("PDDB_Parameter_Content_MaxLength"), this.myIntegerFormatter.format(value.getMaxLength())));
        }
    }

    private void appendIntegerSpecialValue(StringBuilder builder, List<RAMLSpecialValue<Integer>> specialValues) {
        if (specialValues.size() > 0) {
            builder.append(RB.getString("PDDB_Parameter_Content_SpecialValue_Label"));
            int i = 0;
            Iterator<RAMLSpecialValue<Integer>> iterator = specialValues.iterator();
            while (iterator.hasNext()) {
                RAMLSpecialValue<Integer> specialValue;
                if (i > 0) {
                    builder.append(", ");
                }
                if ((specialValue = iterator.next()).getValue() != null) {
                    builder.append(TextUtils.format(RB.getString("PDDB_Parameter_Content_SpecialValue"), this.myIntegerFormatter.format(specialValue.getValue()), specialValue.getText()));
                }
                ++i;
            }
        }
    }

    private void appendRelatedParameters(StringBuilder sb, RAMLRelatedParams relatedParams) {
        List<RAMLRelatedParameter> relatedParamsList = relatedParams.getRelatedParams();
        Collections.sort(relatedParamsList);
        if (relatedParams.getRelatedParams().size() > 0) {
            sb.append("<tr>");
            sb.append("<td  valign=\"top\" class=\"label\">");
            sb.append(RB.getString("PDDB_Parameter_Content_Param_RelatedParamsLabel"));
            sb.append(":</td><td>");
            for (RAMLRelatedParameter relatedParam : relatedParams.getRelatedParams()) {
                if (this.myController.isExisting(relatedParam)) {
                    String distName = PDDBBrowserView.generateDistName(relatedParam);
                    sb.append("<a href=\"" + distName + "\">");
                    sb.append(relatedParam.getParamName());
                    sb.append("</a>");
                } else {
                    sb.append(relatedParam.getParamName());
                }
                sb.append(" in ");
                String moName = relatedParam.getClassName();
                if (this.myController.isMOExisting(moName)) {
                    sb.append("<a href=\"" + moName + "\">");
                    sb.append(moName);
                    sb.append("</a>");
                } else {
                    sb.append(moName);
                }
                if (relatedParam.getDescription() != null) {
                    sb.append(" " + TextUtils.encodeToHTMLSourceCode(relatedParam.getDescription().getDescription()));
                }
                sb.append("<br>");
            }
            sb.append("</td>");
            sb.append("</tr>");
            if (relatedParams.getDescription() != null) {
                sb.append("<tr>");
                sb.append("<td valign=\"top\"  valign=\"top\" class=\"label\">");
                sb.append(RB.getString("PDDB_Parameter_Content_Param_RelatedParamsDescLabel"));
                sb.append(":</td><td>");
                List<String> descriptionParagraphs = relatedParams.getDescription().getDescriptionParagraphs();
                for (String descriptionParagraph : descriptionParagraphs) {
                    String line = TextUtils.encodeToHTMLSourceCode(descriptionParagraph);
                    sb.append(line);
                    sb.append("<br>");
                }
            }
            sb.append("</td>");
            sb.append("</tr>");
        }
    }

    private void appendSimpleType(StringBuilder builder, RAMLSimpleType simpleType) {
        builder.append("<tr>");
        builder.append("<td  valign=\"top\" class=\"label\">");
        builder.append(RB.getString("PDDB_Parameter_Content_Range"));
        builder.append(":</td>");
        if (simpleType instanceof RAMLBitList) {
            builder.append("Type: Bit");
        } else if (simpleType instanceof RAMLBoolean) {
            RAMLBoolean value = (RAMLBoolean)simpleType;
            this.appendRAMLBoolean(builder, value);
        } else if (simpleType instanceof RAMLEnum) {
            RAMLEnum value = (RAMLEnum)simpleType;
            this.appendRAMLEnum(builder, value);
        } else if (simpleType instanceof RAMLDecimal) {
            RAMLDecimal value = (RAMLDecimal)simpleType;
            this.appendRAMLDecimal(builder, value);
        } else if (simpleType instanceof RAMLInteger) {
            RAMLInteger value = (RAMLInteger)simpleType;
            this.appendRAMLInteger(builder, value);
        } else if (simpleType instanceof RAMLString) {
            RAMLString value = (RAMLString)simpleType;
            this.appendRAMLString(builder, value);
        } else {
            builder.append("<td>&nbsp;</td>");
        }
        builder.append("</tr>");
    }

    private void buildUI() {
        JPanel parameterPanel = new JPanel((LayoutManager)new MigLayout("fill, insets 5 17 n 17"));
        this.myTextPane = new PTextPane(new HTMLDocument(new StyleSheet()));
        this.myTextPane.addHyperlinkListener(this.myController);
        this.myTextPane.setEditable(false);
        this.myTextPane.setEditorKit(new NetHTMLEditorKit());
        JScrollPane scrollPane = new JScrollPane(this.myTextPane);
        scrollPane.setPreferredSize(new Dimension(700, 300));
        parameterPanel.add((Component)scrollPane, "grow, shrink");
        JButton saveAsButton = new JButton();
        JButton printButton = new JButton();
        this.myBackButton = new JButton();
        this.myForwardButton = new JButton();
        this.myCloseButton = new JButton();
        PHelpButton helpButton = new PHelpButton();
        this.updateHistoryButtonsState();
        saveAsButton.setName(SAVE_AS_BUTTON);
        printButton.setName(PRINT_BUTTON);
        this.myBackButton.setName(BACK_BUTTON);
        this.myBackButton.setToolTipText(RB.getString("PDDB_Parameter_BackButton_Tooltip"));
        this.myForwardButton.setName(FORWARD_BUTTON);
        this.myForwardButton.setToolTipText(RB.getString("PDDB_Parameter_ForwardButton_Tooltip"));
        this.myCloseButton.setName(CLOSE_BUTTON);
        helpButton.setName(HELP_BUTTON);
        saveAsButton.addActionListener(this);
        printButton.addActionListener(this);
        this.myBackButton.addActionListener(this);
        this.myForwardButton.addActionListener(this);
        this.myCloseButton.addActionListener(this);
        helpButton.addActionListener(this);
        PButtonPane bottomPanel = new PButtonPane(new AbstractButton[]{helpButton, saveAsButton, printButton}, new AbstractButton[]{this.myBackButton, this.myForwardButton}, new AbstractButton[]{this.myCloseButton});
        this.mySearchBar = new TextPaneSearchBar(this.myTextPane);
        JPanel searchPanel = new JPanel((LayoutManager)new MigLayout("insets n 17 0 n, gap 4 "));
        searchPanel.add(this.mySearchBar);
        this.setLayout(new BorderLayout());
        this.add((Component)searchPanel, "North");
        this.add((Component)parameterPanel, "Center");
        this.add((Component)bottomPanel, "South");
        this.pack();
        this.setMinimumSize(new Dimension(600, 300));
        this.setLocationRelativeTo(null);
        Localizer localizer = LocalizerRegistry.lookup("swing");
        localizer.setResourceBundle(RB);
        localizer.localizeObjectHierarchy(new SwingHierarchyIterator(this));
    }

    private void updateHistoryButtonsState() {
        this.myBackButton.setEnabled(this.myController.isBackwardButtonEnabled());
        this.myForwardButton.setEnabled(this.myController.isForwardButtonEnabled());
    }

    private void print() {
        try {
            HashPrintRequestAttributeSet attributes = new HashPrintRequestAttributeSet();
            attributes.add(OrientationRequested.LANDSCAPE);
            this.myTextPane.print(null, null, true, null, attributes, true);
        }
        catch (PrinterException e) {
            this.myLogger.error("Error printing the contents", e);
            this.showMessage(0, RB.getString("PDDB_Parameter_BrowserDialog_Title"), RB.getString("PDDB_Parameter_BrowserDialog_PrintError_Text"));
        }
    }

    private void save() {
        String savedText = this.myTextPane.getText().replaceAll("<a", "<span");
        savedText = savedText.replaceAll("</a>", "</span>");
        SaveChooserController mySaveChooserController = this.myController.getSaveChooserController();
        mySaveChooserController.setVisible(true);
        File saveLocation = mySaveChooserController.selectFile();
        if (saveLocation != null) {
            PrintStream ps;
            String savePath;
            if (saveLocation.isDirectory()) {
                if (!saveLocation.exists()) {
                    saveLocation.mkdirs();
                }
                saveLocation = new File(saveLocation, "Paramater.html");
            }
            if (!(savePath = saveLocation.getAbsolutePath()).endsWith(".html") && !savePath.endsWith(".htm")) {
                savePath = String.valueOf(savePath) + ".html";
            }
            try {
                ps = new PrintStream(savePath);
            }
            catch (FileNotFoundException e) {
                this.myLogger.error("Error printing the contents", e);
                this.showMessage(0, RB.getString("PDDB_Parameter_BrowserDialog_Title"), RB.getString("PDDB_Parameter_BrowserDialog_SaveError_Text"));
                return;
            }
            ps.print(savedText);
            IOUtils.closeQuietly(ps);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (!visible) {
            this.myController.clearHistory();
            this.mySearchBar.clearSearchTextField();
        } else {
            this.myCloseButton.requestFocusInWindow();
        }
        super.setVisible(visible);
    }

    private void showMessage(int errorMessage, String title, String message) {
        JOptionPane.showMessageDialog(this, message, title, errorMessage);
    }

    protected void showMO(RAMLMetaManagedObject metaMo) {
        this.mySearchBar.clearSearchTextField();
        StringBuilder sb = new StringBuilder("<html><head><title>");
        sb.append(metaMo.getClassName());
        sb.append("</title></head><body><table>");
        sb.append("<tr>");
        sb.append("<td  valign=\"top\" class=\"label\">");
        sb.append(RB.getString("PDDB_Parameter_Content_MO_NameLabel"));
        sb.append(":</td><td>" + metaMo.getClassName() + "</td>");
        sb.append("</tr>");
        RAMLDescription description = metaMo.getDescription();
        if (description != null) {
            sb.append("<tr>");
            sb.append("<td  valign=\"top\" class=\"label\">");
            sb.append(RB.getString("PDDB_Parameter_Content_MO_DescriptionLabel"));
            sb.append(":</td><td>" + this.appendParagraphs(description) + "</td>");
            sb.append("</tr>");
        }
        List<RAMLMetaParameter> metaParams = metaMo.getMetaParameters();
        Collections.sort(metaParams, new Comparator<RAMLMetaParameter>(){

            @Override
            public int compare(RAMLMetaParameter o1, RAMLMetaParameter o2) {
                if (o1.isInstanceParameter()) {
                    return -1;
                }
                if (o2.isInstanceParameter()) {
                    return 1;
                }
                return o1.getFullName().compareToIgnoreCase(o2.getFullName());
            }
        });
        if (metaParams.size() > 0) {
            sb.append("<tr>");
            sb.append("<td  valign=\"top\" class=\"label\">");
            sb.append(RB.getString("PDDB_Parameter_Content_MO_ParametersLabel"));
            sb.append(":</td><td>");
            for (RAMLMetaParameter metaParam : metaParams) {
                if (!this.isShowable(metaParam)) continue;
                String distName = RAMLEditComponentFactory.generateDistName(metaParam);
                sb.append(metaParam.getFullName());
                sb.append(" - ");
                sb.append("<a href=\"" + distName + "\">");
                sb.append(metaParam.getName());
                sb.append("</a>");
                sb.append("<br>");
            }
            sb.append("</td>");
            sb.append("</tr>");
        }
        sb.append("</table></html>");
        this.myTextPane.setText(sb.toString());
        this.myTextPane.setCaretPosition(0);
        this.updateHistoryButtonsState();
        this.setVisible(true);
    }

    private boolean isShowable(RAMLMetaParameter metaP) {
        return !metaP.isDeleted() && !metaP.isInstanceParameter() && !metaP.isHidden() && metaP.isVisibleInGUI();
    }

    protected void showParameter(RAMLMetaParameter metaParam) {
        this.mySearchBar.clearSearchTextField();
        StringBuilder sb = new StringBuilder("<html><head><title>");
        sb.append(metaParam.getFullName());
        sb.append("</title></head><body><table>");
        sb.append("<tr>");
        sb.append("<td  valign=\"top\" class=\"label\">");
        sb.append(RB.getString("PDDB_Parameter_Content_Param_FullNameLabel"));
        sb.append(":</td><td>" + metaParam.getFullName() + "</td>");
        sb.append("</tr>");
        sb.append("<tr>");
        sb.append("<td  valign=\"top\" class=\"label\">");
        sb.append(RB.getString("PDDB_Parameter_Content_Param_NameLabel"));
        sb.append(":</td><td>" + metaParam.getName() + "</td>");
        sb.append("</tr>");
        this.appendParamDescription(metaParam, sb);
        String moClass = metaParam.getMetaManagedObject().getClassName();
        sb.append("<tr>");
        sb.append("<td  valign=\"top\" class=\"label\">");
        sb.append(RB.getString("PDDB_Parameter_Content_Param_MOLabel"));
        sb.append(":</td><td><a href=\"" + moClass + "\">" + moClass + "</a></td>");
        sb.append("</tr>");
        sb.append("<tr>");
        sb.append("<td  valign=\"top\" class=\"label\">");
        sb.append(RB.getString("PDDB_Parameter_Content_Param_FullnameLabel"));
        sb.append(":</td><td>" + metaParam.getMetaManagedObject().getFullName() + "</td>");
        sb.append("</tr>");
        RAMLValue valueType = (RAMLValue)metaParam.getValueType();
        if (valueType != null) {
            if (valueType instanceof RAMLSimpleType) {
                this.appendSimpleType(sb, (RAMLSimpleType)valueType);
            } else if (valueType instanceof RAMLComplexType) {
                RAMLComplexType complexType = (RAMLComplexType)valueType;
                sb.append("<tr>");
                sb.append("<td  valign=\"top\" class=\"label\">");
                sb.append(RB.getString("PDDB_Parameter_Content_Param_ParamsLabel"));
                sb.append(":</td><td>");
                for (RAMLMetaParameter subParam : complexType.getParameters()) {
                    if (!this.isShowable(subParam)) continue;
                    String distName = RAMLEditComponentFactory.generateDistName(subParam);
                    sb.append("<a href=\"" + distName + "\">");
                    sb.append(subParam.getName());
                    sb.append("</a>");
                    sb.append(" - ");
                    sb.append(subParam.getFullName());
                    sb.append("<br>");
                }
                sb.append("</td>");
                sb.append("</tr>");
            }
        }
        this.appendRelatedParameters(sb, metaParam.getRelatedParameters());
        sb.append("<tr>");
        sb.append("<td  valign=\"top\" class=\"label\">");
        sb.append(RB.getString("PDDB_Parameter_Content_Param_ModTypeLabel"));
        sb.append(":</td><td>");
        if ("objectLocking".equals(metaParam.getModificationType())) {
            sb.append(RB.getString("PDDB_Parameter_Content_Param_ModType_Objectlocking"));
        } else if ("onLine".equals(metaParam.getModificationType())) {
            sb.append(RB.getString("PDDB_Parameter_Content_Param_ModType_Online"));
        } else {
            sb.append(TextUtils.capitalizeFirstLetter(metaParam.getModificationType()));
        }
        sb.append("</td>");
        sb.append("</tr>");
        this.appendParamReferences(metaParam, sb);
        List<String> functions = metaParam.getRelatedFunctions().getFunctions();
        Collections.sort(functions);
        if (functions.size() > 0) {
            sb.append("<tr>");
            sb.append("<td  valign=\"top\" class=\"label\">");
            sb.append(RB.getString("PDDB_Parameter_Content_Param_RelatedFunctionsLabel"));
            sb.append(":</td><td>");
            Iterator<Object> itr = functions.iterator();
            int i = 0;
            while (itr.hasNext()) {
                if (i > 0) {
                    sb.append("<br>");
                }
                sb.append((String)itr.next());
                ++i;
            }
            sb.append("</td>");
            sb.append("</tr>");
        }
        this.appendRelatedFeatures(metaParam, sb);
        this.appendParameterCategories(metaParam, sb);
        this.appendCreationPriority(metaParam, sb);
        sb.append("</table></body></html>");
        this.myTextPane.setText(sb.toString());
        this.myTextPane.scrollToReference("Full name:");
        this.myTextPane.setCaretPosition(0);
        this.updateHistoryButtonsState();
        this.setVisible(true);
    }

    private void appendParamReferences(RAMLMetaParameter metaParam, StringBuilder stringBuilder) {
        List<RAMLReference> references = metaParam.getReferences();
        if (references != null && references.size() > 0) {
            ArrayList<RAMLReference> publicReferences = new ArrayList<RAMLReference>(references.size());
            for (RAMLReference reference : references) {
                if (!reference.isPublic()) continue;
                publicReferences.add(reference);
            }
            if (!publicReferences.isEmpty()) {
                stringBuilder.append("<tr>");
                stringBuilder.append("<td  valign=\"top\" class=\"label\">");
                stringBuilder.append(RB.getString("PDDB_Parameter_Content_Param_3GPPLabel"));
                stringBuilder.append(":</td><td>");
                Iterator itr = publicReferences.iterator();
                int i = 0;
                while (itr.hasNext()) {
                    if (i > 0) {
                        stringBuilder.append("<br>");
                    }
                    stringBuilder.append(((RAMLReference)itr.next()).getText());
                    ++i;
                }
                stringBuilder.append("</td>");
                stringBuilder.append("</tr>");
            }
        }
    }

    private void appendParamDescription(RAMLMetaParameter metaParam, StringBuilder stringBuilder) {
        RAMLDescription paramShortDescription = metaParam.getShortDescription();
        RAMLDescription paramFullDescription = metaParam.getDescription();
        if (paramShortDescription != null && !paramShortDescription.getDescription().trim().equals(paramFullDescription.getDescription().trim())) {
            stringBuilder.append("<tr>");
            stringBuilder.append("<td  valign=\"top\" class=\"label\">");
            stringBuilder.append(RB.getString("PDDB_Parameter_Content_Param_ShortDescLabel"));
            stringBuilder.append(":</td><td>");
            stringBuilder.append(this.appendParagraphs(paramShortDescription));
            stringBuilder.append("</td>");
            stringBuilder.append("</tr>");
        }
        if (paramFullDescription != null) {
            stringBuilder.append("<tr>");
            stringBuilder.append("<td  valign=\"top\" class=\"label\">");
            stringBuilder.append(RB.getString("PDDB_Parameter_Content_Param_FullDescLabel"));
            stringBuilder.append(":</td><td class=\"content\">" + this.appendParagraphs(paramFullDescription) + "</td>");
            stringBuilder.append("</tr>");
        }
    }

    private String appendParagraphs(RAMLDescription paramShortDescription) {
        return TextUtils.encodeToHTMLSourceCode(paramShortDescription.getDescription("\n"));
    }

    private void appendRelatedFeatures(RAMLMetaParameter metaParam, StringBuilder sb) {
        List<RAMLFeature> relatedFeatures = metaParam.getFeatures();
        if (relatedFeatures.size() > 0) {
            sb.append("<tr>");
            sb.append("<td  valign=\"top\" class=\"label\">");
            sb.append(RB.getString("PDDB_Parameter_Content_Param_RelatedFeaturesLabel"));
            sb.append(":</td><td>");
            Iterator<RAMLFeature> itr = relatedFeatures.iterator();
            int i = 0;
            while (itr.hasNext()) {
                if (i > 0) {
                    sb.append("<br>");
                }
                sb.append(itr.next().getName());
                ++i;
            }
            sb.append("</td>");
            sb.append("</tr>");
        }
    }

    private void appendParameterCategories(RAMLMetaParameter metaParam, StringBuilder sb) {
        List<String> parameterCategories = metaParam.getParameterCategories();
        if (parameterCategories.size() > 0) {
            sb.append("<tr>");
            sb.append("<td  valign=\"top\" class=\"label\">");
            sb.append(RB.getString("PDDB_Parameter_Content_Param_ParamCategoryLabel"));
            sb.append(":</td><td>");
            Iterator<String> itr = parameterCategories.iterator();
            int i = 0;
            while (itr.hasNext()) {
                if (i > 0) {
                    sb.append("<br>");
                }
                sb.append(itr.next());
                ++i;
            }
            sb.append("</td>");
            sb.append("</tr>");
        }
    }

    private void appendCreationPriority(RAMLMetaParameter metaParam, StringBuilder sb) {
        String creationType = metaParam.getCreationType();
        if (!creationType.isEmpty()) {
            sb.append("<tr>");
            sb.append("<td  valign=\"top\" class=\"label\">");
            sb.append(RB.getString("PDDB_Parameter_Content_Param_CreationTypeLabel"));
            sb.append(":</td><td>");
            sb.append(creationType);
            sb.append("</td>");
            sb.append("</tr>");
        }
    }

    public void setSearchText(String text) {
        this.mySearchBar.setSearchText(text);
    }
}

