/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.savechooser;

import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.frameworks.event.EventProcessor;
import com.nokia.em.poseidon.frameworks.mvc.ControllerBase;
import com.nokia.em.poseidon.gui.common.events.DialogCloseEvent;
import com.nokia.em.poseidon.gui.savechooser.SaveChooserFileValidator;
import com.nokia.em.poseidon.gui.savechooser.SaveChooserModel;
import com.nokia.em.poseidon.gui.savechooser.SaveChooserView;
import com.nokia.em.poseidon.services.snapshot.PSaveSnapshotModules;
import com.nokia.em.poseidon.services.snapshot.PSnapshotConst;
import com.nokia.em.poseidon.snapshot.view.adapter.SnapshotAttributesAdapter;
import com.nokia.em.poseidon.util.PSettings;
import com.nokia.em.poseidon.util.file.PFileFilter;
import com.nokia.em.poseidon.util.file.PFileUtils;
import java.io.File;
import java.util.EventObject;
import java.util.List;
import org.apache.log4j.Logger;

public class SaveChooserController
extends ControllerBase
implements EventProcessor,
SnapshotAttributesAdapter {
    protected boolean myIsFileSelected = false;
    private SaveChooserModel mySaveChooserModel;
    private Logger myLogger = Logger.getLogger(this.getClass());

    public SaveChooserController() {
        this(new SaveChooserModel());
    }

    public SaveChooserController(SaveChooserModel model) {
        this.mySaveChooserModel = model;
        PoseidonRuntime.getRuntime().addObject(this);
    }

    public void setModel(SaveChooserModel model) {
        this.mySaveChooserModel = model;
    }

    public SaveChooserModel getModel() {
        return this.mySaveChooserModel;
    }

    public File selectFile() {
        SaveChooserView chooserView = (SaveChooserView)this.myView;
        while (chooserView != null && chooserView.requestFile()) {
            PFileUtils.FileState state;
            File file = ((SaveChooserView)this.myView).getSelectedFile();
            SaveChooserView saveChooserView = (SaveChooserView)this.getView();
            if (!saveChooserView.confirmFileState(file, state = PFileUtils.canWriteTo(file)) || !saveChooserView.confirmDiskSpace(file)) continue;
            this.storeFileLocation(saveChooserView.getSelectedFile());
            return saveChooserView.getSelectedFile();
        }
        return null;
    }

    protected String restoreFileLocation() {
        String folderName = null;
        if (this.mySaveChooserModel.getDefaultPath() != null) {
            folderName = this.mySaveChooserModel.getDefaultPath();
        } else {
            folderName = String.valueOf(((SaveChooserView)this.getView()).getCurrentDirectory().getAbsolutePath()) + System.getProperty("file.separator");
            if (this.mySaveChooserModel.getDefaultFolder() != null) {
                folderName = String.valueOf(folderName) + this.mySaveChooserModel.getDefaultFolder();
            }
        }
        try {
            return this.getSettings().get(this.mySaveChooserModel.getSettingsKey(), folderName);
        }
        catch (Exception ex) {
            this.myLogger.warn("Cannot store last used saving path. Probably PSettings is not set into model and parent controller is not in HMVC Hierarcy", ex);
            return folderName;
        }
    }

    protected void storeFileLocation(File fileLocation) {
        try {
            this.getSettings().set(this.mySaveChooserModel.getSettingsKey(), fileLocation.getParent());
        }
        catch (Exception ex) {
            this.myLogger.warn("Cannot restore last used saving path. Probably PSettings is not set into model and parent controller is not in HMVC Hierarcy", ex);
        }
    }

    protected String getFolder() {
        return this.restoreFileLocation();
    }

    protected String getDefaultFileName() {
        return this.mySaveChooserModel.getDefaultFileName();
    }

    protected PFileFilter getFileFilter() {
        return this.mySaveChooserModel.getFileFilter();
    }

    protected String getDialogTitleKey() {
        return this.mySaveChooserModel.getDialogTitleKey();
    }

    protected String getDialogTitleString() {
        return this.mySaveChooserModel.getDialogTitle();
    }

    protected SaveChooserFileValidator getFileValidator() {
        return this.mySaveChooserModel.getFileValidator();
    }

    public boolean getOverwriteQuery() {
        return this.mySaveChooserModel.getOverwriteQuery();
    }

    public void closeSaveChooserView() {
        if (this.myView instanceof SaveChooserView) {
            ((SaveChooserView)this.myView).cancelSelection();
        }
    }

    private PSettings getSettings() {
        try {
            return this.mySaveChooserModel.getSettings() != null ? this.mySaveChooserModel.getSettings() : PSettings.getInstance();
        }
        catch (Exception ex) {
            this.myLogger.warn("Did not get settings in SaveChooserController. Obviously conroller parent is not in HMVC hierarcy", ex);
            return null;
        }
    }

    @Override
    public void destroy() {
        PoseidonRuntime.getRuntime().removeObject(this);
        super.destroy();
    }

    @Override
    public void processEvent(EventObject event) {
        if (event instanceof DialogCloseEvent) {
            this.destroy();
        }
    }

    @Override
    public List<PSaveSnapshotModules> getModules() {
        return null;
    }

    @Override
    public PSnapshotConst.SNAPSHOT_LEVEL getLevel() {
        return null;
    }

    @Override
    public void setLevel(PSnapshotConst.SNAPSHOT_LEVEL level) {
    }

    @Override
    public void setNotes(String notes) {
    }

    @Override
    public void setModules(List<PSaveSnapshotModules> modules) {
    }
}

