/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.savechooser;

import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.gui.savechooser.SaveChooserFileValidator;
import com.nokia.em.poseidon.util.file.PFileUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class SaveChooserDefaultValidator
implements SaveChooserFileValidator {
    protected Map<String, String> myMessageMap;
    protected ResourceBundle myResourceBundle = I18n.getI18n().getBundle(this.getClass());

    public SaveChooserDefaultValidator() {
        this.myMessageMap = new HashMap<String, String>();
    }

    @Override
    public boolean validateSelection(File selectedFile) {
        String fileName = selectedFile.getName();
        int nameLen = fileName.length();
        if (nameLen > 254) {
            this.myMessageMap.put("Save.InvalidFileHeader", this.myResourceBundle.getString("SaveChooser.LongFileNameHeader_Text"));
            this.myMessageMap.put("Save.InvalidFileBody", this.myResourceBundle.getString("SaveChooser.LongFileNameBody_Text"));
            return false;
        }
        int i = 0;
        while (i < nameLen) {
            char ch = fileName.charAt(i);
            if ((ch < ' ' || ch > '~') && !PFileUtils.isUTF8CharacterSupported() && !PFileUtils.isLanguangeSupported(fileName, i) || ch == '|' || ch == '\"' || ch == '<' || ch == ':' || ch == '>') {
                this.myMessageMap.put("Save.InvalidFileHeader", this.myResourceBundle.getString("SaveChooser.InvalidFileHeader_Text"));
                this.myMessageMap.put("Save.InvalidFileBody", this.myResourceBundle.getString("SaveChooser.InvalidFileBody_Text"));
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public Map<String, String> getValidationFailMessage() {
        return this.myMessageMap;
    }
}

