/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.savechooser;

import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.frameworks.mvc.Controller;
import com.nokia.em.poseidon.frameworks.mvc.GuiEvent;
import com.nokia.em.poseidon.frameworks.mvc.GuiListener;
import com.nokia.em.poseidon.frameworks.mvc.View;
import com.nokia.em.poseidon.gui.common.PStaticDialogs;
import com.nokia.em.poseidon.gui.common.file.FileChooserBase;
import com.nokia.em.poseidon.gui.savechooser.SaveChooserController;
import com.nokia.em.poseidon.services.ui.UserInterface;
import com.nokia.em.poseidon.services.ui.notification.PAppMessage;
import com.nokia.em.poseidon.util.TextUtils;
import com.nokia.em.poseidon.util.file.PFileFilter;
import com.nokia.em.poseidon.util.file.PFileUtils;
import com.nokia.widgets.balloon.Balloon;
import java.awt.Component;
import java.awt.Container;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class SaveChooserView
extends FileChooserBase
implements View {
    protected ResourceBundle myResourceBundle;
    protected boolean myFileSelected = false;
    protected Component myParentComponent;
    protected boolean myIsDisposed;
    private SaveChooserController myController;
    private int myReturnValue;
    private JDialog myDialog = null;
    private long minDiskSpace = 1024L;
    private Logger myLogger = Logger.getLogger(SaveChooserView.class);
    private PAppMessage myDiskSpaceLimitMessage;
    private boolean shouldNotAppearSaveAsDialog = false;

    public SaveChooserView(SaveChooserController ctrl) {
        this(ctrl, null);
    }

    public SaveChooserView(SaveChooserController ctrl, Component parent) {
        this.myController = ctrl;
        this.setSettingsKey(this.myController.getModel().getSettingsKey());
        this.myResourceBundle = I18n.getI18n().getBundle(this.getClass());
        this.myParentComponent = parent;
        this.setUseQuickSelection(false);
    }

    private void initFileChooser() {
        this.setAcceptAllFileFilterUsed(false);
        File selectedDirectory = new File(this.myController.getFolder());
        if (!selectedDirectory.isDirectory()) {
            selectedDirectory = new File(this.myController.getModel().getDefaultPath());
        }
        this.setCurrentDirectory(selectedDirectory);
        this.setDialogTitle(this.myController.getDialogTitleString() != null ? this.myController.getDialogTitleString() : this.myResourceBundle.getString(this.myController.getDialogTitleKey()));
        if (this.myController.getDefaultFileName() != null) {
            this.setSelectedFile(this.resolveDefaultFileName());
        }
        if (this.myController.getFileFilter() != null) {
            this.setFileFilter(this.myController.getFileFilter());
        }
    }

    protected File resolveDefaultFileName() {
        String currentDirectory = this.getCurrentDirectory() + System.getProperty("file.separator");
        File defaultFile = new File(String.valueOf(currentDirectory) + this.myController.getDefaultFileName());
        return defaultFile.exists() ? this.createAlternativeDefaultFile(defaultFile) : defaultFile;
    }

    public File createAlternativeDefaultFile(File defaultFile) {
        String currentDirectory = this.getCurrentDirectory() + System.getProperty("file.separator");
        String fileName = PFileUtils.getFileNameWithoutExtension(defaultFile);
        String fileExtension = PFileUtils.getFileExtension(defaultFile);
        int i = 1;
        File tempFile = defaultFile;
        while ((tempFile = new File(String.valueOf(currentDirectory) + fileName + "(" + i + ")." + fileExtension)).exists() && ++i < 999) {
        }
        return tempFile;
    }

    public boolean confirmDiskSpace(File file) {
        String fileName = TextUtils.forcedTextWrap(file.getName());
        int index = file.getAbsolutePath().lastIndexOf(File.separatorChar);
        if (index < 1) {
            return true;
        }
        String filePath = file.getAbsolutePath().substring(0, index);
        File tempFile = new File(filePath);
        long freeSpace = tempFile.getFreeSpace();
        if (freeSpace < this.getMinDiskSpace()) {
            this.myLogger.debug("Free space in the disk is " + freeSpace + " byte.");
            this.createDiskSpaceLimitMessage(fileName);
            return false;
        }
        return true;
    }

    private void createDiskSpaceLimitMessage(String fileName) {
        String title = this.myController.getDialogTitleString() != null ? this.myController.getDialogTitleString() : this.myResourceBundle.getString(this.myController.getDialogTitleKey());
        String headline = this.myResourceBundle.getString("SaveFileChooser.LimitSpace_Headline");
        String message = MessageFormat.format(this.myResourceBundle.getString("SaveFileChooser.LimitSpace_Message"), fileName);
        Action[] actions = new Action[]{PStaticDialogs.getEmptyAction(this.myResourceBundle.getString("CloseAction_Text"))};
        this.myDiskSpaceLimitMessage = new PAppMessage(title, headline, message, null, actions);
        this.myDiskSpaceLimitMessage.setMessageLevel(PAppMessage.MessageLevel.INFO);
        PStaticDialogs.showMessage(PoseidonRuntime.getRuntime().getService(UserInterface.class).getFrame(), this.myDiskSpaceLimitMessage);
    }

    public void setMinDiskSpace(long space) {
        this.minDiskSpace = space;
    }

    public long getMinDiskSpace() {
        return this.minDiskSpace;
    }

    public boolean confirmFileState(File file, PFileUtils.FileState state) {
        String fileName = TextUtils.forcedTextWrap(file.getName());
        if (state.equals((Object)PFileUtils.FileState.EXISTS)) {
            if (!this.myController.getOverwriteQuery()) {
                return true;
            }
            PStaticDialogs.showQuestionMessage(this.myParentComponent, this.myController.getDialogTitleString() != null ? this.myController.getDialogTitleString() : this.myResourceBundle.getString(this.myController.getDialogTitleKey()), this.myResourceBundle.getString("SaveFileChooser.FileExists_Headline"), MessageFormat.format(this.myResourceBundle.getString("SaveFileChooser.FileExists_Message"), fileName), null, new Action[]{new ReplaceAction(), PStaticDialogs.getEmptyAction(this.myResourceBundle.getString("CancelAction_Text"), '\u0000')});
            return this.myFileSelected;
        }
        if (state.equals((Object)PFileUtils.FileState.HIDDEN)) {
            PStaticDialogs.showInformationDialog(this.myParentComponent, this.myController.getDialogTitleString() != null ? this.myController.getDialogTitleString() : this.myResourceBundle.getString(this.myController.getDialogTitleKey()), this.myResourceBundle.getString("SaveFileChooser.Hidden_File_Headline"), MessageFormat.format(this.myResourceBundle.getString("SaveFileChooser.Hidden_File_Message"), fileName), null);
            return false;
        }
        if (state.equals((Object)PFileUtils.FileState.CANNOT_WRITE)) {
            PStaticDialogs.showInformationDialog(this.myParentComponent, this.myController.getDialogTitleString() != null ? this.myController.getDialogTitleString() : this.myResourceBundle.getString(this.myController.getDialogTitleKey()), this.myResourceBundle.getString("SaveFileChooser.Readonly_File_Headline"), MessageFormat.format(this.myResourceBundle.getString("SaveFileChooser.Readonly_File_Message"), fileName), null);
            return false;
        }
        if (state.equals((Object)PFileUtils.FileState.PATH_NOT_EXISTS)) {
            PStaticDialogs.showInformationDialog(this.myParentComponent, this.myController.getDialogTitleString() != null ? this.myController.getDialogTitleString() : this.myResourceBundle.getString(this.myController.getDialogTitleKey()), this.myResourceBundle.getString("SaveFileChooser.Not_Writable_File_Headline"), this.myResourceBundle.getString("SaveFileChooser.Not_Writable_File_Message"), null);
            return false;
        }
        return state.equals((Object)PFileUtils.FileState.WRITABLE);
    }

    protected void fireGuiEvent(GuiEvent event) {
        GuiListener[] guiListenerArray = (GuiListener[])this.listenerList.getListeners(GuiListener.class);
        int n = guiListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            GuiListener listener = guiListenerArray[n2];
            listener.processGuiEvent(event);
            ++n2;
        }
    }

    protected boolean requestFile() {
        if (this.shouldNotAppearSaveAsDialog) {
            return false;
        }
        if (this.myParentComponent == null) {
            return this.showSaveDialog(PoseidonRuntime.getRuntime().getService(UserInterface.class).getFrame()) == 0;
        }
        return this.showSaveDialog(this.myParentComponent) == 0;
    }

    protected boolean checkSelection(File file) {
        boolean valid = true;
        if (this.myController.getFileValidator() == null) {
            return valid;
        }
        valid = this.myController.getFileValidator().validateSelection(file);
        if (!valid) {
            Map<String, String> messages = this.myController.getFileValidator().getValidationFailMessage();
            final String strErrorMsg = messages.get("Save.InvalidFileBody");
            final String strErrorHdr = messages.get("Save.InvalidFileHeader");
            this.closeBalloon();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SaveChooserView.this.myBalloon = new Balloon(SaveChooserView.this.myFilenameField, SaveChooserView.this.myDialog, strErrorMsg, strErrorHdr, 0, 0);
                    SaveChooserView.this.myBalloon.showBalloon();
                }
            });
        }
        return valid;
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.shouldNotAppearSaveAsDialog = false;
            this.initFileChooser();
        }
    }

    @Override
    public File getSelectedFile() {
        if (this.getFileFilter() instanceof PFileFilter && super.getSelectedFile() != null && !super.getSelectedFile().isDirectory()) {
            PFileFilter filter = (PFileFilter)this.getFileFilter();
            String fileName = super.getSelectedFile().getName();
            boolean fileNameHasExtension = false;
            List<String> extensions = filter.getExtensions();
            for (String extension : extensions) {
                if (!PFileUtils.isFileExtensionAppended(fileName, extension)) continue;
                fileNameHasExtension = true;
                break;
            }
            if (extensions.size() > 0 && !fileNameHasExtension) {
                return new File(String.valueOf(super.getSelectedFile().getPath()) + "." + extensions.get(0));
            }
        }
        return super.getSelectedFile();
    }

    @Override
    public final void approveSelection() {
        if (this.checkSelection(this.getSelectedFile())) {
            if (this.myDialog != null) {
                this.saveSettings();
                this.myDialog.setVisible(false);
            }
            this.myReturnValue = 0;
            this.fireActionPerformed("ApproveSelection");
        }
    }

    @Override
    public int showDialog(Component parent, String approveButtonText) throws HeadlessException {
        if (this.myController == null) {
            return 1;
        }
        this.myDialog = this.createDialog(parent);
        this.myDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SaveChooserView.this.setSelectedFile(null);
                SaveChooserView.this.myReturnValue = 1;
            }
        });
        this.myReturnValue = -1;
        this.rescanCurrentDirectory();
        if (this.getSelectedFile() != null) {
            this.checkSelection(this.getSelectedFile());
        }
        if (this.myController.getDefaultFileName() != null) {
            this.setSelectedFile(this.resolveDefaultFileName());
        }
        this.myDialog.setVisible(true);
        return this.myReturnValue;
    }

    @Override
    public void cancelSelection() {
        if (this.myDialog != null) {
            this.closeMessages();
            this.myDialog.setVisible(false);
            this.setSelectedFile(null);
        }
        this.fireActionPerformed("CancelSelection");
    }

    private void closeMessages() {
        if (this.myDiskSpaceLimitMessage != null) {
            PStaticDialogs.closeOpenMessageDialog(this.myDiskSpaceLimitMessage.getID());
            this.myDiskSpaceLimitMessage = null;
        }
        this.shouldNotAppearSaveAsDialog = true;
        PStaticDialogs.closeOpenDialogs();
    }

    @Override
    public void addGuiListener(GuiListener listener) {
        this.listenerList.add(GuiListener.class, listener);
    }

    @Override
    public void removeGuiListener(GuiListener listener) {
        this.listenerList.remove(GuiListener.class, listener);
    }

    public void setDialog(JDialog myDialog) {
        this.myDialog = myDialog;
    }

    @Override
    public Controller getController() {
        return this.myController;
    }

    @Override
    public void setController(Controller ctrl) {
        if (ctrl == null) {
            this.removeGuiListener(this.myController);
        } else {
            this.addGuiListener(ctrl);
        }
        this.myController = (SaveChooserController)ctrl;
    }

    @Override
    public boolean isDisposed() {
        return this.myIsDisposed;
    }

    @Override
    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        Container parent = this.getParent();
        if (parent != null) {
            parent.remove(this);
            parent.validate();
            parent.repaint();
        }
        GuiListener[] guiListenerArray = (GuiListener[])this.listenerList.getListeners(GuiListener.class);
        int n = guiListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            GuiListener listener = guiListenerArray[n2];
            this.listenerList.remove(GuiListener.class, listener);
            ++n2;
        }
        this.closeMessages();
        this.closeBalloon();
        this.myIsDisposed = true;
        this.myController = null;
        if (this.myDialog != null) {
            this.myDialog.dispose();
            this.myDialog = null;
        }
    }

    public void showRequest() {
        this.setVisible(true);
    }

    public void hideRequest() {
        this.setVisible(false);
    }

    public boolean isShown() {
        return this.isVisible();
    }

    protected final class ReplaceAction
    extends AbstractAction {
        private ReplaceAction() {
            this.putValue("Name", SaveChooserView.this.myResourceBundle.getString("SaveFileChooser.Replace_Action"));
            this.putValue("MnemonicKey", SaveChooserView.this.myResourceBundle.getMnemonic("SaveFileChooser.Replace_Action_Mnemonic"));
            this.putValue("Default", Boolean.TRUE);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            SaveChooserView.this.myFileSelected = true;
        }
    }
}

