/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.snapshot;

import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.frameworks.event.EventProcessor;
import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.frameworks.progress.step.PStepProgressSource;
import com.nokia.em.poseidon.gui.common.CloseConfirmationMessage;
import com.nokia.em.poseidon.gui.savechooser.SaveChooserController;
import com.nokia.em.poseidon.gui.savechooser.SaveChooserDefaultValidator;
import com.nokia.em.poseidon.gui.savechooser.SaveChooserModel;
import com.nokia.em.poseidon.gui.snapshot.PSaveSnapshotView;
import com.nokia.em.poseidon.gui.snapshot.PSnapshotController;
import com.nokia.em.poseidon.gui.snapshot.PSnapshotSaveAvailability;
import com.nokia.em.poseidon.gui.snapshot.PSnapshotViewUtils;
import com.nokia.em.poseidon.gui.snapshot.StepProgressAdapter;
import com.nokia.em.poseidon.services.conninfo.BasicConnectionFilter;
import com.nokia.em.poseidon.services.conninfo.ConnectionEvent;
import com.nokia.em.poseidon.services.conninfo.ConnectionInfo;
import com.nokia.em.poseidon.services.conninfo.ConnectionStatus;
import com.nokia.em.poseidon.services.snapshot.PSaveSnapshotModules;
import com.nokia.em.poseidon.services.snapshot.PSnapshotConst;
import com.nokia.em.poseidon.services.snapshot.PSnapshotGuiListener;
import com.nokia.em.poseidon.services.snapshot.PSnapshotGuiListenerEvent;
import com.nokia.em.poseidon.services.snapshot.PSnapshotService;
import com.nokia.em.poseidon.services.ui.UserInterface;
import com.nokia.em.poseidon.util.PSettings;
import com.nokia.em.poseidon.util.file.PFileUtils;
import com.nokia.widgets.progress.ProgressDialogController;
import com.nokia.widgets.progress.ProgressFactory;
import com.nokia.widgets.progress.models.ProgressDialogModel;
import com.nokia.widgets.progress.models.StepProgressModel;
import com.nokia.widgets.progress.views.ProgressDialogCloseListener;
import com.nokia.widgets.progress.views.ProgressGuiEvent;
import java.awt.Dimension;
import java.io.File;
import java.net.MalformedURLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

@Deprecated
public class PSaveSnapshotController
extends SaveChooserController
implements PSnapshotGuiListener,
EventProcessor {
    private static final String SEPARATOR = "_";
    private static final int DIALOG_WIDTH_OFFSET = 100;
    private boolean myIsSnapshotOngoing;
    private static CloseConfirmationMessage myCloseMsg;
    protected final SimpleDateFormat myFormat = new SimpleDateFormat("yyyyMMdd-HHmm");
    protected ResourceBundle myResourceBundle;
    protected PSnapshotService myService;
    protected Logger myLogger = Logger.getLogger(this.getClass());
    protected String mySiteName = "";
    protected ProgressDialogController myProgressDialogController;
    protected PSnapshotConst.SNAPSHOT_LEVEL myLevel;
    protected String myNotes = "";
    public static final String SNAPSHOT_FILE_SW_VERSION = "SNAPSHOT_FILE_SW_VERSION";
    public static final String SNAPSHOT_FILE_DIST_NAME = "SNAPSHOT_FILE_DIST_NAME";
    protected PSettings mySettings;
    protected List<PSaveSnapshotModules> myModules;
    private boolean myIsFirstime;

    @Deprecated
    public PSaveSnapshotController() {
        this((List<PSnapshotConst.SNAPSHOT_LEVEL>)null);
    }

    @Deprecated
    public PSaveSnapshotController(List<PSnapshotConst.SNAPSHOT_LEVEL> disabledLevels) throws IllegalArgumentException {
        this.myService = PoseidonRuntime.getRuntime().getService(PSnapshotService.class);
        this.myResourceBundle = I18n.getI18n().getBaseBundle();
        this.mySettings = PSettings.getInstance();
        PoseidonRuntime.getRuntime().addObject(this);
        PSnapshotSaveAvailability ps = (PSnapshotSaveAvailability)PoseidonRuntime.getRuntime().getRuntimeProperty("SAVE_SNAPSHOT_FUNCTION_AVAILABLE");
        if (ps != null) {
            ps.setSaveSnapshotController(this);
        }
        myCloseMsg = PoseidonRuntime.getRuntime().getObject(CloseConfirmationMessage.class);
        final SaveChooserModel model = this.getModel();
        model.setSettingsKey("SnapshotPreviousFileLocation");
        PSaveSnapshotView view = new PSaveSnapshotView(this, PoseidonRuntime.getRuntime().getService(UserInterface.class).getFrame());
        view.setDisabledLevels(disabledLevels);
        model.setDialogTitle(this.myResourceBundle.getString("PSaveSnapshotAsView_Title"));
        model.setFileFilter(PSnapshotViewUtils.createFileFilter(this.mySettings.get("snapshotFileType", "zip")));
        model.setDefaultPath(this.myService.getSaveLocation());
        this.myIsFirstime = true;
        model.setFileValidator(new SaveChooserDefaultValidator(){

            @Override
            public boolean validateSelection(File selectedFile) {
                if (PSaveSnapshotController.this.myIsFirstime) {
                    PSaveSnapshotController.this.myIsFirstime = false;
                    String originalFilename = PSaveSnapshotController.this.createFileName();
                    String fileName = PFileUtils.removeInvalidCharacters(originalFilename);
                    File validSelectedFile = ((PSaveSnapshotView)PSaveSnapshotController.this.myView).checkFileNameUniqueness(fileName);
                    model.setDefaultFileName(validSelectedFile.getName());
                    ((PSaveSnapshotView)PSaveSnapshotController.this.myView).setSelectedFile(validSelectedFile);
                    if (!fileName.equals(originalFilename)) {
                        this.myMessageMap.put("Save.InvalidFileHeader", this.myResourceBundle.getString("PSaveSnapshotView_invalidSiteName_header"));
                        this.myMessageMap.put("Save.InvalidFileBody", this.myResourceBundle.getString("PSaveSnapshotView_invalidSiteName_text"));
                        return false;
                    }
                    return true;
                }
                return super.validateSelection(selectedFile);
            }
        });
        this.setView(view);
        this.setVisible(true);
        File file = this.selectFile();
        if (file != null) {
            this.startSavingSnapshot(this.myLevel, file, this.myNotes);
        } else {
            PoseidonRuntime.getRuntime().removeObject(this);
            this.destroy();
        }
    }

    @Deprecated
    protected void startSavingSnapshot(PSnapshotConst.SNAPSHOT_LEVEL level, File location, String notes) {
        this.myService.addGuiListener(this);
        ProgressDialogModel dialogModel = new ProgressDialogModel();
        dialogModel.setAdditionalInfo(this.myService.getAdditionalInfo());
        dialogModel.setTitle(this.myResourceBundle.getString("PSaveSnapshotController_Saving_Title"));
        dialogModel.setHeadingText(this.myResourceBundle.getString("PSaveSnapshotController_Saving_Header"));
        this.myProgressDialogController = ProgressFactory.createStepProgressDialog(PoseidonRuntime.getRuntime().getService(UserInterface.class).getFrame(), dialogModel);
        StepProgressModel progressModel = (StepProgressModel)this.myProgressDialogController.getProgressControllerModel();
        progressModel.setEstimatedDurationVisible(false);
        this.myProgressDialogController.getModel().setActionButtonEnabled(false);
        StepProgressAdapter adapter = new StepProgressAdapter(this.myProgressDialogController);
        adapter.setProgressSource((PStepProgressSource)((Object)this.myService));
        this.myProgressDialogController.getView().setResizable(true);
        this.myProgressDialogController.setCloseListener(new ProgressDialogCloseListener(){

            @Override
            public void closeRequest() {
                if (PSaveSnapshotController.this.myProgressDialogController.getProgressControllerModel().getProgressState() != 1) {
                    if (myCloseMsg.closeAndStopRequested(PSaveSnapshotController.this.myProgressDialogController.getView(), PSaveSnapshotController.this.myResourceBundle.getString("PSaveSnapshotController_Saving_Title"), PSaveSnapshotController.this.myResourceBundle.getString("PSaveSnapshotController_Saving_Operation_Text"))) {
                        PSaveSnapshotController.this.myProgressDialogController.guiUpdated(new ProgressGuiEvent("cancelaction"));
                    } else {
                        return;
                    }
                }
                PSaveSnapshotController.this.destroy();
                PSaveSnapshotController.this.myProgressDialogController.destroy();
            }
        });
        try {
            if (this.myModules != null && this.myModules.size() > 0) {
                ArrayList<PSaveSnapshotModules> selectedModules = new ArrayList<PSaveSnapshotModules>();
                for (PSaveSnapshotModules module : this.myModules) {
                    if (!module.isModuleSelected()) continue;
                    selectedModules.add(module);
                }
                this.myService.saveSnapshot(level, location, notes, adapter, selectedModules);
            } else {
                this.myService.saveSnapshot(level, location, notes, adapter);
            }
            if (progressModel.getVisibleSteps().size() >= 17) {
                progressModel.setUseScrolling(true);
            } else {
                progressModel.setUseScrolling(false);
            }
            this.myIsSnapshotOngoing = true;
            this.myProgressDialogController.getProgressController().start(true);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int dialogWidth = PSaveSnapshotController.this.myProgressDialogController.getView().getWidth();
                    int dialogHeight = PSaveSnapshotController.this.myProgressDialogController.getView().getHeight();
                    PSaveSnapshotController.this.myProgressDialogController.getView().setMinimumSize(new Dimension(dialogWidth + 100, dialogHeight));
                    PSaveSnapshotController.this.myProgressDialogController.show();
                }
            });
        }
        catch (MalformedURLException exception) {
            this.myLogger.error("Snapshot temporary directories cannot be created" + exception);
            this.myService.removeGuiListener(this);
            PoseidonRuntime.getRuntime().removeObject(this);
            ((PSaveSnapshotView)this.getView()).showMessage(PSnapshotController.ErrorType.CANNOT_CREATE_TEMP_DIR, new Object[0]);
            this.destroy();
        }
    }

    @Override
    public void setLevel(PSnapshotConst.SNAPSHOT_LEVEL level) {
        this.myLevel = level;
    }

    @Override
    public PSnapshotConst.SNAPSHOT_LEVEL getLevel() {
        return this.myLevel;
    }

    @Override
    public void setNotes(String notes) {
        this.myNotes = notes;
    }

    protected String createFileName() {
        ConnectionEvent event;
        String distName = this.getDistName();
        String softwareReleaseVersion = this.getSWReleaseVersion();
        ConnectionInfo connectionInfoService = PoseidonRuntime.getRuntime().getService(ConnectionInfo.class);
        if (connectionInfoService != null && (event = connectionInfoService.getLatestConnectionEvent(new BasicConnectionFilter(ConnectionStatus.CONNECTED))) != null) {
            this.mySiteName = event.getNetworkElementName();
        }
        this.mySiteName = this.mySiteName != null && this.mySiteName.length() > 0 ? String.valueOf(this.mySiteName.replaceAll(" ", "")) + SEPARATOR : this.myResourceBundle.getString("unknown_Text");
        return "Snapshot_" + distName + softwareReleaseVersion + this.mySiteName + this.myFormat.format(new Date()) + "." + this.mySettings.get("snapshotFileType", "zip");
    }

    protected String getSWReleaseVersion() {
        if (PoseidonRuntime.getRuntime().getRuntimeProperty(SNAPSHOT_FILE_SW_VERSION) == null) {
            return "";
        }
        return (String)PoseidonRuntime.getRuntime().getRuntimeProperty(SNAPSHOT_FILE_SW_VERSION);
    }

    protected String getDistName() {
        if (PoseidonRuntime.getRuntime().getRuntimeProperty(SNAPSHOT_FILE_DIST_NAME) == null) {
            return "";
        }
        return (String)PoseidonRuntime.getRuntime().getRuntimeProperty(SNAPSHOT_FILE_DIST_NAME);
    }

    public static String format(String property) {
        if (property.trim().length() == 0) {
            return "";
        }
        return String.valueOf(property.trim()) + SEPARATOR;
    }

    @Override
    public void operationFinished(PSnapshotGuiListenerEvent event) {
        this.myIsSnapshotOngoing = false;
        this.myService.removeGuiListener(this);
        if (this.myProgressDialogController != null) {
            myCloseMsg.operationFinished(this.myProgressDialogController.getView());
        }
        PSnapshotGuiListenerEvent.Type eventType = event.getType();
        if (!this.isDestroyed()) {
            boolean isMediatorDiskIsFull = eventType.equals((Object)PSnapshotGuiListenerEvent.Type.MEDIATOR_FAILED_DISK_FULL);
            boolean isMediatorFailed = eventType.equals((Object)PSnapshotGuiListenerEvent.Type.MEDIATORS_FAILED_SAVING);
            if (isMediatorFailed || isMediatorDiskIsFull) {
                this.myLogger.warn("Snapshot saving finished with errors, Failed mediators and tasks: " + event);
                PSnapshotController.ErrorType error = isMediatorFailed ? PSnapshotController.ErrorType.MEDIATORS_FAILED_SAVING : PSnapshotController.ErrorType.MEDIATOR_FAILED_DISK_FULL;
                ((PSaveSnapshotView)this.getView()).showMessage(error, event.getInfo());
            } else if (eventType.equals((Object)PSnapshotGuiListenerEvent.Type.SNAPSHOT_SAVING_FAILED)) {
                this.myLogger.error("Snapshot saving failed " + event);
                ((PSaveSnapshotView)this.getView()).showMessage(PSnapshotController.ErrorType.SAVING_FAILED, event.getInfo());
            } else if (eventType.equals((Object)PSnapshotGuiListenerEvent.Type.SNAPSHOT_COPYING_FAILED)) {
                this.myLogger.error("Copying snapshot file to destination failed " + event);
                ((PSaveSnapshotView)this.getView()).showMessage(PSnapshotController.ErrorType.COPYING_FAILED, event.getInfo());
            } else {
                this.myLogger.debug("Snapshot saving finished successfully");
            }
        } else {
            this.myLogger.debug("Snapshot saving dialog closed forcefully");
        }
        if (eventType.equals((Object)PSnapshotGuiListenerEvent.Type.SUCCESS)) {
            this.myProgressDialogController.getModel().setActionButtonEnabled(true);
        }
    }

    @Override
    public void processEvent(EventObject event) {
    }

    @Override
    public void setModules(List<PSaveSnapshotModules> modules) {
        this.myModules = modules;
    }

    @Override
    public List<PSaveSnapshotModules> getModules() {
        return this.myModules;
    }

    public boolean isSnapshotOngoing() {
        return this.myIsSnapshotOngoing;
    }

    public boolean isCancelled() {
        return this.myProgressDialogController.getProgressControllerModel().isCanceled();
    }

    @Override
    public void operationStarted(PSnapshotGuiListenerEvent event) {
    }
}

