/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.snapshot;

import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.services.snapshot.PSaveSnapshotModules;
import com.nokia.em.poseidon.services.snapshot.PSnapshotMediator;
import com.nokia.widgets.table.PDisabledTableModel;
import com.nokia.widgets.table.PValidatableTableModel;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class PSaveSnapshotTableModel
extends AbstractTableModel
implements PValidatableTableModel,
PDisabledTableModel {
    public static final int COLUMN_SELECT = 0;
    protected static final int COLUMN_MODULE = 1;
    private static final String APPLICATION_NAME = "BTS Site Manager";
    private List<PSaveSnapshotModules> myTableItems;
    private boolean myIsTableDisabled = true;
    private String[] myColumnNames = new String[]{"", ""};
    private Object[][] myRowData;

    @Deprecated
    public PSaveSnapshotTableModel() {
        this.initTableModel();
    }

    public PSaveSnapshotTableModel(String[] columnNames) {
        this.myColumnNames = columnNames;
        this.initTableModel();
    }

    private void initTableModel() {
        this.myTableItems = new ArrayList<PSaveSnapshotModules>();
        this.createModules();
        this.myRowData = new Object[this.myTableItems.size()][this.myColumnNames.length];
        this.initTableValue();
    }

    private void initTableValue() {
        int i = 0;
        while (i < this.myTableItems.size()) {
            PSaveSnapshotModules tableItem = this.myTableItems.get(i);
            this.setValueAt(tableItem.isModuleSelected(), i, 0);
            this.setValueAt(tableItem.getName(), i, 1);
            ++i;
        }
    }

    public void setAllModuleSelected(boolean state) {
        for (PSaveSnapshotModules entry : this.myTableItems) {
            entry.setModuleSelected(state);
        }
    }

    public List<PSaveSnapshotModules> getModules() {
        return this.myTableItems;
    }

    @Override
    public String getColumnName(int column) {
        return this.myColumnNames[column];
    }

    @Override
    public int getColumnCount() {
        if (this.myColumnNames == null) {
            return 0;
        }
        return this.myColumnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.myTableItems.size();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                if (this.myIsTableDisabled) {
                    return !this.myIsTableDisabled;
                }
                return this.myTableItems.get(rowIndex).isEditable();
            }
        }
        return false;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Boolean.class;
            }
        }
        return Object.class;
    }

    @Override
    public Object getValueAt(int row, int col) {
        return this.myRowData[row][col];
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        this.myRowData[row][col] = value;
        if (col == 0) {
            Boolean bool = (Boolean)value;
            this.myTableItems.get(row).setModuleSelected(bool);
        }
        this.fireTableCellUpdated(row, col);
    }

    public void setTableDisabled(boolean value) {
        this.myIsTableDisabled = value;
    }

    private void createModules() {
        List<PSnapshotMediator> snapshotMediatorObjects = PoseidonRuntime.getRuntime().getObjects(PSnapshotMediator.class);
        for (PSnapshotMediator mediator : snapshotMediatorObjects) {
            if (!APPLICATION_NAME.equals(mediator.getDescription().getStringProperty("shortPublicName")) || mediator.getModules() == null) continue;
            this.myTableItems.addAll(mediator.getModules());
        }
    }

    @Override
    public boolean isCellDisabled(int row, int column) {
        if (this.myIsTableDisabled) {
            return true;
        }
        return !this.myTableItems.get(row).isEditable();
    }

    @Override
    public boolean isMandatory(int row, int column) {
        return false;
    }

    @Override
    public boolean isValid(int row, int column) {
        return true;
    }

    @Override
    public boolean isMissing(int row, int column) {
        return false;
    }
}

