/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.snapshot;

import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.frameworks.i18n.localizer.Localizer;
import com.nokia.em.poseidon.frameworks.i18n.localizer.LocalizerRegistry;
import com.nokia.em.poseidon.frameworks.i18n.localizer.swing.SwingHierarchyIterator;
import com.nokia.em.poseidon.gui.common.edittable.PEditTable;
import com.nokia.em.poseidon.gui.savechooser.SaveChooserController;
import com.nokia.em.poseidon.gui.snapshot.PSaveSnapshotInAvailabilityDetails;
import com.nokia.em.poseidon.gui.snapshot.PSaveSnapshotTableModel;
import com.nokia.em.poseidon.gui.snapshot.PSaveSnapshotView;
import com.nokia.em.poseidon.gui.snapshot.PSnapshotSaveAvailability;
import com.nokia.em.poseidon.services.help.PHelp;
import com.nokia.em.poseidon.services.snapshot.PSaveSnapshotModules;
import com.nokia.em.poseidon.services.snapshot.PSnapshotConst;
import com.nokia.em.poseidon.services.snapshot.PSnapshotService;
import com.nokia.laf.NetFileChooserUI;
import com.nokia.widgets.ClientProperties;
import com.nokia.widgets.buttons.PHelpButton;
import com.nokia.widgets.infotip.InfoButton;
import com.nokia.widgets.labels.PLabel;
import com.nokia.widgets.table.CheckBoxHeaderRenderer;
import com.nokia.widgets.table.PTableModelSorter;
import com.nokia.widgets.util.ScaleUtils;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.table.TableColumnModel;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class PSaveSnapshotUI
extends NetFileChooserUI
implements ActionListener {
    private static final int DEFAULT_TABLE_HEIGHT = 135;
    private static final int DEFAULT_TABLE_WIDTH = 181;
    private static final int COLUMN_SELECT_MAX_WIDTH = 60;
    protected final int MAX_CHARACTERS = 500;
    protected final String STR_MAX_CHARACTERS = "/500";
    protected PEditTable myTable;
    protected PSaveSnapshotTableModel mySnapshotTableModel;
    protected JTextArea myNotesArea;
    protected JRadioButton myAllButton;
    protected JRadioButton myMostImportantButton;
    protected JRadioButton myCurrentButton;
    protected ResourceBundle myResourceBundle = I18n.getI18n().getBundle(this.getClass());
    protected PLabel myCharactersCountLabel;
    protected String myApplicationName = (String)PoseidonRuntime.getRuntime().getRuntimeProperty("shortPublicName");
    private boolean myModuleVisible;
    protected SaveChooserController myController;
    protected PSnapshotService myService;
    private Map<PLabel, PSaveSnapshotModules.PSaveSnapshotWarningLabelVisibility> myWarningLabelMap;

    public PSaveSnapshotUI(JFileChooser chooser) {
        super(chooser);
        if (this.myApplicationName == null || this.myApplicationName.length() == 0) {
            this.myApplicationName = this.myResourceBundle.getString("PSaveSnapshotView_Default_AppName");
        }
        this.myService = PoseidonRuntime.getRuntime().getService(PSnapshotService.class);
        PSnapshotSaveAvailability ps = (PSnapshotSaveAvailability)PoseidonRuntime.getRuntime().getRuntimeProperty("SAVE_SNAPSHOT_FUNCTION_AVAILABLE");
        if (ps != null) {
            ps.removePropertyChangeListener("SAVESNAPSHOTUI_PROPERTYCHANGE");
            ps.addPropertyChangeListener("SAVESNAPSHOTUI_PROPERTYCHANGE", this);
        }
    }

    public static ComponentUI createUI(JComponent comp) {
        return new PSaveSnapshotUI((JFileChooser)comp);
    }

    @Override
    public JPanel getAccessoryPanel() {
        JPanel panel = super.getAccessoryPanel();
        panel.add(Box.createVerticalStrut(155), "East");
        return panel;
    }

    @Override
    protected void addControlButtons() {
        this.myControlButtonPanel = new JPanel();
        this.myControlButtonPanel.setLayout(new BoxLayout(this.myControlButtonPanel, 1));
        this.myControlButtonPanel.add(this.getBottomPanel());
        this.myControlButtonPanel.add(this.createCustomPanel());
        PHelpButton helpButton = new PHelpButton();
        helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PoseidonRuntime.getRuntime().getService(PHelp.class).showHelp(SwingUtilities.getWindowAncestor(PSaveSnapshotUI.this.getFileChooser()), "Poseidon_Savingsnapshotfile");
            }
        });
        this.getApproveButton(this.getFileChooser()).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PSaveSnapshotUI.this.myModuleVisible) {
                    PSaveSnapshotUI.this.unselectAllModules();
                    PSaveSnapshotUI.this.setControllerModules();
                }
            }
        });
        JPanel buttons = this.getButtonPanel();
        buttons.add(helpButton);
        this.myControlButtonPanel.add(buttons);
        this.getFileChooser().add((Component)this.myControlButtonPanel, "South");
    }

    protected void unselectAllModules() {
        if (this.myCurrentButton.isSelected()) {
            this.mySnapshotTableModel.setAllModuleSelected(false);
        }
    }

    protected JPanel createCustomPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        PLabel detailLevelLabel = new PLabel();
        detailLevelLabel.setLabelType(ClientProperties.LABEL_SYSTEM_TEXT);
        detailLevelLabel.setName("PSaveSnapshotView_DetailLevel");
        this.createRadioButtonGroup();
        PLabel charactersLabel = new PLabel();
        charactersLabel.setLabelType(ClientProperties.LABEL_SYSTEM_TEXT);
        charactersLabel.setName("PSaveSnapshotView_CharactersLeft");
        this.myCharactersCountLabel = PLabel.createValueText();
        this.myCharactersCountLabel.setForeground(new Color(0, 0, 0));
        PLabel notesLabel = new PLabel();
        notesLabel.setLabelType(ClientProperties.LABEL_SYSTEM_TEXT);
        notesLabel.setName("PSaveSnapshotView_Notes");
        JScrollPane scrollPane = this.createNotesTextArea();
        notesLabel.setLabelFor(this.myNotesArea);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 0;
        gbc.anchor = 23;
        gbc.fill = 0;
        gbc.gridwidth = 1;
        ++gbc.gridy;
        Insets labelInsets = new Insets(2, 18, 0, 0);
        this.addDetailLevelToPanel(panel, detailLevelLabel, gbc, labelInsets);
        if (this.myService != null && this.myService.getAdditionalInfo() != null) {
            this.addAdditionalInfoToPanel(panel, gbc, this.myService.getAdditionalInfo());
        }
        this.initTableModel();
        List<PSaveSnapshotModules> modules = this.mySnapshotTableModel.getModules();
        if (this.isModuleVisible(modules)) {
            PLabel fetchDataFromLabel = new PLabel();
            fetchDataFromLabel.setLabelType(ClientProperties.LABEL_SYSTEM_TEXT);
            fetchDataFromLabel.setName("PSaveSnapshotView_FetchDataFrom");
            this.createTable();
            JScrollPane tableScrollPane = this.createTableScrollPane();
            this.myWarningLabelMap = new HashMap<PLabel, PSaveSnapshotModules.PSaveSnapshotWarningLabelVisibility>();
            for (PSaveSnapshotModules module : modules) {
                if (module.getWarningLabel() == null) continue;
                this.myWarningLabelMap.put(module.getWarningLabel(), module.getWarningLabelVisibility());
            }
            this.addFetchDataFromToPanel(panel, fetchDataFromLabel, tableScrollPane, this.myWarningLabelMap.keySet(), gbc);
        }
        this.addCharactersCountToPanel(panel, charactersLabel, gbc);
        this.addNotesToPanel(panel, notesLabel, scrollPane, gbc, labelInsets);
        Localizer localizer = LocalizerRegistry.lookup("swing");
        localizer.setResourceBundle(this.myResourceBundle);
        localizer.localizeObjectHierarchy(new SwingHierarchyIterator(panel));
        return panel;
    }

    protected boolean isModuleVisible(List<PSaveSnapshotModules> modules) {
        this.myModuleVisible = modules.size() > 0;
        return this.myModuleVisible;
    }

    protected void initTableModel() {
        String[] columnNames = new String[]{"", this.myResourceBundle.getString("PSaveSnapshotTableModel_Module")};
        this.mySnapshotTableModel = new PSaveSnapshotTableModel(columnNames);
    }

    private void createRadioButtonGroup() {
        ButtonGroup bg = new ButtonGroup();
        Object[] args = new Object[]{this.myApplicationName};
        this.myCurrentButton = new JRadioButton(MessageFormat.format(this.myResourceBundle.getString("PSaveSnapshotView_Current"), args));
        this.myCurrentButton.setName("PSaveSnapshotUI.CurrentDataRadioButton");
        this.myCurrentButton.addActionListener(this);
        bg.add(this.myCurrentButton);
        this.myMostImportantButton = new JRadioButton(this.myResourceBundle.getString("PSaveSnapshotView_MostImportant"));
        this.myMostImportantButton.setName("PSaveSnapshotUI.MostImportantDataRadioButton");
        this.myMostImportantButton.addActionListener(this);
        bg.add(this.myMostImportantButton);
        this.myAllButton = new JRadioButton(this.myResourceBundle.getString("PSaveSnapshotView_All"));
        this.myAllButton.setName("PSaveSnapshotUI.AllDataRadioButton");
        this.myAllButton.addActionListener(this);
        bg.add(this.myAllButton);
    }

    private void createTable() {
        this.myTable = new PEditTable(new PTableModelSorter(this.mySnapshotTableModel));
        this.myTable.setName("ModulesTable");
        this.myTable.setDragEnabled(false);
        this.myTable.setFocusable(true);
        this.myTable.sizeColumnsToFit(1);
        this.myTable.getTableHeader().setReorderingAllowed(false);
        this.myTable.packColumns();
        TableColumnModel tableColumn = this.myTable.getColumnModel();
        tableColumn.getColumn(0).setHeaderRenderer(new CheckBoxHeaderRenderer(this.myTable));
        tableColumn.getColumn(0).setPreferredWidth(60);
        tableColumn.getColumn(0).setMaxWidth(60);
        tableColumn.getColumn(1).setPreferredWidth(this.getMaxWidthForModuleColumn());
        this.myTable.getModel().addTableModelListener(new ModuleSelectionListener());
    }

    private int getMaxWidthForModuleColumn() {
        int max = (int)Math.ceil(3.0 * PSaveSnapshotUI.getStringWidth(this.myTable.getFont(), this.mySnapshotTableModel.getColumnName(1)));
        int row = 0;
        while (row < this.mySnapshotTableModel.getRowCount()) {
            int current = (int)PSaveSnapshotUI.getStringWidth(this.myTable.getFont(), this.mySnapshotTableModel.getValueAt(row, 1).toString());
            max = Math.max(max, current);
            ++row;
        }
        return ScaleUtils.scale(max) + 10;
    }

    private JScrollPane createTableScrollPane() {
        JScrollPane tableScrollPane = new JScrollPane(this.myTable);
        tableScrollPane.setHorizontalScrollBarPolicy(31);
        tableScrollPane.setVerticalScrollBarPolicy(20);
        tableScrollPane.setColumnHeaderView(this.myTable.getTableHeader());
        tableScrollPane.setPreferredSize(new Dimension(this.getMaxTableWidth(), 135));
        return tableScrollPane;
    }

    private int getMaxTableWidth() {
        return Math.max(181, 60 + this.getMaxWidthForModuleColumn());
    }

    private JScrollPane createNotesTextArea() {
        this.myNotesArea = new JTextArea(new CustomDocument());
        this.myNotesArea.setText(this.myResourceBundle.getString("PSaveSnapshotView_NotesGuideText"));
        this.myNotesArea.setLineWrap(true);
        this.myNotesArea.setWrapStyleWord(true);
        this.myNotesArea.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        this.myNotesArea.addFocusListener(new CustomFocusListener());
        JScrollPane scrollPane = new JScrollPane(this.myNotesArea);
        scrollPane.setBorder(BorderFactory.createEmptyBorder(0, 14, 0, 16));
        scrollPane.setPreferredSize(new Dimension(105, 115));
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setVerticalScrollBarPolicy(20);
        return scrollPane;
    }

    private void addDetailLevelToPanel(JPanel panel, PLabel detailLevelLabel, GridBagConstraints gbc, Insets labelInsets) {
        gbc.insets = labelInsets;
        panel.add((Component)detailLevelLabel, gbc);
        ++gbc.gridx;
        gbc.insets = new Insets(0, 15, 0, 0);
        panel.add((Component)this.myCurrentButton, gbc);
        ++gbc.gridy;
        gbc.insets = new Insets(0, 15, 0, 0);
        panel.add((Component)this.myMostImportantButton, gbc);
        ++gbc.gridy;
        panel.add((Component)this.myAllButton, gbc);
    }

    private void addAdditionalInfoToPanel(JPanel panel, GridBagConstraints gbc, String additionalInfo) {
        ++gbc.gridx;
        gbc.insets = new Insets(0, 15, 0, 0);
        InfoButton InfoButton2 = new InfoButton(additionalInfo);
        panel.add((Component)InfoButton2, gbc);
    }

    private void addFetchDataFromToPanel(JPanel panel, PLabel fetchDataFromLabel, JScrollPane tableScrollPane, Set<PLabel> warningLabels, GridBagConstraints gbc) {
        gbc.gridx -= 2;
        ++gbc.gridy;
        gbc.insets = new Insets(12, 18, 0, 0);
        panel.add((Component)fetchDataFromLabel, gbc);
        gbc.gridx += 2;
        gbc.insets = new Insets(12, 18, 0, 12);
        panel.add((Component)tableScrollPane, gbc);
        for (PLabel warningLabel : warningLabels) {
            gbc.insets = new Insets(12, 220, 0, 12);
            panel.add((Component)warningLabel, gbc);
        }
    }

    private void addCharactersCountToPanel(JPanel panel, PLabel charactersLabel, GridBagConstraints gbc) {
        ++gbc.gridy;
        gbc.insets = new Insets(2, 0, 6, 18);
        gbc.weightx = 1.0;
        gbc.anchor = 24;
        panel.add((Component)charactersLabel, gbc);
        gbc.weightx = 0.0;
        ++gbc.gridx;
        panel.add((Component)this.myCharactersCountLabel, gbc);
    }

    private void addNotesToPanel(JPanel panel, PLabel notesLabel, JScrollPane scrollPane, GridBagConstraints gbc, Insets labelInsets) {
        gbc.anchor = 23;
        gbc.gridx -= 2;
        gbc.insets = labelInsets;
        panel.add((Component)notesLabel, gbc);
        ++gbc.gridy;
        gbc.insets = new Insets(0, 4, 12, 0);
        gbc.gridwidth = 3;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel.add((Component)scrollPane, gbc);
    }

    private boolean isAnyRowSelected() {
        boolean anyRowSelected = false;
        int i = 0;
        while (i < this.mySnapshotTableModel.getRowCount()) {
            anyRowSelected = (Boolean)this.mySnapshotTableModel.getValueAt(i, 0);
            if (anyRowSelected) break;
            ++i;
        }
        return anyRowSelected;
    }

    private void setSaveButtonEnabled(boolean flag) {
        Component[] components = this.getButtonPanel().getComponents();
        Component saveButton = null;
        Component[] componentArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            if (component instanceof JButton) {
                saveButton = component;
                break;
            }
            ++n2;
        }
        if (saveButton != null) {
            saveButton.setEnabled(flag);
            this.closeSaveButtonBalloon(flag);
        }
    }

    @Override
    protected void installListeners(JFileChooser fc) {
        super.installListeners(fc);
        fc.addPropertyChangeListener(this);
    }

    @Override
    protected void uninstallListeners(JFileChooser fc) {
        super.uninstallListeners(fc);
        fc.removePropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        this.setSaveButtonEnabled(this.isDirectorySelectedOrHasFileName());
        this.checkSaveSnapshotAvailability();
        if (this.myModuleVisible && this.myTable.isEnabled()) {
            this.setSaveButtonEnabled(this.isAnyRowSelected() && this.isDirectorySelectedOrHasFileName());
            this.checkSaveSnapshotAvailability();
        }
        if ("disabledlevels".equals(evt.getPropertyName())) {
            List disabledLevels = (List)evt.getNewValue();
            if (disabledLevels == null) {
                disabledLevels = Collections.EMPTY_LIST;
            }
            this.myCurrentButton.setEnabled(!disabledLevels.contains((Object)PSnapshotConst.SNAPSHOT_LEVEL.AVAILABLE_DATA));
            this.myMostImportantButton.setEnabled(!disabledLevels.contains((Object)PSnapshotConst.SNAPSHOT_LEVEL.MOST_IMPORTANT_DATA));
            this.myAllButton.setEnabled(!disabledLevels.contains((Object)PSnapshotConst.SNAPSHOT_LEVEL.ALL_DATA));
            if (this.myAllButton.isEnabled()) {
                this.myAllButton.doClick();
            } else if (this.myMostImportantButton.isEnabled()) {
                this.myMostImportantButton.doClick();
            } else if (this.myCurrentButton.isEnabled()) {
                this.myCurrentButton.doClick();
            } else {
                throw new IllegalArgumentException("All levels cannot be disabled.");
            }
        }
    }

    private boolean isDirectorySelectedOrHasFileName() {
        return this.isDirectorySelected() || this.getFileName().length() > 0;
    }

    private void checkSaveSnapshotAvailability() {
        PSnapshotSaveAvailability saveAvailable = (PSnapshotSaveAvailability)PoseidonRuntime.getRuntime().getRuntimeProperty("SAVE_SNAPSHOT_FUNCTION_AVAILABLE");
        if (saveAvailable != null && this.myTextField != null) {
            if (this.myTextField.getText().isEmpty() && saveAvailable.isSnapshotSaveAvailable() && !this.isDirectorySelected()) {
                this.setSaveButtonEnabled(false);
            } else if (!saveAvailable.isSaveAvailabilityRulesEmpty()) {
                this.setSaveButtonEnabled(saveAvailable.isSnapshotSaveAvailable());
            }
            this.setTooltipAndBalloon(saveAvailable);
        }
    }

    private void setTooltipAndBalloon(PSnapshotSaveAvailability saveAvailable) {
        this.getApproveButton(this.getFileChooser()).setToolTipText(saveAvailable.getSaveSnapshotButtonTooltip());
        if (this.shouldShowSaveButtonBalloon(saveAvailable)) {
            this.showSaveButtonBalloon(saveAvailable);
        }
    }

    private void showSaveButtonBalloon(PSnapshotSaveAvailability saveAvailable) {
        PSaveSnapshotInAvailabilityDetails details = saveAvailable.getSaveSnapshotButtonDetails();
        ((PSaveSnapshotView)this.getFileChooser()).showSaveButtonBalloon(details.getTitle(), details.getDetails());
    }

    private boolean shouldShowSaveButtonBalloon(PSnapshotSaveAvailability saveAvailable) {
        return saveAvailable.getSaveSnapshotButtonDetails() != null && !saveAvailable.isSnapshotSaveAvailable();
    }

    private void closeSaveButtonBalloon(boolean saveButtonEnable) {
        if (saveButtonEnable) {
            ((PSaveSnapshotView)this.getFileChooser()).closeSaveButtonBalloon();
        }
    }

    public static double getStringWidth(Font font, String text) {
        double width = 0.0;
        FontMetrics fm = new Button().getFontMetrics(font);
        width = SwingUtilities.computeStringWidth(fm, text);
        return width;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.myController = (SaveChooserController)((PSaveSnapshotView)this.getFileChooser()).getController();
        if (e.getSource().equals(this.myAllButton)) {
            this.myController.setLevel(PSnapshotConst.SNAPSHOT_LEVEL.ALL_DATA);
        } else if (e.getSource().equals(this.myMostImportantButton)) {
            this.myController.setLevel(PSnapshotConst.SNAPSHOT_LEVEL.MOST_IMPORTANT_DATA);
        } else if (e.getSource().equals(this.myCurrentButton)) {
            this.myController.setLevel(PSnapshotConst.SNAPSHOT_LEVEL.AVAILABLE_DATA);
        }
        if (this.myModuleVisible) {
            this.setTableState();
            if (this.myTable.isEnabled()) {
                this.setSaveButtonEnabled(this.isAnyRowSelected() && this.isDirectorySelectedOrHasFileName());
            } else {
                this.setSaveButtonEnabled(this.isDirectorySelectedOrHasFileName());
                this.checkSaveSnapshotAvailability();
            }
            this.updateWarningLabelVisibility(e);
        }
    }

    protected void setTableState() {
        boolean currentDetailLevelselected = this.myCurrentButton.isSelected();
        this.mySnapshotTableModel.setTableDisabled(currentDetailLevelselected);
        this.myTable.getTableHeader().setEnabled(!currentDetailLevelselected);
        this.myTable.setEnabled(!currentDetailLevelselected);
        this.myTable.repaint();
    }

    private void updateWarningLabelVisibility(ActionEvent e) {
        for (PLabel warningLabel : this.myWarningLabelMap.keySet()) {
            PSaveSnapshotModules.PSaveSnapshotWarningLabelVisibility warningLabelVisibility = this.myWarningLabelMap.get(warningLabel);
            if (warningLabelVisibility == PSaveSnapshotModules.PSaveSnapshotWarningLabelVisibility.CURRENT_VISIBLE) {
                warningLabel.setVisible(e.getSource().equals(this.myCurrentButton));
                continue;
            }
            if (warningLabelVisibility == PSaveSnapshotModules.PSaveSnapshotWarningLabelVisibility.MOST_VISIBLE) {
                warningLabel.setVisible(e.getSource().equals(this.myMostImportantButton));
                continue;
            }
            if (warningLabelVisibility == PSaveSnapshotModules.PSaveSnapshotWarningLabelVisibility.ALL_VISIBLE) {
                warningLabel.setVisible(e.getSource().equals(this.myAllButton));
                continue;
            }
            if (warningLabelVisibility != PSaveSnapshotModules.PSaveSnapshotWarningLabelVisibility.MOST_AND_ALL_VISIBLE) continue;
            warningLabel.setVisible(e.getSource().equals(this.myMostImportantButton) || e.getSource().equals(this.myAllButton));
        }
    }

    public void handleDispose() {
        PSnapshotSaveAvailability ps = (PSnapshotSaveAvailability)PoseidonRuntime.getRuntime().getRuntimeProperty("SAVE_SNAPSHOT_FUNCTION_AVAILABLE");
        if (ps != null) {
            ps.removePropertyChangeListener("SAVESNAPSHOTUI_PROPERTYCHANGE", this);
        }
    }

    protected void setControllerModules() {
        this.myController.setModules(this.mySnapshotTableModel.getModules());
    }

    protected class CustomDocument
    extends PlainDocument {
        protected CustomDocument() {
        }

        @Override
        public void insertString(int offset, String str, AttributeSet attrs) throws BadLocationException {
            String inserted = str;
            int currentLength = this.getLength();
            if (currentLength + str.length() > 500) {
                inserted = str.substring(0, 500 - currentLength);
            }
            super.insertString(offset, inserted, attrs);
            PSaveSnapshotUI.this.myCharactersCountLabel.setText(String.valueOf(500 - this.getLength()) + "/500");
        }

        @Override
        public void remove(int offs, int len) throws BadLocationException {
            super.remove(offs, len);
            PSaveSnapshotUI.this.myCharactersCountLabel.setText(String.valueOf(500 - this.getLength()) + "/500");
        }
    }

    protected class CustomFocusListener
    implements FocusListener {
        private boolean myFirstTime = true;

        protected CustomFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (this.myFirstTime) {
                PSaveSnapshotUI.this.myNotesArea.setText("");
                this.myFirstTime = false;
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            PSaveSnapshotUI.this.myController.setNotes(PSaveSnapshotUI.this.myNotesArea.getText());
        }
    }

    private class ModuleSelectionListener
    implements TableModelListener {
        private ModuleSelectionListener() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (PSaveSnapshotUI.this.myController != null && PSaveSnapshotUI.this.mySnapshotTableModel != null) {
                PSaveSnapshotUI.this.setControllerModules();
                PSaveSnapshotUI.this.setSaveButtonEnabled(PSaveSnapshotUI.this.isAnyRowSelected() && PSaveSnapshotUI.this.isDirectorySelectedOrHasFileName());
                if (PSaveSnapshotUI.this.getApproveButton(PSaveSnapshotUI.this.getFileChooser()).isEnabled()) {
                    PSaveSnapshotUI.this.checkSaveSnapshotAvailability();
                }
            }
        }
    }
}

