/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.snapshot;

import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.gui.common.PStaticDialogs;
import com.nokia.em.poseidon.gui.savechooser.SaveChooserController;
import com.nokia.em.poseidon.gui.savechooser.SaveChooserView;
import com.nokia.em.poseidon.gui.snapshot.PSaveSnapshotUI;
import com.nokia.em.poseidon.gui.snapshot.PSnapshotController;
import com.nokia.em.poseidon.gui.snapshot.UIClassIDProvider;
import com.nokia.em.poseidon.services.snapshot.PSnapshotConst;
import com.nokia.em.poseidon.services.ui.UserInterface;
import com.nokia.em.poseidon.util.TextUtils;
import com.nokia.em.poseidon.util.file.diskspace.DiskSpaceException;
import com.nokia.widgets.balloon.Balloon;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class PSaveSnapshotView
extends SaveChooserView
implements HierarchyListener {
    private static final int STEPS_INDEX_DISK_FULL = 1;
    private static final int STEPS_INDEX = 0;
    private static final int PREFERRED_ERROR_WIDTH = 50;
    private static final int PATH_INDEX = 0;
    private static final int CAUSE_INDEX = 1;
    private String myStrErrorHdr;
    private String myStrErrorMsg;

    static {
        UIManager.put("PSaveSnapshotUI", PSaveSnapshotUI.class.getName());
    }

    public PSaveSnapshotView(SaveChooserController ctrl, Component parent) {
        super(ctrl, parent);
        this.addHierarchyListener(this);
    }

    public void setDisabledLevels(List<PSnapshotConst.SNAPSHOT_LEVEL> disabledLevels) {
        this.firePropertyChange("disabledlevels", null, disabledLevels);
    }

    public void showMessage(PSnapshotController.ErrorType type, Object ... param) {
        JFrame mainFrame = PoseidonRuntime.getRuntime().getService(UserInterface.class).getFrame();
        if (type.equals((Object)PSnapshotController.ErrorType.CANNOT_CREATE_TEMP_DIR)) {
            PStaticDialogs.showErrorDialog(mainFrame, this.getSnapshotDialogTitle(), this.myResourceBundle.getString("PSaveSnapshotView_Saving_Start_Fail_Header"), this.myResourceBundle.getString("PSaveSnapshotView_Saving_Start_Fail_Message"), null);
        } else if (type.equals((Object)PSnapshotController.ErrorType.MEDIATOR_FAILED_DISK_FULL)) {
            this.showElementFailureDiskIsFull(mainFrame, param);
        } else if (type.equals((Object)PSnapshotController.ErrorType.MEDIATORS_FAILED_SAVING)) {
            this.showElementFailure(mainFrame, param);
        } else if (type.equals((Object)PSnapshotController.ErrorType.SAVING_FAILED)) {
            this.showGeneralFailure(mainFrame, param);
        } else if (type.equals((Object)PSnapshotController.ErrorType.COPYING_FAILED)) {
            this.showCopyFailure(mainFrame, param);
        }
    }

    private String getSnapshotDialogTitle() {
        return this.myResourceBundle.getString("PSaveSnapshotView_Title");
    }

    private void showElementFailure(JFrame mainFrame, Object ... param) {
        String message = this.myResourceBundle.getString("PSaveSnapshotView_Saving_Partial_Fail_Message");
        message = String.valueOf(TextUtils.textWrap(message, 50)) + param[0] + this.myResourceBundle.getString("PSaveSnapshotView_Saving_Partial_Fail_Try_Again");
        PStaticDialogs.showErrorDialog(mainFrame, this.getSnapshotDialogTitle(), this.myResourceBundle.getString("PSaveSnapshotView_Saving_Partial_Fail_Header"), message, null);
    }

    private void showElementFailureDiskIsFull(JFrame mainFrame, Object ... param) {
        String message = String.valueOf(this.getErrorMessage("", this.myResourceBundle.getString("PSaveSnapshotView_Saving_Partial_Disk_Full_Fail_Message"), param)) + param[1];
        PStaticDialogs.showErrorDialog(mainFrame, this.getSnapshotDialogTitle(), this.myResourceBundle.getString("PSaveSnapshotView_Saving_Partial_Fail_Header"), message, null);
    }

    private String getErrorMessage(String originalMessage, String alternativeMessage, Object ... param) {
        String newMessage = originalMessage;
        if (param != null) {
            Object[] wrapPath = new Object[]{TextUtils.textWrapPath(param[0].toString(), 50)};
            newMessage = TextUtils.textWrap(MessageFormat.format(alternativeMessage, wrapPath));
        }
        return newMessage;
    }

    private void showGeneralFailure(JFrame mainFrame, Object ... param) {
        String message = this.getErrorMessage(this.myResourceBundle.getString("PSaveSnapshotView_Saving_Fail_Message"), this.myResourceBundle.getString("PSaveSnapshotView_Saving_Fail_Disk_Full_Message"), param);
        String header = param == null ? this.myResourceBundle.getString("PSaveSnapshotView_Saving_Fail_Header") : this.myResourceBundle.getString("PSaveSnapshotView_Saving_Fail_Disk_Full_Header");
        PStaticDialogs.showErrorDialog(mainFrame, this.getSnapshotDialogTitle(), header, message, null);
    }

    private void showCopyFailure(JFrame mainFrame, Object ... param) {
        String message = this.myResourceBundle.getString("PSaveSnapshotView_Copying_Fail_Message");
        String header = this.myResourceBundle.getString("PSaveSnapshotView_Copying_Fail_Header");
        if (param.length > 1 && param[1] instanceof DiskSpaceException) {
            header = this.myResourceBundle.getString("PSaveSnapshotView_Copying_Fail_Disk_Full_Header");
            Object[] wrapPath = new Object[]{TextUtils.textWrapPath(param[0].toString(), 50)};
            message = TextUtils.textWrap(MessageFormat.format(this.myResourceBundle.getString("PSaveSnapshotView_Copying_Fail_Disk_Full_Message"), wrapPath));
        }
        Action[] actions = new Action[]{PStaticDialogs.getEmptyAction(this.myResourceBundle.getString("CloseAction_Text"))};
        PStaticDialogs.showErrorDialog(mainFrame, this.getCopyDialogTitle(), header, message, null, actions);
    }

    private String getCopyDialogTitle() {
        return this.myResourceBundle.getString("PSaveSnapshotView_Copying_Fail_Title");
    }

    public void showError(String strErrorHdr, String strErrorMsg) {
        this.closeBalloon();
        if (SwingUtilities.getAncestorOfClass(JInternalFrame.class, this) != null) {
            this.myBalloon = this.createBalloon(strErrorHdr, strErrorMsg, this.myFilenameField);
            this.myBalloon.showBalloon();
        } else {
            this.myStrErrorHdr = strErrorHdr;
            this.myStrErrorMsg = strErrorMsg;
        }
    }

    public void showSaveButtonBalloon(String strErrorHdr, String strErrorMsg) {
        if (!this.isSaveButtonBalloonShown()) {
            this.closeBalloon();
            this.myBalloon = this.createBalloon(strErrorHdr, strErrorMsg, this.myApproveButton);
            this.myBalloon.showBalloon();
        }
    }

    public void closeSaveButtonBalloon() {
        if (this.isSaveButtonBalloonShown()) {
            this.closeBalloon();
        }
    }

    private boolean isSaveButtonBalloonShown() {
        if (this.myBalloon == null) {
            return false;
        }
        return this.myBalloon.getHost() == this.myApproveButton;
    }

    private Balloon createBalloon(String strErrorHdr, String strErrorMsg, JComponent component) {
        return new Balloon(component, this, strErrorMsg, strErrorHdr, 0, 0);
    }

    @Override
    public String getUIClassID() {
        Optional<UIClassIDProvider> uiClassIDProvider = Optional.ofNullable(PoseidonRuntime.getRuntime().getObject(UIClassIDProvider.class));
        return uiClassIDProvider.map(classProvider -> classProvider.getUIClassID()).orElse("PSaveSnapshotUI");
    }

    protected File checkFileNameUniqueness(String defaultFilename) {
        String currentDirectory = this.getCurrentDirectory() + System.getProperty("file.separator");
        File defaultFile = new File(String.valueOf(currentDirectory) + defaultFilename);
        return defaultFile.exists() ? this.createAlternativeDefaultFile(defaultFile) : defaultFile;
    }

    @Override
    protected JDialog createDialog(Component parent) throws HeadlessException {
        JDialog dialog = super.createDialog(parent);
        dialog.setMinimumSize(new Dimension(780, 700));
        if (dialog.getX() == this.getDefaultXCoordinate() && dialog.getY() == this.getDefaultYCoordinate()) {
            dialog.setLocationRelativeTo(parent);
        }
        return dialog;
    }

    @Override
    protected void removeTooltipText() {
        this.myApproveButton.setToolTipText(null);
        this.myRejectButton.setToolTipText(null);
        this.myApproveButton.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (PSaveSnapshotView.this.myApproveButton != null && PSaveSnapshotView.this.myApproveButton.isEnabled()) {
                    PSaveSnapshotView.this.myApproveButton.setToolTipText(null);
                }
            }
        });
    }

    @Override
    public void hierarchyChanged(HierarchyEvent e) {
        long changeFlags = e.getChangeFlags();
        if ((changeFlags & 4L) != 0L && this.isVisible() && this.myStrErrorHdr != null && this.myStrErrorMsg != null) {
            this.closeBalloon();
            this.myBalloon = this.createBalloon(this.myStrErrorHdr, this.myStrErrorMsg, this.myFilenameField);
            this.myBalloon.showBalloon();
        }
    }

    @Override
    public void dispose() {
        if (this.getUI() instanceof PSaveSnapshotUI) {
            PSaveSnapshotUI saveSnapshotUI = (PSaveSnapshotUI)this.getUI();
            saveSnapshotUI.handleDispose();
        }
        super.dispose();
    }

    public void closeDialogs() {
        Arrays.asList(Window.getWindows()).stream().filter(window -> this.isDialogBelongsSnapshotView((Window)window)).forEach(window -> window.setVisible(false));
    }

    private boolean isDialogBelongsSnapshotView(Window window) {
        if (!(window instanceof JDialog)) {
            return false;
        }
        JDialog dialog = (JDialog)window;
        return this.getSnapshotDialogTitle().equals(dialog.getTitle()) || this.getCopyDialogTitle().equals(dialog.getTitle());
    }
}

