/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.snapshot;

import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.frameworks.i18n.localizer.Localizer;
import com.nokia.em.poseidon.frameworks.i18n.localizer.LocalizerRegistry;
import com.nokia.em.poseidon.frameworks.i18n.localizer.swing.SwingHierarchyIterator;
import com.nokia.em.poseidon.frameworks.mvc.Controller;
import com.nokia.em.poseidon.frameworks.mvc.View;
import com.nokia.em.poseidon.frameworks.mvc.swing.JDialogViewBase;
import com.nokia.em.poseidon.gui.common.PStaticDialogs;
import com.nokia.em.poseidon.gui.common.taskview.PTaskViewButtonBar;
import com.nokia.em.poseidon.gui.snapshot.PSnapshotController;
import com.nokia.em.poseidon.gui.snapshot.PSnapshotDetailsController;
import com.nokia.em.poseidon.services.snapshot.desc.ManagerShortName;
import com.nokia.em.poseidon.services.snapshot.desc.Notes;
import com.nokia.em.poseidon.services.snapshot.desc.SavingDate;
import com.nokia.em.poseidon.services.snapshot.desc.SnapshotInfo;
import com.nokia.em.poseidon.services.snapshot.desc.SoftwareReleaseVersion;
import com.nokia.em.poseidon.services.snapshot.desc.UserName;
import com.nokia.em.poseidon.services.ui.UserInterface;
import com.nokia.widgets.ClientProperties;
import com.nokia.widgets.PPanel;
import com.nokia.widgets.labels.PLabel;
import com.nokia.widgets.labels.PMultiLineLabel;
import com.nokia.widgets.util.PListFocusTraversalPolicy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.MessageFormat;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class PSnapshotDetailsView
extends JDialogViewBase {
    private ResourceBundle myResourceBundle;
    private SnapshotInfo mySnapshotInfo;
    private JButton myCloseButton;
    private PSnapshotDetailsController mySnapshotDetailsController;
    private final PListFocusTraversalPolicy myFocusPolicy = new PListFocusTraversalPolicy();

    public PSnapshotDetailsView(PSnapshotDetailsController snapshotDetailsController, Frame owner, SnapshotInfo info) {
        super((Controller)snapshotDetailsController, owner);
        this.mySnapshotDetailsController = snapshotDetailsController;
        this.mySnapshotInfo = info;
        this.myResourceBundle = I18n.getI18n().getBundle(this.getClass());
        this.addGuiListener(snapshotDetailsController);
        this.buildGui();
        this.restoreSettings();
    }

    public void showMessage(PSnapshotController.ErrorType type) {
        if (type.equals((Object)PSnapshotController.ErrorType.NO_INFORMATION)) {
            PStaticDialogs.showErrorDialog(PoseidonRuntime.getRuntime().getService(UserInterface.class).getFrame(), this.myResourceBundle.getString("PSnapshotDetailsView.Title"), this.myResourceBundle.getString("PSnapshotDetailsView.NoInfo_header"), this.myResourceBundle.getString("PSnapshotDetailsView.NoInfo_message"), null);
        }
    }

    private void buildGui() {
        this.setTitle(this.myResourceBundle.getString("PSnapshotDetailsView.Title"));
        PPanel contentPanel = new PPanel();
        contentPanel.setLayout(new BorderLayout());
        this.setContentPane(contentPanel);
        PPanel upperPanel = new PPanel();
        upperPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 6));
        upperPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        contentPanel.add((Component)upperPanel, "Center");
        Insets firstColInsets = new Insets(0, 18, 3, 0);
        Insets secondColInsets = new Insets(0, 18, 3, 12);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 23;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(12, 18, 3, 0);
        upperPanel.add((Component)this.createLabel("PSnapshotDetailsView.NotesLabel"), gbc);
        ++gbc.gridx;
        gbc.insets = new Insets(12, 18, 3, 12);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        this.addNotesToPanel(upperPanel, gbc);
        gbc.fill = 0;
        gbc.weightx = 0.0;
        --gbc.gridx;
        ++gbc.gridy;
        gbc.insets = firstColInsets;
        upperPanel.add((Component)this.createLabel("PSnapshotDetailsView.FileNameLabel"), gbc);
        ++gbc.gridx;
        gbc.insets = secondColInsets;
        upperPanel.add((Component)this.createTextLabel(this.getDataFromInfo(infoKey.KEY_FILENAME)), gbc);
        --gbc.gridx;
        ++gbc.gridy;
        gbc.insets = firstColInsets;
        upperPanel.add((Component)this.createLabel("PSnapshotDetailsView.SavingDateLabel"), gbc);
        ++gbc.gridx;
        gbc.insets = secondColInsets;
        PLabel versionLabel = this.createTextLabel(this.getDataFromInfo(infoKey.KEY_SAVING_DATE));
        upperPanel.add((Component)versionLabel, gbc);
        --gbc.gridx;
        ++gbc.gridy;
        gbc.insets = firstColInsets;
        upperPanel.add((Component)this.createLabel("PSnapshotDetailsView.UserNameLabel"), gbc);
        ++gbc.gridx;
        gbc.insets = secondColInsets;
        upperPanel.add((Component)this.createTextLabel(this.getDataFromInfo(infoKey.KEY_USER_NAME)), gbc);
        --gbc.gridx;
        ++gbc.gridy;
        gbc.insets = new Insets(6, 18, 12, 12);
        gbc.gridwidth = 2;
        Object[] params = new Object[]{this.getDataFromInfo(infoKey.KEY_MANAGER_NAME)};
        PLabel temp = this.createTextLabel(MessageFormat.format(this.myResourceBundle.getString("PSnapshotDetailsView.VersionLabel"), params));
        temp.setLabelType(ClientProperties.LABEL_TITLE);
        upperPanel.add((Component)temp, gbc);
        gbc.gridwidth = 1;
        ++gbc.gridy;
        gbc.insets = firstColInsets;
        upperPanel.add((Component)this.createLabel("PSnapshotDetailsView.SavedVersionLabel"), gbc);
        ++gbc.gridx;
        gbc.insets = secondColInsets;
        upperPanel.add((Component)this.createTextLabel(this.getDataFromInfo(infoKey.KEY_SAVED_VERSION)), gbc);
        --gbc.gridx;
        ++gbc.gridy;
        gbc.insets = firstColInsets;
        PLabel openedVersionLabel = this.createLabel("PSnapshotDetailsView.OpenedVersionLabel");
        upperPanel.add((Component)openedVersionLabel, gbc);
        ++gbc.gridx;
        gbc.insets = new Insets(0, 18, 18, 12);
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        upperPanel.add((Component)this.createTextLabel(this.getDataFromInfo(infoKey.KEY_OPENED_VERSION)), gbc);
        this.myCloseButton = new JButton();
        this.myCloseButton.setName("CloseAction");
        this.myCloseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PSnapshotDetailsView.this.mySnapshotDetailsController.destroy();
            }
        });
        AbstractButton[] buttons = new AbstractButton[]{this.myCloseButton};
        PTaskViewButtonBar buttonbar = new PTaskViewButtonBar(buttons);
        contentPanel.add((Component)buttonbar, "South");
        Localizer localizer = LocalizerRegistry.lookup("swing");
        localizer.setResourceBundle(this.myResourceBundle);
        localizer.localizeObjectHierarchy(new SwingHierarchyIterator(this));
        this.setModal(true);
        this.setResizable(false);
        this.addFocusTraversalPolicy();
        this.pack();
        this.getRootPane().setDefaultButton(this.myCloseButton);
        this.myCloseButton.requestFocus();
    }

    private void addFocusTraversalPolicy() {
        this.myFocusPolicy.add(this.myCloseButton);
        this.setFocusTraversalPolicy(this.myFocusPolicy);
    }

    private void addNotesToPanel(PPanel upperPanel, GridBagConstraints gbc) {
        PMultiLineLabel notesTextLabel = this.createNotesLabel();
        JScrollPane scrollPane = this.createNotesScrollPane(notesTextLabel);
        upperPanel.add((Component)scrollPane, gbc);
    }

    private PMultiLineLabel createNotesLabel() {
        PMultiLineLabel notesTextLabel = new PMultiLineLabel();
        notesTextLabel.setBorder(new EmptyBorder(0, 4, 0, 4));
        notesTextLabel.setText(this.getDataFromInfo(infoKey.KEY_NOTES));
        notesTextLabel.setBackgroundColorTransparent();
        notesTextLabel.setRows(5);
        return notesTextLabel;
    }

    private JScrollPane createNotesScrollPane(PMultiLineLabel notesTextLabel) {
        final JScrollPane scrollPane = new JScrollPane(notesTextLabel);
        scrollPane.setPreferredSize(new Dimension(0, 95));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                scrollPane.getVerticalScrollBar().setValue(0);
            }
        });
        return scrollPane;
    }

    private PLabel createLabel(String name) {
        PLabel label = new PLabel();
        label.setLabelType(ClientProperties.LABEL_SYSTEM_TEXT);
        label.setName(name);
        return label;
    }

    private PLabel createTextLabel(String text) {
        PLabel label = PLabel.createValueText(text);
        return label;
    }

    private String getDataFromInfo(infoKey key) {
        String returnValue = "";
        switch (key) {
            case KEY_NOTES: {
                String temp;
                Notes notes = this.mySnapshotInfo.getNotes();
                if (notes == null || (temp = notes.getNotes()) == null) break;
                returnValue = temp;
                break;
            }
            case KEY_FILENAME: {
                String temp = this.mySnapshotInfo.getFileName();
                if (temp == null) break;
                try {
                    returnValue = URLDecoder.decode(temp, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    returnValue = temp.replace("%20", " ");
                }
                break;
            }
            case KEY_SAVING_DATE: {
                String temp;
                SavingDate savingDate = this.mySnapshotInfo.getSavingDate();
                if (savingDate == null || (temp = savingDate.getSavingDate()) == null) break;
                returnValue = temp;
                break;
            }
            case KEY_USER_NAME: {
                String temp;
                UserName userName = this.mySnapshotInfo.getUserName();
                if (userName == null || (temp = userName.getUserName()) == null) break;
                returnValue = temp;
                break;
            }
            case KEY_MANAGER_NAME: {
                String temp;
                ManagerShortName managerShortName = this.mySnapshotInfo.getManagerShortName();
                if (managerShortName == null || (temp = managerShortName.getManagerShortName()) == null) break;
                returnValue = temp;
                break;
            }
            case KEY_SAVED_VERSION: {
                String temp;
                SoftwareReleaseVersion version = this.mySnapshotInfo.getSoftwareReleaseVersion();
                if (version == null || (temp = version.getSoftwareReleaseVersion()) == null) break;
                returnValue = temp;
                break;
            }
            case KEY_OPENED_VERSION: {
                String temp = this.mySnapshotInfo.getOpeningVersion();
                if (temp == null) break;
                returnValue = temp;
                break;
            }
        }
        return returnValue;
    }

    public void add(View view, Object constraint) {
    }

    private static enum infoKey {
        KEY_NOTES,
        KEY_FILENAME,
        KEY_SAVING_DATE,
        KEY_USER_NAME,
        KEY_MANAGER_NAME,
        KEY_SAVED_VERSION,
        KEY_OPENED_VERSION;

    }
}

