/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.snapshot;

import com.nokia.em.poseidon.gui.savechooser.SaveChooserController;
import com.nokia.em.poseidon.gui.snapshot.PSaveSnapshotInAvailabilityDetails;
import com.nokia.em.poseidon.gui.snapshot.SaveAvailabilityRule;
import com.nokia.em.poseidon.gui.snapshot.SaveAvailabilityRuleWithDetails;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;

public class PSnapshotSaveAvailability {
    private String myIsSnapshotButtonTooltip;
    private PSaveSnapshotInAvailabilityDetails mySaveSnapshotButtonDetails;
    public static final String SAVE_SNAPSHOT_AVAILABLE = "SAVE_SNAPSHOT_FUNCTION_AVAILABLE";
    public static final String SAVESNAPSHOTUI_PROPERTYCHANGE = "SAVESNAPSHOTUI_PROPERTYCHANGE";
    private Map<String, SaveAvailabilityRule> mySaveAvailabilityRules = new HashMap<String, SaveAvailabilityRule>();
    private SaveChooserController mySaveSnapshotController;
    private PropertyChangeSupport myPropertyChangeSupport = new PropertyChangeSupport(this);

    public void setSaveSnapshotController(SaveChooserController controller) {
        this.mySaveSnapshotController = controller;
    }

    public void addSaveAvailabilityRule(String name, SaveAvailabilityRule rule) {
        this.mySaveAvailabilityRules.put(name, rule);
        this.myPropertyChangeSupport.firePropertyChange(SAVESNAPSHOTUI_PROPERTYCHANGE, null, rule);
    }

    public void removeSaveAvailabilityRule(String name) {
        this.mySaveAvailabilityRules.remove(name);
        this.myPropertyChangeSupport.firePropertyChange(SAVESNAPSHOTUI_PROPERTYCHANGE, name, null);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.myPropertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.myPropertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName) {
        PropertyChangeListener[] listeners = this.myPropertyChangeSupport.getPropertyChangeListeners(propertyName);
        if (listeners != null && listeners.length > 0) {
            this.myPropertyChangeSupport.removePropertyChangeListener(propertyName, listeners[0]);
        }
    }

    public boolean isSnapshotSaveAvailable() {
        for (Map.Entry<String, SaveAvailabilityRule> entry : this.mySaveAvailabilityRules.entrySet()) {
            if (this.mySaveSnapshotController == null || entry.getValue().isSnapshotSaveAvailable(this.mySaveSnapshotController.getModules(), this.mySaveSnapshotController.getLevel())) continue;
            this.setSaveSnapshotButtonTooltip(entry.getValue().getSaveSnapshotButtonTooltip());
            this.setBalloonDetails(entry.getValue());
            return false;
        }
        this.setSaveSnapshotButtonTooltip(null);
        this.setBalloonDetails(null);
        return true;
    }

    private void setBalloonDetails(SaveAvailabilityRule value) {
        if (value instanceof SaveAvailabilityRuleWithDetails) {
            this.setSaveSnapshotButtonDetails(((SaveAvailabilityRuleWithDetails)value).getDetails());
        } else {
            this.setSaveSnapshotButtonDetails(null);
        }
    }

    private void setSaveSnapshotButtonTooltip(String tooltip) {
        this.myIsSnapshotButtonTooltip = tooltip;
    }

    public String getSaveSnapshotButtonTooltip() {
        return this.myIsSnapshotButtonTooltip;
    }

    public PSaveSnapshotInAvailabilityDetails getSaveSnapshotButtonDetails() {
        return this.mySaveSnapshotButtonDetails;
    }

    private void setSaveSnapshotButtonDetails(PSaveSnapshotInAvailabilityDetails details) {
        this.mySaveSnapshotButtonDetails = details;
    }

    public boolean isSaveAvailabilityRulesEmpty() {
        return this.mySaveAvailabilityRules.isEmpty();
    }
}

