/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.snapshot;

import com.nokia.em.poseidon.frameworks.progress.step.PStepProgressErrorEvent;
import com.nokia.em.poseidon.frameworks.progress.step.PStepProgressEvent;
import com.nokia.em.poseidon.frameworks.progress.step.PStepProgressListener;
import com.nokia.em.poseidon.frameworks.progress.step.PStepProgressSource;
import com.nokia.em.poseidon.frameworks.progress.step.PStepProgressTask;
import com.nokia.widgets.progress.ProgressController;
import com.nokia.widgets.progress.ProgressDialogController;
import com.nokia.widgets.progress.ProgressSourceAdapter;
import com.nokia.widgets.progress.models.StepProgressModel;
import com.nokia.widgets.progress.models.StepProgressTask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;

public class StepProgressAdapter
extends ProgressSourceAdapter
implements PStepProgressListener {
    protected ProgressController myProgressController;
    protected Map<PStepProgressTask, String> myTasksToID;
    protected int myTaskID = 10000;
    protected PStepProgressSource myProgressSource;
    protected StepProgressModel myProgressModel;
    protected ProgressDialogController myProgressDialogController;

    public StepProgressAdapter(ProgressDialogController progressDialogController) {
        this.myProgressDialogController = progressDialogController;
        this.myProgressController = progressDialogController.getProgressController();
        this.myTasksToID = new HashMap<PStepProgressTask, String>();
        this.myProgressModel = (StepProgressModel)this.myProgressController.getModel();
    }

    public PStepProgressSource getProgressSource() {
        return this.myProgressSource;
    }

    public void setProgressSource(PStepProgressSource progressSource) {
        this.myProgressSource = progressSource;
        this.myProgressController.addSource(this);
    }

    @Override
    public void setProgressTasks(List<PStepProgressTask> tasks) {
        if (tasks != null) {
            ArrayList<String> mainTaskIDs = new ArrayList<String>();
            for (PStepProgressTask task : tasks) {
                if ("Main Task".equals(task.getOperationName())) {
                    task.setOperationName(task.getOwner());
                    this.addChildTasksToModel(task, null);
                    mainTaskIDs.add(this.myTasksToID.get(task));
                    continue;
                }
                this.addChildTasksToModel(task, null);
            }
            if (mainTaskIDs.size() > 1) {
                for (String id : mainTaskIDs) {
                    this.myProgressModel.collapseStep(id);
                }
            }
        }
    }

    private void addChildTasksToModel(PStepProgressTask task, StepProgressTask parentTask) {
        StepProgressTask createdTask = new StepProgressTask(String.valueOf(++this.myTaskID), task.getOperationName(), parentTask);
        this.myProgressModel.addStep(createdTask);
        this.myTasksToID.put(task, String.valueOf(this.myTaskID));
        List<PStepProgressTask> children = task.getChildTasks();
        if (children.size() > 0) {
            for (PStepProgressTask progressTask : children) {
                this.addChildTasksToModel(progressTask, createdTask);
            }
        }
    }

    public void updateStepDescription(PStepProgressEvent event) {
        String id = this.myTasksToID.get(event.getUpdatedTask());
        this.myProgressModel.setStepDescription(id, event.getUpdatedTask().getOperationName());
    }

    @Override
    public void taskUpdated(PStepProgressEvent event) {
        PStepProgressTask.State taskState = event.getUpdatedTask().getState();
        String id = this.myTasksToID.get(event.getUpdatedTask());
        this.myProgressModel.setStepDescription(id, event.getUpdatedTask().getOperationName());
        switch (taskState) {
            case STARTED: {
                this.myProgressModel.startStep(id);
                break;
            }
            case CANCELLED: {
                this.myProgressModel.cancelStep(id);
                break;
            }
            default: {
                this.myProgressModel.stopStep(id, PStepProgressTask.State.COMPLETED.equals((Object)event.getUpdatedTask().getState()));
            }
        }
    }

    @Override
    public void operationCompleted(PStepProgressEvent event) {
        this.taskUpdated(event);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StepProgressAdapter.this.myProgressController.stop();
            }
        });
    }

    @Override
    public void operationFailed(PStepProgressErrorEvent event) {
        this.taskUpdated(event);
        this.myProgressController.stop();
    }

    @Override
    public boolean canBeCancelled() {
        return this.myProgressSource.isCancellable();
    }

    @Override
    public boolean canBeRestarted() {
        return false;
    }

    @Override
    public void cancel() {
        this.myProgressSource.cancel();
    }
}

