/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.treeview;

import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;

public abstract class PAbstractNode {
    public static final int LEVEL_MAIN = 0;
    public static final int LEVEL_FIRST_SUB = 1;
    public static final int LEVEL_LEAF_NODE = 2;
    public static final String RENDERER_SET_PROPERTY = "NEW_RENDERER";
    public static final String EDITOR_SET_PROPERTY = "NEW_EDITOR";
    public static final String CHILDREN_ADDED_PROPERTY = "CHILDREN_ADDED";
    public static final String CHILDREN_REMOVED_PROPERTY = "CHILDREN_REMOVED";
    public static final String DATA_STATE_CHANGE_PROPERTY = "DATA_STATE_CHANGED";
    public static final String CONTENT_CHANGE_PROPERTY = "CONTENT_CHANGED";
    protected String myTitle = null;
    protected boolean mySelected = false;
    protected boolean mySpecialNode = false;
    protected int myLevel;
    protected TreeCellEditor myCellEditor;
    protected TreeCellRenderer myCellRenderer;
    protected Vector<PAbstractNode> myChildren;
    protected Vector<PropertyChangeListener> myPropertyChangeListeners;
    protected ResourceBundle myResourceBundle;
    protected PAbstractNode myParent;

    public PAbstractNode(String title, boolean selected, int level) {
        this.myTitle = title;
        this.mySelected = selected;
        this.myLevel = level;
        this.myResourceBundle = I18n.getI18n().getBundle(this.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.myPropertyChangeListeners.clear();
        PAbstractNode pAbstractNode = this;
        synchronized (pAbstractNode) {
            if (this.myChildren != null) {
                try {
                    Iterator<PAbstractNode> iter = this.myChildren.iterator();
                    while (iter.hasNext()) {
                        iter.next().clear();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.myChildren.clear();
            }
            this.myChildren = null;
            this.myParent = null;
        }
        this.myCellEditor = null;
    }

    public String getTitle() {
        return this.myTitle;
    }

    public void setTitle(String title) {
        this.myTitle = title;
    }

    public void setSelected(boolean selected) {
        this.mySelected = selected;
    }

    public boolean isSelected() {
        return this.mySelected;
    }

    public void setSpecialNode(boolean specialNode) {
        this.mySpecialNode = specialNode;
    }

    public boolean isSpecialNode() {
        return this.mySpecialNode;
    }

    public int getLevel() {
        return this.myLevel;
    }

    public void setEditor(TreeCellEditor cellEditor) {
        this.myCellEditor = cellEditor;
        this.firePropertyChange(EDITOR_SET_PROPERTY, this.myCellEditor);
    }

    public void setRenderer(TreeCellRenderer cellRenderer) {
        this.myCellRenderer = cellRenderer;
        this.firePropertyChange(RENDERER_SET_PROPERTY, this.myCellRenderer);
    }

    public TreeCellEditor getEditor() {
        return this.myCellEditor;
    }

    public TreeCellRenderer getRenderer() {
        return this.myCellRenderer;
    }

    public PAbstractNode getParent() {
        return this.myParent;
    }

    public void setParent(PAbstractNode parent) {
        this.myParent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChildren(PAbstractNode[] children) throws UnsupportedOperationException {
        if (this.myChildren == null) {
            this.myChildren = new Vector();
        }
        PAbstractNode pAbstractNode = this;
        synchronized (pAbstractNode) {
            int i = 0;
            while (i < children.length) {
                this.myChildren.add(children[i]);
                children[i].setParent(this);
                ++i;
            }
            this.firePropertyChange(CHILDREN_ADDED_PROPERTY, children);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(PAbstractNode child) throws UnsupportedOperationException {
        if (this.myChildren == null) {
            this.myChildren = new Vector();
        }
        PAbstractNode pAbstractNode = this;
        synchronized (pAbstractNode) {
            this.myChildren.add(child);
            child.setParent(this);
            PAbstractNode[] children = new PAbstractNode[]{child};
            this.firePropertyChange(CHILDREN_ADDED_PROPERTY, children);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(PAbstractNode child, int index) throws UnsupportedOperationException {
        if (this.myChildren == null) {
            this.myChildren = new Vector();
        }
        PAbstractNode pAbstractNode = this;
        synchronized (pAbstractNode) {
            this.myChildren.add(index, child);
            child.setParent(this);
            PAbstractNode[] children = new PAbstractNode[]{child};
            this.firePropertyChange(CHILDREN_ADDED_PROPERTY, children);
        }
    }

    public PAbstractNode[] getChildren() throws UnsupportedOperationException {
        if (this.myChildren == null) {
            return null;
        }
        Object[] children = new PAbstractNode[this.myChildren.size()];
        this.myChildren.copyInto(children);
        return children;
    }

    public int getChildIndex(PAbstractNode child) throws UnsupportedOperationException {
        if (this.myChildren == null) {
            return 0;
        }
        return this.myChildren.indexOf(child);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChild(PAbstractNode child) throws UnsupportedOperationException {
        if (this.myChildren == null) {
            return;
        }
        PAbstractNode pAbstractNode = this;
        synchronized (pAbstractNode) {
            this.myChildren.removeElement(child);
            child.setParent(null);
            PAbstractNode[] children = new PAbstractNode[]{child};
            this.firePropertyChange(CHILDREN_REMOVED_PROPERTY, children);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChildren(PAbstractNode[] children) throws UnsupportedOperationException {
        if (this.myChildren == null) {
            return;
        }
        PAbstractNode pAbstractNode = this;
        synchronized (pAbstractNode) {
            int i = 0;
            while (i < children.length) {
                this.myChildren.removeElement(children[i]);
                children[i].setParent(null);
                ++i;
            }
            this.firePropertyChange(CHILDREN_REMOVED_PROPERTY, children);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChildren() throws UnsupportedOperationException {
        if (this.myChildren == null) {
            return;
        }
        PAbstractNode pAbstractNode = this;
        synchronized (pAbstractNode) {
            Object[] children = new PAbstractNode[this.myChildren.size()];
            this.myChildren.copyInto(children);
            int i = 0;
            while (i < children.length) {
                ((PAbstractNode)children[i]).setParent(null);
                ++i;
            }
            this.myChildren.removeAllElements();
            this.firePropertyChange(CHILDREN_REMOVED_PROPERTY, children);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.myPropertyChangeListeners == null) {
            this.myPropertyChangeListeners = new Vector();
        }
        this.myPropertyChangeListeners.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.myPropertyChangeListeners.remove(listener);
    }

    public void firePropertyChange(String propertyName, Object newValue) {
        if (this.myPropertyChangeListeners == null) {
            return;
        }
        PropertyChangeEvent evt = new PropertyChangeEvent(this, propertyName, null, newValue);
        for (PropertyChangeListener propChangeListener : this.myPropertyChangeListeners) {
            if (propChangeListener == null) continue;
            propChangeListener.propertyChange(evt);
        }
    }

    public String[] getValues() {
        return new String[]{this.myTitle};
    }
}

