/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.treeview;

import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.frameworks.mvc.Controller;
import com.nokia.em.poseidon.gui.treeview.PAbstractNode;
import com.nokia.em.poseidon.gui.treeview.PTableCellWrapper;
import com.nokia.em.poseidon.gui.treeview.PTableLeafNode;
import com.nokia.em.poseidon.gui.treeview.PTableLeafNodeHeaderGroup;
import com.nokia.em.poseidon.gui.treeview.PTitleNode;
import com.nokia.em.poseidon.gui.treeview.PTreeViewController;
import com.nokia.em.poseidon.gui.treeview.TreeViewTreeHighlight;
import com.nokia.em.poseidon.util.TextUtils;
import com.nokia.laf.NetLabelUIHelper;
import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.NetTheme;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.ClientProperties;
import com.nokia.widgets.PBorderFactory;
import com.nokia.widgets.PPanel;
import com.nokia.widgets.buttons.PToolButton;
import com.nokia.widgets.icons.CommonIcons;
import com.nokia.widgets.icons.PArrowIcon;
import com.nokia.widgets.labels.PLabel;
import com.nokia.widgets.labels.highlight.DefaultLabelHighlightPainter;
import com.nokia.widgets.labels.highlight.DefaultLabelHighlighter;
import com.nokia.widgets.layout.PVerticalLayout;
import com.nokia.widgets.layout.RowAlignLayout;
import com.nokia.widgets.table.PTable;
import com.nokia.widgets.table.PTableCellRenderer;
import com.nokia.widgets.table.TableHighlight;
import com.nokia.widgets.util.NSNColors;
import com.nokia.widgets.util.ScaleUtils;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class PDefaultRendererPanel
extends PPanel {
    private static final int MAINLEVEL_WIDTH = 597;
    private static final int FIRSTSUBLEVEL_WIDTH = 585;
    private static final int TITLE_LEAF_WIDTH = 573;
    private static final int MAINLEVEL_HEIGHT = 25;
    private static final int FIRSTSUBLEVEL_HEIGHT = 25;
    private static final int TITLE_LEAF_HEIGHT = 18;
    private static final int NODEEXTEND_WIDTH = 38;
    private static final int LAST_DATA_COLUMN_MAX_WITH = 150;
    private static final Color BACKGROUND_COLOR = new Color(255, 255, 255);
    protected PToolButton myPrintButton = null;
    protected PToolButton mySaveButton = null;
    private PLabel myTitleLabel = null;
    private ResourceBundle myResourceBundle;
    private String mySiteName;
    protected PLabel myStatusLabel;
    protected PLabel myElapsedTime;
    protected Timer myElapsedTimeTimer;
    protected long myOperationStartTime = -1L;
    protected int myElapsedTimeMinutes;
    protected int myElapsedTimeSeconds;
    protected DefaultMutableTreeNode myValue;
    protected TreeModel myTreeModel;
    protected Controller myController;
    protected Dimension myMainLevelSize;
    protected Dimension mySubLevelSize;
    private Dimension mySubLevelTitleLeafSize;
    private Rectangle mySaveButtonBounds;
    private Rectangle myPrintButtonBounds;
    private List<PTable> myTables = new ArrayList<PTable>();

    public PDefaultRendererPanel(Controller ctrl, String siteName, TreeModel treeModel) {
        this.myResourceBundle = I18n.getI18n().getBundle(this.getClass());
        this.mySiteName = siteName;
        this.myTreeModel = treeModel;
        this.myController = ctrl;
        this.myTitleLabel = PLabel.createSubHeader();
        this.initTitleNodeWidth();
        this.myStatusLabel = new PLabel("", 4);
        this.myStatusLabel.setLabelType(ClientProperties.LABEL_VALUE_TEXT);
        this.myElapsedTime = new PLabel("00:00", 2);
        this.myElapsedTime.setLabelType(ClientProperties.LABEL_VALUE_TEXT);
        this.myElapsedTimeTimer = new Timer(0, new ElapsedTimerListener());
        this.myElapsedTimeTimer.setDelay(500);
        this.myElapsedTimeTimer.setRepeats(true);
    }

    public void clear() {
        this.myValue = null;
        this.myResourceBundle = null;
        this.myPrintButton = null;
        this.mySaveButton = null;
        this.myController = null;
        this.myTreeModel = null;
        this.clearTables();
        if (this.myElapsedTimeTimer != null) {
            this.myElapsedTimeTimer.stop();
            this.myElapsedTimeTimer = null;
        }
    }

    public void buildUI(Object value, boolean expanded, int row, JTree tree, PPanel parent) {
        DefaultMutableTreeNode node;
        this.removeAll();
        this.clearTables();
        this.myValue = node = (DefaultMutableTreeNode)value;
        PAbstractNode userObject = (PAbstractNode)node.getUserObject();
        if (userObject.getLevel() == 2) {
            this.createLeaf(tree, node, userObject, parent);
        } else {
            this.createTitleNode(expanded, row, tree, node);
        }
    }

    private void clearTables() {
        if (this.myTables != null) {
            for (PTable table : this.myTables) {
                table.getModel().removeTableModelListener(table);
                ((TreeViewTableModelWrapper)table.getModel()).clearModel();
            }
            this.myTables.clear();
        }
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        if (this.mySaveButtonBounds != null && this.mySaveButtonBounds.contains(event.getPoint())) {
            return this.mySaveButton.getToolTipText();
        }
        if (this.myPrintButtonBounds != null && this.myPrintButtonBounds.contains(event.getPoint())) {
            return this.myPrintButton.getToolTipText();
        }
        return super.getToolTipText(event);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.mySaveButton != null) {
            this.mySaveButtonBounds = this.mySaveButton.getBounds();
        }
        if (this.myPrintButton != null) {
            this.myPrintButtonBounds = this.myPrintButton.getBounds();
        }
    }

    private void createTitleNode(boolean expanded, int row, JTree tree, DefaultMutableTreeNode node) {
        PTitleNode titleNode = (PTitleNode)node.getUserObject();
        String searchText = PDefaultRendererPanel.getSearchText(tree);
        TreeViewTreeHighlight emphasizedHighlight = PDefaultRendererPanel.getEmphasizedHighlight(tree);
        Dimension size = null;
        if (titleNode.getLevel() == 0) {
            this.setBackground(new Color(NetTheme.getSelectionColor().getRGB()));
            this.myTitleLabel.setForeground(new Color(UIManager.getColor("Tree.selectionForeground").getRGB()));
            this.myStatusLabel.setForeground(this.myTitleLabel.getForeground());
            this.myTitleLabel.setOffsetForeground(null);
            size = this.myMainLevelSize;
        } else {
            PAbstractNode parentNode = titleNode.getParent();
            int level = 0;
            while (parentNode.getLevel() != 0) {
                ++level;
                parentNode = parentNode.getParent();
            }
            int width = this.mySubLevelSize.width - level * (this.myMainLevelSize.width - this.mySubLevelSize.width);
            size = new Dimension(width, 25);
            this.setBackground(new Color(UIManager.getColor("Table.evenHoverBackground").getRGB()));
        }
        int realWidth = this.getFontMetrics(this.myTitleLabel.getFont()).stringWidth(titleNode.getTitle()) + 38;
        if (realWidth >= size.width) {
            size = new Dimension(realWidth, size.height);
        }
        this.setSize(size);
        this.setPreferredSize(size);
        this.setMinimumSize(size);
        int verticalAlignment = (int)Math.ceil((double)NetLookAndFeel.getFontSizeIncrement() / 2.0);
        RowAlignLayout gridbag = new RowAlignLayout(6, 4, 2 - verticalAlignment);
        gridbag.setComponentScaled(false);
        gridbag.setButtonBar(false);
        this.setLayout(gridbag);
        PToolButton expandCollapseButton = this.createExpandAndCollapseButton(expanded, row, tree);
        this.add((Component)expandCollapseButton, "West");
        if (node.isLeaf()) {
            expandCollapseButton.setEnabled(false);
        }
        this.myTitleLabel.setText(titleNode.getTitle());
        Icon icon = titleNode.getIcon();
        if (icon != null) {
            this.myTitleLabel.setIcon(icon);
        }
        this.add((Component)this.myTitleLabel, "West");
        this.add((Component)this.myStatusLabel, "Center");
        this.add((Component)this.myElapsedTime, "Center");
        this.myTitleLabel.clearSelection();
        this.addHighlight(tree, node, this.myTitleLabel, 0, 0, searchText, emphasizedHighlight, 0);
        this.myStatusLabel.clearSelection();
        this.myElapsedTime.clearSelection();
        this.createPrintAndSaveButton(node);
        this.setDataState(titleNode);
    }

    private PToolButton createExpandAndCollapseButton(boolean expanded, int row, JTree tree) {
        PToolButton expandCollapseButton = new PToolButton();
        expandCollapseButton.setName("PDefaultRendererPanel.ExpandAndCollapseButton");
        expandCollapseButton.setMargin(new Insets(3, 0, 0, 0));
        expandCollapseButton.setRolloverEnabled(false);
        expandCollapseButton.setFocusable(false);
        expandCollapseButton.setBorderPainted(false);
        expandCollapseButton.setContentAreaFilled(false);
        this.removeButtonActionListeners(expandCollapseButton);
        expandCollapseButton.addActionListener(new NodeAction(tree, row));
        expandCollapseButton.setEnabled(true);
        Color arrowColor = NetUtils.decodeColor("#5B5B5B");
        if (expanded) {
            expandCollapseButton.setIcon(new PArrowIcon(8, 4, arrowColor, 5));
        } else {
            expandCollapseButton.setIcon(new PArrowIcon(8, 4, arrowColor, 3));
        }
        return expandCollapseButton;
    }

    private void createPrintAndSaveButton(DefaultMutableTreeNode node) {
        PTitleNode titleNode = (PTitleNode)node.getUserObject();
        if (titleNode.isPrintable()) {
            if (titleNode.isSaveAvailable()) {
                this.initSaveButton();
                this.add((Component)this.mySaveButton, "East");
                this.mySaveButton.setEnabled(true);
                this.mySaveButton.setVisible(true);
                this.mySaveButton.setBackground(this.getBackground());
            }
            this.initPrintButton();
            this.add((Component)this.myPrintButton, "East");
            this.myPrintButton.setBackground(this.getBackground());
            this.myPrintButton.setEnabled(true);
            this.myPrintButton.setVisible(true);
        } else if (titleNode.isSaveAvailable()) {
            this.initSaveButton();
            this.add((Component)this.mySaveButton, "East");
            this.mySaveButton.setEnabled(true);
            this.mySaveButton.setVisible(true);
            this.mySaveButton.setBackground(this.getBackground());
        }
        if (this.myPrintButton != null) {
            Object[] args = new Object[]{titleNode.getTitle()};
            String printToolTipText = MessageFormat.format(this.myResourceBundle.getString("PTreeViewDefaultPrinter.ToolTipText"), args);
            this.myPrintButton.setToolTipText(printToolTipText);
            this.removeButtonActionListeners(this.myPrintButton);
            this.myPrintButton.addActionListener(new PrintAction(node));
            this.myPrintButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        }
        if (this.mySaveButton != null) {
            Object[] saveArgs = new Object[]{titleNode.getTitle()};
            String saveToolTipText = MessageFormat.format(this.myResourceBundle.getString("TreeViewLevelSave_ToolTipText"), saveArgs);
            this.mySaveButton.setToolTipText(saveToolTipText);
            this.removeButtonActionListeners(this.mySaveButton);
            this.mySaveButton.addActionListener(new SaveAction(node, this, this.mySiteName));
            this.mySaveButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        }
    }

    private void initPrintButton() {
        this.myPrintButton = new PToolButton(CommonIcons.getPrintIcon());
        this.myPrintButton.setName("PDefaultRendererPanel.PrintButton");
        this.myPrintButton.setMargin(new Insets(0, 0, 0, 0));
        this.myPrintButton.setBorderPainted(false);
        this.myPrintButton.setContentAreaFilled(false);
    }

    private void initSaveButton() {
        this.mySaveButton = new PToolButton(CommonIcons.getSaveAsIcon());
        this.mySaveButton.setName("PDefaultRendererPanel.SaveButton");
        this.mySaveButton.setMargin(new Insets(0, 0, 0, 0));
        this.mySaveButton.setBorderPainted(false);
        this.mySaveButton.setContentAreaFilled(false);
    }

    protected void setDataState(PTitleNode titleNode) {
        int dataState = titleNode.getDataState();
        String dataStateText = titleNode.getDataStateText();
        Icon dataStateIcon = titleNode.getDataStateIcon();
        this.myTitleLabel.setEnabled(true);
        if (dataState == 1) {
            if (dataStateText != null) {
                this.myStatusLabel.setText(dataStateText);
            } else {
                this.myStatusLabel.setText(this.myResourceBundle.getString("TreeViewProgress_Text"));
            }
            if (!titleNode.isStateIconHidden()) {
                if (dataStateIcon != null) {
                    this.myStatusLabel.setIcon(dataStateIcon);
                } else {
                    this.myStatusLabel.setIcon(CommonIcons.getProgressOngoingIcon());
                }
            }
            if (!this.myElapsedTimeTimer.isRunning()) {
                this.myElapsedTime.setEnabled(true);
                this.myElapsedTimeMinutes = 0;
                this.myElapsedTimeSeconds = 0;
                this.myOperationStartTime = System.currentTimeMillis();
                this.myElapsedTimeTimer.start();
            }
            this.myStatusLabel.setEnabled(true);
            if (this.myPrintButton != null) {
                this.myPrintButton.setEnabled(false);
            }
            if (this.mySaveButton != null) {
                this.mySaveButton.setEnabled(false);
            }
        } else if (dataState == 2) {
            this.myElapsedTimeTimer.stop();
            if (dataStateText != null) {
                this.myStatusLabel.setText(dataStateText);
            } else {
                this.myStatusLabel.setText(this.myResourceBundle.getString("TreeViewWarning_Text"));
            }
            if (!titleNode.isStateIconHidden()) {
                if (dataStateIcon != null) {
                    this.myStatusLabel.setIcon(dataStateIcon);
                } else {
                    this.myStatusLabel.setIcon(CommonIcons.getWarningIcon());
                }
            }
            this.myElapsedTime.setText(null);
            this.myElapsedTime.setEnabled(false);
            this.myStatusLabel.setEnabled(true);
            this.myTitleLabel.setEnabled(false);
            if (this.myPrintButton != null) {
                this.myPrintButton.setEnabled(false);
            }
            if (this.mySaveButton != null) {
                this.mySaveButton.setEnabled(false);
            }
        } else if (dataState == 3) {
            if (dataStateText != null) {
                this.myStatusLabel.setText(dataStateText);
            }
            if (dataStateIcon != null && !titleNode.isStateIconHidden()) {
                this.myStatusLabel.setIcon(dataStateIcon);
            }
            this.myElapsedTimeTimer.stop();
            this.myTitleLabel.setEnabled(false);
            this.myElapsedTime.setText(null);
            this.myElapsedTime.setEnabled(false);
            this.myStatusLabel.setText(null);
            this.myStatusLabel.setIcon(null);
            this.myStatusLabel.setEnabled(false);
            if (this.myPrintButton != null) {
                this.myPrintButton.setEnabled(false);
            }
            if (this.mySaveButton != null) {
                this.mySaveButton.setEnabled(false);
            }
        } else if (dataState == 4) {
            if (dataStateText != null) {
                this.myStatusLabel.setText(dataStateText);
            } else {
                this.myStatusLabel.setText(this.myResourceBundle.getString("StoppedTask.Name"));
            }
            if (!titleNode.isStateIconHidden()) {
                if (dataStateIcon != null) {
                    this.myStatusLabel.setIcon(dataStateIcon);
                } else {
                    this.myStatusLabel.setIcon(CommonIcons.getProgressSuccessIcon());
                }
            }
            this.myElapsedTimeTimer.stop();
            this.myElapsedTime.setEnabled(true);
            this.myStatusLabel.setEnabled(true);
            this.myStatusLabel.setEnabled(true);
            if (this.myPrintButton != null) {
                this.myPrintButton.setEnabled(true);
            }
            if (this.mySaveButton != null) {
                this.mySaveButton.setEnabled(true);
            }
        } else {
            if (dataStateText != null) {
                this.myStatusLabel.setText(dataStateText);
            }
            if (dataStateIcon != null && !titleNode.isStateIconHidden()) {
                this.myStatusLabel.setIcon(dataStateIcon);
            }
            this.myElapsedTimeTimer.stop();
            this.myElapsedTime.setText(null);
            this.myElapsedTime.setEnabled(false);
            this.myStatusLabel.setEnabled(false);
            this.myStatusLabel.setText(null);
            this.myStatusLabel.setIcon(null);
            this.myStatusLabel.setEnabled(true);
            if (this.myPrintButton != null) {
                this.myPrintButton.setEnabled(true);
            }
            if (this.mySaveButton != null) {
                this.mySaveButton.setEnabled(true);
            }
        }
    }

    private void createLeaf(JTree tree, DefaultMutableTreeNode node, PAbstractNode userObject, PPanel parent) {
        this.setBackground(BACKGROUND_COLOR);
        this.setLayout(new PVerticalLayout(0, 0, 0, 0));
        PTableLeafNode leaf = (PTableLeafNode)userObject;
        if (leaf.isShowTitle() && leaf.getTitle() != null && leaf.getParent() != null) {
            LayoutManager layout;
            if (parent != null && (layout = parent.getLayout()) instanceof FlowLayout) {
                ((FlowLayout)layout).setHgap(4);
                ((FlowLayout)layout).setVgap(8);
            }
            PPanel titlePanel = this.createLeafTitlePanel(tree, node, leaf);
            titlePanel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
            this.add(titlePanel);
        }
        this.createLeafDataPanel(tree, node, leaf);
    }

    private PPanel createLeafTitlePanel(JTree tree, DefaultMutableTreeNode node, PTableLeafNode leaf) {
        String title = leaf.getTitle();
        if (title == null) {
            title = "";
        }
        String searchText = PDefaultRendererPanel.getSearchText(tree);
        TreeViewTreeHighlight emphasizedHighlight = PDefaultRendererPanel.getEmphasizedHighlight(tree);
        Dimension size = this.getLeafNodeSize(leaf);
        int realWidth = this.getFontMetrics(this.myTitleLabel.getFont()).stringWidth(title) + 38;
        if (realWidth >= size.width) {
            size = new Dimension(realWidth, size.height);
        }
        PPanel titlePanel = new PPanel();
        titlePanel.setBackground(new Color(UIManager.getColor("Table.evenHoverBackground").getRGB()));
        titlePanel.setSize(size);
        titlePanel.setPreferredSize(size);
        titlePanel.setMinimumSize(size);
        titlePanel.setLayout(new BoxLayout(titlePanel, 2));
        this.myTitleLabel.setText(title);
        this.myTitleLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        titlePanel.add(this.myTitleLabel);
        this.myTitleLabel.clearSelection();
        this.addHighlight(tree, node, this.myTitleLabel, 0, 0, searchText, emphasizedHighlight, 0);
        return titlePanel;
    }

    private Dimension getLeafNodeSize(PTableLeafNode leaf) {
        Dimension size = null;
        int level = -1;
        PAbstractNode parentNode = leaf.getParent();
        if (parentNode != null) {
            while (parentNode.getLevel() != 0) {
                ++level;
                parentNode = parentNode.getParent();
            }
        }
        int width = this.mySubLevelTitleLeafSize.width - level * (this.mySubLevelSize.width - this.mySubLevelTitleLeafSize.width);
        size = new Dimension(width, 18);
        return size;
    }

    private void createLeafDataPanel(JTree tree, DefaultMutableTreeNode node, PTableLeafNode leaf) {
        boolean hasHeader;
        PTable table = null;
        boolean bl = hasHeader = leaf.isShowHeaders() && leaf.getHeaders() != null && leaf.getHeaders().size() != 0;
        if (leaf.getTableModel() != null) {
            TreeViewTableModelWrapper wrapper = new TreeViewTableModelWrapper(leaf.getTableModel());
            table = new PTable(wrapper);
        } else {
            table = new PTable();
        }
        table.setDefaultRenderer(Object.class, new TreeViewTableCellRenderer(leaf.checkIfParentUnavailableAndDataUndefined()));
        if (hasHeader) {
            this.configureHeaderRow(tree, node, leaf, table);
        }
        table.setShowGrid(false);
        table.setRowHeight(ScaleUtils.scale(19));
        table.setBackground(BACKGROUND_COLOR);
        table.setBorder(BorderFactory.createEmptyBorder());
        table.setRowSelectionAllowed(false);
        table.setFocusable(false);
        if (table.getRowCount() > 0) {
            table.packCells();
        } else {
            table.packHeader();
        }
        if (hasHeader) {
            JTableHeader header = table.getTableHeader();
            header.setBackground(BACKGROUND_COLOR);
            this.add(header);
            this.adjustTheColumnWidth(leaf, table);
            if (!leaf.checkIfParentUnavailable() && table.getRowCount() == 0) {
                header.setPreferredSize(new Dimension(table.getTableHeader().getColumnModel().getTotalColumnWidth(), table.getTableHeader().getPreferredSize().height));
            }
            header.setBorder(PBorderFactory.getDashedUnderlineBorder());
        }
        Dimension nodeSize = this.getLeafNodeSize(leaf);
        int columnsWidth = 0;
        int i = 0;
        while (i < table.getColumnModel().getColumnCount()) {
            if (i == table.getColumnModel().getColumnCount() - 1) {
                int leftWidth = nodeSize.width - columnsWidth;
                int maxWidth = leftWidth < 150 ? 150 : leftWidth;
                table.getColumnModel().getColumn(i).setMaxWidth(maxWidth);
                leaf.setMaxWidthForLastColumn(maxWidth);
            }
            columnsWidth += table.getColumnModel().getColumn(i).getPreferredWidth();
            ++i;
        }
        if (table.getRowCount() > 0) {
            table.packCells();
        } else {
            table.packHeader();
        }
        this.highlightTableLeafNode(table, tree, node);
        if (table.getRowCount() > 0 || hasHeader && leaf.checkIfParentUnavailable()) {
            this.add(table);
        }
        this.myTables.add(table);
    }

    private void adjustTheColumnWidth(PTableLeafNode leaf, PTable table) {
        Map<Integer, PTableLeafNodeHeaderGroup> headGroups = leaf.getHeaderGroup();
        int continueColumn = 0;
        int i = 0;
        while (i < table.getColumnModel().getColumnCount()) {
            if (continueColumn > 0) {
                --continueColumn;
            } else {
                int preferredWidth = table.getColumnModel().getColumn(i).getPreferredWidth();
                table.getColumnModel().getColumn(i).setMinWidth(preferredWidth);
                if (headGroups.keySet().contains(i)) {
                    int averageWidth;
                    String headGroupElement = headGroups.get(i).getText();
                    FontMetrics fm = new Button().getFontMetrics(table.getFont());
                    int headGroupElementWidth = SwingUtilities.computeStringWidth(fm, headGroupElement);
                    int columnWidthTotal = 0;
                    continueColumn = headGroups.get(i).getEndColumn() - headGroups.get(i).getStartColumn();
                    int j = 0;
                    while (j < continueColumn + 1) {
                        columnWidthTotal += table.getColumnModel().getColumn(i + j).getPreferredWidth();
                        ++j;
                    }
                    int totalWidth = Math.max(columnWidthTotal, headGroupElementWidth);
                    int actuallyWidth = averageWidth = totalWidth / (continueColumn + 1);
                    int j2 = 0;
                    while (j2 < continueColumn + 1) {
                        if (j2 == continueColumn) {
                            actuallyWidth += 12;
                        }
                        table.getColumnModel().getColumn(i + j2).setMinWidth(actuallyWidth);
                        ++j2;
                    }
                }
            }
            ++i;
        }
    }

    private void configureHeaderRow(JTree tree, DefaultMutableTreeNode node, PTableLeafNode leaf, PTable table) {
        Map<Integer, PTableLeafNodeHeaderGroup> headGroups;
        JTableHeader header = table.getTableHeader();
        header.setBackground(BACKGROUND_COLOR);
        header.setReorderingAllowed(false);
        header.setDefaultRenderer(new TreeViewTableHeaderRenderer(tree, node));
        header.putClientProperty("OrangeTouch.headerGroupSameAsHeader", true);
        boolean hasNonEmptyHeader = false;
        int i = 0;
        while (i < table.getColumnModel().getColumnCount()) {
            Object headerValue = leaf.getHeaders().get(i);
            hasNonEmptyHeader = hasNonEmptyHeader || !"".equals(headerValue);
            table.getColumnModel().getColumn(i).setHeaderValue(headerValue);
            table.getColumnModel().getColumn(i).setResizable(false);
            ++i;
        }
        if (!hasNonEmptyHeader) {
            header.setBorder(BorderFactory.createEmptyBorder());
        }
        if ((headGroups = leaf.getHeaderGroup()).size() > 0) {
            table.setHeaderGroupFont(header.getFont().deriveFont(0));
            for (Integer column : headGroups.keySet()) {
                table.addHeaderGroup(column, headGroups.get(column).getText());
            }
        }
    }

    private void highlightTableLeafNode(PTable table, JTree tree, DefaultMutableTreeNode node) {
        String searchText = PDefaultRendererPanel.getSearchText(tree);
        TreeViewTreeHighlight emphasizedHighlight = PDefaultRendererPanel.getEmphasizedHighlight(tree);
        table.highlight(searchText);
        DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
        Object[] nodes = model.getPathToRoot(node);
        TreePath path = new TreePath(nodes);
        if (emphasizedHighlight != null && path.equals(emphasizedHighlight.getPath())) {
            int row = 0;
            if (((PTableLeafNode)node.getUserObject()).isShowHeaders()) {
                ++row;
            }
            if (((PTableLeafNode)node.getUserObject()).isShowTitle() && ((PTableLeafNode)node.getUserObject()).getTitle() != null) {
                ++row;
            }
            table.putClientProperty("OrangeTouch.tableEmphasizedHighlight", new TableHighlight(searchText, emphasizedHighlight.getRow() - row, emphasizedHighlight.getColumn(), emphasizedHighlight.getIndex()));
        }
    }

    private static TreeViewTreeHighlight getEmphasizedHighlight(JTree tree) {
        TreeViewTreeHighlight emphasizedHighlight = null;
        if (tree != null) {
            emphasizedHighlight = (TreeViewTreeHighlight)tree.getClientProperty("OrangeTouch.treeEmphasizedHighlight");
        }
        return emphasizedHighlight;
    }

    private static String getSearchText(JTree tree) {
        String searchText = "";
        if (tree != null) {
            searchText = (String)tree.getClientProperty("OrangeTouch.highlightText");
        }
        return searchText;
    }

    private void addHighlight(JTree tree, DefaultMutableTreeNode node, PLabel label, int row, int column, String searchText, TreeViewTreeHighlight highlight, int offset) {
        if (searchText == null || searchText.length() == 0) {
            return;
        }
        DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
        Object[] nodes = model.getPathToRoot(node);
        TreePath path = new TreePath(nodes);
        label.highlight(searchText);
        if (highlight != null && path.equals(highlight.getPath()) && highlight.getText() != null && row == highlight.getRow() && column == highlight.getColumn()) {
            int start = highlight.getIndex() + offset;
            String text = highlight.getText();
            text = text.replaceAll("\\\\", "");
            label.addSelection(start, start + text.length(), NSNColors.getPurple());
        }
    }

    private void initTitleNodeWidth() {
        Dimension viewSize;
        if (this.myController instanceof PTreeViewController && (viewSize = ((PTreeViewController)this.myController).getTreeViewDialogSize()) != null) {
            this.myMainLevelSize = new Dimension((int)viewSize.getWidth() - 49, 25);
            this.mySubLevelSize = new Dimension(this.myMainLevelSize.width - 12, 25);
            this.mySubLevelTitleLeafSize = new Dimension(this.mySubLevelSize.width - 12, 18);
            return;
        }
        this.myMainLevelSize = new Dimension(597, 25);
        this.mySubLevelSize = new Dimension(585, 25);
        this.mySubLevelTitleLeafSize = new Dimension(573, 18);
    }

    private void removeButtonActionListeners(JButton button) {
        ActionListener[] listeners = button.getActionListeners();
        if (listeners != null) {
            int length = listeners.length;
            int i = 0;
            while (i < length) {
                button.removeActionListener(listeners[i]);
                ++i;
            }
        }
    }

    protected class ElapsedTimerListener
    implements ActionListener {
        protected ElapsedTimerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            long currentTime = System.currentTimeMillis();
            long elapsedTime = currentTime - PDefaultRendererPanel.this.myOperationStartTime;
            int elapsedSeconds = (int)(elapsedTime / 1000L);
            PDefaultRendererPanel.this.myElapsedTimeMinutes = elapsedSeconds / 60;
            PDefaultRendererPanel.this.myElapsedTimeSeconds = elapsedSeconds % 60;
            StringBuffer timeText = new StringBuffer(5);
            String minutesStr = PDefaultRendererPanel.this.myElapsedTimeMinutes < 10 ? "0" + PDefaultRendererPanel.this.myElapsedTimeMinutes : String.valueOf(PDefaultRendererPanel.this.myElapsedTimeMinutes);
            String secondsStr = PDefaultRendererPanel.this.myElapsedTimeSeconds < 10 ? "0" + PDefaultRendererPanel.this.myElapsedTimeSeconds : String.valueOf(PDefaultRendererPanel.this.myElapsedTimeSeconds);
            timeText.append(minutesStr);
            timeText.append(':');
            timeText.append(secondsStr);
            PDefaultRendererPanel.this.myElapsedTime.setText(timeText.toString());
            PDefaultRendererPanel.this.myElapsedTime.updateUI();
            ((DefaultTreeModel)PDefaultRendererPanel.this.myTreeModel).nodeChanged(PDefaultRendererPanel.this.myValue);
        }
    }

    private static class NodeAction
    implements ActionListener {
        private JTree myContainer = null;
        private int myRow;

        private NodeAction(JTree container, int row) {
            this.myContainer = container;
            this.myRow = row;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.myContainer.isExpanded(this.myRow)) {
                this.myContainer.collapseRow(this.myRow);
            } else {
                this.myContainer.expandRow(this.myRow);
            }
        }
    }

    private static class PrintAction
    implements ActionListener {
        private DefaultMutableTreeNode myNode = null;

        private PrintAction(DefaultMutableTreeNode node) {
            this.myNode = node;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PTitleNode titleNode = (PTitleNode)this.myNode.getUserObject();
            titleNode.getCommandHandler().handlePrintAction(titleNode.getPrinter(), titleNode, titleNode.getTitle());
        }
    }

    private static class SaveAction
    implements ActionListener {
        private DefaultMutableTreeNode myNode = null;
        private Container myParent;
        private String mySiteName;

        private SaveAction(DefaultMutableTreeNode node, Container parent, String siteName) {
            this.myNode = node;
            this.myParent = parent;
            this.mySiteName = siteName;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PTitleNode userObject = (PTitleNode)this.myNode.getUserObject();
            userObject.getCommandHandler().handleSaveAction(userObject.getFileWriter(), this.myParent, userObject, userObject.getTitle(), this.mySiteName);
        }
    }

    private class TreeViewTableCellRenderer
    extends PTableCellRenderer {
        private static final long serialVersionUID = 9086667039252415598L;
        private boolean myDataUnavailable = false;

        public TreeViewTableCellRenderer(boolean dataUnavailable) {
            this.myDataUnavailable = dataUnavailable;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setBackground(BACKGROUND_COLOR);
            this.setHorizontalAlignment(((TreeViewTableModelWrapper)table.getModel()).resolveAlignment(column));
            this.putClientProperty("labelType", ClientProperties.LABEL_VALUE_TEXT);
            this.setVerticalAlignment(0);
            this.setVerticalTextPosition(0);
            this.setText("");
            this.setIcon(null);
            this.setForeground(UIManager.getColor("Label.foreground"));
            if (value instanceof PTableCellWrapper) {
                PTableCellWrapper cellWrapper = (PTableCellWrapper)value;
                this.setText(cellWrapper.getTableCellValue());
                if (ClientProperties.LABEL_SYSTEM_TEXT.equals(cellWrapper.getLabelType())) {
                    this.putClientProperty("labelType", ClientProperties.LABEL_SYSTEM_TEXT);
                } else if (ClientProperties.LABEL_TITLE.equals(cellWrapper.getLabelType())) {
                    this.putClientProperty("labelType", ClientProperties.LABEL_TITLE);
                } else {
                    this.putClientProperty("labelType", ClientProperties.LABEL_VALUE_TEXT);
                }
                new NetLabelUIHelper().propertyChanged(this);
                this.setForeground(new Color(this.getForeground().getRGB()));
                this.setHorizontalAlignment(cellWrapper.getHorizontalAlignment());
                this.setVerticalAlignment(cellWrapper.getVerticalAlignment());
            } else if (value instanceof ImageIcon) {
                this.setIcon((ImageIcon)value);
            } else if (this.myDataUnavailable && column == 1) {
                this.setText(PDefaultRendererPanel.this.myResourceBundle.getString("PDefaultRendererPanel.no_Data"));
                this.setForeground(new Color(153, 153, 153));
            } else {
                String textValue;
                String string = textValue = value == null ? "" : value.toString();
                if (column == table.getColumnCount() - 1) {
                    FontMetrics fontMetrics = table.getFontMetrics(this.getFont());
                    int stringWidth = SwingUtilities.computeStringWidth(fontMetrics, textValue);
                    int cellGapWidth = SwingUtilities.computeStringWidth(fontMetrics, "##");
                    int columnMaxWidth = table.getColumnModel().getColumn(column).getMaxWidth() - cellGapWidth;
                    if (columnMaxWidth < stringWidth) {
                        textValue = TextUtils.getFormatTextByLimitedFontWidth(fontMetrics, textValue, columnMaxWidth);
                        this.setVerticalAlignment(1);
                        this.setVerticalTextPosition(1);
                    }
                }
                this.setText(textValue);
            }
            return this;
        }
    }

    private static class TreeViewTableHeaderRenderer
    extends PTableCellRenderer {
        private static final long serialVersionUID = 8203653721706454361L;
        private JTree myTree;
        private DefaultMutableTreeNode myNode;

        public TreeViewTableHeaderRenderer(JTree tree, DefaultMutableTreeNode node) {
            this.myTree = tree;
            this.myNode = node;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setBackground(BACKGROUND_COLOR);
            new NetLabelUIHelper().propertyChanged(this);
            this.setText(value.toString());
            this.highlightHeaderSearchText(column, row == -2);
            this.setOpaque(false);
            return this;
        }

        private void highlightHeaderSearchText(int column, boolean isHeaderGroup) {
            String searchText = PDefaultRendererPanel.getSearchText(this.myTree);
            if (searchText == null || searchText.length() == 0) {
                return;
            }
            TreeViewTreeHighlight emphasizedHighlight = PDefaultRendererPanel.getEmphasizedHighlight(this.myTree);
            DefaultLabelHighlighter highlighter = new DefaultLabelHighlighter();
            DefaultTreeModel model = (DefaultTreeModel)this.myTree.getModel();
            Object[] nodes = model.getPathToRoot(this.myNode);
            TreePath path = new TreePath(nodes);
            String escapedText = null;
            if (searchText != null && searchText.length() > 0) {
                escapedText = searchText.replaceAll("(\\p{Punct})", "\\\\$1");
            }
            if (escapedText != null) {
                escapedText = escapedText.toLowerCase();
                Pattern p = Pattern.compile(escapedText);
                String lowerCaseText = this.getText().toLowerCase();
                Matcher m = p.matcher(lowerCaseText);
                int headerRow = 0;
                if (((PTableLeafNode)this.myNode.getUserObject()).isShowTitle() && ((PTableLeafNode)this.myNode.getUserObject()).getTitle() != null) {
                    ++headerRow;
                }
                if (isHeaderGroup) {
                    headerRow = -2;
                }
                while (m.find()) {
                    if (emphasizedHighlight != null && path.equals(emphasizedHighlight.getPath()) && emphasizedHighlight.getColumn() == column && emphasizedHighlight.getRow() == headerRow && m.start() == emphasizedHighlight.getIndex()) {
                        highlighter.addHighlight(m.start(), m.end(), new DefaultLabelHighlightPainter(NSNColors.getPurple()));
                        continue;
                    }
                    highlighter.addHighlight(m.start(), m.end(), new DefaultLabelHighlightPainter());
                }
            }
            this.putClientProperty("OrangeTouch.highlighter", highlighter);
        }
    }

    private static class TreeViewTableModelWrapper
    implements TableModel,
    TableModelListener {
        private TableModel myTableModel;
        private Map<Integer, Integer> myColumnAlignmentCache;

        public TreeViewTableModelWrapper(TableModel model) {
            this.myTableModel = model;
            this.myTableModel.addTableModelListener(this);
            this.myColumnAlignmentCache = new HashMap<Integer, Integer>();
        }

        public void clearModel() {
            this.myTableModel.removeTableModelListener(this);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public int getRowCount() {
            return this.myTableModel.getRowCount();
        }

        @Override
        public int getColumnCount() {
            return this.myTableModel.getColumnCount();
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.myTableModel.getColumnName(columnIndex);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return this.myTableModel.getColumnClass(columnIndex);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.myTableModel.getValueAt(rowIndex, columnIndex);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            this.myTableModel.setValueAt(aValue, rowIndex, columnIndex);
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
            this.myTableModel.addTableModelListener(l);
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
            this.myTableModel.removeTableModelListener(l);
        }

        public int resolveAlignment(int column) {
            if (this.myColumnAlignmentCache.get(column) != null) {
                return this.myColumnAlignmentCache.get(column);
            }
            int i = 0;
            while (i < this.getRowCount()) {
                if (!(this.getValueAt(i, column) instanceof Number)) {
                    this.myColumnAlignmentCache.put(column, 2);
                    return 2;
                }
                ++i;
            }
            this.myColumnAlignmentCache.put(column, 4);
            return 4;
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            this.myColumnAlignmentCache.clear();
        }
    }
}

