/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.treeview;

import com.nokia.em.poseidon.gui.treeview.PLeafNode;
import com.nokia.em.poseidon.gui.treeview.PTableLeafNodeHeaderGroup;
import com.nokia.em.poseidon.gui.treeview.PTitleNode;
import com.nokia.em.poseidon.util.TextUtils;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.table.PTable;
import java.awt.FontMetrics;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class PTableLeafNode
extends PLeafNode {
    private boolean myShowTitle = false;
    private boolean myShowHeaders = true;
    private TableModel myTableModel = new DefaultTableModel();
    private boolean myHeadersAdded = false;
    private int myMaxWidthForLastColumn;
    private Map<Integer, PTableLeafNodeHeaderGroup> myHeaderGroups = new TreeMap<Integer, PTableLeafNodeHeaderGroup>();

    public PTableLeafNode(boolean selected) {
        super(selected);
    }

    public PTableLeafNode(boolean selected, boolean showHeaders) {
        super(selected);
        this.myShowHeaders = showHeaders;
    }

    public PTableLeafNode(String title, boolean selected) {
        super(selected);
        this.myTitle = title;
    }

    public void setTableModel(TableModel tableModel) {
        this.myTableModel = tableModel;
    }

    public TableModel getTableModel() {
        return this.myTableModel;
    }

    public List getHeaders() {
        Vector<String> columnNames = new Vector<String>();
        int i = 0;
        while (i < this.myTableModel.getColumnCount()) {
            columnNames.add(this.myTableModel.getColumnName(i));
            ++i;
        }
        return columnNames;
    }

    public void setHeaders(Object[] headers) {
        ((DefaultTableModel)this.myTableModel).setColumnIdentifiers(headers);
        this.myHeadersAdded = true;
    }

    public List getRows() {
        return ((DefaultTableModel)this.myTableModel).getDataVector();
    }

    public void addRow(Vector row) {
        if (row == null) {
            return;
        }
        if (!this.myHeadersAdded) {
            int columnCount = row.size();
            int i = 0;
            while (i < columnCount) {
                ((DefaultTableModel)this.myTableModel).addColumn("");
                ++i;
            }
            this.myHeadersAdded = true;
        }
        ((DefaultTableModel)this.myTableModel).addRow(row);
    }

    public void removeRow(int index) {
        ((DefaultTableModel)this.myTableModel).removeRow(index);
    }

    public void removeRows() {
        while (this.myTableModel.getRowCount() > 0) {
            ((DefaultTableModel)this.myTableModel).removeRow(0);
        }
    }

    public void setShowHeaders(boolean showHeaders) {
        this.myShowHeaders = showHeaders;
    }

    public boolean isShowHeaders() {
        return this.myShowHeaders;
    }

    public boolean isShowHeaderGroup() {
        return !this.myHeaderGroups.isEmpty();
    }

    public void addHeaderGroup(int firstColumn, PTableLeafNodeHeaderGroup value) {
        this.myHeaderGroups.put(firstColumn, value);
    }

    public Map<Integer, PTableLeafNodeHeaderGroup> getHeaderGroup() {
        return this.myHeaderGroups;
    }

    public void setShowTitle(boolean showTitle) {
        this.myShowTitle = showTitle;
    }

    public boolean isShowTitle() {
        return this.myShowTitle;
    }

    @Override
    public Object[] getSaveFormat() {
        List rowList;
        Object[] format = null;
        int addLines = 0;
        boolean dataUnavailable = this.checkIfParentUnavailableAndDataUndefined();
        if (this.isShowTitle() && this.getTitle() != null) {
            addLines += 2;
        }
        if (this.isShowHeaders()) {
            if (this.isShowHeaderGroup()) {
                ++addLines;
            }
            addLines += 2;
        }
        if (this.getRows().isEmpty() && this.checkIfParentUnavailable()) {
            ++addLines;
        }
        format = new String[addLines + this.getRows().size()];
        int index = 0;
        if (this.isShowTitle() && this.getTitle() != null) {
            format[index++] = "";
            format[index++] = this.getTitle();
        }
        int[] maxColLength = this.getMaxColLength();
        if (this.isShowHeaders()) {
            List headersList = this.getHeaders();
            int spanColumn = 0;
            String headerGroupText = "";
            String tempHeaderGroupText = "";
            String headerText = "";
            StringBuilder hb = new StringBuilder();
            int i = 0;
            while (i < headersList.size()) {
                int maxColLegth = maxColLength[i];
                if (this.isShowHeaderGroup()) {
                    tempHeaderGroupText = "";
                    if (spanColumn > 0) {
                        --spanColumn;
                    } else {
                        Map<Integer, PTableLeafNodeHeaderGroup> headerGroups = this.getHeaderGroup();
                        if (headerGroups.keySet().contains(i)) {
                            PTableLeafNodeHeaderGroup headGroup = headerGroups.get(i);
                            spanColumn = headGroup.getEndColumn() - headGroup.getStartColumn();
                            tempHeaderGroupText = headGroup.getText();
                            int j = i + 1;
                            while (j < i + spanColumn + 1) {
                                maxColLegth += maxColLength[j];
                                ++j;
                            }
                        }
                        headerGroupText = String.valueOf(headerGroupText) + tempHeaderGroupText + this.getIndentation(maxColLegth - tempHeaderGroupText.length() + 2);
                        if (!"".equals(tempHeaderGroupText)) {
                            headerGroupText = String.valueOf(headerGroupText) + this.getIndentation(2);
                        }
                    }
                }
                ++i;
            }
            i = 0;
            while (i < headersList.size()) {
                String tempText = (String)headersList.get(i);
                headerText = String.valueOf(headerText) + tempText + this.getIndentation(maxColLength[i] - tempText.length() + 2);
                ++i;
            }
            if (this.isShowHeaderGroup()) {
                format[index++] = headerGroupText;
            }
            i = 0;
            while (i < headerText.length()) {
                if (headerText.charAt(i) != ' ') break;
                hb.append(" ");
                ++i;
            }
            int j = 0;
            while (j < headerText.trim().length()) {
                hb.append("-");
                ++j;
            }
            format[index++] = headerText;
            format[index++] = hb.toString();
        }
        if ((rowList = this.getRows()).isEmpty() && this.checkIfParentUnavailable()) {
            format[index++] = this.myResourceBundle.getString("PDefaultRendererPanel.no_Data");
        } else {
            int i = 0;
            while (i < rowList.size()) {
                List singleRowData = (List)rowList.get(i);
                StringBuilder sb = new StringBuilder();
                int j = 0;
                while (j < singleRowData.size()) {
                    Object tempText = singleRowData.get(j);
                    if (dataUnavailable && j == 1) {
                        sb.append(" ");
                        sb.append(this.myResourceBundle.getString("PDefaultRendererPanel.no_Data"));
                    } else if (tempText != null && !(tempText instanceof Icon)) {
                        sb.append(tempText.toString());
                        sb.append(this.getIndentation(maxColLength[j] - tempText.toString().length() + 2));
                    }
                    ++j;
                }
                format[index++] = sb.toString();
                ++i;
            }
        }
        return format;
    }

    public boolean checkIfParentUnavailableAndDataUndefined() {
        TableModel model;
        PTitleNode titleNode;
        boolean hasHeader;
        boolean bl = hasHeader = this.isShowHeaders() && this.getHeaders() != null && this.getHeaders().size() != 0;
        if (this.getParent() != null && this.getParent() instanceof PTitleNode && (titleNode = (PTitleNode)this.getParent()).getDataState() == 2 && (model = this.getTableModel()).getColumnCount() == 2 && !hasHeader) {
            int i = 0;
            while (i < model.getRowCount()) {
                if (model.getValueAt(i, 1) != null) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public boolean checkIfParentUnavailable() {
        PTitleNode titleNode;
        return this.getParent() != null && this.getParent() instanceof PTitleNode && (titleNode = (PTitleNode)this.getParent()).getDataState() == 2;
    }

    private String getIndentation(int spaceCount) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < spaceCount) {
            sb.append(" ");
            ++i;
        }
        return sb.toString();
    }

    private int[] getMaxColLength() {
        int i;
        int max = 0;
        int[] hl = null;
        if (this.isShowHeaders()) {
            List headersList = this.getHeaders();
            hl = new int[headersList.size()];
            i = 0;
            while (i < headersList.size()) {
                String text = (String)headersList.get(i);
                hl[i] = max = Math.max(max, text.length());
                ++i;
            }
        }
        List rowList = this.getRows();
        i = 0;
        while (i < rowList.size()) {
            List singleRowData = (List)rowList.get(i);
            if (hl != null) {
                if (hl.length < singleRowData.size()) {
                    int[] tempA = (int[])hl.clone();
                    hl = new int[singleRowData.size()];
                    int j = 0;
                    while (j < tempA.length) {
                        hl[j] = tempA[j];
                        ++j;
                    }
                }
            } else {
                hl = new int[singleRowData.size()];
            }
            int j = 0;
            while (j < singleRowData.size()) {
                String text;
                if (singleRowData.get(j) != null && (text = String.valueOf(singleRowData.get(j))) != null) {
                    hl[j] = Math.max(hl[j], text.length());
                }
                ++j;
            }
            ++i;
        }
        if (this.isShowHeaderGroup()) {
            Map<Integer, PTableLeafNodeHeaderGroup> headerGroups = this.getHeaderGroup();
            List headersList = this.getHeaders();
            int spanHeaderGroupColumn = 0;
            String tempHeaderGroupText = "";
            int spanColumn = 0;
            int i2 = 0;
            while (i2 < headersList.size()) {
                if (headerGroups.keySet().contains(i2)) {
                    PTableLeafNodeHeaderGroup headGroup = headerGroups.get(i2);
                    spanHeaderGroupColumn = headGroup.getEndColumn() - headGroup.getStartColumn();
                    tempHeaderGroupText = headGroup.getText();
                    int j = i2;
                    while (j < i2 + spanHeaderGroupColumn + 1) {
                        spanColumn += hl[j];
                        ++j;
                    }
                    int totalRemain = Math.abs(tempHeaderGroupText.length() - spanColumn);
                    int averageColumnWidthRemain = totalRemain / spanHeaderGroupColumn + 1;
                    int j2 = i2;
                    while (j2 < i2 + spanHeaderGroupColumn) {
                        hl[j2] = hl[j2] + averageColumnWidthRemain;
                        ++j2;
                    }
                }
                ++i2;
            }
        }
        return hl;
    }

    @Override
    public Object[] getPrintFormat() {
        ((DefaultTableModel)this.myTableModel).setColumnIdentifiers(this.getHeaders().toArray());
        Object[] printTable = null;
        String empty = " ";
        boolean dataUnavailable = this.checkIfParentUnavailableAndDataUndefined();
        StringBuilder title = new StringBuilder();
        DefaultTableModel tempTableModel = null;
        if (this.isShowTitle() && this.getTitle() != null) {
            title.append(this.getIndentation(6));
            title.append(this.getTitle());
        }
        if (dataUnavailable) {
            String noData = this.myResourceBundle.getString("PDefaultRendererPanel.no_Data");
            tempTableModel = new DefaultTableModel(this.myTableModel.getRowCount(), this.myTableModel.getColumnCount());
            int row = 0;
            while (row < this.myTableModel.getRowCount()) {
                int column = 0;
                while (column < this.myTableModel.getColumnCount()) {
                    if (column == 1) {
                        tempTableModel.setValueAt(noData, row, 1);
                    } else {
                        tempTableModel.setValueAt(this.myTableModel.getValueAt(row, column), row, column);
                    }
                    ++column;
                }
                ++row;
            }
        } else if (this.checkIfParentUnavailable() && this.myTableModel.getRowCount() == 0 && !this.getHeaders().isEmpty()) {
            tempTableModel = new DefaultTableModel(1, this.myTableModel.getColumnCount());
            tempTableModel.setColumnIdentifiers(this.getHeaders().toArray());
            tempTableModel.setValueAt(this.myResourceBundle.getString("PDefaultRendererPanel.no_Data"), 0, 0);
        }
        if (title.length() > 0) {
            printTable = tempTableModel == null ? new Object[]{empty.toString(), title.toString(), this.myTableModel} : new Object[]{empty.toString(), title.toString(), tempTableModel};
        } else if (tempTableModel == null) {
            if (this.getHeaderGroup().isEmpty()) {
                printTable = new Object[]{this.myTableModel};
            } else {
                PTable table = new PTable(this.myTableModel);
                for (Integer startColumn : this.getHeaderGroup().keySet()) {
                    table.addHeaderGroup(startColumn, this.getHeaderGroup().get(startColumn).getText());
                }
                printTable = new Object[]{table};
            }
        } else {
            printTable = new Object[]{tempTableModel};
        }
        return printTable;
    }

    @Override
    public String[] getValues() {
        if (this.myTableModel == null) {
            return new String[0];
        }
        int index = 0;
        String[] values = new String[this.myTableModel.getRowCount() * this.myTableModel.getColumnCount()];
        int i = 0;
        while (i < this.myTableModel.getRowCount()) {
            int j = 0;
            while (j < this.myTableModel.getColumnCount()) {
                values[index] = this.myTableModel.getValueAt(i, j) == null ? "" : (this.myTableModel.getValueAt(i, j) instanceof ImageIcon ? "" : this.myTableModel.getValueAt(i, j).toString());
                ++index;
                ++j;
            }
            ++i;
        }
        return values;
    }

    public int getNumOfLinesInOneRow(int row, FontMetrics fontMetrics) {
        List singleRowData;
        Object cellData;
        List rowList = this.getRows();
        if (row < rowList.size() && (cellData = (singleRowData = (List)rowList.get(row)).get(singleRowData.size() - 1)) != null) {
            String textValue = cellData.toString();
            int maxWidth = this.getMaxWidthForLastColumn();
            int cellGapWidth = SwingUtilities.computeStringWidth(fontMetrics, "##");
            int columnMaxWidth = maxWidth - cellGapWidth;
            textValue = TextUtils.getFormatTextByLimitedFontWidth(fontMetrics, textValue, columnMaxWidth);
            String[] lines = NetUtils.breakupLines(textValue);
            return lines.length;
        }
        return 1;
    }

    public void setMaxWidthForLastColumn(int maxWidth) {
        this.myMaxWidthForLastColumn = maxWidth;
    }

    public int getMaxWidthForLastColumn() {
        return this.myMaxWidthForLastColumn;
    }
}

