/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.treeview;

import com.nokia.em.poseidon.frameworks.mvc.Controller;
import com.nokia.em.poseidon.gui.treeview.PDefaultRendererPanel;
import com.nokia.widgets.PBorderFactory;
import com.nokia.widgets.PPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;

public class PTreeViewCellHandler
extends PPanel
implements TreeCellRenderer,
TreeCellEditor {
    private static final Color BACKGROUND_COLOR = new Color(255, 255, 255);
    protected PDefaultRendererPanel myContentPanel = null;
    private Object myValue;
    private Vector<CellEditorListener> myCellEditorListener;

    public PTreeViewCellHandler(Controller ctrl, String siteName, TreeModel treeModel) {
        this.setBackground(BACKGROUND_COLOR);
        this.myContentPanel = new PDefaultRendererPanel(ctrl, siteName, treeModel);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return new Dimension(dimension.width - 5, dimension.height - 5);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.validate();
    }

    public void clear() {
        if (this.myContentPanel != null) {
            this.myContentPanel.clear();
            this.myContentPanel = null;
        }
        this.myValue = null;
        if (this.myCellEditorListener != null) {
            this.myCellEditorListener.clear();
        }
        this.myCellEditorListener = null;
    }

    @Override
    public boolean isCellEditable(EventObject evt) {
        MouseEvent mevt;
        return evt instanceof MouseEvent && (mevt = (MouseEvent)evt).getClickCount() == 1;
    }

    @Override
    public void removeCellEditorListener(CellEditorListener listener) {
        if (this.myCellEditorListener == null) {
            return;
        }
        this.myCellEditorListener.remove(listener);
    }

    @Override
    public boolean shouldSelectCell(EventObject evt) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        return true;
    }

    @Override
    public void addCellEditorListener(CellEditorListener listener) {
        if (this.myCellEditorListener == null) {
            this.myCellEditorListener = new Vector();
        }
        this.myCellEditorListener.add(listener);
    }

    @Override
    public void cancelCellEditing() {
        if (this.myCellEditorListener != null) {
            ChangeEvent ev = new ChangeEvent(this);
            for (CellEditorListener editorListener : this.myCellEditorListener) {
                editorListener.editingStopped(ev);
            }
        }
    }

    @Override
    public Object getCellEditorValue() {
        if (this.myValue != null) {
            return ((DefaultMutableTreeNode)this.myValue).getUserObject();
        }
        return null;
    }

    @Override
    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        return this.getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, true);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.removeAll();
        this.myValue = value;
        this.myContentPanel.buildUI(value, expanded, row, tree, this);
        this.add((Component)this.myContentPanel, "Center");
        this.validate();
        this.drawFocus(hasFocus);
        return this;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        return this.myContentPanel.getToolTipText(event);
    }

    private void drawFocus(boolean hasFocus) {
        if (hasFocus) {
            this.myContentPanel.setBorder(PBorderFactory.getFocusBorder());
        } else {
            this.myContentPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        }
    }
}

