/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.treeview;

import com.nokia.em.poseidon.gui.treeview.PAbstractNode;
import com.nokia.em.poseidon.gui.treeview.PTreeViewCommandHandler;
import com.nokia.em.poseidon.gui.treeview.PTreeViewFileSelector;
import com.nokia.em.poseidon.gui.treeview.PTreeViewFileWriter;
import com.nokia.em.poseidon.gui.treeview.PTreeViewFileWriterFactory;
import com.nokia.em.poseidon.gui.treeview.PTreeViewPrinter;
import com.nokia.em.poseidon.gui.treeview.PTreeViewPrinterFactory;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import org.apache.log4j.Logger;

public class PTreeViewCommandHandlerImpl
implements PTreeViewCommandHandler {
    Logger myLogger = Logger.getLogger(this.getClass());

    @Override
    public void handleSaveAction(PTreeViewFileWriter fileWriter, Component parent, PAbstractNode node, String title, String siteName) {
        PTreeViewFileWriter treeViewWriter = fileWriter;
        if (fileWriter == null) {
            treeViewWriter = PTreeViewFileWriterFactory.getCurrentWriter(0);
        }
        PTreeViewFileSelector.setFileFilter(treeViewWriter.getFileFilter());
        PTreeViewFileSelector.setDefaultFileName(treeViewWriter.getDefaultFileName());
        PTreeViewFileSelector.setDefaultFileExt(treeViewWriter.getDefaultFileExt());
        PTreeViewFileSelector.setFileChooserTitle(treeViewWriter.getFileChooserTitle());
        File file = PTreeViewFileSelector.getSelectedFile(parent, title, siteName);
        if (file == null) {
            return;
        }
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(file);
        }
        catch (Exception exception) {
            this.myLogger.error("Failure in opening output stream", exception);
            return;
        }
        treeViewWriter.writeTreeInfo(outputStream, node, title);
    }

    @Override
    public void handlePrintAction(PTreeViewPrinter printer, PAbstractNode node, String title) {
        if (printer == null) {
            PTreeViewPrinter treeViewPrinter = PTreeViewPrinterFactory.getCurrentPrinter(0);
            treeViewPrinter.printTreeInfo(node, title);
        } else {
            printer.printTreeInfo(node, title);
        }
    }
}

