/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.treeview;

import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.frameworks.event.EventProcessor;
import com.nokia.em.poseidon.frameworks.mvc.ControllerBase;
import com.nokia.em.poseidon.gui.common.events.DialogCloseEvent;
import com.nokia.em.poseidon.gui.treeview.PAbstractNode;
import com.nokia.em.poseidon.gui.treeview.PTitleNode;
import com.nokia.em.poseidon.gui.treeview.PTreeViewCloseListener;
import com.nokia.em.poseidon.gui.treeview.PTreeViewCommandHandler;
import com.nokia.em.poseidon.gui.treeview.PTreeViewCommandHandlerImpl;
import com.nokia.em.poseidon.gui.treeview.PTreeViewDialogView;
import com.nokia.em.poseidon.gui.treeview.PTreeViewFileWriter;
import com.nokia.em.poseidon.gui.treeview.PTreeViewModel;
import com.nokia.em.poseidon.gui.treeview.PTreeViewPrinter;
import com.nokia.em.poseidon.gui.treeview.PTreeViewUI;
import com.nokia.em.poseidon.services.help.PHelp;
import com.nokia.widgets.buttons.PToolButton;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class PTreeViewController
extends ControllerBase
implements EventProcessor {
    private PTreeViewModel myTreeViewModel;
    private String mySiteName;
    private String myTitle;
    private PTreeViewFileWriter myFileWriter;
    private PTreeViewPrinter myPrinter;
    private String myHelpId;
    private Vector<PTreeViewCloseListener> myClosingListeners;
    private PTreeViewCommandHandler myCommandHandler;
    private Dimension myDialogSize;

    public PTreeViewController(PTreeViewModel model, String siteName) {
        this.myTreeViewModel = model;
        this.mySiteName = siteName;
        this.myClosingListeners = new Vector();
        this.myCommandHandler = new PTreeViewCommandHandlerImpl();
        this.setCommandHandler(model.getMainLevelNodes());
        PoseidonRuntime.getRuntime().addObject(this);
    }

    @Override
    public void destroy() {
        PoseidonRuntime.getRuntime().removeObject(this);
        this.myTreeViewModel.clearModel();
        int i = 0;
        while (i < this.myClosingListeners.size()) {
            this.myClosingListeners.remove(0).treeViewClosed();
            ++i;
        }
        this.myTreeViewModel = null;
        this.myFileWriter = null;
        this.myPrinter = null;
        this.myClosingListeners.clear();
        this.myClosingListeners = null;
        this.myCommandHandler = null;
        super.destroy();
    }

    public PTreeViewModel getModel() {
        return this.myTreeViewModel;
    }

    public void setFileWriter(PTreeViewFileWriter fileWriter) {
        this.myFileWriter = fileWriter;
    }

    public void setPrinter(PTreeViewPrinter printer) {
        this.myPrinter = printer;
    }

    public void setHelpButtonAction(String helpId) {
        this.myHelpId = helpId;
    }

    public void setSaveVisible(boolean value) {
        ((PTreeViewUI)((Object)this.getView())).setSaveVisible(value);
    }

    public void setPrintVisible(boolean value) {
        ((PTreeViewUI)((Object)this.getView())).setPrintVisible(value);
    }

    public void setHelpVisible(boolean value) {
        ((PTreeViewUI)((Object)this.getView())).setHelpVisible(value);
    }

    public void setSaveEnable(boolean value) {
        ((PTreeViewUI)((Object)this.getView())).setSaveEnable(value);
    }

    public void setPrintEnable(boolean value) {
        ((PTreeViewUI)((Object)this.getView())).setPrintEnable(value);
    }

    public void setHelpEnable(boolean value) {
        ((PTreeViewUI)((Object)this.getView())).setHelpEnable(value);
    }

    public void setSearchFieldEnable(boolean value) {
        ((PTreeViewUI)((Object)this.getView())).setSearchFieldEnable(value);
    }

    public void setSearchFieldVisible(boolean value) {
        ((PTreeViewUI)((Object)this.getView())).setSearchFieldVisible(value);
    }

    public void setTitle(String title) {
        this.myTitle = title;
        if (this.getView() != null) {
            ((PTreeViewUI)((Object)this.getView())).setTitle(title);
        }
    }

    public void setExpandAllEnabled(boolean value) {
        ((PTreeViewUI)((Object)this.getView())).setExpandAllEnabled(value);
    }

    public void setCollapseAllEnabled(boolean value) {
        ((PTreeViewUI)((Object)this.getView())).setCollapseAllEnabled(value);
    }

    public void setTreeViewTreeEnabled(boolean value) {
        ((PTreeViewUI)((Object)this.getView())).setTreeViewTreeEnabled(value);
    }

    public void addCustomAction(Action customAction) {
        ((PTreeViewUI)((Object)this.getView())).addCustomAction(customAction);
    }

    public void addCustomToolButton(PToolButton customButton) {
        ((PTreeViewUI)((Object)this.getView())).addCustomToolButton(customButton);
    }

    public void addCustomToolButton(PToolButton customButton, int index) {
        ((PTreeViewUI)((Object)this.getView())).addCustomToolButton(customButton);
    }

    public void setContextSpecificTooltipData(String toolTip) {
        ((PTreeViewUI)((Object)this.getView())).setContextSpecificTooltipData(toolTip);
    }

    public void addMainLevelNodes(PAbstractNode[] mainLevelNodes) {
        ((PTreeViewUI)((Object)this.getView())).addMainLevelNodes(mainLevelNodes);
    }

    public void removeMainLevelNodes(PAbstractNode[] mainLevelNodes) {
        ((PTreeViewUI)((Object)this.getView())).removeMainLevelNodes(mainLevelNodes);
    }

    public void addTreeViewClosingListener(PTreeViewCloseListener listener) {
        this.myClosingListeners.add(listener);
    }

    public void removeTreeViewClosingListener(PTreeViewCloseListener listener) {
        this.myClosingListeners.remove(listener);
    }

    public void setTreeViewDialogSize(Dimension size) {
        if (this.myView instanceof PTreeViewDialogView) {
            ((PTreeViewDialogView)this.myView).setPreferredSize(size);
            ((PTreeViewDialogView)this.myView).setMinimumSize(size);
        }
        this.myDialogSize = size;
    }

    public Dimension getTreeViewDialogSize() {
        return this.myDialogSize;
    }

    public void setTreeViewHandler(PTreeViewCommandHandler cmdHandler) {
        this.myCommandHandler = cmdHandler;
    }

    public PTreeViewCommandHandler getTreeViewHandler() {
        return this.myCommandHandler;
    }

    void save(Component parent, PAbstractNode node) {
        this.myCommandHandler.handleSaveAction(this.myFileWriter, parent, node, this.myTitle, this.mySiteName);
    }

    void print(PAbstractNode node) {
        this.myCommandHandler.handlePrintAction(this.myPrinter, node, this.myTitle);
    }

    void generateHelp() {
        PoseidonRuntime.getRuntime().getService(PHelp.class).showHelp((Window)((Object)this.getView()), this.myHelpId);
    }

    private void setCommandHandler(PAbstractNode[] nodes) {
        int i = 0;
        while (i < nodes.length) {
            if (nodes[i] instanceof PTitleNode) {
                PTitleNode titleNode = (PTitleNode)nodes[i];
                if (titleNode.getCommandHandler() == null) {
                    titleNode.setCommandHandler(new PTreeViewCommandHandlerImpl());
                }
                try {
                    if (titleNode.getChildren() != null) {
                        this.setCommandHandler(titleNode.getChildren());
                    }
                }
                catch (UnsupportedOperationException ex) {
                    Logger.getLogger(this.getClass()).trace("Cannot set action handler to all children");
                }
            }
            ++i;
        }
    }

    @Override
    public void processEvent(EventObject event) {
        if (event instanceof DialogCloseEvent && this.getView() instanceof PTreeViewDialogView) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PTreeViewController.this.destroy();
                }
            });
        }
    }
}

