/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.treeview;

import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.frameworks.print.PPrintHelper;
import com.nokia.em.poseidon.frameworks.print.PPrintTable;
import com.nokia.em.poseidon.frameworks.print.PPrintText;
import com.nokia.em.poseidon.frameworks.print.PPrintableArea;
import com.nokia.em.poseidon.frameworks.print.PPrintableDoc;
import com.nokia.em.poseidon.frameworks.print.PPrintableSection;
import com.nokia.em.poseidon.gui.treeview.PAbstractNode;
import com.nokia.em.poseidon.gui.treeview.PLeafNode;
import com.nokia.em.poseidon.gui.treeview.PTitleNode;
import com.nokia.laf.NetLookAndFeel;
import com.nokia.widgets.table.PTable;
import java.awt.Font;
import java.text.DateFormat;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class PTreeViewDefaultPrinter
extends PPrintableDoc
implements PPrintableSection {
    static final String FONT_NAME_PTREEVIEW = NetLookAndFeel.getUserTextFont().getName();
    static final int FONT_SIZE_PTREEVIEW = 9;
    static final Font DEFAULfT_FONT = new Font(FONT_NAME_PTREEVIEW, 0, 9);
    private PAbstractNode myNode;
    protected PPrintableArea myFooter;
    protected PPrintableArea myHeader;
    protected ResourceBundle myResourceBundle;
    protected String myTitle;
    protected DateFormat myDateFormat;
    private PPrintHelper myPrintHelper;
    private PPrintText.ALIGN myAlignment = PPrintText.ALIGN.CENTER;

    public PTreeViewDefaultPrinter(PAbstractNode node, String title, DateFormat dateFormat) {
        this.myResourceBundle = I18n.getI18n().getBundle(this.getClass());
        this.myTitle = title;
        this.myNode = node;
        this.myDateFormat = dateFormat;
        this.setDefaultFont(DEFAULfT_FONT);
        this.myPrintHelper = new PPrintHelper(this);
    }

    @Override
    public void doPrinting() {
        this.createTreeInfoPrintOut();
    }

    @Override
    public PPrintableArea createPageHeader() {
        return this.myPrintHelper.createPageHeader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTreeInfoPrintOut() {
        this.setPageHeader(this.createPageHeader());
        PAbstractNode pAbstractNode = this.myNode;
        synchronized (pAbstractNode) {
            this.createTreeInfoNodePrintOut(this.myNode, 0, false);
        }
        this.add(this.createPageFooter());
    }

    private void createTreeInfoNodePrintOut(PAbstractNode node, int origSpaceCount, boolean isMainTitlePrinted) {
        int spaceCount = origSpaceCount;
        switch (node.getLevel()) {
            case 1: {
                if (!isMainTitlePrinted) {
                    this.add(this.createTitlePrintTable((PTitleNode)node.getParent(), spaceCount));
                }
            }
            case 0: {
                PTitleNode titleNode = (PTitleNode)node;
                if (titleNode.getTitle().equals("DUMMY_ROOT")) {
                    --spaceCount;
                }
                this.add(this.createTitlePrintTable(titleNode, spaceCount));
                PAbstractNode[] children = null;
                try {
                    children = titleNode.getChildren();
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                if (children == null) break;
                int i = 0;
                while (i < children.length) {
                    if (i != 0 && !(children[i] instanceof PLeafNode)) {
                        PPrintText emptyRow = new PPrintText(" ", this);
                        emptyRow.setIndentation(spaceCount * 6);
                        this.add(emptyRow);
                    }
                    this.createTreeInfoNodePrintOut(children[i], spaceCount + 1, true);
                    ++i;
                }
                break;
            }
            case 2: {
                Object[] format = ((PLeafNode)node).getPrintFormat();
                if (format == null) break;
                int i = 0;
                while (i < format.length) {
                    PPrintTable tableData;
                    if (format[i] instanceof TableModel) {
                        TableModel tableModel = (TableModel)format[i];
                        tableData = new PPrintTable(tableModel, (PPrintableArea)this);
                        this.setPPrintTableProperties(spaceCount, tableModel, tableData);
                    } else if (format[i] instanceof PTable) {
                        PTable table = (PTable)format[i];
                        tableData = new PPrintTable(table, (PPrintableArea)this);
                        this.setPPrintTableProperties(spaceCount, table.getModel(), tableData);
                    } else {
                        PPrintText data = new PPrintText(" ", this);
                        data.setIndentation(spaceCount * 6);
                        data.setText("" + format[i]);
                        this.add(data);
                    }
                    ++i;
                }
                break;
            }
        }
    }

    private void setPPrintTableProperties(int spaceCount, TableModel tableModel, PPrintTable tableData) {
        tableData.setIndentation(spaceCount * 6);
        tableData.setDrawTableLines(false);
        if (tableModel.getColumnName(0) != null && !"".equals(tableModel.getColumnName(0)) && !"A".equals(tableModel.getColumnName(0))) {
            tableData.setPaintHeaderLine(true);
            tableData.setPaintTableHeader(true);
        }
        tableData.setCellBottomMarginal(2);
        tableData.setCellLeftMarginal(2);
        tableData.setCellRightMarginal(6);
        tableData.setCellTopMarginal(2);
        this.add(tableData);
    }

    private PPrintTable createTitlePrintTable(PTitleNode titleNode, int spaceCount) {
        DefaultTableModel titleTableModel = new DefaultTableModel(1, 5);
        if (titleNode.getIcon() != null) {
            titleTableModel.setValueAt(titleNode.getIcon(), 0, 0);
        }
        if (titleNode.getTitle().equals("DUMMY_ROOT")) {
            titleTableModel.setValueAt(" ", 0, 1);
        } else {
            titleTableModel.setValueAt(titleNode.getTitle(), 0, 1);
        }
        PPrintTable printTable = new PPrintTable(titleTableModel, (PPrintableArea)this);
        printTable.setIndentation(spaceCount * 6);
        printTable.setDrawTableLines(false);
        printTable.setCellBottomMarginal(2);
        printTable.setCellLeftMarginal(2);
        printTable.setCellRightMarginal(6);
        printTable.setCellTopMarginal(2);
        return printTable;
    }

    public PPrintableArea createPageFooter() {
        return this.myPrintHelper.createPageFooter(1);
    }

    @Override
    public String getReportName() {
        return this.myTitle;
    }

    @Override
    public PPrintText.ALIGN getAlignment() {
        return this.myAlignment;
    }
}

