/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.treeview;

import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.frameworks.i18n.localizer.Localizer;
import com.nokia.em.poseidon.frameworks.i18n.localizer.LocalizerRegistry;
import com.nokia.em.poseidon.frameworks.i18n.localizer.swing.SwingHierarchyIterator;
import com.nokia.em.poseidon.frameworks.mvc.Controller;
import com.nokia.em.poseidon.frameworks.mvc.View;
import com.nokia.em.poseidon.frameworks.mvc.swing.JDialogViewBase;
import com.nokia.em.poseidon.gui.treeview.PAbstractNode;
import com.nokia.em.poseidon.gui.treeview.PTreeViewController;
import com.nokia.em.poseidon.gui.treeview.PTreeViewPanelView;
import com.nokia.em.poseidon.gui.treeview.PTreeViewTree;
import com.nokia.em.poseidon.gui.treeview.PTreeViewUI;
import com.nokia.widgets.ClientProperties;
import com.nokia.widgets.PPanel;
import com.nokia.widgets.buttons.PHelpButton;
import com.nokia.widgets.buttons.PToolButton;
import com.nokia.widgets.layout.RowAlignLayout;
import com.nokia.widgets.util.WidgetResources;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;

public class PTreeViewDialogView
extends JDialogViewBase
implements PTreeViewUI {
    protected static final int DIALOG_WIDTH = 700;
    protected static final int DIALOG_HEIGHT = 600;
    protected PTreeViewTree myTreeViewTree = null;
    protected PTreeViewController myTreeViewController = null;
    protected JButton myCloseButton = new JButton();
    protected PHelpButton myHelpButton = new PHelpButton();
    protected JPanel myUpperPanel = null;
    protected PPanel myButtonPanel = null;
    protected ResourceBundle myResourceBundle;
    protected String mySiteName;
    protected Frame myParentFrame;
    private Localizer myLocalizer;

    public PTreeViewDialogView(Frame parentFrame, PTreeViewController controller, String siteName) {
        super((Controller)controller, parentFrame, true);
        this.myParentFrame = parentFrame;
        this.myResourceBundle = I18n.getI18n().getBundle(this.getClass());
        this.myTreeViewController = controller;
        this.mySiteName = siteName;
        this.initialise();
        this.pack();
        this.restoreSettings();
        this.myLocalizer = LocalizerRegistry.lookup("swing");
        this.myLocalizer.setResourceBundle(this.myResourceBundle);
        this.myLocalizer.localizeObjectHierarchy(new SwingHierarchyIterator(this));
        this.addWindowFocusListener(new WindowAdapter(){
            private boolean focusGainedOnce = false;

            @Override
            public void windowGainedFocus(WindowEvent e) {
                if (!this.focusGainedOnce) {
                    PTreeViewDialogView.this.myCloseButton.requestFocusInWindow();
                    this.focusGainedOnce = true;
                }
            }
        });
        this.addPropertyChangeListener("title", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String tooltip = MessageFormat.format(WidgetResources.getString("HelpButton_TooltipText"), (String)evt.getNewValue());
                PTreeViewDialogView.this.myHelpButton.setToolTipText(tooltip);
            }
        });
    }

    @Override
    public Dimension getSize() {
        return this.myTreeViewController == null || this.myTreeViewController.getTreeViewDialogSize() == null ? super.getSize() : this.myTreeViewController.getTreeViewDialogSize();
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible == this.isVisible()) {
            return;
        }
        this.myUpperPanel.setVisible(visible);
        super.setVisible(visible);
    }

    @Override
    public void dispose() {
        if (this.myUpperPanel != null) {
            ((View)((Object)this.myUpperPanel)).dispose();
        }
        this.myParentFrame = null;
        this.myResourceBundle = null;
        this.myTreeViewController = null;
        this.mySiteName = null;
        this.myButtonPanel = null;
        this.myCloseButton = null;
        this.myHelpButton = null;
        this.myLocalizer = null;
        this.myTreeViewController = null;
        this.myTreeViewTree = null;
        this.myUpperPanel = null;
        this.removeWindowListener(this.myWindowAdapter);
        this.myWindowAdapter = null;
        this.removeAll();
        super.dispose();
    }

    @Override
    public void setSaveVisible(boolean value) {
        ((PTreeViewPanelView)this.myUpperPanel).setSaveVisible(value);
    }

    @Override
    public void setPrintVisible(boolean value) {
        ((PTreeViewPanelView)this.myUpperPanel).setPrintVisible(value);
    }

    @Override
    public void setSearchFieldVisible(boolean value) {
        ((PTreeViewPanelView)this.myUpperPanel).setSearchFieldVisible(value);
    }

    @Override
    public void setSearchFieldEnable(boolean value) {
        ((PTreeViewPanelView)this.myUpperPanel).setSearchFieldEnable(value);
    }

    @Override
    public void setHelpVisible(boolean value) {
        this.myHelpButton.setVisible(value);
        this.myHelpButton.setEnabled(value);
    }

    @Override
    public void setSaveEnable(boolean value) {
        ((PTreeViewPanelView)this.myUpperPanel).setSaveEnable(value);
    }

    @Override
    public void setPrintEnable(boolean value) {
        ((PTreeViewPanelView)this.myUpperPanel).setPrintEnable(value);
    }

    @Override
    public void setHelpEnable(boolean value) {
        this.myHelpButton.setEnabled(value);
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(title);
    }

    @Override
    public void setExpandAllEnabled(boolean value) {
        ((PTreeViewPanelView)this.myUpperPanel).setExpandAllEnabled(value);
    }

    @Override
    public void setCollapseAllEnabled(boolean value) {
        ((PTreeViewPanelView)this.myUpperPanel).setCollapseAllEnabled(value);
    }

    @Override
    public void setCollapseExpandTreeLevels(int levels) {
        ((PTreeViewPanelView)this.myUpperPanel).setCollapseExpandTreeLevels(levels);
    }

    @Override
    public void setTreeViewTreeEnabled(boolean value) {
        ((PTreeViewPanelView)this.myUpperPanel).setTreeViewTreeEnabled(value);
    }

    @Override
    public void addCustomAction(Action customAction) {
        ((PTreeViewPanelView)this.myUpperPanel).addCustomAction(customAction);
    }

    @Override
    public void addCustomToolButton(PToolButton customButton) {
        ((PTreeViewPanelView)this.myUpperPanel).addCustomToolButton(customButton);
    }

    @Override
    public void setContextSpecificTooltipData(String toolTip) {
        ((PTreeViewPanelView)this.myUpperPanel).setContextSpecificTooltipData(toolTip);
    }

    @Override
    public void addMainLevelNodes(PAbstractNode[] mainLevelNodes) {
        ((PTreeViewPanelView)this.myUpperPanel).addMainLevelNodes(mainLevelNodes);
    }

    @Override
    public void removeMainLevelNodes(PAbstractNode[] mainLevelNodes) {
        ((PTreeViewPanelView)this.myUpperPanel).removeMainLevelNodes(mainLevelNodes);
    }

    public void add(View view, Object constraint) {
    }

    public void addCustomToolButton(PToolButton toolButton, int index) {
        ((PTreeViewPanelView)this.myUpperPanel).addCustomToolButton(toolButton, index);
    }

    protected void initialise() {
        Dimension setSize = this.myTreeViewController.getTreeViewDialogSize();
        if (setSize != null) {
            this.setMinimumSize(setSize);
        } else {
            this.setMinimumSize(new Dimension(700, 600));
        }
        Container contentPane = this.getContentPane();
        contentPane.removeAll();
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraints contentPaneConstraints = new GridBagConstraints();
        contentPaneConstraints.gridx = 0;
        contentPaneConstraints.gridy = 0;
        contentPaneConstraints.gridwidth = 0;
        contentPaneConstraints.gridheight = 1;
        contentPaneConstraints.weightx = 1.0;
        contentPaneConstraints.weighty = 1.0;
        contentPaneConstraints.fill = 1;
        this.myUpperPanel = new PTreeViewPanelView(this.myTreeViewController, this.mySiteName);
        this.myUpperPanel.setBorder(BorderFactory.createEmptyBorder(0, 26, 0, 26));
        this.myTreeViewTree = ((PTreeViewPanelView)this.myUpperPanel).getTreeViewTree();
        contentPane.add((Component)this.myUpperPanel, contentPaneConstraints);
        this.myButtonPanel = new PPanel();
        contentPaneConstraints.weightx = 1.0;
        contentPaneConstraints.weighty = 0.0;
        contentPaneConstraints.gridy = -1;
        contentPaneConstraints.fill = 2;
        contentPane.add((Component)this.myButtonPanel, contentPaneConstraints);
        this.myButtonPanel.setVisibleUpperEdge(true);
        this.myButtonPanel.setLayout(new RowAlignLayout());
        this.myButtonPanel.setPanelType(ClientProperties.PANEL_BUTTONAREA_BACKGROUND);
        this.myCloseButton.setFocusable(true);
        this.myButtonPanel.add((Component)this.myCloseButton, "East");
        this.myCloseButton.setName("CloseAction");
        this.myCloseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PTreeViewDialogView.this.myTreeViewController != null) {
                    PTreeViewDialogView.this.myTreeViewController.destroy();
                }
            }
        });
        this.myHelpButton.setEnabled(true);
        this.myHelpButton.setVisible(true);
        this.myButtonPanel.add((Component)this.myHelpButton, "West");
        this.myHelpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PTreeViewDialogView.this.helpClicked(e);
            }
        });
        this.setModal(true);
    }

    protected void helpClicked(ActionEvent e) {
        this.myTreeViewController.generateHelp();
    }

    protected void removeButtonActionListeners(JButton button) {
        ActionListener[] listeners = button.getActionListeners();
        if (listeners != null) {
            int length = listeners.length;
            int i = 0;
            while (i < length) {
                button.removeActionListener(listeners[i]);
                ++i;
            }
        }
    }

    public void collapseAll() {
        this.myTreeViewTree.collapseAll();
    }
}

