/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.treeview;

import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.gui.savechooser.SaveChooserController;
import com.nokia.em.poseidon.gui.savechooser.SaveChooserFactory;
import com.nokia.em.poseidon.gui.savechooser.SaveChooserModel;
import com.nokia.em.poseidon.gui.savechooser.SaveChooserView;
import com.nokia.em.poseidon.util.PSettings;
import com.nokia.em.poseidon.util.file.PFileFilter;
import java.awt.Component;
import java.io.File;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.filechooser.FileFilter;

public class PTreeViewFileSelector {
    private static final String SETTINGS_KEY_SAVING_FILE = "TreeInfoFile";
    private static String myDefaultFileName;
    private static String myDefaultFileExt;
    private static String myChooserTitle;

    public static File getSelectedFile(Component parent, String title, String siteName) {
        SaveChooserController saveController = SaveChooserFactory.createFileChooserController(parent);
        SaveChooserModel model = saveController.getModel();
        model.setDefaultFileName(PTreeViewFileSelector.createFileName(PTreeViewFileSelector.removeSpaces(title), PTreeViewFileSelector.removeSpaces(siteName)));
        model.setSettingsKey(SETTINGS_KEY_SAVING_FILE);
        model.setSettings(PSettings.getInstance());
        model.setDefaultPath(PoseidonRuntime.getRuntime().getUserHome());
        model.setDialogTitle(MessageFormat.format(myChooserTitle, title));
        ((SaveChooserView)saveController.getView()).setSettingsKey(model.getSettingsKey());
        ResourceBundle myResourceBundle = I18n.getI18n().getBundle(PTreeViewFileSelector.class);
        Object[] param = new Object[]{"txt", "txt"};
        String description = MessageFormat.format(myResourceBundle.getString("SaveFileChooser.File_Description"), param);
        model.setFileFilter(new PFileFilter("txt", description));
        saveController.setVisible(true);
        return saveController.selectFile();
    }

    public static void setFileFilter(FileFilter filter) {
    }

    public static void setDefaultFileName(String fileName) {
        myDefaultFileName = fileName;
    }

    public static void setDefaultFileExt(String ext) {
        myDefaultFileExt = ext;
    }

    public static void setFileChooserTitle(String title) {
        myChooserTitle = title;
    }

    private static String removeSpaces(String origValue) {
        String value = origValue;
        if (value == null) {
            return value;
        }
        value = value.trim();
        return value.replace(" ", "");
    }

    private static String createFileName(String title, String siteName) {
        if (myDefaultFileName != null) {
            if (myDefaultFileExt == null) {
                return myDefaultFileName;
            }
            return String.valueOf(myDefaultFileName) + "." + myDefaultFileExt;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        StringBuffer fileName = new StringBuffer();
        if (title != null) {
            fileName.append(String.valueOf(title) + "_");
        }
        if (siteName != null) {
            fileName.append(String.valueOf(siteName) + "_");
        }
        fileName.append(dateFormat.format(new Date()));
        if (myDefaultFileExt != null) {
            fileName.append("." + myDefaultFileExt);
        }
        return fileName.toString();
    }
}

