/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.treeview;

import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.gui.treeview.PAbstractNode;
import com.nokia.em.poseidon.gui.treeview.PLeafNode;
import com.nokia.em.poseidon.gui.treeview.PTitleNode;
import com.nokia.em.poseidon.gui.treeview.PTreeViewFileWriter;
import com.nokia.em.poseidon.util.helper.FileWriterHelper;
import com.nokia.em.poseidon.util.helper.WriterInterFace;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.text.DateFormat;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class PTreeViewFileWriterImpl
implements PTreeViewFileWriter,
WriterInterFace {
    private static final int CHILD_INDENTATION = 2;
    private int myMaxLineLength = 100;
    private FileWriterHelper myFileWriterHelper;
    private String myTitle;
    private PrintWriter myWriter;
    private ResourceBundle myResourceBundle;
    private PAbstractNode myNode;
    private Logger myLogger = Logger.getLogger(PTreeViewFileWriterImpl.class);

    public PTreeViewFileWriterImpl() {
        this.myResourceBundle = I18n.getI18n().getBundle(this.getClass());
    }

    @Override
    public void writeTreeInfo(OutputStream outputStream, PAbstractNode node, String title) {
        this.initializeFields(outputStream, node, title);
        this.myFileWriterHelper = new FileWriterHelper(this);
        this.doWriteTreeInfo();
    }

    @Override
    public PrintWriter getWriter() {
        return this.myWriter;
    }

    @Override
    public String getTitle() {
        return this.myTitle;
    }

    public void initializeFields(OutputStream outputStream, PAbstractNode node, String title) {
        this.myLogger.debug("Default charset is: " + Charset.defaultCharset());
        try {
            this.myLogger.debug("Try to write using UTF-8");
            this.myWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8")));
            long size = this.getFileSize(outputStream);
            if (size == 0L) {
                this.myWriter.print('\ufeff');
            } else {
                this.myWriter.println();
            }
        }
        catch (UnsupportedEncodingException e) {
            this.myLogger.warn("UTF-8 not supported, use the default charset", e);
            this.myWriter = new PrintWriter(outputStream);
        }
        this.myNode = node;
        this.myTitle = title;
        this.myMaxLineLength = Math.max(this.myMaxLineLength, this.calculateMaxLineLength(this.myNode, -2));
    }

    private long getFileSize(OutputStream outputStream) {
        long size = -1L;
        if (outputStream instanceof FileOutputStream) {
            FileOutputStream fileOutputStream = (FileOutputStream)outputStream;
            try {
                size = fileOutputStream.getChannel().size();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Invalid output stream");
            }
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWriteTreeInfo() {
        this.writeHeader();
        PAbstractNode pAbstractNode = this.myNode;
        synchronized (pAbstractNode) {
            this.writeTreeNode(this.myNode, 0, false);
        }
        this.myWriter.println();
        this.writeFooter();
        this.myWriter.flush();
        this.myWriter.close();
    }

    @Override
    public FileFilter getFileFilter() {
        return new TreeInfoFileFilter();
    }

    @Override
    public String getDefaultFileName() {
        return null;
    }

    @Override
    public String getDefaultFileExt() {
        return "txt";
    }

    @Override
    public String getFileChooserTitle() {
        return this.myResourceBundle.getString("TreeViewSave_SaveDialog_Title");
    }

    @Override
    public void setDateFormat(DateFormat format) {
    }

    private String getIndentation(int spaceCount) {
        StringBuilder text = new StringBuilder();
        int i = 0;
        while (i < spaceCount) {
            text.append(" ");
            ++i;
        }
        return text.toString();
    }

    private void writeTreeNode(PAbstractNode node, int spaceCount, boolean isMainTitleWritten) {
        switch (node.getLevel()) {
            case 1: {
                if (!isMainTitleWritten) {
                    int newSpaceCount = spaceCount > 0 ? spaceCount - 1 : 0;
                    this.writeNodeTitle(node.getParent(), newSpaceCount);
                }
            }
            case 0: {
                this.writeNodeTitle(node, spaceCount);
                PAbstractNode[] children = null;
                try {
                    children = ((PTitleNode)node).getChildren();
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                if (children == null) break;
                int i = 0;
                while (i < children.length) {
                    if (i != 0 && !(children[i] instanceof PLeafNode)) {
                        this.myWriter.println();
                    }
                    this.writeTreeNode(children[i], spaceCount + 1, true);
                    ++i;
                }
                break;
            }
            case 2: {
                Object[] format = ((PLeafNode)node).getSaveFormat();
                if (format == null) break;
                int i = 0;
                while (i < format.length) {
                    this.myWriter.println(String.valueOf(this.getIndentation(spaceCount)) + format[i]);
                    ++i;
                }
                break;
            }
        }
    }

    private void writeNodeTitle(PAbstractNode node, int spaceCount) {
        if (!((PTitleNode)node).getTitle().equals("DUMMY_ROOT")) {
            this.writeSeparatorLine(spaceCount);
            this.myWriter.println(String.valueOf(this.getIndentation(spaceCount)) + ((PTitleNode)node).getTitle());
            this.writeSeparatorLine(spaceCount);
        }
    }

    private void writeHeader() {
        this.myFileWriterHelper.writeHeader();
    }

    private void writeFooter() {
        this.myFileWriterHelper.writeFooter();
    }

    protected void writeSeparatorLine(int spaceCount) {
        int index = 0;
        while (index < this.myMaxLineLength) {
            if (index >= spaceCount) {
                this.myWriter.print("-");
            } else {
                this.myWriter.print(" ");
            }
            ++index;
        }
        this.myWriter.println();
    }

    private int calculateMaxLineLength(PAbstractNode node, int spaceCount) {
        int maxRowLength = 0;
        switch (node.getLevel()) {
            case 0: 
            case 1: {
                if (!((PTitleNode)node).getTitle().equals("DUMMY_ROOT")) {
                    maxRowLength = Math.max(maxRowLength, (String.valueOf(this.getIndentation(spaceCount)) + ((PTitleNode)node).getTitle()).length());
                }
                PAbstractNode[] children = null;
                children = ((PTitleNode)node).getChildren();
                if (children == null) break;
                int i = 0;
                while (i < children.length) {
                    maxRowLength = Math.max(maxRowLength, this.calculateMaxLineLength(children[i], spaceCount + 2));
                    ++i;
                }
                break;
            }
            case 2: {
                Object[] format = ((PLeafNode)node).getSaveFormat();
                if (format == null) break;
                int i = 0;
                while (i < format.length) {
                    maxRowLength = Math.max(maxRowLength, (String.valueOf(this.getIndentation(spaceCount)) + format[i]).length());
                    ++i;
                }
                break;
            }
        }
        return maxRowLength;
    }

    private static class TreeInfoFileFilter
    extends FileFilter {
        private String myTxt = ".txt";

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            return file.getName().endsWith(this.myTxt);
        }

        @Override
        public String getDescription() {
            return "Text Only(*.txt)";
        }
    }
}

