/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.treeview;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;

public class PTreeViewFocusTraversalPolicy
extends FocusTraversalPolicy {
    private Component[] myComponents;

    public PTreeViewFocusTraversalPolicy(Component[] components) {
        this.myComponents = components;
    }

    @Override
    public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
        int index = this.getComponentIndex(aComponent);
        if (index == -1) {
            return this.myComponents[0];
        }
        if (index == this.myComponents.length - 1) {
            return this.myComponents[0];
        }
        return this.myComponents[index + 1];
    }

    @Override
    public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
        int index = this.getComponentIndex(aComponent);
        if (index == -1) {
            return this.myComponents[0];
        }
        if (index == 0) {
            return this.myComponents[this.myComponents.length - 1];
        }
        return this.myComponents[index - 1];
    }

    @Override
    public Component getDefaultComponent(Container focusCycleRoot) {
        if (this.myComponents != null) {
            return this.myComponents[0];
        }
        return null;
    }

    @Override
    public Component getLastComponent(Container focusCycleRoot) {
        if (this.myComponents != null && this.myComponents.length > 0) {
            return this.myComponents[this.myComponents.length - 1];
        }
        return null;
    }

    @Override
    public Component getFirstComponent(Container focusCycleRoot) {
        if (this.myComponents != null) {
            return this.myComponents[0];
        }
        return null;
    }

    private int getComponentIndex(Component comp) {
        int i = 0;
        while (i < this.myComponents.length) {
            if (comp == this.myComponents[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

