/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.treeview;

import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.frameworks.i18n.localizer.Localizer;
import com.nokia.em.poseidon.frameworks.i18n.localizer.LocalizerRegistry;
import com.nokia.em.poseidon.frameworks.i18n.localizer.swing.SwingHierarchyIterator;
import com.nokia.em.poseidon.frameworks.mvc.View;
import com.nokia.em.poseidon.frameworks.mvc.swing.JPanelViewBase;
import com.nokia.em.poseidon.gui.treeview.PAbstractNode;
import com.nokia.em.poseidon.gui.treeview.PTitleNode;
import com.nokia.em.poseidon.gui.treeview.PTreeViewController;
import com.nokia.em.poseidon.gui.treeview.PTreeViewTree;
import com.nokia.em.poseidon.gui.treeview.PTreeViewTreeSearchField;
import com.nokia.em.poseidon.gui.treeview.PTreeViewUI;
import com.nokia.em.poseidon.util.progressoperation.ProgressOperation;
import com.nokia.widgets.ClientProperties;
import com.nokia.widgets.PPanel;
import com.nokia.widgets.buttons.PToolButton;
import com.nokia.widgets.icons.CommonIcons;
import com.nokia.widgets.labels.PLabel;
import com.nokia.widgets.tree.TreeSearchBar;
import com.nokia.widgets.tree.TreeUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import net.miginfocom.swing.MigLayout;

public class PTreeViewPanelView
extends JPanelViewBase
implements PTreeViewUI {
    protected PTreeViewTree myTreeViewTree = null;
    protected PTreeViewController myTreeViewController = null;
    protected PToolButton myCollapseAllButton = new PToolButton();
    protected PToolButton myExpandAllButton = new PToolButton();
    protected PToolButton mySaveButton = new PToolButton();
    protected PToolButton myPrintButton = new PToolButton();
    protected PPanel myUpperPanel = null;
    protected PLabel myMainLabel = null;
    protected ResourceBundle myResourceBundle = I18n.getI18n().getBundle(this.getClass());
    protected String mySiteName;
    protected DefaultTreeModel myTreeModel;
    private Localizer myLocalizer;
    protected TreeSearchBar myTreeSearchBar;
    private static int MAX_EXPAND_NUMBER = 5000;

    public PTreeViewPanelView(PTreeViewController controller, String siteName) {
        super(controller);
        this.myTreeViewController = controller;
        this.mySiteName = siteName;
        this.myTreeModel = this.createTreeModel(this.myTreeViewController.getModel().getMainLevelNodes());
        this.myTreeViewTree = new PTreeViewTree(controller, this.myTreeModel, this.mySiteName);
        this.myTreeSearchBar = new TreeSearchBar(this.myTreeViewTree){

            @Override
            public void instantiateSearchTextField() {
                this.mySearchTextField = new PTreeViewTreeSearchField(this.getTree());
                this.mySearchTextField.addSearchListener(this);
            }
        };
        this.myTreeSearchBar.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.myTreeSearchBar.setName("SearchTextField");
        this.initialise();
        this.myLocalizer = LocalizerRegistry.lookup("swing");
        this.myLocalizer.setResourceBundle(this.myResourceBundle);
        this.myLocalizer.localizeObjectHierarchy(new SwingHierarchyIterator(this));
        this.adjustCollapseExpandTreeLevels();
    }

    @Override
    public void dispose() {
        this.clear();
        this.myCollapseAllButton = null;
        this.myExpandAllButton = null;
        this.myPrintButton = null;
        this.myTreeSearchBar = null;
        this.myMainLabel = null;
        this.mySiteName = null;
        this.removeAll();
        super.dispose();
    }

    public void clear() {
        if (this.myTreeViewController.getModel() != null) {
            this.myTreeViewController.getModel().clearModel();
        }
        this.myTreeViewTree.clear();
        this.myTreeViewTree = null;
        this.myUpperPanel = null;
        this.myResourceBundle = null;
        this.myTreeViewController = null;
        this.myTreeModel = null;
        this.myLocalizer = null;
    }

    @Override
    public void setSaveVisible(boolean value) {
        this.mySaveButton.setVisible(value);
        this.mySaveButton.setEnabled(value);
    }

    @Override
    public void setPrintVisible(boolean value) {
        this.myPrintButton.setVisible(value);
        this.myPrintButton.setEnabled(value);
    }

    @Override
    public void setSearchFieldVisible(boolean value) {
        this.myTreeSearchBar.setVisible(value);
    }

    @Override
    public void setSearchFieldEnable(boolean value) {
        this.myTreeSearchBar.setEnabled(value);
        this.myTreeSearchBar.getSearchField().setEnabled(value);
    }

    @Override
    public void setHelpVisible(boolean value) {
    }

    @Override
    public void setSaveEnable(boolean value) {
        this.mySaveButton.setEnabled(value);
    }

    @Override
    public void setPrintEnable(boolean value) {
        this.myPrintButton.setEnabled(value);
    }

    @Override
    public void setHelpEnable(boolean value) {
    }

    @Override
    public void setTitle(String title) {
        this.myMainLabel.setEnabled(true);
        this.myMainLabel.setVisible(true);
        this.myMainLabel.setText(title);
    }

    @Override
    public void setExpandAllEnabled(boolean value) {
        this.myExpandAllButton.setEnabled(value);
    }

    @Override
    public void setCollapseAllEnabled(boolean value) {
        this.myCollapseAllButton.setEnabled(value);
    }

    @Override
    public void setCollapseExpandTreeLevels(int levels) {
        this.myTreeViewTree.setCollapseExpandTreeLevels(levels);
        if (levels == -1) {
            this.myCollapseAllButton.setToolTipText(this.myResourceBundle.getString("TreeViewCollapseAllButton_ToolTipText"));
            this.myExpandAllButton.setToolTipText(this.myResourceBundle.getString("TreeViewExpandAllButton_ToolTipText"));
        } else if (levels == 2) {
            this.myCollapseAllButton.setToolTipText(this.myResourceBundle.getString("TreeViewCollapseMainButton_ToolTipText"));
            this.myExpandAllButton.setToolTipText(this.myResourceBundle.getString("TreeViewExpandMainButton_ToolTipText"));
        } else {
            String collapseTooltipString = this.myResourceBundle.getString("TreeViewCollapseAllLevelsButton_ToolTipText");
            String expandTooltipString = this.myResourceBundle.getString("TreeViewExpandAllLevelsButton_ToolTipText");
            Object[] arg = new Object[]{levels};
            this.myCollapseAllButton.setToolTipText(MessageFormat.format(collapseTooltipString, arg));
            this.myExpandAllButton.setToolTipText(MessageFormat.format(expandTooltipString, arg));
        }
    }

    @Override
    public void setTreeViewTreeEnabled(boolean value) {
        this.myTreeViewTree.setEnabled(value);
    }

    @Override
    public void addCustomAction(Action customAction) {
        PToolButton toolButton = new PToolButton();
        toolButton.setName("PTreeViewPanelView." + customAction.getValue("Name") + "Button");
        toolButton.setIcon((Icon)customAction.getValue("SmallIcon"));
        toolButton.setToolTipText((String)customAction.getValue("LongDescription"));
        toolButton.setAction(customAction);
        PPanel iconPanel = (PPanel)this.myUpperPanel.getComponent(0);
        iconPanel.add(toolButton);
        this.revalidate();
    }

    @Override
    public void addCustomToolButton(PToolButton customButton) {
        PPanel iconPanel = (PPanel)this.myUpperPanel.getComponent(0);
        iconPanel.add(customButton);
        this.revalidate();
    }

    public void addCustomToolButton(PToolButton customButton, int index) {
        PPanel iconPanel = (PPanel)this.myUpperPanel.getComponent(0);
        iconPanel.add((Component)customButton, Math.min(index, iconPanel.getComponentCount()));
        this.revalidate();
    }

    @Override
    public void setContextSpecificTooltipData(String toolTip) {
        Object[] args = new Object[]{toolTip};
        String printToolTipText = MessageFormat.format(this.myResourceBundle.getString("TreeViewPrint_ToolTipText"), args);
        String saveToolTipText = MessageFormat.format(this.myResourceBundle.getString("TreeViewSave_ToolTipText"), args);
        this.myPrintButton.setToolTipText(printToolTipText);
        this.mySaveButton.setToolTipText(saveToolTipText);
    }

    @Override
    public void addMainLevelNodes(PAbstractNode[] mainLevelNodes) {
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)this.myTreeModel.getRoot();
        PTitleNode userObject = (PTitleNode)rootNode.getUserObject();
        int i = 0;
        while (i < mainLevelNodes.length) {
            try {
                userObject.addChild(mainLevelNodes[i]);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            ++i;
        }
    }

    @Override
    public void removeMainLevelNodes(PAbstractNode[] mainLevelNodes) {
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)this.myTreeModel.getRoot();
        PTitleNode userObject = (PTitleNode)rootNode.getUserObject();
        int i = 0;
        while (i < mainLevelNodes.length) {
            try {
                userObject.removeChild(mainLevelNodes[i]);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            ++i;
        }
    }

    public void add(View view, Object constraint) {
    }

    public PTreeViewTree getTreeViewTree() {
        return this.myTreeViewTree;
    }

    public void clearSearchResults() {
        this.myTreeSearchBar.getSearchField().setText(null);
    }

    protected void initialise() {
        PTreeViewPanelView contentPane = this;
        contentPane.removeAll();
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraints contentPaneConstraints = new GridBagConstraints();
        contentPaneConstraints.gridx = 0;
        contentPaneConstraints.gridy = 0;
        contentPaneConstraints.gridwidth = 0;
        contentPaneConstraints.gridheight = 1;
        contentPaneConstraints.weightx = 1.0;
        contentPaneConstraints.weighty = 1.0;
        contentPaneConstraints.fill = 1;
        this.myUpperPanel = new PPanel();
        this.myUpperPanel.setPanelType(ClientProperties.PANEL_USER_BACKGROUND);
        this.myUpperPanel.setVisibleLowerEdge(true);
        this.myUpperPanel.setLayout(new BorderLayout());
        contentPane.add((Component)this.myUpperPanel, (Object)contentPaneConstraints);
        contentPaneConstraints.weightx = 1.0;
        contentPaneConstraints.weighty = 0.0;
        contentPaneConstraints.gridy = -1;
        contentPaneConstraints.fill = 2;
        JScrollPane scrollPane = new JScrollPane(this.myTreeViewTree);
        scrollPane.getViewport().add((Component)this.myTreeViewTree, null);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.putClientProperty("OrangeTouch.curvedSheet", true);
        scrollPane.getVerticalScrollBar().setUnitIncrement(50);
        this.myUpperPanel.setBorder(new EmptyBorder(13, 0, 5, 0));
        this.myUpperPanel.add((Component)this.createIconPanel(), "North");
        this.myUpperPanel.add((Component)scrollPane, "Center");
    }

    protected void expandAllClicked() {
        this.adjustCollapseExpandTreeLevels();
        this.myTreeViewTree.expandAll();
    }

    protected void collapseAllClicked() {
        this.adjustCollapseExpandTreeLevels();
        this.myTreeViewTree.collapseAll();
    }

    protected void saveClicked() {
        PAbstractNode userObject = (PAbstractNode)((DefaultMutableTreeNode)this.myTreeViewTree.getModel().getRoot()).getUserObject();
        this.myTreeViewController.save(this, userObject);
    }

    protected void printClicked() {
        PAbstractNode userObject = (PAbstractNode)((DefaultMutableTreeNode)this.myTreeViewTree.getModel().getRoot()).getUserObject();
        this.myTreeViewController.print(userObject);
    }

    protected void removeButtonActionListeners(JButton button) {
        ActionListener[] listeners = button.getActionListeners();
        if (listeners != null) {
            int length = listeners.length;
            int i = 0;
            while (i < length) {
                button.removeActionListener(listeners[i]);
                ++i;
            }
        }
    }

    private DefaultTreeModel createTreeModel(PAbstractNode[] mainLevelNodes) {
        PTitleNode rootNode = new PTitleNode("DUMMY_ROOT", false, 0, null);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(rootNode);
        int i = 0;
        while (i < mainLevelNodes.length) {
            try {
                rootNode.addChild(mainLevelNodes[i]);
            }
            catch (UnsupportedOperationException e) {
                e.printStackTrace();
            }
            this.addChildrenRecursively(root, mainLevelNodes[i]);
            ++i;
        }
        return new DefaultTreeModel(root);
    }

    private void addChildrenRecursively(DefaultMutableTreeNode node, PAbstractNode child) {
        DefaultMutableTreeNode childTreeNode = new DefaultMutableTreeNode(child);
        node.add(childTreeNode);
        if (child instanceof PTitleNode) {
            PAbstractNode[] children = null;
            try {
                children = child.getChildren();
            }
            catch (UnsupportedOperationException e) {
                e.printStackTrace();
            }
            if (children != null) {
                int i = 0;
                while (i < children.length) {
                    this.addChildrenRecursively(childTreeNode, children[i]);
                    ++i;
                }
            }
        }
    }

    public void adjustCollapseExpandTreeLevels() {
        if (this.myTreeViewTree.getCollapseExpandTreeLevels() == -1 && TreeUtils.getTreeNodeCount(this.myTreeViewTree) - 1 > MAX_EXPAND_NUMBER) {
            this.setCollapseExpandTreeLevels(2);
        }
    }

    protected PPanel createIconPanel() {
        PPanel iconPanel = new PPanel();
        this.myMainLabel = new PLabel();
        this.myMainLabel.setLabelType(ClientProperties.LABEL_TITLE);
        this.myMainLabel.setEnabled(false);
        this.myMainLabel.setVisible(false);
        this.myCollapseAllButton.setName("TreeViewCollapseAllButton");
        this.myCollapseAllButton.setIcon(CommonIcons.getCollapseAllIcon());
        this.myCollapseAllButton.setBackground(iconPanel.getBackground());
        this.myCollapseAllButton.setFocusable(true);
        this.myCollapseAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object operation = ProgressOperation.createOperation(new Runnable(){

                    @Override
                    public void run() {
                        PTreeViewPanelView.this.collapseAllClicked();
                    }
                }, Runnable.class);
                ((Runnable)operation).run();
            }
        });
        this.myExpandAllButton.setName("TreeViewExpandAllButton");
        this.myExpandAllButton.setIcon(CommonIcons.getExpandAllIcon());
        this.myExpandAllButton.setFocusable(true);
        this.myExpandAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object operation = ProgressOperation.createOperation(new Runnable(){

                    @Override
                    public void run() {
                        PTreeViewPanelView.this.expandAllClicked();
                    }
                }, Runnable.class);
                ((Runnable)operation).run();
            }
        });
        this.mySaveButton.setName("TreeViewSaveAsButton");
        this.mySaveButton.setIcon(CommonIcons.getSaveAsIcon());
        this.mySaveButton.setFocusable(true);
        this.mySaveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PTreeViewPanelView.this.saveClicked();
            }
        });
        this.myPrintButton.setName("TreeViewPrintButton");
        this.myPrintButton.setIcon(CommonIcons.getPrintIcon());
        this.myPrintButton.setFocusable(true);
        this.myPrintButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PTreeViewPanelView.this.printClicked();
            }
        });
        MigLayout migLayout = new MigLayout("insets 0 0 3 0", "[]3[]", "[]3[]");
        iconPanel.setLayout((LayoutManager)migLayout);
        iconPanel.add((Component)this.myMainLabel, "span, wrap");
        iconPanel.add(this.myCollapseAllButton);
        iconPanel.add(this.myExpandAllButton);
        iconPanel.add(this.myTreeSearchBar);
        iconPanel.add((Component)new PLabel(), "pushx 100");
        iconPanel.add(this.mySaveButton);
        iconPanel.add(this.myPrintButton);
        return iconPanel;
    }
}

