/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.treeview;

import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.frameworks.mvc.Controller;
import com.nokia.em.poseidon.gui.treeview.PAbstractNode;
import com.nokia.em.poseidon.gui.treeview.PTableLeafNode;
import com.nokia.em.poseidon.gui.treeview.PTitleNode;
import com.nokia.em.poseidon.gui.treeview.PTreeViewCellHandler;
import com.nokia.em.poseidon.gui.treeview.PTreeViewTreeRenderer;
import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.JumpScrollable;
import com.nokia.widgets.tree.TreeUtils;
import com.nokia.widgets.util.ScaleUtils;
import java.awt.Component;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.ImageObserver;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class PTreeViewTree
extends JTree
implements PropertyChangeListener,
JumpScrollable {
    private transient TreeCellEditor myEditor = null;
    private transient TreeCellRenderer myRenderer = null;
    private int myCollapseExpandLevels = -1;
    private ResourceBundle myResourceBundle;
    PTreeViewTreeRenderer myRendererAndEditor;
    private ConcurrentLinkedQueue<PropertyChangeEvent> myChildAddedEvents = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<DefaultMutableTreeNode> myAddedNodes = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<DefaultMutableTreeNode> myChangedNodes = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<PropertyChangeEvent> myChildRemovedEvents = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<DefaultMutableTreeNode> myRemovedNodes = new ConcurrentLinkedQueue();

    public PTreeViewTree(Controller ctrl, TreeModel model, String siteName) {
        super(model);
        this.putClientProperty("OrangeTouch.wholeRowActiveInTree", false);
        this.putClientProperty("OrangeTouch.hideTreeNodeDashedSeparator", Boolean.TRUE);
        this.putClientProperty("OrangeTouch.hideTreeNodeSelectionBorder", Boolean.TRUE);
        this.putClientProperty("OrangeTouch.paintHoverFrame", false);
        this.myRendererAndEditor = new PTreeViewTreeRenderer(ctrl, this, model, siteName);
        this.myEditor = this.myRendererAndEditor;
        this.myRenderer = this.myRendererAndEditor;
        this.myResourceBundle = I18n.getI18n().getBundle(this.getClass());
        ToolTipManager.sharedInstance().registerComponent(this);
        this.initialise();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getModel().getRoot();
        this.addPropertyChangeListeners(root);
        this.expandTreeLevels(true, 2);
        this.setImageObservers(root);
        this.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                Component comp = e.getComponent();
                if (!PTreeViewTree.this.isEnabled()) {
                    NetUtils.setInactiveCursor(comp);
                    return;
                }
                TreePath path = PTreeViewTree.this.getPathForLocation(e.getX(), e.getY());
                if (path != null) {
                    Object node = path.getLastPathComponent();
                    if (node != null && PTreeViewTree.this.getModel().isLeaf(node)) {
                        NetUtils.setInactiveCursor(comp);
                    } else {
                        NetUtils.setActiveCursor(comp);
                    }
                }
            }
        });
    }

    public void expandTreeLevels(boolean expand, int level) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getModel().getRoot();
        TreeUtils.expand(this, new TreePath(root.getPath()), expand, level);
    }

    public void clear() {
        this.removePropertyChangeListeners((DefaultMutableTreeNode)this.getModel().getRoot());
        ToolTipManager.sharedInstance().unregisterComponent(this);
        this.myRendererAndEditor.clear();
        this.myRendererAndEditor = null;
        this.myEditor = null;
        this.myRenderer = null;
    }

    private boolean isCleared() {
        return this.myRendererAndEditor == null;
    }

    public void expandAll() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getModel().getRoot();
        if (this.myCollapseExpandLevels == -1) {
            TreeUtils.expand(this, new TreePath(root.getPath()), true);
        } else {
            this.expandTreeLevels(true, this.myCollapseExpandLevels);
        }
    }

    public void collapseAll() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getModel().getRoot();
        if (this.myCollapseExpandLevels == -1) {
            this.collapseRecursively(root, Integer.MAX_VALUE);
        } else {
            this.collapseRecursively(root, this.myCollapseExpandLevels);
        }
    }

    public void setCollapseExpandTreeLevels(int levels) {
        this.myCollapseExpandLevels = levels;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object source = evt.getSource();
        final String propertyName = evt.getPropertyName();
        DefaultMutableTreeNode rootNode = this.searchNode((DefaultMutableTreeNode)this.getModel().getRoot(), (PAbstractNode)source);
        if (rootNode == null || this.isCleared()) {
            return;
        }
        if (propertyName.equals("DATA_STATE_CHANGED") || propertyName.equals("CONTENT_CHANGED")) {
            this.myChangedNodes.offer(rootNode);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PAbstractNode pNode;
                    if (PTreeViewTree.this.isCleared()) {
                        return;
                    }
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)PTreeViewTree.this.myChangedNodes.poll();
                    TreeCellEditor editor = PTreeViewTree.this.myRendererAndEditor.getCellEditor(node);
                    if (editor instanceof PTreeViewCellHandler) {
                        editor.cancelCellEditing();
                    }
                    ((DefaultTreeModel)PTreeViewTree.this.getModel()).nodeChanged(node);
                    if (propertyName.equals("CONTENT_CHANGED")) {
                        ((DefaultTreeModel)PTreeViewTree.this.getModel()).reload(node);
                    }
                    PTreeViewTree.this.setImageObserver(node);
                    if (node.getUserObject() != null && node.getUserObject() instanceof PAbstractNode && (pNode = (PAbstractNode)node.getUserObject()).isSpecialNode()) {
                        DefaultTreeModel model = (DefaultTreeModel)PTreeViewTree.this.getModel();
                        Object[] nodes = null;
                        if (pNode.getChildren() != null && pNode.getChildren().length > 0) {
                            PAbstractNode[] childNodes = pNode.getChildren();
                            DefaultMutableTreeNode childNode = PTreeViewTree.this.searchNode((DefaultMutableTreeNode)PTreeViewTree.this.getModel().getRoot(), childNodes[childNodes.length - 1]);
                            nodes = model.getPathToRoot(childNode);
                            if (nodes != null) {
                                TreePath path = new TreePath(nodes);
                                PTreeViewTree.this.scrollPathToVisible(path);
                            }
                        }
                        if ((nodes = model.getPathToRoot(node)) != null) {
                            TreePath path = new TreePath(nodes);
                            PTreeViewTree.this.scrollPathToVisible(path);
                        }
                    }
                }
            });
        } else if (propertyName.equals("CHILDREN_ADDED")) {
            Enumeration<TreeNode> allChildren = rootNode.children();
            while (allChildren.hasMoreElements()) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)allChildren.nextElement();
                TreeCellEditor editor = this.myRendererAndEditor.getCellEditor(child);
                if (!(editor instanceof PTreeViewCellHandler)) continue;
                editor.cancelCellEditing();
            }
            this.myChildAddedEvents.offer(evt);
            this.myAddedNodes.offer(rootNode);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (PTreeViewTree.this.isCleared()) {
                        return;
                    }
                    PAbstractNode[] children = (PAbstractNode[])((PropertyChangeEvent)PTreeViewTree.this.myChildAddedEvents.poll()).getNewValue();
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)PTreeViewTree.this.myAddedNodes.poll();
                    if (children != null) {
                        int i = 0;
                        while (i < children.length) {
                            PTreeViewTree.this.insertChildren(node, children[i]);
                            ++i;
                        }
                    }
                    ((DefaultTreeModel)PTreeViewTree.this.getModel()).reload(node);
                    if ((PTitleNode)node.getUserObject() != null && ((PTitleNode)node.getUserObject()).isSelected()) {
                        PTreeViewTree.this.expandSelectedPaths(node);
                    }
                    PTreeViewTree.this.setImageObservers(node);
                }
            });
        } else if (propertyName.equals("CHILDREN_REMOVED") && this.myRendererAndEditor != null) {
            this.myChildRemovedEvents.offer(evt);
            this.myRemovedNodes.offer(rootNode);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (PTreeViewTree.this.isCleared()) {
                        return;
                    }
                    PAbstractNode[] children = (PAbstractNode[])((PropertyChangeEvent)PTreeViewTree.this.myChildRemovedEvents.poll()).getNewValue();
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)PTreeViewTree.this.myRemovedNodes.poll();
                    if (children != null) {
                        int i = 0;
                        while (i < children.length) {
                            DefaultMutableTreeNode childNode = PTreeViewTree.this.searchNode(node, children[i]);
                            if (childNode != null) {
                                TreeCellEditor editor = PTreeViewTree.this.myRendererAndEditor.getCellEditor(childNode);
                                if (editor instanceof PTreeViewCellHandler) {
                                    editor.cancelCellEditing();
                                }
                                PTreeViewTree.this.myRendererAndEditor.removeCellEditorListeners(childNode);
                                node.remove(childNode);
                                PTreeViewTree.this.myRendererAndEditor.removeNodeModifiers(childNode);
                            }
                            ++i;
                        }
                    }
                    PTreeViewTree.this.removeImageObservers(node);
                    ((DefaultTreeModel)PTreeViewTree.this.getModel()).reload(node);
                }
            });
        }
    }

    public DefaultMutableTreeNode searchNode(DefaultMutableTreeNode node, PAbstractNode userObject) {
        Object nodeUserObject = node.getUserObject();
        if (nodeUserObject.equals(userObject)) {
            return node;
        }
        Enumeration<TreeNode> children = node.children();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode treeNode = this.searchNode((DefaultMutableTreeNode)children.nextElement(), userObject);
            if (treeNode == null) continue;
            return treeNode;
        }
        return null;
    }

    private void insertChildren(DefaultMutableTreeNode parentNode, PAbstractNode child) {
        if (child instanceof PTitleNode) {
            child.addPropertyChangeListener(this);
        }
        int childIndex = 0;
        try {
            childIndex = ((PTitleNode)parentNode.getUserObject()).getChildIndex(child);
            if (childIndex == -1) {
                childIndex = 0;
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(child);
        parentNode.insert(childNode, childIndex);
        this.myRendererAndEditor.storeNodeModifiers(childNode);
        this.myRendererAndEditor.addCellEditorListeners(childNode);
        PAbstractNode[] children = child.getChildren();
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                this.insertChildren(childNode, children[i]);
                ++i;
            }
        }
    }

    private void initialise() {
        TreeUI treeUI = this.getUI();
        if (treeUI instanceof BasicTreeUI) {
            BasicTreeUI basicUi = (BasicTreeUI)treeUI;
            basicUi.setCollapsedIcon(null);
            basicUi.setExpandedIcon(null);
            basicUi.setLeftChildIndent(5);
        }
        this.putClientProperty("JTree.lineStyle", "None");
        this.setRowHeight(0);
        this.setExpandsSelectedPaths(true);
        this.setScrollsOnExpand(true);
        this.setEditable(true);
        this.setRootVisible(false);
        this.setShowsRootHandles(false);
        this.setInvokesStopCellEditing(true);
        this.setCellRenderer(this.myRenderer);
        this.setCellEditor(this.myEditor);
    }

    private void setImageObservers(DefaultMutableTreeNode root) {
        this.setImageObserver(root);
        int childrenCount = root.getChildCount();
        int i = 0;
        while (i < childrenCount) {
            if (root.getChildAt(i) instanceof DefaultMutableTreeNode) {
                this.setImageObservers((DefaultMutableTreeNode)root.getChildAt(i));
            }
            ++i;
        }
    }

    private void setImageObserver(DefaultMutableTreeNode node) {
        if (node.getUserObject() instanceof PTitleNode) {
            PTitleNode titleNode = (PTitleNode)node.getUserObject();
            this.setImageObserver(node, titleNode.getDataStateIcon());
            this.setImageObserver(node, titleNode.getIcon());
        }
    }

    private void setImageObserver(DefaultMutableTreeNode node, Icon icon) {
        ImageIcon imageIcon;
        if (icon != null && icon instanceof ImageIcon && (imageIcon = (ImageIcon)icon).getImageObserver() == null) {
            imageIcon.setImageObserver(new NodeImageObserver(this, node));
        }
    }

    private void removeImageObservers(DefaultMutableTreeNode root) {
        this.removeImageObserver(root);
        int childrenCount = root.getChildCount();
        int i = 0;
        while (i < childrenCount) {
            if (root.getChildAt(i) instanceof DefaultMutableTreeNode) {
                this.setImageObservers((DefaultMutableTreeNode)root.getChildAt(i));
            }
            ++i;
        }
    }

    private void removeImageObserver(DefaultMutableTreeNode node) {
        if (node.getUserObject() instanceof PTitleNode) {
            Icon icon;
            PTitleNode titleNode = (PTitleNode)node.getUserObject();
            Icon stateIcon = titleNode.getDataStateIcon();
            if (stateIcon != null && stateIcon instanceof ImageIcon) {
                ((ImageIcon)stateIcon).setImageObserver(null);
            }
            if ((icon = titleNode.getIcon()) != null && icon instanceof ImageIcon) {
                ((ImageIcon)icon).setImageObserver(null);
            }
        }
    }

    private void addPropertyChangeListeners(DefaultMutableTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject != null && userObject instanceof PTitleNode) {
            ((PTitleNode)userObject).addPropertyChangeListener(this);
        }
        Enumeration<TreeNode> children = node.children();
        while (children.hasMoreElements()) {
            this.addPropertyChangeListeners((DefaultMutableTreeNode)children.nextElement());
        }
    }

    private void removePropertyChangeListeners(DefaultMutableTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject != null && userObject instanceof PTitleNode) {
            ((PTitleNode)userObject).removePropertyChangeListener(this);
        }
        Enumeration<TreeNode> children = node.children();
        while (children.hasMoreElements()) {
            this.removePropertyChangeListeners((DefaultMutableTreeNode)children.nextElement());
        }
    }

    private void expandSelectedPaths(DefaultMutableTreeNode keyValue) {
        DefaultMutableTreeNode key = keyValue;
        PAbstractNode userObject = (PAbstractNode)key.getUserObject();
        if (userObject.isSelected() || userObject.getLevel() == 0) {
            this.expandPath(new TreePath(key.getPath()));
        }
        Enumeration<TreeNode> e = key.children();
        while (e.hasMoreElements()) {
            key = (DefaultMutableTreeNode)e.nextElement();
            this.expandSelectedPaths(key);
        }
    }

    public void collapseRecursively(DefaultMutableTreeNode key, int level) {
        if (level < 1) {
            return;
        }
        Enumeration<TreeNode> e = key.children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            this.collapseRecursively(node, level - 1);
        }
        if (!key.isRoot()) {
            this.collapsePath(new TreePath(key.getPath()));
        }
    }

    @Override
    public void updateUI() {
        this.setUI((TreeUI)UIManager.getUI(this));
        this.initialise();
        this.invalidate();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getJumpScrollIncrement(Rectangle viewRect, int direction) {
        TreePath firstRowInView = this.getClosestPathForLocation(0, viewRect.y);
        TreeNode currentTitle = (TreeNode)firstRowInView.getPathComponent(1);
        TreeNode root = currentTitle.getParent();
        int currentTitleIndex = root.getIndex(currentTitle);
        TreeNode nextTitle = null;
        if (direction > 0) {
            if (currentTitleIndex >= root.getChildCount() - 1) return 0;
            nextTitle = root.getChildAt(currentTitleIndex + 1);
        } else {
            nextTitle = currentTitleIndex > 0 && viewRect.y == this.getPathBounds((TreePath)new TreePath((Object[])new Object[]{root, currentTitle})).y ? root.getChildAt(currentTitleIndex - 1) : currentTitle;
        }
        Rectangle nextTitleBounds = this.getPathBounds(new TreePath(new Object[]{root, nextTitle}));
        return Math.abs(nextTitleBounds.y - viewRect.y);
    }

    @Override
    public String getTooltipText(int direction) {
        return direction > 0 ? this.myResourceBundle.getString("TreeViewTree.jumpScrollNext_Tooltip") : this.myResourceBundle.getString("TreeViewTree.jumpScrollPrevious_Tooltip");
    }

    public void scrollRowToVisible(TreePath path, int row) {
        if (path != null) {
            Rectangle bounds;
            this.makeVisible(path);
            Object component = path.getLastPathComponent();
            int yOffset = ScaleUtils.scale(6);
            if (component instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)component;
                Object userObject = node.getUserObject();
                if (userObject instanceof PTitleNode) {
                    yOffset = ScaleUtils.scale(11);
                }
                if (userObject instanceof PTableLeafNode) {
                    int lineCount;
                    PTableLeafNode leafNode = (PTableLeafNode)userObject;
                    if (leafNode.isShowTitle()) {
                        yOffset = ScaleUtils.scale(11);
                    }
                    if (row > -1 && (lineCount = leafNode.getNumOfLinesInOneRow(row, this.getFontMetrics(this.getFont()))) > 1) {
                        yOffset += ScaleUtils.scale(18) * (lineCount - 1);
                    }
                }
            }
            if ((bounds = this.getPathBounds(path)) != null) {
                int height = ScaleUtils.scale(19 + this.getRowHeightIncrement());
                bounds.y += height * row;
                bounds.y += yOffset;
                bounds.height = height;
                this.scrollRectToVisible(bounds);
                if (this.accessibleContext != null) {
                    ((JTree.AccessibleJTree)this.accessibleContext).fireVisibleDataPropertyChange();
                }
            }
        }
    }

    public void setEmptyText(Object value) {
        this.putClientProperty("OrangeTouch.emptyText", value);
    }

    public Object getEmptyText() {
        return this.getClientProperty("OrangeTouch.emptyText");
    }

    private int getRowHeightIncrement() {
        int increment = NetLookAndFeel.getFontSizeIncrement();
        if (increment == 0) {
            return (int)Math.ceil((double)this.getFontMetrics(UIManager.getFont("Label.font")).getHeight() / 16.0) - 1;
        }
        return 0;
    }

    public int getCollapseExpandTreeLevels() {
        return this.myCollapseExpandLevels;
    }

    private class NodeImageObserver
    implements ImageObserver {
        private JTree myTree;
        private DefaultTreeModel myModel;
        private TreeNode myNode;

        public NodeImageObserver(JTree tree, TreeNode nodes) {
            this.myTree = tree;
            this.myModel = (DefaultTreeModel)tree.getModel();
            this.myNode = nodes;
        }

        @Override
        public boolean imageUpdate(Image img, int flags, int x, int y, int w, int h) {
            TreePath path;
            Rectangle rect;
            if ((flags & 0x30) != 0 && (rect = this.myTree.getPathBounds(path = new TreePath(this.myModel.getPathToRoot(this.myNode)))) != null) {
                this.myTree.repaint(rect);
            }
            return (flags & 0xA0) == 0;
        }
    }
}

