/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.treeview;

import com.nokia.em.poseidon.frameworks.mvc.Controller;
import com.nokia.em.poseidon.gui.treeview.PAbstractNode;
import com.nokia.em.poseidon.gui.treeview.PTreeViewCellHandler;
import com.nokia.em.poseidon.gui.treeview.PTreeViewTree;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class PTreeViewTreeRenderer
implements TreeCellRenderer,
TreeCellEditor,
PropertyChangeListener,
FocusListener {
    private Hashtable<DefaultMutableTreeNode, TreeCellRenderer> myRenderers = new Hashtable();
    private Hashtable<DefaultMutableTreeNode, TreeCellEditor> myEditors = new Hashtable();
    private TreeCellRenderer myCurrentRenderer;
    private TreeCellEditor myCurrentEditor;
    private String mySiteName;
    private PTreeViewTree myTreeViewTree;
    private Vector<CellEditorListener> myCellEditorListener;
    private TreeModel myTreeModel;
    private Controller myController;

    public PTreeViewTreeRenderer(Controller ctrl, PTreeViewTree tree, TreeModel treeModel, String siteName) {
        this.mySiteName = siteName;
        this.myTreeViewTree = tree;
        this.myTreeModel = treeModel;
        this.myController = ctrl;
        this.myTreeViewTree.addFocusListener(this);
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)treeModel.getRoot();
        this.storeNodeModifiers(root);
    }

    public void storeNodeModifiers(DefaultMutableTreeNode node) {
        if (node == null) {
            return;
        }
        PAbstractNode userObject = (PAbstractNode)node.getUserObject();
        if (userObject == null) {
            return;
        }
        if (userObject.getEditor() == null && userObject.getRenderer() == null) {
            PTreeViewCellHandler cellHandler = new PTreeViewCellHandler(this.myController, this.mySiteName, this.myTreeModel);
            this.myEditors.put(node, cellHandler);
            this.myRenderers.put(node, cellHandler);
        }
        if (userObject.getEditor() != null) {
            this.myEditors.put(node, userObject.getEditor());
        }
        if (userObject.getRenderer() != null) {
            this.myRenderers.put(node, userObject.getRenderer());
        }
        userObject.addPropertyChangeListener(this);
        Enumeration<TreeNode> children = node.children();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
            this.storeNodeModifiers(child);
        }
    }

    public void clear() {
        Collection<TreeCellRenderer> renderers = this.myRenderers.values();
        Iterator<TreeCellRenderer> iter = renderers.iterator();
        while (iter.hasNext()) {
            ((PTreeViewCellHandler)iter.next()).clear();
        }
        Collection<TreeCellEditor> editors = this.myEditors.values();
        Iterator<TreeCellEditor> itera = editors.iterator();
        while (itera.hasNext()) {
            ((PTreeViewCellHandler)itera.next()).clear();
        }
        this.myRenderers.clear();
        this.myRenderers = null;
        this.myEditors.clear();
        this.myEditors = null;
        this.myCurrentRenderer = null;
        this.myCurrentEditor = null;
        this.myTreeModel = null;
        this.myCellEditorListener.clear();
        this.myCellEditorListener = null;
        this.myController = null;
        this.myTreeViewTree.removeFocusListener(this);
        this.myTreeViewTree = null;
    }

    public void removeNodeModifiers(DefaultMutableTreeNode node) {
        PAbstractNode userObject = (PAbstractNode)node.getUserObject();
        userObject.removePropertyChangeListener(this);
        this.myEditors.remove(node);
        this.myRenderers.remove(node);
        Enumeration<TreeNode> children = node.children();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
            this.removeNodeModifiers(child);
        }
    }

    public void addCellEditorListeners(DefaultMutableTreeNode node) {
        if (this.myCellEditorListener == null) {
            return;
        }
        TreeCellEditor editor = this.myEditors.get(node);
        if (editor != null) {
            for (CellEditorListener cellEditorListener : this.myCellEditorListener) {
                editor.addCellEditorListener(cellEditorListener);
            }
        }
        Enumeration<TreeNode> children = node.children();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
            this.addCellEditorListeners(child);
        }
    }

    public void removeCellEditorListeners(DefaultMutableTreeNode node) {
        if (this.myCellEditorListener == null) {
            return;
        }
        TreeCellEditor editor = this.myEditors.get(node);
        if (editor != null) {
            for (CellEditorListener cellEditorListener : this.myCellEditorListener) {
                editor.removeCellEditorListener(cellEditorListener);
            }
        }
        Enumeration<TreeNode> children = node.children();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
            this.removeCellEditorListeners(child);
        }
    }

    @Override
    public boolean isCellEditable(EventObject evt) {
        TreeCellEditor currentEditor;
        DefaultMutableTreeNode selectedNode = null;
        if (evt == null) {
            selectedNode = (DefaultMutableTreeNode)this.myTreeViewTree.getSelectionPath().getLastPathComponent();
        } else if (evt instanceof MouseEvent) {
            MouseEvent mevt = (MouseEvent)evt;
            Point selectionPoint = mevt.getPoint();
            TreePath path = this.myTreeViewTree.getPathForLocation(selectionPoint.x, selectionPoint.y);
            selectedNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        }
        if (selectedNode != null && (currentEditor = this.myEditors.get(selectedNode)) != null) {
            this.myCurrentEditor = currentEditor;
        }
        if (this.myCurrentEditor != null) {
            return this.myCurrentEditor.isCellEditable(evt);
        }
        return false;
    }

    @Override
    public void removeCellEditorListener(CellEditorListener listener) {
        Enumeration<DefaultMutableTreeNode> keys = this.myEditors.keys();
        while (keys.hasMoreElements()) {
            TreeCellEditor cellEditor = this.myEditors.get(keys.nextElement());
            cellEditor.removeCellEditorListener(listener);
        }
        if (this.myCellEditorListener == null) {
            return;
        }
        this.myCellEditorListener.remove(listener);
    }

    @Override
    public boolean shouldSelectCell(EventObject evt) {
        TreeCellEditor currentEditor;
        DefaultMutableTreeNode selectedNode = null;
        if (evt == null) {
            selectedNode = (DefaultMutableTreeNode)this.myTreeViewTree.getSelectionPath().getLastPathComponent();
        } else if (evt instanceof MouseEvent) {
            MouseEvent mevt = (MouseEvent)evt;
            Point selectionPoint = mevt.getPoint();
            TreePath path = this.myTreeViewTree.getPathForLocation(selectionPoint.x, selectionPoint.y);
            selectedNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        }
        if (selectedNode != null && (currentEditor = this.myEditors.get(selectedNode)) != null) {
            this.myCurrentEditor = currentEditor;
        }
        if (this.myCurrentEditor != null) {
            return this.myCurrentEditor.shouldSelectCell(evt);
        }
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        boolean value = true;
        if (this.myCurrentEditor != null) {
            value = this.myCurrentEditor.stopCellEditing();
        }
        return value;
    }

    @Override
    public void addCellEditorListener(CellEditorListener listener) {
        Enumeration<DefaultMutableTreeNode> keys = this.myEditors.keys();
        while (keys.hasMoreElements()) {
            TreeCellEditor cellEditor = this.myEditors.get(keys.nextElement());
            cellEditor.addCellEditorListener(listener);
        }
        if (this.myCellEditorListener == null) {
            this.myCellEditorListener = new Vector();
        }
        this.myCellEditorListener.add(listener);
    }

    @Override
    public void cancelCellEditing() {
        if (this.myCurrentEditor != null) {
            this.myCurrentEditor.cancelCellEditing();
        }
    }

    @Override
    public Object getCellEditorValue() {
        if (this.myCurrentEditor != null) {
            return this.myCurrentEditor.getCellEditorValue();
        }
        return null;
    }

    @Override
    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        this.myCurrentEditor = this.myEditors.get(node);
        return this.myCurrentEditor.getTreeCellEditorComponent(tree, value, isSelected, expanded, leaf, row);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (this.myRenderers == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        this.myCurrentRenderer = this.myRenderers.get(node);
        return this.myCurrentRenderer.getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, hasFocus);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object source = evt.getSource();
        String propertyName = evt.getPropertyName();
        DefaultMutableTreeNode node = null;
        if (propertyName.equals("NEW_RENDERER") || propertyName.equals("NEW_EDITOR") || propertyName.equals("CHILDREN_ADDED") || propertyName.equals("CHILDREN_REMOVED") && this.myTreeViewTree != null) {
            node = this.myTreeViewTree.searchNode((DefaultMutableTreeNode)this.myTreeViewTree.getModel().getRoot(), (PAbstractNode)source);
        }
        if (node != null) {
            if (propertyName.equals("NEW_RENDERER")) {
                this.myRenderers.put(node, (TreeCellRenderer)evt.getNewValue());
            } else if (propertyName.equals("NEW_EDITOR")) {
                this.myEditors.put(node, (TreeCellEditor)evt.getNewValue());
                if (this.myCellEditorListener != null) {
                    int i = 0;
                    while (i < this.myCellEditorListener.size()) {
                        ((TreeCellEditor)evt.getNewValue()).addCellEditorListener(this.myCellEditorListener.get(i));
                        ++i;
                    }
                }
            }
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.myTreeViewTree.getSelectionPath() == null) {
            this.myTreeViewTree.setSelectionRow(0);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    public TreeCellEditor getCellEditor(DefaultMutableTreeNode node) {
        return this.myEditors.get(node);
    }
}

